/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.pdfgeneration;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.project.CollaboratorTableColumn;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Column;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.ExperimentDesignRDFReport;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.PDFGenerator;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Table;

public class ProjectReportPage {
    private static final Logger logger = Logger.getLogger(ProjectReportPage.class);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final PDRectangle PAGE_SIZE = ExperimentDesignRDFReport.PAGE_SIZE;
    private static final PDFont BOLD_FONT = ExperimentDesignRDFReport.BOLD_FONT;
    private static final float FONT_SIZE = 12.0f;
    private static final float MARGIN = 40.0f;
    private static final PDFont TEXT_FONT = ExperimentDesignRDFReport.TEXT_FONT;
    private static final float LENGTH = ExperimentDesignRDFReport.LENGTH;
    private static final float CELL_MARGIN = 2.0f;

    public static void addProjectPage(Entry projectEntry, ProjectProperty projectProperty, PDDocument document, float yIndex) {
        if (document != null) {
            try {
                PDPage page = new PDPage(PDPage.PAGE_SIZE_LETTER);
                document.addPage(page);
                yIndex = PDFGenerator.writeSimpleText(document, page, "Project Information", BOLD_FONT, 12.0f, 40.0f, yIndex);
                float x = PDFGenerator.writeTextOnTheSameLine(document, page, "Name", TEXT_FONT, 12.0f, 40.0f, yIndex, true);
                yIndex = PDFGenerator.writeSimpleText(document, page, ": " + projectEntry.getDisplayName(), TEXT_FONT, 12.0f, x, yIndex);
                x = PDFGenerator.writeTextOnTheSameLine(document, page, "Date Created", TEXT_FONT, 12.0f, 40.0f, yIndex, true);
                yIndex = PDFGenerator.writeSimpleText(document, page, ": " + projectEntry.getCreationDate().toString(), TEXT_FONT, 12.0f, x, yIndex);
                ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails((Entry)projectEntry);
                if (projectDetails != null) {
                    if (projectDetails.getDescription() != null) {
                        x = PDFGenerator.writeTextOnTheSameLine(document, page, "Description", TEXT_FONT, 12.0f, 40.0f, yIndex, true);
                        yIndex = PDFGenerator.drawMultilineString(document, page, TEXT_FONT, 12.0f, ": " + projectDetails.getDescription(), yIndex, x, LENGTH);
                    }
                    Object[] pageAndYIndex = new Object[]{page, Float.valueOf(yIndex)};
                    ProjectReportPage.addExtraLine(pageAndYIndex);
                    ProjectReportPage.addProjectCollaboratorsPart(projectDetails, document, pageAndYIndex);
                    ProjectReportPage.addExtraLine(pageAndYIndex);
                    ProjectReportPage.addProjectTasklistPart(projectDetails, document, pageAndYIndex);
                    ProjectReportPage.addExtraLine(pageAndYIndex);
                    ProjectReportPage.addProjectEventsPart(projectDetails, document, pageAndYIndex);
                    ProjectReportPage.addExtraLine(pageAndYIndex);
                    ProjectReportPage.addProjectKeywordsPart(projectDetails, document, pageAndYIndex);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static void addProjectCollaboratorsPart(ProjectDetails projectDetails, PDDocument document, Object[] pageAndYIndex) {
        int i = 1;
        try {
            ProjectReportPage.checkMargin(document, pageAndYIndex);
            pageAndYIndex[1] = Float.valueOf(PDFGenerator.writeSimpleText(document, (PDPage)pageAndYIndex[0], "Project Collaborators", BOLD_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue()));
            for (ProjectCollaborator collaborator : projectDetails.getCollaborators()) {
                try {
                    ProjectReportPage.checkMargin(document, pageAndYIndex);
                    ProjectReportPage.addExtraLine(pageAndYIndex);
                    pageAndYIndex[1] = Float.valueOf(PDFGenerator.writeSimpleText(document, (PDPage)pageAndYIndex[0], String.valueOf(i) + ". " + CollaboratorTableColumn.getColumnValue((ProjectCollaborator)collaborator, (String)CollaboratorTableColumn.COLUMNS[0]), BOLD_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue()));
                    int j = 0;
                    while (j < CollaboratorTableColumn.COLUMNS.length) {
                        if (j == 5) {
                            ProjectReportPage.addMultiLine(document, pageAndYIndex, CollaboratorTableColumn.COLUMNS[j], ": " + CollaboratorTableColumn.getColumnValue((ProjectCollaborator)collaborator, (String)CollaboratorTableColumn.COLUMNS[j]));
                        } else {
                            ProjectReportPage.addLine(document, pageAndYIndex, CollaboratorTableColumn.COLUMNS[j], ": " + CollaboratorTableColumn.getColumnValue((ProjectCollaborator)collaborator, (String)CollaboratorTableColumn.COLUMNS[j]));
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addProjectTasklistPart(ProjectDetails projectDetails, PDDocument document, Object[] pageAndYIndex) {
        try {
            if (!projectDetails.getTasklists().isEmpty()) {
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(new Column("Task", 90.0f));
                columns.add(new Column("Person", 80.0f));
                columns.add(new Column("Status", 60.0f));
                columns.add(new Column("Due Date", 70.0f));
                columns.add(new Column("Role", 80.0f));
                columns.add(new Column("Group/P.I.", 80.0f));
                columns.add(new Column("Description", 90.0f));
                int tableSize = projectDetails.getTasklists().size();
                String[][] content = new String[tableSize][7];
                int row = 0;
                float maxRowHeight = 15.0f;
                for (ProjectTasklist task : projectDetails.getTasklists()) {
                    maxRowHeight = ProjectReportPage.writeTaskRow(task, content, row, maxRowHeight);
                    ++row;
                }
                ProjectReportPage.addTable(document, pageAndYIndex, "Tasklist", columns, content, maxRowHeight);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addProjectEventsPart(ProjectDetails projectDetails, PDDocument document, Object[] pageAndYIndex) {
        try {
            if (!projectDetails.getEvents().isEmpty()) {
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(new Column("Action", 125.0f));
                columns.add(new Column("Date", 125.0f));
                columns.add(new Column("Description", 300.0f));
                int tableSize = projectDetails.getEvents().size();
                String[][] content = new String[tableSize][4];
                int row = 0;
                float maxRowHeight = 15.0f;
                for (ProjectEvent event : projectDetails.getEvents()) {
                    maxRowHeight = ProjectReportPage.writeEventRow(event, content, row, maxRowHeight);
                    ++row;
                }
                ProjectReportPage.addTable(document, pageAndYIndex, "Events", columns, content, maxRowHeight);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addTable(PDDocument document, Object[] pageAndYIndex, String title, List<Column> columns, String[][] content, float maxRowHeight) {
        try {
            float tableStretchHeight = ((Float)pageAndYIndex[1]).floatValue() == LENGTH ? ((Float)pageAndYIndex[1]).floatValue() - 80.0f : ((Float)pageAndYIndex[1]).floatValue() - 40.0f;
            float actualTableHeight = maxRowHeight * (float)content.length + 15.0f;
            float tableMaxHeight = PAGE_SIZE.getHeight() - 80.0f;
            logger.debug((Object)("actualTableHeight : " + actualTableHeight));
            Table table = ExperimentDesignRDFReport.createTable(columns, content, tableStretchHeight, tableMaxHeight, maxRowHeight);
            if (actualTableHeight > tableStretchHeight && actualTableHeight < PAGE_SIZE.getHeight() - 80.0f) {
                pageAndYIndex[0] = new PDPage(PDPage.PAGE_SIZE_LETTER);
                document.addPage((PDPage)pageAndYIndex[0]);
                pageAndYIndex[1] = Float.valueOf(LENGTH);
                table.setHeight(((Float)pageAndYIndex[1]).floatValue() - 80.0f);
            }
            pageAndYIndex[1] = Float.valueOf(PDFGenerator.writeSimpleText(document, (PDPage)pageAndYIndex[0], title, BOLD_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue()));
            pageAndYIndex[1] = Float.valueOf(new PDFGenerator().drawTable(document, (PDPage)pageAndYIndex[0], table, true, ((Float)pageAndYIndex[1]).floatValue()));
            pageAndYIndex[0] = (PDPage)document.getDocumentCatalog().getAllPages().get(document.getDocumentCatalog().getAllPages().size() - 1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static float writeTaskRow(ProjectTasklist task, String[][] content, int row, float maxRowHeight) {
        maxRowHeight = ProjectReportPage.assignValue(task.getTask(), content, row, 0, 90, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(task.getPerson(), content, row, 1, 80, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(task.getStatus(), content, row, 2, 60, maxRowHeight);
        String dueDate = task.getDueDate() == null ? "" : dateFormat.format(task.getDueDate());
        maxRowHeight = ProjectReportPage.assignValue(dueDate, content, row, 3, 70, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(task.getRole(), content, row, 4, 80, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(task.getGroupOrPIName(), content, row, 5, 80, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(task.getDescription(), content, row, 6, 90, maxRowHeight);
        return maxRowHeight;
    }

    private static float assignValue(String value, String[][] content, int row, int column, int columnSize, float maxRowHeight) {
        try {
            content[row][column] = value == null ? "" : value;
            maxRowHeight = Math.max(PDFGenerator.calculateRowHeight(content[row][column], columnSize, TEXT_FONT, 12.0f, 2.0f), maxRowHeight);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return maxRowHeight;
    }

    private static float writeEventRow(ProjectEvent event, String[][] content, int row, float maxRowHeight) {
        String value = event.getProjectAction() == null || event.getProjectAction().getAction() == null ? "" : event.getProjectAction().getAction();
        maxRowHeight = ProjectReportPage.assignValue(value, content, row, 0, 125, maxRowHeight);
        value = event.getEventDate() == null ? "" : dateFormat.format(event.getEventDate());
        logger.debug((Object)("date  is " + value));
        maxRowHeight = ProjectReportPage.assignValue(value, content, row, 1, 100, maxRowHeight);
        maxRowHeight = ProjectReportPage.assignValue(event.getDescription(), content, row, 2, 250, maxRowHeight);
        return maxRowHeight;
    }

    private static void addProjectKeywordsPart(ProjectDetails projectDetails, PDDocument document, Object[] pageAndYIndex) {
        try {
            ProjectReportPage.checkMargin(document, pageAndYIndex);
            ProjectReportPage.addExtraLine(pageAndYIndex);
            pageAndYIndex[1] = Float.valueOf(PDFGenerator.writeSimpleText(document, (PDPage)pageAndYIndex[0], "Keywords", BOLD_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue()));
            String keywords = ProjectReportPage.getCSKeywords(projectDetails.getKeywords());
            pageAndYIndex[1] = keywords.isEmpty() && ((Float)pageAndYIndex[1]).floatValue() != LENGTH ? Float.valueOf(((Float)pageAndYIndex[1]).floatValue() - 20.0f) : Float.valueOf(PDFGenerator.drawMultilineString(document, (PDPage)pageAndYIndex[0], TEXT_FONT, 12.0f, keywords, ((Float)pageAndYIndex[1]).floatValue(), 40.0f, LENGTH));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getCSKeywords(Set<String> keywordSet) {
        String keywords = "";
        String separator = ", ";
        for (String keyword : keywordSet) {
            keywords = String.valueOf(keywords) + keyword + separator;
        }
        if (!keywords.isEmpty()) {
            keywords = keywords.substring(0, keywords.length() - separator.length());
        }
        return keywords;
    }

    private static void checkMargin(PDDocument document, Object[] pageAndYIndex) {
        if (((Float)pageAndYIndex[1]).floatValue() < 40.0f) {
            pageAndYIndex[0] = new PDPage(PDPage.PAGE_SIZE_LETTER);
            document.addPage((PDPage)pageAndYIndex[0]);
            pageAndYIndex[1] = Float.valueOf(LENGTH);
        }
    }

    private static void addExtraLine(Object[] pageAndYIndex) {
        if (((Float)pageAndYIndex[1]).floatValue() != LENGTH) {
            pageAndYIndex[1] = Float.valueOf(((Float)pageAndYIndex[1]).floatValue() - 20.0f);
        }
    }

    private static void addMultiLine(PDDocument document, Object[] pageAndYIndex, String label, String value) {
        try {
            ProjectReportPage.checkMargin(document, pageAndYIndex);
            float x = PDFGenerator.writeTextOnTheSameLine(document, (PDPage)pageAndYIndex[0], label, TEXT_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue(), true);
            value = value == null ? "" : value;
            pageAndYIndex[1] = value.isEmpty() ? Float.valueOf(((Float)pageAndYIndex[1]).floatValue() - 20.0f) : Float.valueOf(PDFGenerator.drawMultilineString(document, (PDPage)pageAndYIndex[0], TEXT_FONT, 12.0f, value, ((Float)pageAndYIndex[1]).floatValue(), x, LENGTH));
            pageAndYIndex[0] = (PDPage)document.getDocumentCatalog().getAllPages().get(document.getDocumentCatalog().getAllPages().size() - 1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void addLine(PDDocument document, Object[] pageAndYIndex, String label, String value) {
        try {
            ProjectReportPage.checkMargin(document, pageAndYIndex);
            float x = PDFGenerator.writeTextOnTheSameLine(document, (PDPage)pageAndYIndex[0], label, TEXT_FONT, 12.0f, 40.0f, ((Float)pageAndYIndex[1]).floatValue(), true);
            value = value == null ? "" : value;
            pageAndYIndex[1] = Float.valueOf(PDFGenerator.writeSimpleText(document, (PDPage)pageAndYIndex[0], value, TEXT_FONT, 12.0f, x, ((Float)pageAndYIndex[1]).floatValue()));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

