/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGType;
import org.jdesktop.layout.GroupLayout;

public class GAGOptionsDialog
extends EscapeDialog
implements ActionListener,
ListSelectionListener,
ChangeListener,
ItemListener {
    private boolean specify_subs;
    private GAGDictionary theGAGDictionary;
    private GAGOptions theGAGOptions;
    private boolean allow_events = true;
    private JButton button_cancel;
    private JButton button_ok;
    private JCheckBox field_allow_redend_loss;
    private JComboBox field_derivatization;
    private JList field_gag_families;
    private JSpinner field_max_no_acetyls;
    private JSpinner field_max_no_sulfates;
    private JSpinner field_max_no_units;
    private JSpinner field_min_no_acetyls;
    private JSpinner field_min_no_sulfates;
    private JSpinner field_min_no_units;
    private JList field_modifications;
    private JCheckBox field_reduced;
    private JCheckBox field_unsaturated;
    private JCheckBox field_allow_unlikely_acetylation;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;

    public GAGOptionsDialog(Frame parent, GAGDictionary dict, GAGOptions opt) {
        super(parent, true);
        this.theGAGDictionary = dict;
        this.theGAGOptions = opt;
        this.initComponents();
        this.setTraversal();
        this.setData(this.theGAGOptions);
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private Object[] generateValues(int min, int max, boolean include_und) {
        if (include_und) {
            Object[] values = new Object[1 + (max - min + 1)];
            values[0] = "---";
            for (int i = min; i <= max; ++i) {
                values[i - min + 1] = i;
            }
            return values;
        }
        Object[] values = new Object[max - min + 1];
        for (int i = min; i <= max; ++i) {
            values[i - min] = i;
        }
        return values;
    }

    private void setValue(JSpinner field, int value) {
        if (value == 999) {
            field.setValue("---");
        } else {
            field.setValue(value);
        }
    }

    private int getValue(JSpinner field) {
        if (field.getValue().equals("---")) {
            return 999;
        }
        return (Integer)field.getValue();
    }

    private int limitValue(int v, int l) {
        if (v == 999) {
            return 999;
        }
        return Math.min(v, l);
    }

    private ListModel createModel(Collection<String> values) {
        DefaultListModel<String> ret = new DefaultListModel<String>();
        for (String v : values) {
            ret.addElement(v);
        }
        return ret;
    }

    private ListModel createModel(String[] values) {
        DefaultListModel<String> ret = new DefaultListModel<String>();
        for (int i = 0; i < values.length; ++i) {
            ret.addElement(values[i]);
        }
        return ret;
    }

    private void selectValues(JList field, String[] values) {
        DefaultListModel dlm = (DefaultListModel)field.getModel();
        for (int i = 0; i < values.length; ++i) {
            int ind = dlm.indexOf(values[i]);
            field.addSelectionInterval(ind, ind);
        }
    }

    private int getMaxNoAcetyls(GAGOptions gag_opt) {
        int ret = 0;
        for (int i = 0; i < gag_opt.GAG_FAMILIES.length; ++i) {
            GAGType cur_type = this.theGAGDictionary.getType(gag_opt.GAG_FAMILIES[i], gag_opt);
            ret = Math.max(ret, cur_type.getMaxNoAcetyls(gag_opt.MAX_NO_UNITS));
        }
        return ret;
    }

    private int getMaxNoSulfates(GAGOptions gag_opt) {
        int ret = 0;
        for (int i = 0; i < gag_opt.GAG_FAMILIES.length; ++i) {
            GAGType cur_type = this.theGAGDictionary.getType(gag_opt.GAG_FAMILIES[i], gag_opt);
            ret = Math.max(ret, cur_type.getMaxNoSulfates(gag_opt.MAX_NO_UNITS, 0));
        }
        return ret;
    }

    private void setData(GAGOptions gag_opt) {
        this.field_gag_families.setSelectionMode(2);
        this.field_gag_families.setModel(this.createModel(this.theGAGDictionary.getFamilies()));
        this.selectValues(this.field_gag_families, gag_opt.GAG_FAMILIES);
        this.field_min_no_units.setModel(new SpinnerListModel(this.generateValues(1, 10, false)));
        this.field_max_no_units.setModel(new SpinnerListModel(this.generateValues(1, 10, false)));
        this.setValue(this.field_min_no_units, gag_opt.MIN_NO_UNITS);
        this.setValue(this.field_max_no_units, gag_opt.MAX_NO_UNITS);
        int max_no_acetyls = this.getMaxNoAcetyls(gag_opt);
        this.field_min_no_acetyls.setModel(new SpinnerListModel(this.generateValues(0, max_no_acetyls, false)));
        this.field_max_no_acetyls.setModel(new SpinnerListModel(this.generateValues(0, max_no_acetyls, true)));
        this.setValue(this.field_min_no_acetyls, this.limitValue(gag_opt.MIN_NO_ACETYLS, max_no_acetyls));
        this.setValue(this.field_max_no_acetyls, this.limitValue(gag_opt.MAX_NO_ACETYLS, max_no_acetyls));
        int max_no_sulfates = this.getMaxNoSulfates(gag_opt);
        this.field_min_no_sulfates.setModel(new SpinnerListModel(this.generateValues(0, max_no_sulfates, false)));
        this.field_max_no_sulfates.setModel(new SpinnerListModel(this.generateValues(0, max_no_sulfates, true)));
        this.setValue(this.field_min_no_sulfates, this.limitValue(gag_opt.MIN_NO_SULFATES, max_no_sulfates));
        this.setValue(this.field_max_no_sulfates, this.limitValue(gag_opt.MAX_NO_SULFATES, max_no_sulfates));
        this.field_reduced.setSelected(gag_opt.IS_REDUCED);
        this.field_unsaturated.setSelected(gag_opt.IS_UNSATURATED);
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"Und", "perMe", "perDMe", "perMe(C^13)", "perAc", "perDAc"}));
        this.field_derivatization.setSelectedItem(gag_opt.DERIVATIZATION);
        this.field_modifications.setSelectionMode(2);
        this.field_modifications.setModel(this.createModel(GAGOptions.ALL_MODIFICATIONS));
        this.selectValues(this.field_modifications, gag_opt.MODIFICATIONS);
        this.field_allow_unlikely_acetylation.setSelected(gag_opt.ALLOW_UNLIKELY_ACETYLATION);
        this.field_allow_redend_loss.setSelected(gag_opt.ALLOW_REDEND_LOSS);
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_gag_families);
        tp.addComponent((Component)this.field_min_no_units);
        tp.addComponent((Component)this.field_max_no_units);
        tp.addComponent((Component)this.field_min_no_acetyls);
        tp.addComponent((Component)this.field_max_no_acetyls);
        tp.addComponent((Component)this.field_min_no_sulfates);
        tp.addComponent((Component)this.field_max_no_sulfates);
        tp.addComponent((Component)this.field_reduced);
        tp.addComponent((Component)this.field_unsaturated);
        tp.addComponent((Component)this.field_derivatization);
        tp.addComponent((Component)this.field_modifications);
        tp.addComponent((Component)this.field_allow_unlikely_acetylation);
        tp.addComponent((Component)this.field_allow_redend_loss);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.field_gag_families.addListSelectionListener(this);
        this.field_min_no_units.addChangeListener(this);
        this.field_max_no_units.addChangeListener(this);
        this.field_min_no_acetyls.addChangeListener(this);
        this.field_max_no_acetyls.addChangeListener(this);
        this.field_min_no_sulfates.addChangeListener(this);
        this.field_max_no_sulfates.addChangeListener(this);
        this.field_modifications.addListSelectionListener(this);
        this.field_allow_unlikely_acetylation.addItemListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private String[] getValues(JList field) {
        Object[] sel = field.getSelectedValues();
        String[] ret = new String[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            ret[i] = (String)sel[i];
        }
        return ret;
    }

    private void retrieveData(GAGOptions gag_opt) {
        gag_opt.GAG_FAMILIES = this.getValues(this.field_gag_families);
        gag_opt.MIN_NO_UNITS = this.getValue(this.field_min_no_units);
        gag_opt.MAX_NO_UNITS = this.getValue(this.field_max_no_units);
        gag_opt.MIN_NO_ACETYLS = this.getValue(this.field_min_no_acetyls);
        gag_opt.MAX_NO_ACETYLS = this.getValue(this.field_max_no_acetyls);
        gag_opt.MIN_NO_SULFATES = this.getValue(this.field_min_no_sulfates);
        gag_opt.MAX_NO_SULFATES = this.getValue(this.field_max_no_sulfates);
        gag_opt.IS_REDUCED = this.field_reduced.isSelected();
        gag_opt.IS_UNSATURATED = this.field_unsaturated.isSelected();
        gag_opt.DERIVATIZATION = (String)this.field_derivatization.getSelectedItem();
        gag_opt.MODIFICATIONS = this.getValues(this.field_modifications);
        gag_opt.ALLOW_UNLIKELY_ACETYLATION = this.field_allow_unlikely_acetylation.isSelected();
        gag_opt.ALLOW_REDEND_LOSS = this.field_allow_redend_loss.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData(this.theGAGOptions);
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.allow_events) {
            this.stateChanged(e.getSource());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.allow_events) {
            this.stateChanged(e.getSource());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.allow_events) {
            this.stateChanged(e.getSource());
        }
    }

    public void stateChanged(Object source) {
        this.allow_events = false;
        if (source == this.field_max_no_units) {
            this.setValue(this.field_min_no_units, Math.min(this.getValue(this.field_min_no_units), this.getValue(this.field_max_no_units)));
        } else if (source == this.field_min_no_units) {
            this.setValue(this.field_max_no_units, Math.max(this.getValue(this.field_min_no_units), this.getValue(this.field_max_no_units)));
        } else if (source == this.field_max_no_acetyls) {
            this.setValue(this.field_min_no_acetyls, Math.min(this.getValue(this.field_min_no_acetyls), this.getValue(this.field_max_no_acetyls)));
        } else if (source == this.field_min_no_acetyls) {
            this.setValue(this.field_max_no_acetyls, Math.max(this.getValue(this.field_min_no_acetyls), this.getValue(this.field_max_no_acetyls)));
        } else if (source == this.field_max_no_sulfates) {
            this.setValue(this.field_min_no_sulfates, Math.min(this.getValue(this.field_min_no_sulfates), this.getValue(this.field_max_no_sulfates)));
        } else if (source == this.field_min_no_sulfates) {
            this.setValue(this.field_max_no_sulfates, Math.max(this.getValue(this.field_min_no_sulfates), this.getValue(this.field_max_no_sulfates)));
        }
        GAGOptions buffer = new GAGOptions();
        this.retrieveData(buffer);
        this.setData(buffer);
        this.allow_events = true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.field_reduced = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.field_unsaturated = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.field_min_no_units = new JSpinner();
        this.field_max_no_units = new JSpinner();
        this.field_min_no_acetyls = new JSpinner();
        this.field_min_no_sulfates = new JSpinner();
        this.jLabel8 = new JLabel();
        this.field_max_no_acetyls = new JSpinner();
        this.field_max_no_sulfates = new JSpinner();
        this.jLabel9 = new JLabel();
        this.field_derivatization = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.field_gag_families = new JList();
        this.jLabel10 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.field_modifications = new JList();
        this.field_allow_unlikely_acetylation = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.field_allow_redend_loss = new JCheckBox();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GAGOptionsDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("GAG families");
        this.jLabel2.setText("# units");
        this.jLabel3.setText("Min");
        this.jLabel4.setText("# acetyls");
        this.jLabel5.setText("# sulfates");
        this.field_reduced.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_reduced.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel6.setText("reduced");
        this.field_unsaturated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_unsaturated.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel7.setText("unsaturated");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.jLabel8.setText("Max");
        this.jLabel9.setText("derivatized");
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.field_gag_families.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.field_gag_families.setVisibleRowCount(5);
        this.jScrollPane1.setViewportView(this.field_gag_families);
        this.jLabel10.setText("modifications");
        this.field_modifications.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.field_modifications.setVisibleRowCount(4);
        this.jScrollPane2.setViewportView(this.field_modifications);
        this.field_allow_unlikely_acetylation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_allow_unlikely_acetylation.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel12.setText("Allow unlikely");
        this.jLabel13.setText("acetylation");
        this.jLabel14.setText("Allow loss of");
        this.jLabel15.setText("reducing end");
        this.field_allow_redend_loss.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_allow_redend_loss.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(68, 68, 68).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 296, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(21, 21, 21).add((Component)this.jScrollPane1, -1, 194, Short.MAX_VALUE)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel13)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel15)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel10).add((Component)this.jLabel12).add((Component)this.jLabel9).add((Component)this.jLabel7).add((Component)this.jLabel6).add((Component)this.jLabel5).add((Component)this.jLabel4).add((Component)this.jLabel2).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.field_allow_redend_loss).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).add(60, 60, 60)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.field_min_no_sulfates, -1, 91, Short.MAX_VALUE).add((Component)this.field_min_no_acetyls, -1, 91, Short.MAX_VALUE).add(1, (Component)this.field_reduced).add(1, (Component)this.field_unsaturated).add(1, (Component)this.field_derivatization, 0, 91, Short.MAX_VALUE).add(1, (Component)this.field_min_no_units, -1, 91, Short.MAX_VALUE)).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel8).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.field_max_no_units).add(1, (Component)this.field_max_no_acetyls, -1, 64, Short.MAX_VALUE).add((Component)this.field_max_no_sulfates))).addPreferredGap(0)).add(1, (Component)this.field_allow_unlikely_acetylation).add((Component)this.jScrollPane2, -1, 194, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.field_max_no_units, this.field_min_no_units}, 1);
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -2, 90, -2)).add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_max_no_units, -2, -1, -2).add((Component)this.field_min_no_units, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_min_no_acetyls, -2, -1, -2).add((Component)this.field_max_no_acetyls, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_min_no_sulfates, -2, -1, -2).add((Component)this.field_max_no_sulfates, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_reduced).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_unsaturated).add((Component)this.jLabel7)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_derivatization, -2, -1, -2).add((Component)this.jLabel9)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabel10).add(62, 62, 62)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jScrollPane2, -2, 71, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_allow_unlikely_acetylation).add((Component)this.jLabel12, -2, 15, -2)).addPreferredGap(0).add((Component)this.jLabel13).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel14, -2, 15, -2).add((Component)this.field_allow_redend_loss)).addPreferredGap(0).add((Component)this.jLabel15).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

