/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.jdesktop.layout.GroupLayout;

public class AnnotationOptionsDialog
extends EscapeDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private FragmentOptions theFragmentOptions;
    private AnnotationOptions theAnnotationOptions;
    private boolean annotate_fragments = true;
    private boolean derive_options = true;
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_accuracy;
    private JComboBox field_accuracy_unit;
    private JCheckBox field_afragments;
    private JCheckBox field_bfragments;
    private JCheckBox field_cfragments;
    private JCheckBox field_compute_exchanges;
    private JCheckBox field_derive_from_parent;
    private JCheckBox field_internal_fragments;
    private JSpinner field_max_ex_k_ions;
    private JSpinner field_max_ex_li_ions;
    private JSpinner field_max_ex_na_ions;
    private JSpinner field_max_no_charges;
    private JSpinner field_max_no_h_ions;
    private JSpinner field_max_no_k_ions;
    private JSpinner field_max_no_li_ions;
    private JSpinner field_max_no_na_ions;
    private JCheckBox field_negative_mode;
    private JSpinner field_no_cleavages;
    private JSpinner field_no_crossrings;
    private JCheckBox field_xfragments;
    private JCheckBox field_yfragments;
    private JCheckBox field_zfragments;
    private JCheckBox field_iterate_ion_combinations;
    private JCheckBox field_clearExistingAnnotations;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public AnnotationOptionsDialog(Frame parent, FragmentOptions frag_opt, AnnotationOptions ann_opt, boolean ann_fragments, boolean der_options) {
        super(parent, true);
        this.theFragmentOptions = frag_opt != null ? frag_opt : new FragmentOptions();
        this.theAnnotationOptions = ann_opt != null ? ann_opt : new AnnotationOptions();
        this.annotate_fragments = ann_fragments;
        this.derive_options = der_options;
        this.initComponents();
        this.fillComponents();
        this.setSelections();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private void setValue(JSpinner field, int value) {
        if (value == 999) {
            field.setValue("---");
        } else {
            field.setValue(value);
        }
    }

    private int getValue(JSpinner field) {
        if (field.getValue().equals("---")) {
            return 999;
        }
        return (Integer)field.getValue();
    }

    private Object[] generateValues(int min, int max, boolean include_und) {
        if (include_und) {
            Object[] values = new Object[1 + (max - min + 1)];
            values[0] = "---";
            for (int i = min; i <= max; ++i) {
                values[i - min + 1] = i;
            }
            return values;
        }
        Object[] values = new Object[max - min + 1];
        for (int i = min; i <= max; ++i) {
            values[i - min] = i;
        }
        return values;
    }

    private void fillComponents() {
        this.field_no_cleavages.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.field_no_crossrings.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        this.field_accuracy_unit.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.field_accuracy_unit.addItem("Da");
        this.field_accuracy_unit.addItem("ppm");
        this.field_max_no_h_ions.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.field_max_no_na_ions.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.field_max_no_li_ions.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.field_max_no_k_ions.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.field_max_no_charges.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.field_max_ex_na_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_max_ex_li_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_max_ex_k_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_accuracy.setText("1.0");
    }

    private void setSelections() {
        this.field_afragments.setSelected(this.theFragmentOptions.ADD_AFRAGMENTS);
        this.field_bfragments.setSelected(this.theFragmentOptions.ADD_BFRAGMENTS);
        this.field_cfragments.setSelected(this.theFragmentOptions.ADD_CFRAGMENTS);
        this.field_xfragments.setSelected(this.theFragmentOptions.ADD_XFRAGMENTS);
        this.field_yfragments.setSelected(this.theFragmentOptions.ADD_YFRAGMENTS);
        this.field_zfragments.setSelected(this.theFragmentOptions.ADD_ZFRAGMENTS);
        this.field_iterate_ion_combinations.setSelected(this.theFragmentOptions.ITERATE_ION_COMBINATIONS);
        this.field_internal_fragments.setSelected(this.theFragmentOptions.INTERNAL_FRAGMENTS);
        this.field_no_cleavages.setValue(this.theFragmentOptions.MAX_NO_CLEAVAGES);
        this.field_no_crossrings.setValue(this.theFragmentOptions.MAX_NO_CROSSRINGS);
        this.field_negative_mode.setSelected(this.theAnnotationOptions.NEGATIVE_MODE);
        this.field_max_no_h_ions.setValue(this.theAnnotationOptions.MAX_NO_H_IONS);
        this.field_max_no_na_ions.setValue(this.theAnnotationOptions.MAX_NO_NA_IONS);
        this.field_max_no_li_ions.setValue(this.theAnnotationOptions.MAX_NO_LI_IONS);
        this.field_max_no_k_ions.setValue(this.theAnnotationOptions.MAX_NO_K_IONS);
        this.field_max_no_charges.setValue(this.theAnnotationOptions.MAX_NO_CHARGES);
        this.field_compute_exchanges.setSelected(this.theAnnotationOptions.COMPUTE_EXCHANGES);
        this.setValue(this.field_max_ex_na_ions, this.theAnnotationOptions.MAX_EX_NA_IONS);
        this.setValue(this.field_max_ex_li_ions, this.theAnnotationOptions.MAX_EX_LI_IONS);
        this.setValue(this.field_max_ex_k_ions, this.theAnnotationOptions.MAX_EX_K_IONS);
        this.field_derive_from_parent.setSelected(this.theAnnotationOptions.DERIVE_FROM_PARENT && this.derive_options);
        this.field_accuracy.setText(Double.toString(this.theAnnotationOptions.MASS_ACCURACY));
        this.field_accuracy_unit.setSelectedItem(this.theAnnotationOptions.MASS_ACCURACY_UNIT);
        this.field_clearExistingAnnotations.setSelected(this.theAnnotationOptions.CLEAR_EXISTING_ANNOTATIONS);
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_bfragments);
        tp.addComponent((Component)this.field_cfragments);
        tp.addComponent((Component)this.field_yfragments);
        tp.addComponent((Component)this.field_zfragments);
        tp.addComponent((Component)this.field_afragments);
        tp.addComponent((Component)this.field_xfragments);
        tp.addComponent((Component)this.field_internal_fragments);
        tp.addComponent((Component)this.field_no_cleavages);
        tp.addComponent((Component)this.field_no_crossrings);
        tp.addComponent((Component)this.field_internal_fragments);
        tp.addComponent((Component)this.field_negative_mode);
        tp.addComponent((Component)this.field_max_no_h_ions);
        tp.addComponent((Component)this.field_max_no_na_ions);
        tp.addComponent((Component)this.field_max_no_li_ions);
        tp.addComponent((Component)this.field_max_no_k_ions);
        tp.addComponent((Component)this.field_max_no_charges);
        tp.addComponent((Component)this.field_compute_exchanges);
        tp.addComponent((Component)this.field_max_ex_na_ions);
        tp.addComponent((Component)this.field_max_ex_li_ions);
        tp.addComponent((Component)this.field_max_ex_k_ions);
        tp.addComponent((Component)this.field_derive_from_parent);
        tp.addComponent((Component)this.field_accuracy);
        tp.addComponent((Component)this.field_accuracy_unit);
        tp.addComponent((Component)this.field_clearExistingAnnotations);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.field_negative_mode.addItemListener(this);
        this.field_compute_exchanges.addItemListener(this);
        this.field_max_no_h_ions.addChangeListener(this);
        this.field_max_no_na_ions.addChangeListener(this);
        this.field_max_no_li_ions.addChangeListener(this);
        this.field_max_no_k_ions.addChangeListener(this);
        this.field_max_no_charges.addChangeListener(this);
        this.field_max_ex_na_ions.addChangeListener(this);
        this.field_max_ex_li_ions.addChangeListener(this);
        this.field_max_ex_k_ions.addChangeListener(this);
        this.field_derive_from_parent.addItemListener(this);
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
        this.field_clearExistingAnnotations.addActionListener(this);
    }

    private void enableItems() {
        this.field_afragments.setEnabled(this.annotate_fragments);
        this.field_bfragments.setEnabled(this.annotate_fragments);
        this.field_cfragments.setEnabled(this.annotate_fragments);
        this.field_xfragments.setEnabled(this.annotate_fragments);
        this.field_yfragments.setEnabled(this.annotate_fragments);
        this.field_zfragments.setEnabled(this.annotate_fragments);
        this.field_iterate_ion_combinations.setEnabled(this.annotate_fragments);
        this.field_internal_fragments.setEnabled(this.annotate_fragments);
        this.field_no_cleavages.setEnabled(this.annotate_fragments);
        this.field_no_crossrings.setEnabled(this.annotate_fragments);
        this.field_negative_mode.setEnabled(!this.field_derive_from_parent.isSelected());
        this.field_max_no_h_ions.setEnabled(!this.field_derive_from_parent.isSelected());
        this.field_max_no_na_ions.setEnabled(!this.field_negative_mode.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_max_no_li_ions.setEnabled(!this.field_negative_mode.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_max_no_k_ions.setEnabled(!this.field_negative_mode.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_max_no_charges.setEnabled(!this.field_derive_from_parent.isSelected());
        this.field_compute_exchanges.setEnabled(!this.field_derive_from_parent.isSelected());
        this.field_max_ex_na_ions.setEnabled(this.field_compute_exchanges.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_max_ex_li_ions.setEnabled(this.field_compute_exchanges.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_max_ex_k_ions.setEnabled(this.field_compute_exchanges.isSelected() && !this.field_derive_from_parent.isSelected());
        this.field_derive_from_parent.setEnabled(this.derive_options);
    }

    private void retrieveData() {
        this.theFragmentOptions.ADD_AFRAGMENTS = this.field_afragments.isSelected();
        this.theFragmentOptions.ADD_BFRAGMENTS = this.field_bfragments.isSelected();
        this.theFragmentOptions.ADD_CFRAGMENTS = this.field_cfragments.isSelected();
        this.theFragmentOptions.ADD_XFRAGMENTS = this.field_xfragments.isSelected();
        this.theFragmentOptions.ADD_YFRAGMENTS = this.field_yfragments.isSelected();
        this.theFragmentOptions.ADD_ZFRAGMENTS = this.field_zfragments.isSelected();
        this.theFragmentOptions.ITERATE_ION_COMBINATIONS = this.field_iterate_ion_combinations.isSelected();
        this.theFragmentOptions.INTERNAL_FRAGMENTS = this.field_internal_fragments.isSelected();
        this.theFragmentOptions.MAX_NO_CLEAVAGES = (Integer)this.field_no_cleavages.getValue();
        this.theFragmentOptions.MAX_NO_CROSSRINGS = (Integer)this.field_no_crossrings.getValue();
        this.theAnnotationOptions.NEGATIVE_MODE = this.field_negative_mode.isSelected();
        this.theAnnotationOptions.MAX_NO_H_IONS = (Integer)this.field_max_no_h_ions.getValue();
        this.theAnnotationOptions.MAX_NO_NA_IONS = (Integer)this.field_max_no_na_ions.getValue();
        this.theAnnotationOptions.MAX_NO_LI_IONS = (Integer)this.field_max_no_li_ions.getValue();
        this.theAnnotationOptions.MAX_NO_K_IONS = (Integer)this.field_max_no_k_ions.getValue();
        this.theAnnotationOptions.MAX_NO_CHARGES = (Integer)this.field_max_no_charges.getValue();
        this.theAnnotationOptions.COMPUTE_EXCHANGES = this.field_compute_exchanges.isSelected();
        this.theAnnotationOptions.MAX_EX_NA_IONS = this.getValue(this.field_max_ex_na_ions);
        this.theAnnotationOptions.MAX_EX_LI_IONS = this.getValue(this.field_max_ex_li_ions);
        this.theAnnotationOptions.MAX_EX_K_IONS = this.getValue(this.field_max_ex_k_ions);
        if (this.derive_options) {
            this.theAnnotationOptions.DERIVE_FROM_PARENT = this.field_derive_from_parent.isSelected();
        }
        this.theAnnotationOptions.MASS_ACCURACY = Double.valueOf(this.field_accuracy.getText());
        this.theAnnotationOptions.MASS_ACCURACY_UNIT = (String)this.field_accuracy_unit.getSelectedItem();
        this.theAnnotationOptions.CLEAR_EXISTING_ANNOTATIONS = this.field_clearExistingAnnotations.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.return_status = action;
            this.closeDialog();
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableItems();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        int max_no_charges_ions = 0;
        max_no_charges_ions = Math.max(max_no_charges_ions, (Integer)this.field_max_no_h_ions.getValue());
        if (!this.field_negative_mode.isSelected()) {
            max_no_charges_ions = Math.max(max_no_charges_ions, (Integer)this.field_max_no_na_ions.getValue());
            max_no_charges_ions = Math.max(max_no_charges_ions, (Integer)this.field_max_no_li_ions.getValue());
            max_no_charges_ions = Math.max(max_no_charges_ions, (Integer)this.field_max_no_k_ions.getValue());
        }
        if (source == this.field_max_no_charges) {
            int max_no_charges_new = (Integer)this.field_max_no_charges.getValue();
            this.enforceValue(this.field_max_no_h_ions, max_no_charges_ions, max_no_charges_new);
            this.enforceValue(this.field_max_no_na_ions, max_no_charges_ions, max_no_charges_new);
            this.enforceValue(this.field_max_no_li_ions, max_no_charges_ions, max_no_charges_new);
            this.enforceValue(this.field_max_no_k_ions, max_no_charges_ions, max_no_charges_new);
        }
        if (source == this.field_max_no_h_ions || source == this.field_max_no_na_ions || source == this.field_max_no_li_ions || source == this.field_max_no_k_ions) {
            this.field_max_no_charges.setValue(max_no_charges_ions);
        }
    }

    public void enforceValue(JSpinner field, int old_max_value, int new_max_value) {
        int value = (Integer)field.getValue();
        if (value > new_max_value || value == old_max_value) {
            field.setValue(new_max_value);
        }
    }

    private void initComponents() {
        this.field_bfragments = new JCheckBox();
        this.field_cfragments = new JCheckBox();
        this.field_yfragments = new JCheckBox();
        this.field_zfragments = new JCheckBox();
        this.field_iterate_ion_combinations = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jLabel3 = new JLabel();
        this.field_afragments = new JCheckBox();
        this.field_xfragments = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.field_accuracy = new JTextField();
        this.field_accuracy_unit = new JComboBox();
        this.jLabel18 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.field_compute_exchanges = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.field_negative_mode = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.field_no_cleavages = new JSpinner();
        this.field_no_crossrings = new JSpinner();
        this.field_max_no_charges = new JSpinner();
        this.field_max_no_h_ions = new JSpinner();
        this.field_max_no_na_ions = new JSpinner();
        this.field_max_no_li_ions = new JSpinner();
        this.field_max_no_k_ions = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.field_max_ex_na_ions = new JSpinner();
        this.field_max_ex_li_ions = new JSpinner();
        this.field_max_ex_k_ions = new JSpinner();
        this.field_derive_from_parent = new JCheckBox();
        this.field_internal_fragments = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.field_clearExistingAnnotations = new JCheckBox();
        this.setTitle("Fragment options");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AnnotationOptionsDialog.this.closeDialog();
            }
        });
        this.field_bfragments.setText("B fragments");
        this.field_bfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_bfragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_cfragments.setText("C fragments");
        this.field_cfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_cfragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_yfragments.setText("Y fragments");
        this.field_yfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_yfragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_zfragments.setText("Z fragments");
        this.field_zfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_zfragments.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel1.setText("Fragment types");
        this.jLabel2.setText("Max n.o. cleavages");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.jLabel3.setText("Cross ring fragments");
        this.field_afragments.setText("A fragments");
        this.field_afragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_afragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_xfragments.setText("X fragments");
        this.field_xfragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_xfragments.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel14.setText("Max # H ions");
        this.jLabel15.setText("Max # Na ions");
        this.jLabel16.setText("Max # Li ions");
        this.jLabel17.setText("Accuracy");
        this.field_accuracy.setText("9999.9999");
        this.field_accuracy_unit.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "da"}));
        this.jLabel18.setText("Max # K ions");
        this.jLabel4.setFont(new Font("Dialog", 2, 12));
        this.jLabel4.setText("Fragment options");
        this.jLabel5.setFont(new Font("Dialog", 2, 12));
        this.jLabel5.setText("Mass options");
        this.jLabel6.setText("Max # charges");
        this.jLabel8.setText("Max n.o. cross rings");
        this.field_compute_exchanges.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_compute_exchanges.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel19.setText("Neutral exchanges");
        this.field_negative_mode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_negative_mode.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel9.setText("Negative mode");
        this.jLabel20.setText("Max ex. Na ions");
        this.jLabel21.setText("Max ex. Li ions");
        this.jLabel22.setText("Max ex K ions");
        this.field_clearExistingAnnotations.setText("Clear existing annotations");
        this.field_derive_from_parent.setText("Derive options from parent ion");
        this.field_derive_from_parent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_derive_from_parent.setMargin(new Insets(0, 0, 0, 0));
        this.field_internal_fragments.setText("Internal fragments");
        this.field_internal_fragments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_internal_fragments.setMargin(new Insets(0, 0, 0, 0));
        this.field_iterate_ion_combinations.setText("Iterate ion combinations");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 362, Short.MAX_VALUE).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_bfragments).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.field_xfragments, -1, -1, Short.MAX_VALUE).add(1, (Component)this.field_afragments, -1, -1, Short.MAX_VALUE).add(1, (Component)this.field_zfragments, -1, -1, Short.MAX_VALUE).add(1, (Component)this.field_yfragments, -1, -1, Short.MAX_VALUE).add(1, (Component)this.field_cfragments, -1, -1, Short.MAX_VALUE)).add((Component)this.field_internal_fragments).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.field_no_crossrings).add(1, (Component)this.field_no_cleavages, -1, 50, Short.MAX_VALUE)))).add((Component)this.jLabel5).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel9).add((Component)this.jLabel14).add((Component)this.jLabel15).add((Component)this.jLabel16).add((Component)this.jLabel18).add((Component)this.jLabel6).add((Component)this.jLabel17)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.field_max_no_k_ions).add((Component)this.field_max_no_li_ions).add((Component)this.field_max_no_na_ions).add((Component)this.field_max_no_charges).add((Component)this.field_negative_mode).add((Component)this.field_max_no_h_ions, -2, 51, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel20).add((Component)this.jLabel21).add((Component)this.jLabel22)).add(29, 29, 29).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_max_ex_na_ions, -2, 56, -2).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_max_ex_k_ions, -1, 56, Short.MAX_VALUE).add((Component)this.field_max_ex_li_ions, -1, 56, Short.MAX_VALUE))))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel19).addPreferredGap(0).add((Component)this.field_compute_exchanges)))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.field_accuracy).addPreferredGap(0).add((Component)this.field_accuracy_unit, -2, 60, -2)).add(1, (Component)this.field_derive_from_parent).add(1, (Component)this.field_iterate_ion_combinations))))))).add((GroupLayout.Group)layout.createSequentialGroup().add(100, 100, 100).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add(1, (Component)this.field_clearExistingAnnotations)).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_bfragments)).addPreferredGap(0).add((Component)this.field_cfragments).addPreferredGap(0).add((Component)this.field_yfragments).addPreferredGap(0).add((Component)this.field_zfragments).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_afragments, -2, 15, -2)).addPreferredGap(0).add((Component)this.field_xfragments).addPreferredGap(0).add((Component)this.field_internal_fragments).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_no_cleavages, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.field_no_crossrings, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.field_negative_mode).add((Component)this.jLabel19).add((Component)this.field_compute_exchanges)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel14).add((Component)this.field_max_no_h_ions, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.field_max_no_na_ions, -2, -1, -2).add((Component)this.jLabel20).add((Component)this.field_max_ex_na_ions, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel16).add((Component)this.field_max_no_li_ions, -2, -1, -2).add((Component)this.jLabel21).add((Component)this.field_max_ex_li_ions, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.field_max_no_k_ions, -2, -1, -2).add((Component)this.jLabel22).add((Component)this.field_max_ex_k_ions, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.field_max_no_charges, -2, -1, -2)).addPreferredGap(0).add((Component)this.field_derive_from_parent, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel17).add((Component)this.field_accuracy_unit, -2, -1, -2).add((Component)this.field_accuracy, -2, 27, -2)).add((Component)this.field_iterate_ion_combinations).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap().add((Component)this.field_clearExistingAnnotations)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void hideClearAnnotationOption() {
        this.field_clearExistingAnnotations.setVisible(false);
        this.pack();
    }
}

