/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;

@Singleton
public class UtilityFile {
    private static Logger logger = Logger.getLogger(UtilityFile.class);
    @Inject
    @Named(value="workspace_location")
    private static String workspaceLocation;
    @Inject
    private static IGritsDataModelService gritsDataModelService;

    public static String generateFileName(String[] existingNames) {
        logger.info((Object)"Generating file name ");
        String fileName = "";
        int randomLength = 0;
        do {
            fileName = "sample";
            while (randomLength < 5) {
                int randomcharacter = (int)(Math.random() * 10.0);
                ++randomLength;
                fileName = String.valueOf(fileName) + randomcharacter;
            }
            fileName = String.valueOf(fileName) + ".xml";
        } while (Arrays.asList(existingNames).contains(fileName));
        logger.info((Object)("File name generated " + fileName));
        return fileName;
    }

    public static File getSampleGroupDirectory(String projectName) {
        String sampleFolderLocation = String.valueOf(workspaceLocation) + File.separator + projectName + File.separator + "samples";
        File sampleFolder = new File(sampleFolderLocation);
        if (!sampleFolder.exists() || !sampleFolder.isDirectory()) {
            sampleFolder.mkdir();
            logger.info((Object)("Sample folder created : " + sampleFolder.getAbsolutePath()));
        }
        logger.info((Object)("Sample folder found : " + sampleFolder.getAbsolutePath()));
        return sampleFolder;
    }

    public static File getSampleFolderForSample(Entry sampleEntry) {
        logger.info((Object)"Getting sample folder ");
        File sampleFile = null;
        if (sampleEntry != null) {
            logger.info((Object)("Sample folder for : " + sampleEntry.getDisplayName()));
            Entry projectEntry = gritsDataModelService.findParentByType(sampleEntry, "org.grits.toolbox.property.project");
            sampleFile = UtilityFile.getSampleGroupDirectory(projectEntry.getDisplayName());
        }
        return sampleFile;
    }

    public static boolean updateSampleFile(Sample sample, Entry analyteEntry) {
        boolean updated;
        block6: {
            logger.info((Object)"Updating file for analyte entry");
            updated = false;
            try {
                try {
                    SampleProperty sampleProperty = (SampleProperty)analyteEntry.getProperty();
                    PropertyDataFile sampleDataFile = sampleProperty.getSampleFile();
                    if (sampleDataFile != null && sampleDataFile.getName() != null) {
                        String fileLocation = UtilityFile.getSampleFolderForSample(analyteEntry) + File.separator + sampleDataFile.getName();
                        UtilityFile.writeToFile(sample, fileLocation);
                        updated = true;
                        logger.info((Object)("Sample updated in file : " + fileLocation));
                        break block6;
                    }
                    logger.fatal((Object)"Sample entry does not have a sample file name.");
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Getting File", (String)"Sample entry does not have a sample file name.");
                }
                catch (IOException e) {
                    logger.error((Object)("The changes made could not be written to the file.\n" + e.getMessage()), (Throwable)e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Writing File", (String)"The changes made could not be written to the file.");
                }
                catch (JAXBException e) {
                    logger.error((Object)("The changes made could not be serialized as xml.\n" + e.getMessage()), (Throwable)e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Parsing File", (String)"The changes made could not be serialized to xml.");
                }
            }
            catch (Exception e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Saving File", (String)"The changes made could not be saved to the file. Please contact developers.");
            }
        }
        return updated;
    }

    public static void writeToFile(Sample sample, String fileLocation) throws JAXBException, IOException {
        logger.info((Object)"Writing sample to file");
        if (sample == null || fileLocation == null || fileLocation.isEmpty()) {
            throw new IOException("Null empty value for analyte or its file. Sample : " + sample + " Filelocation : " + fileLocation);
        }
        logger.info((Object)"Serializing the sample object to xml");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter fileWriter = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sample.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)sample, (OutputStream)os);
            logger.info((Object)"Writing the serialized data to the file");
            fileWriter = new FileWriter(fileLocation);
            fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        }
        finally {
            os.close();
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }
}

