/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.commands.EvaluateData;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.ncbi.NCBIGeneUtil;
import org.grits.toolbox.entry.qrtpcr.table.manager.ManagerNatTable;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class ExcelFileHandler {
    private static XSSFCellStyle stylePink;
    private static XSSFCellStyle boldStyle;
    private static XSSFCellStyle stylePurple;
    private static XSSFCellStyle styleRed;
    private static XSSFCellStyle blueBackGround;
    private static XSSFCellStyle yellowCell;
    private static XSSFCellStyle styleRedFill;
    private static XSSFCellStyle styleOrangeFill;
    private static int DEFAULT_CONTROL_GENE_LOCATION;
    private static Logger logger;

    static {
        DEFAULT_CONTROL_GENE_LOCATION = 9;
        logger = Logger.getLogger(ExcelFileHandler.class);
    }

    public static List<GeneList> readMasterGeneLists(String filename, String organism) throws IOException {
        File masterFile = new File(filename);
        FileInputStream file = new FileInputStream(masterFile);
        ArrayList<GeneList> masterLists = new ArrayList<GeneList>();
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        Iterator sheets = workbook.iterator();
        while (sheets.hasNext()) {
            GeneList list = new GeneList();
            Sheet sheet = (Sheet)sheets.next();
            if (!sheet.getSheetName().contains("Gene List")) continue;
            list.setListName(sheet.getSheetName());
            List<Gene> genes = ExcelFileHandler.readMasterGeneListFile(sheet, organism);
            list.setGenes(genes);
            list.setOrganism(organism);
            masterLists.add(list);
        }
        workbook.close();
        file.close();
        return masterLists;
    }

    public static List<Gene> readMasterGeneListFile(String filename, String organism) throws IOException {
        FileInputStream file = new FileInputStream(new File(filename));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        Iterator sheets = workbook.iterator();
        List<Gene> genes = ExcelFileHandler.readMasterGeneListFile((Sheet)sheets.next(), organism);
        workbook.close();
        file.close();
        return genes;
    }

    public static List<Gene> readMasterGeneListFile(Sheet sheet, String organism) throws IOException {
        ArrayList<Gene> geneList = new ArrayList<Gene>();
        Iterator rowIterator = sheet.iterator();
        int i = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (i < 9) {
                ++i;
                continue;
            }
            boolean geneAdd = false;
            Gene gene = new Gene();
            Iterator cellIterator = row.cellIterator();
            boolean makeACopy = false;
            String prefixIdCopy = null;
            String geneSymbolCopy = null;
            block18: while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                switch (cell.getColumnIndex()) {
                    case 0: {
                        String group = cell.getStringCellValue();
                        gene.setGroup(group);
                        if (group == null || !group.toLowerCase().equalsIgnoreCase("housekeeping gene")) continue block18;
                        gene.setIsCommon(true);
                        break;
                    }
                    case 1: {
                        if (cell.getCellType() == CellType.NUMERIC) {
                            gene.setNotes(String.valueOf(cell.getNumericCellValue()));
                            break;
                        }
                        gene.setNotes(cell.getStringCellValue());
                        break;
                    }
                    case 2: {
                        String prefixId = cell.getStringCellValue();
                        if (prefixId == null || prefixId.length() <= 0) continue block18;
                        geneAdd = true;
                        if (prefixId.contains("/")) {
                            gene.setGeneIdentifier(prefixId.substring(0, prefixId.indexOf("/")));
                            int pindex = prefixId.indexOf("_");
                            if (pindex == -1) break;
                            String pre = prefixId.substring(0, pindex);
                            prefixIdCopy = String.valueOf(pre) + "_" + prefixId.substring(prefixId.indexOf("/") + 1);
                            makeACopy = true;
                            break;
                        }
                        if (prefixId.contains("(")) {
                            gene.setGeneIdentifier(prefixId.substring(0, prefixId.indexOf("(")).trim());
                            makeACopy = true;
                            prefixIdCopy = prefixId.substring(prefixId.indexOf("(") + 1, prefixId.indexOf(")"));
                            break;
                        }
                        gene.setGeneIdentifier(prefixId);
                        break;
                    }
                    case 3: {
                        String value = cell.getStringCellValue();
                        if (value != null && value.toLowerCase().contains("no mouse gene")) {
                            geneAdd = false;
                            break;
                        }
                        gene.setAliasString(value.trim());
                        break;
                    }
                    case 4: {
                        if (cell.getCellType() == CellType.NUMERIC) {
                            gene.addGeneId((int)cell.getNumericCellValue());
                            break;
                        }
                        String geneId = cell.getStringCellValue();
                        if (geneId != null && geneId.toLowerCase().startsWith("no hs gene")) {
                            geneAdd = false;
                            break;
                        }
                        try {
                            gene.setGeneIds(geneId);
                        }
                        catch (NumberFormatException e) {
                            logger.warn((Object)"gene id is not valid", (Throwable)e);
                        }
                        continue block18;
                    }
                    case 5: {
                        gene.addRefSeq(cell.getStringCellValue().trim());
                        break;
                    }
                    case 6: {
                        List<String> existing = gene.getRefSeq();
                        gene.setRefSeq(cell.getStringCellValue().trim());
                        List<String> alternatives = gene.getRefSeq();
                        gene.setRefSeq(existing);
                        for (String string : alternatives) {
                            gene.addRefSeq(string);
                        }
                        continue block18;
                    }
                    case 7: {
                        String symbol = cell.getStringCellValue();
                        if (symbol != null && symbol.contains("/") && makeACopy) {
                            gene.setGeneSymbol(symbol.substring(0, symbol.indexOf("/")));
                            geneSymbolCopy = symbol.substring(symbol.indexOf("/") + 1);
                            break;
                        }
                        if (symbol.contains("(") && makeACopy) {
                            gene.setGeneSymbol(symbol.substring(0, symbol.indexOf("(")).trim());
                            geneSymbolCopy = symbol.substring(symbol.indexOf("(") + 1, symbol.indexOf(")"));
                            break;
                        }
                        gene.setGeneSymbol(symbol);
                        break;
                    }
                    case 8: {
                        gene.setForwardPrimer(cell.getStringCellValue());
                        break;
                    }
                    case 9: {
                        gene.setReversePrimer(cell.getStringCellValue());
                        break;
                    }
                    case 10: {
                        gene.setDescription(cell.getStringCellValue());
                        break;
                    }
                }
            }
            if (makeACopy && prefixIdCopy != null) {
                Gene copyGene = GeneUtils.makeACopy(gene);
                copyGene.setGeneIdentifier(prefixIdCopy);
                if (geneSymbolCopy != null) {
                    copyGene.setGeneSymbol(geneSymbolCopy);
                }
                geneList.add(copyGene);
            }
            if (!geneAdd) continue;
            try {
                ExcelFileHandler.getDetailsFromNCBI(gene, organism);
            }
            catch (Exception e) {
                logger.error((Object)("Could not get the details from NCBI for gene " + gene.getGeneSymbol()), (Throwable)e);
            }
            geneList.add(gene);
        }
        return geneList;
    }

    private static void getDetailsFromNCBI(Gene gene, String organism) throws MalformedURLException, Exception {
        NCBIGeneUtil util = new NCBIGeneUtil();
        if (gene.getGeneIds() != null) {
            ArrayList<String> aliasList = new ArrayList<String>();
            ArrayList<String> locationList = new ArrayList<String>();
            ArrayList<String> refSeqList = new ArrayList<String>();
            ArrayList<String> secondaryRefSeqList = new ArrayList<String>();
            String fullname = null;
            for (Integer geneId : gene.getGeneIds()) {
                Gene newGene = util.getDetailsFromNCBI(geneId);
                if (newGene == null) continue;
                aliasList.addAll(newGene.getAliases());
                locationList.addAll(newGene.getLocations());
                refSeqList.addAll(newGene.getRefSeq());
                secondaryRefSeqList.addAll(newGene.getSecondaryRefSeq());
                fullname = newGene.getFullName();
            }
            if (gene.getRefSeq() != null) {
                gene.getRefSeq().addAll(refSeqList);
            } else {
                gene.setRefSeq(refSeqList);
            }
            gene.setSecondaryRefSeq(secondaryRefSeqList);
            gene.setLocations(locationList);
            if (gene.getAliases() != null) {
                gene.getAliases().addAll(aliasList);
            } else {
                gene.setAliases(aliasList);
            }
            gene.setFullName(fullname);
        } else {
            Gene newGene;
            Integer geneId = util.getGeneIdFromNCBI(gene.getGeneSymbol(), organism);
            if (geneId != null && (newGene = util.getDetailsFromNCBI(geneId)) != null) {
                if (gene.getAliases() != null) {
                    gene.getAliases().addAll(newGene.getAliases());
                } else {
                    gene.setAliases(newGene.getAliases());
                }
                gene.setLocations(newGene.getLocations());
                if (gene.getRefSeq() != null) {
                    gene.getRefSeq().addAll(newGene.getRefSeq());
                } else {
                    gene.setRefSeq(newGene.getRefSeq());
                }
                gene.setSecondaryRefSeq(newGene.getSecondaryRefSeq());
                gene.setFullName(newGene.getFullName());
            }
        }
    }

    public static Map<String, List<String>> readRerunLayoutFile(Entry entry, String filename, int rep, String sheetName) throws IOException {
        String fileFolder = FileUtils.getFileFolder(entry);
        FileInputStream file = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        XSSFSheet sheet = null;
        if (sheetName != null) {
            sheet = workbook.getSheet(sheetName);
        }
        if (sheet == null) {
            workbook.close();
            throw new IOException("Invalid file. Could not find plate layout sheet");
        }
        Iterator rowIterator = sheet.iterator();
        TreeMap<String, List<String>> geneListMap = new TreeMap<String, List<String>>();
        HashMap<Integer, String> plateMap = new HashMap<Integer, String>();
        int i = 0;
        int numOfColumns = 12 / rep;
        int increment = numOfColumns + 3;
        int plateIdIndex = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            int j = 0;
            plateIdIndex = 0;
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                String geneIdentifier;
                String plateId;
                Cell cell = (Cell)cellIterator.next();
                int columnIndex = cell.getColumnIndex();
                if (i == 0 && columnIndex == plateIdIndex) {
                    plateId = cell.getStringCellValue();
                    plateMap.put(columnIndex, plateId);
                    plateIdIndex += increment;
                    continue;
                }
                if (i == 0) continue;
                if (columnIndex >= j) {
                    j += increment;
                }
                if (columnIndex == j - increment || columnIndex == j - 1 || columnIndex == j - increment + 1 || (plateId = (String)plateMap.get(j - increment)) == null) continue;
                ArrayList<String> geneList = (ArrayList<String>)geneListMap.get(plateId);
                if (geneList == null) {
                    geneList = new ArrayList<String>();
                }
                if ((geneIdentifier = cell.getStringCellValue()) == null || geneIdentifier.trim().length() <= 0 || geneIdentifier.equalsIgnoreCase("empty")) continue;
                if (geneIdentifier.contains("/")) {
                    geneIdentifier = geneIdentifier.substring(0, geneIdentifier.indexOf("/"));
                } else if (geneIdentifier.contains("(")) {
                    geneIdentifier = geneIdentifier.substring(0, geneIdentifier.indexOf("(")).trim();
                }
                geneList.add(cell.getStringCellValue());
                geneListMap.remove(plateId);
                geneListMap.put(plateId, geneList);
            }
            ++i;
        }
        file.close();
        workbook.close();
        return geneListMap;
    }

    public static List<String> readSheetsFromRerunLayoutFile(Entry entry, String filename) throws IOException {
        ArrayList<String> sheetList = new ArrayList<String>();
        String fileFolder = FileUtils.getFileFolder(entry);
        FileInputStream file = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        Sheet sheet2 = null;
        for (Sheet sheet2 : workbook) {
            Cell plateHeader = sheet2.getRow(0).getCell(0);
            if (plateHeader == null || !plateHeader.getStringCellValue().startsWith("PLATE") && !plateHeader.getStringCellValue().startsWith("Plate")) continue;
            sheetList.add(sheet2.getSheetName());
        }
        file.close();
        workbook.close();
        return sheetList;
    }

    public static List<String> readSheetsFromLayoutFile(Entry entry, String filename) throws IOException {
        ArrayList<String> sheetList = new ArrayList<String>();
        String fileFolder = FileUtils.getFileFolder(entry);
        FileInputStream file = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        Sheet sheet2 = null;
        for (Sheet sheet2 : workbook) {
            Cell plateHeader = sheet2.getRow(0).getCell(1);
            if (plateHeader == null || !plateHeader.getStringCellValue().startsWith("Plate") && !plateHeader.getStringCellValue().startsWith("PLATE")) continue;
            sheetList.add(sheet2.getSheetName());
        }
        file.close();
        workbook.close();
        return sheetList;
    }

    public static Map<String, List<String>> readLayoutFile(Entry entry, String filename, String sheetName) throws IOException {
        String fileFolder = FileUtils.getFileFolder(entry);
        FileInputStream file = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
        XSSFSheet sheet = null;
        if (sheetName != null) {
            sheet = workbook.getSheet(sheetName);
        }
        if (sheet == null) {
            workbook.close();
            throw new IOException("Invalid file. Could not find plate layout sheet");
        }
        Iterator rowIterator = sheet.iterator();
        TreeMap<String, List<String>> geneListMap = new TreeMap<String, List<String>>();
        HashMap<Integer, String> plateMap = new HashMap<Integer, String>();
        int i = 0;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            int j = 1;
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                String plateId;
                Cell cell = (Cell)cellIterator.next();
                int columnIndex = cell.getColumnIndex();
                if (columnIndex != j) continue;
                if (i == 0) {
                    plateId = cell.getStringCellValue();
                    plateMap.put(cell.getColumnIndex(), plateId);
                } else {
                    plateId = (String)plateMap.get(cell.getColumnIndex());
                    if (plateId != null) {
                        String geneIdentifier;
                        ArrayList<String> geneList = (ArrayList<String>)geneListMap.get(plateId);
                        if (geneList == null) {
                            geneList = new ArrayList<String>();
                        }
                        if ((geneIdentifier = cell.getStringCellValue()) != null && geneIdentifier.trim().length() > 0 && !geneIdentifier.equalsIgnoreCase("empty")) {
                            if (geneIdentifier.contains("/")) {
                                geneIdentifier = geneIdentifier.substring(0, geneIdentifier.indexOf("/"));
                            } else if (geneIdentifier.contains("(")) {
                                geneIdentifier = geneIdentifier.substring(0, geneIdentifier.indexOf("(")).trim();
                            }
                            geneList.add(geneIdentifier);
                            geneListMap.remove(plateId);
                            geneListMap.put(plateId, geneList);
                        }
                    }
                }
                j += 4;
            }
            ++i;
        }
        file.close();
        workbook.close();
        return geneListMap;
    }

    public static void exportQrtPCRTable(QrtPCRRun pcrRun, String filename, boolean exportMaster, boolean exportPlateData, boolean exportReruns) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        boldStyle = workbook.createCellStyle();
        XSSFFont bold = workbook.createFont();
        bold.setBold(true);
        boldStyle.setFont((Font)bold);
        stylePurple = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setColor(IndexedColors.LAVENDER.index);
        stylePurple.setFont((Font)font);
        stylePink = workbook.createCellStyle();
        font = workbook.createFont();
        font.setBold(true);
        font.setColor(IndexedColors.ROSE.index);
        stylePink.setFont((Font)font);
        styleRed = workbook.createCellStyle();
        XSSFFont redFont = workbook.createFont();
        redFont.setColor(IndexedColors.RED.index);
        styleRed.setFont((Font)redFont);
        blueBackGround = workbook.createCellStyle();
        blueBackGround.setFillForegroundColor(IndexedColors.LIGHT_BLUE.index);
        blueBackGround.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        yellowCell = workbook.createCellStyle();
        yellowCell.setFillForegroundColor(IndexedColors.YELLOW.index);
        yellowCell.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleRedFill = workbook.createCellStyle();
        styleRedFill.setFillForegroundColor(IndexedColors.RED.index);
        styleRedFill.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleOrangeFill = workbook.createCellStyle();
        styleOrangeFill.setFillForegroundColor(IndexedColors.CORAL.index);
        styleOrangeFill.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Map<Integer, QrtPCRTable> tableMap = pcrRun.getRunIdTableMap();
        for (Integer runId : tableMap.keySet()) {
            String title;
            QrtPCRData qrtPCRData;
            QrtPCRTable table = tableMap.get(runId);
            Set<String> plateIds = table.getPlateDataMap().keySet();
            for (String plateId : plateIds) {
                qrtPCRData = table.getData(plateId);
                qrtPCRData.calculateNormValue();
                if (table.getOriginal().booleanValue()) {
                    EvaluateData.applyRules(qrtPCRData, 0, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
                    qrtPCRData.calculateNormValue();
                }
                title = plateId;
                if (runId > 0) {
                    title = "Rerun-" + runId + "-" + plateId;
                }
                XSSFSheet sheet = workbook.createSheet(title);
                int rownum = ExcelFileHandler.addHeaders(workbook, sheet, plateId, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
                int numReplicates = qrtPCRData.getNumberOfReplicates();
                ExcelFileHandler.addData(sheet, qrtPCRData, rownum, numReplicates, DEFAULT_CONTROL_GENE_LOCATION, "HRPL4", false, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
            }
            for (String plateId : plateIds) {
                qrtPCRData = table.getData(plateId);
                title = String.valueOf(plateId) + "-original";
                if (runId > 0) {
                    title = "Rerun-" + runId + "-" + plateId + "-original";
                }
                XSSFSheet rawDataSheet = workbook.createSheet(title);
                int numReplicates = qrtPCRData.getNumberOfReplicates();
                int rownum = ExcelFileHandler.addHeaders(workbook, rawDataSheet, plateId, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
                ExcelFileHandler.addData(rawDataSheet, qrtPCRData, rownum, numReplicates, DEFAULT_CONTROL_GENE_LOCATION, "HRPL4", true, pcrRun.getThreshold(), pcrRun.getStDevCutOff());
            }
            if (!exportReruns) break;
        }
        if (exportMaster) {
            List<Gene> geneList = QrtPCRRun.generateMasterTable(pcrRun.getFirstRun());
            XSSFSheet masterTableSheet = workbook.createSheet("Master Table");
            workbook.setSheetOrder("Master Table", 0);
            ExcelFileHandler.addMasterTableHeaders(workbook, masterTableSheet);
            ExcelFileHandler.addMasterTableData(masterTableSheet, geneList, pcrRun.getThreshold());
        }
        FileOutputStream out = new FileOutputStream(new File(filename));
        workbook.write((OutputStream)out);
        out.close();
        workbook.close();
    }

    private static void addMasterTableData(XSSFSheet sheet, List<Gene> geneList, Double lowerThreshold) {
        int rownum = 1;
        for (Gene gene : geneList) {
            XSSFRow row = sheet.createRow(rownum);
            if (gene.getIsControl().booleanValue() || gene.getIsCommon().booleanValue()) continue;
            Cell cell = row.createCell(0);
            cell.setCellValue(gene.getGeneIdentifier());
            if (gene.getRunId() > 0) {
                cell.setCellStyle((CellStyle)styleOrangeFill);
            }
            cell = row.createCell(1);
            cell.setCellValue(gene.getGeneSymbol());
            cell = row.createCell(2);
            cell.setCellValue(gene.getAdjustedAverage(gene.getRunId(), lowerThreshold, gene.getNormValue(gene.getRunId())).doubleValue());
            cell = row.createCell(3);
            cell.setCellValue(gene.getStDevForAdjusted(gene.getRunId(), lowerThreshold, gene.getNormValue(gene.getRunId())).doubleValue());
            ++rownum;
        }
    }

    private static void addMasterTableHeaders(XSSFWorkbook workbook, XSSFSheet sheet) {
        XSSFRow row = sheet.createRow(0);
        Cell cell = row.createCell(0);
        cell.setCellValue("Gene Identifier");
        cell = row.createCell(1);
        cell.setCellValue("Gene Symbol");
        cell = row.createCell(2);
        cell.setCellValue("Average");
        cell = row.createCell(3);
        cell.setCellValue("StDev");
    }

    private static void addData(XSSFSheet sheet, QrtPCRData qrtPCRData, int rownum, int numReplicates, int controlGeneLocation, String controlGeneName, boolean raw, Double lowerThreshold, Double stdevCutOff) {
        for (Gene gene : qrtPCRData.getGenes()) {
            gene.setNumOfReplicates(numReplicates);
            XSSFRow row = sheet.createRow(rownum);
            ++rownum;
            Cell cell = row.createCell(1);
            cell.setCellValue(gene.getGeneIdentifier());
            if (gene.getIsControl().booleanValue()) {
                controlGeneLocation = rownum;
                controlGeneName = gene.getGeneIdentifier();
            }
            int i = 0;
            for (GeneData geneData : gene.getDataMap().get(gene.getRunId())) {
                cell = row.createCell(0);
                cell.setCellValue(geneData.getPosition().toString());
                cell = row.createCell(2);
                Double ct0 = !raw ? geneData.getCt() : geneData.getOriginalCt();
                if (ct0 == null) {
                    cell.setCellValue(lowerThreshold.doubleValue());
                    ct0 = lowerThreshold;
                    cell.setCellStyle((CellStyle)stylePink);
                } else if (ct0 >= lowerThreshold) {
                    if (raw) {
                        cell.setCellValue(ct0.doubleValue());
                    } else {
                        ct0 = lowerThreshold;
                        cell.setCellValue(ct0.doubleValue());
                        cell.setCellStyle((CellStyle)stylePurple);
                    }
                } else {
                    cell.setCellValue(ct0.doubleValue());
                    if (!raw && geneData.getPreviousValues() != null && !geneData.getPreviousValues().isEmpty() && geneData.getPreviousValues().get(0) != null) {
                        cell.setCellStyle((CellStyle)styleOrangeFill);
                    }
                }
                cell = row.createCell(4);
                cell.setCellValue(Math.pow(2.0, -1.0 * ct0));
                cell = row.createCell(5);
                Double normValue = null;
                normValue = qrtPCRData.findNormValue(0, raw);
                cell.setCellValue(normValue.doubleValue());
                cell.setCellStyle((CellStyle)blueBackGround);
                cell = row.createCell(6);
                String formula = String.valueOf(CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2))) + String.valueOf(cell.getRowIndex() + 1) + "/" + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
                cell.setCellFormula(formula);
                cell = row.createCell(7);
                Double scaler = null;
                scaler = qrtPCRData.getScaler(lowerThreshold, raw);
                cell.setCellValue(scaler.doubleValue());
                cell.setCellStyle((CellStyle)yellowCell);
                cell = row.createCell(8);
                formula = String.valueOf(CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2))) + String.valueOf(cell.getRowIndex() + 1) + "-" + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
                cell.setCellFormula(formula);
                if (++i == numReplicates) {
                    cell = row.createCell(3);
                    formula = "STDEV(";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() - numReplicates + 2);
                    formula = String.valueOf(formula) + ":";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
                    formula = String.valueOf(formula) + ")";
                    cell.setCellFormula(formula);
                    double stdev = gene.getStandardDeviation(lowerThreshold);
                    if (!raw && stdev >= stdevCutOff && gene.getShouldRerun().booleanValue()) {
                        cell.setCellStyle((CellStyle)styleRed);
                        XSSFRow idRow = sheet.getRow(cell.getRowIndex() - numReplicates + 1);
                        Cell idCell = idRow.getCell(1);
                        idCell.setCellStyle((CellStyle)styleRedFill);
                    }
                    cell = row.createCell(9);
                    formula = "AVERAGE(";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() - numReplicates + 2);
                    formula = String.valueOf(formula) + ":";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
                    formula = String.valueOf(formula) + ")";
                    cell.setCellFormula(formula);
                    cell = row.createCell(10);
                    formula = "STDEV(";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2)) + String.valueOf(cell.getRowIndex() - numReplicates + 2);
                    formula = String.valueOf(formula) + ":";
                    formula = String.valueOf(formula) + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2)) + String.valueOf(cell.getRowIndex() + 1);
                    formula = String.valueOf(formula) + ")";
                    cell.setCellFormula(formula);
                }
                if (i >= numReplicates) continue;
                row = sheet.createRow(rownum++);
            }
        }
        XSSFRow row = sheet.createRow(rownum++);
        Cell cell = row.createCell(1);
        cell.setCellValue("Avg " + controlGeneName);
        cell.setCellStyle((CellStyle)boldStyle);
        cell = row.createCell(2);
        String formula = "AVERAGE(" + CellReference.convertNumToColString((int)cell.getColumnIndex()) + controlGeneLocation + ":" + CellReference.convertNumToColString((int)cell.getColumnIndex()) + String.valueOf(controlGeneLocation + numReplicates - 1) + ")";
        cell.setCellFormula(formula);
        cell = row.createCell(4);
        cell.setCellValue(qrtPCRData.findNormValue(0, raw));
        cell = row.createCell(5);
        cell.setCellValue(qrtPCRData.findNormValue(0, raw));
        cell.setCellStyle((CellStyle)blueBackGround);
        cell = row.createCell(6);
        formula = String.valueOf(CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2))) + String.valueOf(cell.getRowIndex() + 1) + "/" + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
        cell.setCellFormula(formula);
        cell = row.createCell(7);
        cell.setCellValue(qrtPCRData.getScaler(lowerThreshold, raw));
        cell.setCellStyle((CellStyle)yellowCell);
        cell = row.createCell(8);
        formula = String.valueOf(CellReference.convertNumToColString((int)(cell.getColumnIndex() - 2))) + String.valueOf(cell.getRowIndex() + 1) + "-" + CellReference.convertNumToColString((int)(cell.getColumnIndex() - 1)) + String.valueOf(cell.getRowIndex() + 1);
        cell.setCellFormula(formula);
    }

    private static int addHeaders(XSSFWorkbook workbook, XSSFSheet sheet, String plateId, Double lowerThreshold, Double stdevCutOff) {
        XSSFRow row = sheet.createRow(0);
        Cell cell = row.createCell(0);
        cell.setCellValue(plateId);
        cell = row.createCell(1);
        cell.setCellValue("Re-Run");
        cell.setCellStyle((CellStyle)styleRedFill);
        cell = row.createCell(2);
        cell.setCellValue(">=" + lowerThreshold + " in Bold Purple, empty values in Bold Pink");
        cell.setCellStyle((CellStyle)stylePurple);
        cell = row.createCell(3);
        cell.setCellValue(">=" + stdevCutOff + " in Red");
        cell.setCellStyle((CellStyle)styleRed);
        cell = row.createCell(9);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 9, 10));
        cell.setCellValue("Scaled Data");
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("Well");
        cell = row.createCell(1);
        cell.setCellValue("Gene ID");
        cell = row.createCell(2);
        cell.setCellValue("Ct Value");
        cell = row.createCell(3);
        cell.setCellValue("Std Dev Cts");
        cell = row.createCell(4);
        cell.setCellValue("2^-ct");
        cell = row.createCell(5);
        cell.setCellValue("Norm Value");
        cell = row.createCell(6);
        cell.setCellValue("Normalized");
        cell = row.createCell(7);
        cell.setCellValue("Scaler");
        cell = row.createCell(8);
        cell.setCellValue("Adjusted");
        cell = row.createCell(9);
        cell.setCellValue("Average");
        cell = row.createCell(10);
        cell.setCellValue("Stdev");
        return 2;
    }

    public static void exportMasterGeneList(String name, ManagerNatTable table, String filename) {
        XSSFCell cell;
        if (table == null) {
            return;
        }
        Set columns = table.getTablePreference().getPreferenceSettings().getHeaders();
        DataLayer layer = table.getBodyDataLayer();
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFSheet sheet = wb.createSheet(name);
        int rowIndex = 0;
        int cellIndex = 0;
        XSSFRow header = sheet.createRow((int)((short)rowIndex++));
        for (GRITSColumnHeader column : columns) {
            if (column.getKeyValue().equals("Select")) continue;
            cell = header.createCell(cellIndex++);
            cell.setCellValue(column.getLabel());
            cell.setCellStyle((CellStyle)headerStyle);
        }
        int i = 0;
        while (i < layer.getRowCount()) {
            XSSFRow row = sheet.createRow((int)((short)rowIndex++));
            cellIndex = 0;
            int j = 0;
            for (GRITSColumnHeader column : columns) {
                if (column.getKeyValue().equals("Select")) {
                    ++j;
                    continue;
                }
                Object val = layer.getDataValueByPosition(j, i);
                if (val instanceof Boolean) {
                    ++j;
                    continue;
                }
                cell = row.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)cellStyle);
                String text = (String)val;
                cell.setCellValue(text);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < columns.size()) {
            sheet.autoSizeColumn((int)((short)i));
            ++i;
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            wb.write((OutputStream)fos);
            fos.close();
            wb.close();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Export Gene List Successful", (String)("Workbook saved to the file:\n\n" + filename));
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Export Gene List Failed", (String)("Could not save workbook to the file:\n\n" + msg));
        }
    }

    public static void exportMasterGeneList(String name, TableViewer tableViewer, String filename) {
        TableItem[] items;
        XSSFCell cell;
        if (tableViewer == null) {
            return;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.LEMON_CHIFFON.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFSheet sheet = wb.createSheet(name);
        Table table = tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int rowIndex = 0;
        int cellIndex = 0;
        XSSFRow header = sheet.createRow((int)((short)rowIndex++));
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            cell = header.createCell(cellIndex++);
            cell.setCellValue(column.getText());
            cell.setCellStyle((CellStyle)headerStyle);
            ++n2;
        }
        TableItem[] tableItemArray = items = table.getItems();
        int n3 = items.length;
        n = 0;
        while (n < n3) {
            TableItem item = tableItemArray[n];
            XSSFRow row = sheet.createRow((int)((short)rowIndex++));
            cellIndex = 0;
            int i = 0;
            while (i < columns.length) {
                cell = row.createCell(cellIndex++);
                cell.setCellStyle((CellStyle)cellStyle);
                String text = item.getText(i);
                cell.setCellValue(text);
                ++i;
            }
            ++n;
        }
        int i = 0;
        while (i < columns.length) {
            sheet.autoSizeColumn((int)((short)i));
            ++i;
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            wb.write((OutputStream)fos);
            fos.close();
            wb.close();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Export Gene List Successful", (String)("Workbook saved to the file:\n\n" + filename));
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Export Gene List Failed", (String)("Could not save workbook to the file:\n\n" + msg));
        }
    }

    public static void main(String[] args) {
        try {
            List<GeneList> geneLists = ExcelFileHandler.readMasterGeneLists("/Users/sena/Desktop/2015_Human_Master_Gene_List.xlsx", "human");
            geneLists.addAll(ExcelFileHandler.readMasterGeneLists("/Users/sena/Desktop/2013_Mouse_Gene_List.xlsx", "mouse"));
            for (GeneList geneList : geneLists) {
                GeneUtils.cleanUpGenesForMasterGeneList(geneList);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)geneList, (OutputStream)os);
                FileWriter fileWriter = new FileWriter("/Users/sena/Desktop/" + geneList.getListName() + ".xml");
                fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                fileWriter.close();
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

