/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.Plate;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.model.Well;
import org.grits.toolbox.entry.qrtpcr.model.view.GeneView;

public class PlateLayoutDialog
extends WizardPage {
    private static final Image PLACED = ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.TICK_ICON).createImage();
    private Grid firstTable;
    private Grid secondTable;
    List<GeneView> geneViewList = new ArrayList<GeneView>();
    Integer width = 12;
    Integer height = 8;
    PlateLayout layout;
    XSSFSheet plateSheet;
    boolean shown = false;
    private GridTableViewer listTableViewer;
    private List<GeneView[]> inputData = new ArrayList<GeneView[]>();
    private GridTableViewer tableViewer;

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<GeneView> getGeneViewList() {
        return this.geneViewList;
    }

    protected PlateLayoutDialog(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Composite firstTableComposite = new Composite(container, 0);
        firstTableComposite.setLayout((Layout)new GridLayout(1, true));
        this.firstTable = this.createTable(firstTableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.firstTable);
        Composite secondTableComposite = new Composite(container, 0);
        secondTableComposite.setLayout((Layout)new GridLayout(1, true));
        this.secondTable = this.createPlateMapTable(secondTableComposite, this.height, this.width);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.secondTable);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        boolean allPlaced = true;
        for (GeneView geneView : this.geneViewList) {
            allPlaced |= geneView.isPlaced();
        }
        return allPlaced;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.shown = true;
        }
        if (this.shown && !visible) {
            this.replacePlate();
            ArrayList<GeneView> notYetPlaced = new ArrayList<GeneView>();
            for (GeneView geneView : this.geneViewList) {
                if (geneView.isPlaced()) continue;
                notYetPlaced.add(geneView);
            }
            this.addToNextPage(notYetPlaced);
            this.shown = false;
        }
        super.setVisible(visible);
    }

    private void replacePlate() {
        Plate plate2;
        Plate existing = null;
        if (this.layout.getPlates() != null) {
            for (Plate plate2 : this.layout.getPlates()) {
                if (!plate2.getPlateId().equals(this.getTitle())) continue;
                existing = plate2;
            }
        }
        plate2 = this.convertInputDataIntoPlate();
        if (existing != null) {
            this.layout.getPlates().remove(existing);
        }
        this.layout.addPlate(plate2);
    }

    private void addToNextPage(List<GeneView> notYetPlaced) {
        IWizardPage nextPage = this.getNextPage();
        if (nextPage != null && nextPage instanceof PlateLayoutDialog) {
            ((PlateLayoutDialog)nextPage).getGeneViewList().addAll(notYetPlaced);
            ((PlateLayoutDialog)nextPage).refreshGeneList();
        }
    }

    private void refreshGeneList() {
        if (this.listTableViewer != null) {
            this.listTableViewer.setInput(this.geneViewList);
            this.listTableViewer.refresh();
            ((Composite)this.listTableViewer.getControl()).layout();
        }
    }

    private Grid createPlateMapTable(Composite parent, int rows, int columns) {
        String[][] data = new String[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                data[i][j] = "";
                ++j;
            }
            ++i;
        }
        this.tableViewer = new GridTableViewer(parent, 2818);
        Grid grid = this.tableViewer.getGrid();
        grid.setHeaderVisible(true);
        grid.setRowHeaderVisible(true);
        grid.setCellSelectionEnabled(true);
        grid.setLinesVisible(true);
        this.tableViewer.setRowHeaderLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                char newIndex = (char)(65 + ((GridItem)cell.getItem()).getRowIndex());
                cell.setText(String.valueOf(newIndex));
            }
        });
        int i2 = 0;
        while (i2 < columns) {
            GridViewerColumn column = new GridViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(String.valueOf(i2 + 1));
            column.getColumn().setWidth(80);
            column.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    int columnIndex = cell.getColumnIndex();
                    cell.setText(((GeneView[])cell.getElement())[columnIndex].getGeneIdentifier());
                }
            });
            ++i2;
        }
        if (this.inputData.isEmpty()) {
            i2 = 0;
            while (i2 < rows) {
                GeneView[] geneViewListForRow = new GeneView[columns];
                int j = 0;
                while (j < columns) {
                    geneViewListForRow[j] = new GeneView();
                    geneViewListForRow[j].setGeneIdentifier("");
                    geneViewListForRow[j].setGeneSymbol("");
                    ++j;
                }
                this.inputData.add(geneViewListForRow);
                ++i2;
            }
        }
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    return ((ArrayList)inputElement).toArray();
                }
                return super.getElements(inputElement);
            }
        });
        this.tableViewer.setInput(this.inputData);
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        DragAndDropSupport2 dndSupport = new DragAndDropSupport2(this.tableViewer, data, this.inputData);
        int operations = 7;
        this.tableViewer.addDropSupport(operations, transfer, (DropTargetListener)dndSupport);
        grid.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Point curLoc = Display.getCurrent().map(null, PlateLayoutDialog.this.tableViewer.getControl(), new Point(e.x, e.y));
                Menu menu = new Menu((Control)PlateLayoutDialog.this.tableViewer.getGrid());
                final MenuItem item = new MenuItem(menu, 8);
                item.setText("Delete Cell");
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GeneView[] geneViews;
                        Point position = (Point)item.getData();
                        if (position != null && (geneViews = (GeneView[])PlateLayoutDialog.this.inputData.get(position.y)) != null && position.x <= geneViews.length) {
                            geneViews[position.x - 1] = new GeneView();
                            geneViews[position.x - 1].setGeneIdentifier("");
                            geneViews[position.x - 1].setGeneSymbol("");
                            PlateLayoutDialog.this.tableViewer.refresh();
                            PlateLayoutDialog.this.tableViewer.getGrid().setRedraw(true);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                GridItem[] items = PlateLayoutDialog.this.tableViewer.getGrid().getItems();
                boolean menuShown = false;
                Point position = null;
                int rowNumber = 0;
                GridItem[] gridItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    GridItem gridItem = gridItemArray[n2];
                    int[] nArray = PlateLayoutDialog.this.tableViewer.getGrid().getColumnOrder();
                    int n3 = nArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int colId = nArray[n4];
                        Rectangle rect = gridItem.getBounds(colId);
                        if (rect.contains(curLoc)) {
                            PlateLayoutDialog.this.tableViewer.getControl().setMenu(menu);
                            position = new Point(colId + 1, rowNumber);
                            menu.getItems()[0].setData((Object)position);
                            menuShown = true;
                            break;
                        }
                        ++n4;
                    }
                    ++rowNumber;
                    ++n2;
                }
                if (!menuShown) {
                    PlateLayoutDialog.this.tableViewer.getControl().setMenu(null);
                }
            }
        });
        return grid;
    }

    private Grid createTable(Composite parent) {
        this.listTableViewer = new GridTableViewer(parent, 2820);
        Grid grid = this.listTableViewer.getGrid();
        grid.setHeaderVisible(true);
        GridColumn column1 = new GridColumn(grid, 0);
        column1.setText("Gene Identifier");
        column1.setWidth(150);
        this.listTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof GeneView) {
                    return ((Gene)element).getGeneIdentifier();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof GeneView && ((GeneView)element).isPlaced()) {
                    return PLACED;
                }
                return super.getImage(element);
            }
        });
        this.listTableViewer.setInput(this.geneViewList);
        DragAndDropSupport dndSupport = new DragAndDropSupport(this.listTableViewer);
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        this.listTableViewer.addDragSupport(1, transfer, (DragSourceListener)dndSupport);
        return grid;
    }

    public void setGeneList(List<Gene> list) {
        this.geneViewList.clear();
        for (Gene gene : list) {
            this.geneViewList.add(new GeneView(gene));
        }
    }

    public void layoutGenes(List<Gene> list) {
        this.setGeneList(list);
        this.inputData.clear();
        int i = 0;
        while (i < this.height) {
            GeneView[] geneViewListForRow = new GeneView[this.width.intValue()];
            int j = 0;
            while (j < this.width) {
                int k = 0;
                while (k < this.layout.getNumberOfReplicates() && j < this.width) {
                    if (k == 0) {
                        GeneView geneView = this.getGeneForLocation(i, j);
                        if (geneView != null) {
                            geneViewListForRow[j] = geneView;
                        } else {
                            geneViewListForRow[j] = new GeneView();
                            geneViewListForRow[j].setGeneIdentifier("");
                            geneViewListForRow[j].setGeneSymbol("");
                        }
                    } else {
                        geneViewListForRow[j] = geneViewListForRow[j - 1];
                    }
                    ++j;
                    ++k;
                }
            }
            this.inputData.add(geneViewListForRow);
            ++i;
        }
    }

    private GeneView getGeneForLocation(int row, int column) {
        Character xChar = Character.valueOf('A');
        int i = 0;
        while (i < row) {
            xChar = Character.valueOf((char)(xChar.charValue() + '\u0001'));
            ++i;
        }
        Well well = new Well(xChar.charValue(), column + 1);
        for (Gene gene : this.layout.getControlGeneLocations().keySet()) {
            Well controlGeneLocation = this.layout.getControlGeneLocations().get(gene);
            if (!controlGeneLocation.equals(well)) continue;
            for (GeneView geneView : this.geneViewList) {
                if (!geneView.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
                if (!geneView.isPlaced()) {
                    geneView.setPlaced(true);
                    return geneView;
                }
                return null;
            }
        }
        for (GeneView geneView : this.geneViewList) {
            if (geneView.isPlaced()) continue;
            geneView.setPlaced(true);
            return geneView;
        }
        return null;
    }

    public Plate convertInputDataIntoPlate() {
        Plate plate = new Plate();
        plate.setPlateId(this.getTitle());
        HashMap<Well, Gene> plateMap = new HashMap<Well, Gene>();
        Character charPos = Character.valueOf('A');
        for (GeneView[] row : this.inputData) {
            Integer column = 1;
            GeneView[] geneViewArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                GeneView geneView = geneViewArray[n2];
                Well well = new Well(charPos.charValue(), column);
                if (geneView.getGeneIdentifier() != null && geneView.getGeneIdentifier().trim().length() > 0) {
                    plateMap.put(well, geneView);
                }
                column = column + 1;
                ++n2;
            }
            charPos = Character.valueOf((char)(charPos.charValue() + '\u0001'));
        }
        plate.setPlateMap(plateMap);
        return plate;
    }

    public void setLayout(PlateLayout layout) {
        this.layout = layout;
        this.setWidth(layout.getSize().getWidth());
        this.setHeight(layout.getSize().getHeight());
    }

    public void setPlate(Plate plate) {
        Map<Well, Gene> plateMap = plate.getPlateMap();
        int rows = this.layout.getSize().getHeight();
        int columns = this.layout.getSize().getWidth();
        Character charPos = Character.valueOf('A');
        int i = 0;
        while (i < rows) {
            int column = 1;
            GeneView[] geneViewListForRow = new GeneView[columns];
            int j = 0;
            while (j < columns) {
                Well well = new Well(charPos.charValue(), column);
                Gene gene = plateMap.get(well);
                if (gene == null) {
                    geneViewListForRow[j] = new GeneView();
                    geneViewListForRow[j].setGeneIdentifier("");
                    geneViewListForRow[j].setGeneSymbol("");
                } else {
                    geneViewListForRow[j] = new GeneView(gene);
                    if (!this.geneExistsInGeneViewList(gene)) {
                        this.geneViewList.add(geneViewListForRow[j]);
                        geneViewListForRow[j].setPlaced(true);
                    }
                }
                ++column;
                ++j;
            }
            charPos = Character.valueOf((char)(charPos.charValue() + '\u0001'));
            this.inputData.add(geneViewListForRow);
            ++i;
        }
    }

    boolean geneExistsInGeneViewList(Gene gene) {
        for (GeneView geneView : this.geneViewList) {
            if (!geneView.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
            return true;
        }
        return false;
    }

    public GridTableViewer getTableViewer() {
        return this.tableViewer;
    }

    class DragAndDropSupport
    implements DragSourceListener {
        private final GridTableViewer grid;
        private GeneView draggedGene;
        private static final String DATA_SEPARATOR = "|";

        public DragAndDropSupport(GridTableViewer g) {
            this.grid = g;
        }

        public void dragStart(DragSourceEvent event) {
            if (this.grid.getGrid().getSelectionCount() == 0) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.grid.getSelection();
            Object selected = selection.getFirstElement();
            if (!selection.isEmpty() && selected instanceof GeneView) {
                this.draggedGene = (GeneView)selected;
                StringBuilder builder = new StringBuilder();
                builder.append(this.draggedGene.getGeneIdentifier()).append(DATA_SEPARATOR).append(this.draggedGene.getGeneSymbol()).append(DATA_SEPARATOR).append(this.draggedGene.getIsCommon());
                event.data = builder.toString();
            }
        }

        public void dragFinished(DragSourceEvent event) {
            if (event.detail == 0) {
                return;
            }
            this.draggedGene.setPlaced(true);
            this.draggedGene = null;
            this.grid.setSelection(null);
            this.grid.refresh();
        }
    }

    class DragAndDropSupport2
    implements DropTargetListener {
        private final GridTableViewer grid;
        private String[][] data;
        List<GeneView[]> inputData;
        GeneView draggedGene = null;
        private static final String DATA_SEPARATOR = "|";

        public DragAndDropSupport2(GridTableViewer grid2, String[][] data, List<GeneView[]> inputData) {
            this.grid = grid2;
            this.data = data;
            this.inputData = inputData;
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] geneData;
            String[] stringArray = geneData = event.data != null ? event.data.toString().split("\\|") : new String[]{};
            if (geneData.length > 0) {
                Point cell;
                int[] rowIndexList = null;
                int[] columnIndexList = null;
                if (this.grid.getGrid().getSelectionCount() == 0) {
                    cell = this.findTargetCell(event);
                    if (cell != null) {
                        if (cell.x < this.data.length && cell.y < this.data[0].length) {
                            this.data[cell.x][cell.y] = geneData[0];
                        }
                        rowIndexList = new int[]{cell.x};
                        columnIndexList = new int[]{cell.y};
                    } else {
                        event.detail = 0;
                    }
                } else {
                    cell = this.findTargetCell(event);
                    if (cell != null) {
                        this.data[cell.x][cell.y] = geneData[0];
                    }
                    int cellSelections = this.grid.getGrid().getCellSelectionCount();
                    Point[] cells = this.grid.getGrid().getCellSelection();
                    int index = 0;
                    rowIndexList = new int[cells.length + 1];
                    columnIndexList = new int[cells.length + 1];
                    if (cell != null) {
                        rowIndexList[index] = cell.x;
                        columnIndexList[index] = cell.y;
                        ++index;
                    }
                    int i = 0;
                    while (i < cellSelections) {
                        int rowIndex;
                        int columnIndex = cells[i].x;
                        rowIndexList[index] = rowIndex = cells[i].y;
                        columnIndexList[index++] = columnIndex;
                        if (rowIndex < this.data.length && columnIndex < this.data[0].length) {
                            this.data[rowIndex][columnIndex] = geneData[0];
                        } else {
                            event.detail = 0;
                        }
                        ++i;
                    }
                }
                if (event.detail != 0) {
                    int i = 0;
                    while (i < rowIndexList.length) {
                        int row = rowIndexList[i];
                        int j = 0;
                        while (j < columnIndexList.length) {
                            int column = columnIndexList[j];
                            this.inputData.get(row)[column].setGeneIdentifier(geneData[0]);
                            this.inputData.get(row)[column].setGeneSymbol(geneData[1]);
                            this.inputData.get(row)[column].setIsCommon(Boolean.parseBoolean(geneData[2]));
                            ++j;
                        }
                        ++i;
                    }
                }
                this.grid.setSelection(null);
                this.grid.setInput(this.inputData);
                this.grid.refresh();
            }
        }

        private Point findTargetCell(DropTargetEvent event) {
            Point coordinates = new Point(event.x, event.y);
            coordinates = this.grid.getControl().toControl(coordinates);
            GridItem[] items = this.grid.getGrid().getItems();
            int columns = this.grid.getGrid().getColumnCount();
            GridItem[] gridItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GridItem gridItem = gridItemArray[n2];
                int rowIndex = gridItem.getRowIndex();
                int i = 0;
                while (i < columns) {
                    Rectangle bounds = gridItem.getBounds(i);
                    if (bounds == null) {
                        return null;
                    }
                    int diffY = coordinates.y - bounds.y;
                    int diffX = coordinates.x - bounds.x;
                    if (diffY > 0 && diffY < bounds.height && diffX > 0 && diffX < bounds.width) {
                        return new Point(rowIndex, i);
                    }
                    ++i;
                }
                ++n2;
            }
            return null;
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }
}

