/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.analyzer;

import java.util.Iterator;
import java.util.TreeMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoImporterException;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;
import org.glycoinfo.GlycanFormatconverter.util.analyzer.MonosaccharideNotationAnalyzer;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;

public class MonosaccharideModificator {
    public String start(String _monosaccharide) throws GlyCoImporterException, ConverterExchangeException {
        TreeMap<Integer, String> unitMap = this.resolveNotation(_monosaccharide);
        for (Integer key : unitMap.keySet()) {
            String unit = unitMap.get(key);
            if (unit.matches("^\\d.*$") || this.checkAnomericSymbol(unit) || this.checkConfiguration(unit)) continue;
            if (this.isAnhydro(unit)) {
                unitMap.put(key, this.modifyAnhydro(unit));
                continue;
            }
            if (!this.isUpperCaseNotation(_monosaccharide)) continue;
            if (this.checkModification(unit)) {
                unitMap.put(key, unit.toLowerCase());
                continue;
            }
            String trivialName = "";
            if (MonosaccharideNotationAnalyzer.start(unit)) {
                trivialName = this.modifyTrivialName(unit);
            }
            trivialName = String.valueOf(trivialName) + this.parseSubstituent(trivialName, unit);
            unitMap.put(key, trivialName);
        }
        String ret = "";
        Iterator<String> i = unitMap.values().iterator();
        while (i.hasNext()) {
            ret = String.valueOf(ret) + i.next();
            if (!i.hasNext()) continue;
            ret = String.valueOf(ret) + "-";
        }
        return ret;
    }

    private boolean checkAnomericSymbol(String _notation) {
        if (_notation.length() != 1) {
            return false;
        }
        AnomericStateDescriptor anomDict = AnomericStateDescriptor.forAnomericState((_notation = _notation.toLowerCase()).charAt(0));
        return anomDict != null;
    }

    private boolean checkConfiguration(String _notation) {
        if (_notation.length() != 1) {
            return false;
        }
        return _notation.equals("D") || _notation.equals("L") || _notation.equals("?");
    }

    private boolean checkModification(String _notation) {
        ModificationTemplate modT = ModificationTemplate.forIUPACNotation(_notation.toLowerCase());
        return modT != null;
    }

    private boolean isAnhydro(String _notation) {
        CrossLinkedTemplate crossT = CrossLinkedTemplate.forIUPACNotationWithIgnore(_notation);
        if (crossT == null) {
            return false;
        }
        return crossT.equals(CrossLinkedTemplate.ANHYDROXYL);
    }

    private String modifyTrivialName(String _notation) {
        int point = 3;
        String twoLetter = "";
        String threeLetter = "";
        MonosaccharideIndex modIndex = null;
        if (point == _notation.length()) {
            modIndex = MonosaccharideIndex.forTrivialNameWithIgnore(_notation);
        }
        while (point != _notation.length()) {
            twoLetter = _notation.substring(point - 3, point - 1);
            modIndex = MonosaccharideIndex.forTrivialNameWithIgnore(twoLetter);
            if (modIndex != null) {
                threeLetter = "";
                break;
            }
            threeLetter = _notation.substring(point - 3, point);
            modIndex = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetter);
            if (modIndex == null) {
                ++point;
                continue;
            }
            twoLetter = "";
            break;
        }
        String trivialName = modIndex.getTrivialName();
        String superClass = this.modifySuperClass(_notation);
        String ringSize = "";
        if (superClass == null) {
            ringSize = this.modifyRingSize(_notation, trivialName.toUpperCase());
            return String.valueOf(trivialName) + ringSize.toLowerCase();
        }
        ringSize = this.modifyRingSize(_notation, superClass.toUpperCase());
        if (!twoLetter.equals("") || !threeLetter.equals("")) {
            return String.valueOf(trivialName.toLowerCase()) + superClass + ringSize.toLowerCase();
        }
        return String.valueOf(superClass) + ringSize.toLowerCase();
    }

    private String modifySuperClass(String _notation) {
        int point = 3;
        SuperClass superClass = null;
        while (point != _notation.length()) {
            String threeLetter = _notation.substring(point - 3, point);
            superClass = SuperClass.forSuperClassWithIgnore(threeLetter);
            if (superClass != null) break;
            ++point;
        }
        if (superClass != null) {
            return superClass.getSuperClass();
        }
        return null;
    }

    private String modifyRingSize(String _notation, String _nodeName) {
        int point = _notation.indexOf(_nodeName) + _nodeName.length();
        String ringSize = _notation.substring(point, point + 1);
        if (!(ringSize.equals("P") || ringSize.equals("F") || ringSize.equals("?"))) {
            return "";
        }
        return ringSize;
    }

    private String parseSubstituent(String _modifiedName, String _notation) throws GlyCoImporterException {
        String ret = _notation.replaceFirst(_modifiedName.toUpperCase(), "");
        if (!_modifiedName.equalsIgnoreCase(ret)) {
            return ret;
        }
        return "";
    }

    private String modifyAnhydro(String _notation) {
        CrossLinkedTemplate crossT = CrossLinkedTemplate.forIUPACNotationWithIgnore(_notation);
        if (crossT == null) {
            return _notation;
        }
        if (crossT.equals(CrossLinkedTemplate.ANHYDROXYL)) {
            return crossT.getIUPACnotation();
        }
        return _notation;
    }

    private boolean isUpperCaseNotation(String _notation) {
        boolean ret = true;
        int i = 0;
        while (i < _notation.length()) {
            if (String.valueOf(_notation.charAt(i)).matches("[a-z]")) {
                ret = false;
                break;
            }
            ++i;
        }
        return ret;
    }

    private boolean isLowerCaseNotation(String _notation) {
        boolean ret = true;
        int i = 0;
        while (i < _notation.length()) {
            if (String.valueOf(_notation.charAt(i)).matches("[A-Z]")) {
                ret = false;
                break;
            }
            ++i;
        }
        return ret;
    }

    private TreeMap<Integer, String> resolveNotation(String _notation) {
        int key = 0;
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        String[] stringArray = _notation.split("-");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            ret.put(key, unit);
            ++key;
            ++n2;
        }
        return ret;
    }
}

