/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.GlycoCT;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.SubstituentType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.GlycoCT.RepeatingUnitExtractor;

public class GlyContainerToSugar {
    private Sugar sugar;
    private Map<Node, GlycoNode> m_mapNodeToGlycoNode;
    private Map<SugarUnitRepeat, Edge> m_mapSugarUnitRepeatToEdge;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate;

    private void init() {
        this.sugar = new Sugar();
        this.m_mapNodeToGlycoNode = new HashMap<Node, GlycoNode>();
        this.m_mapSugarUnitRepeatToEdge = new HashMap<SugarUnitRepeat, Edge>();
    }

    public Sugar getConvertedSugar() {
        return this.sugar;
    }

    public void start(GlyContainer _glyCo) throws GlycoconjugateException, GlycanException {
        this.init();
        HashMap t_mapUndToNodes = new HashMap();
        HashMap t_mapUndToEdges = new HashMap();
        int t_nNoParent = 0;
        for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnit()) {
            if (t_und.getConnection() == null) {
                ++t_nNoParent;
            }
            for (Node t_nodeRoot : t_und.getRootNodes()) {
                if (t_nodeRoot instanceof org.glycoinfo.GlycanFormatconverter.Glycan.Substituent) {
                    Substituent substituent = this.convertSubstituent((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_nodeRoot);
                    this.m_mapNodeToGlycoNode.put(t_nodeRoot, (GlycoNode)substituent);
                }
                ArrayList<Edge> arrayList = new ArrayList<Edge>();
                ArrayList<Node> t_nodes = new ArrayList<Node>();
                t_nodes.add(t_nodeRoot);
                LinkedList<Node> linkedList = new LinkedList<Node>();
                linkedList.add(t_nodeRoot);
                while (!linkedList.isEmpty()) {
                    Node t_nodeParent = (Node)linkedList.removeFirst();
                    for (Edge t_edge : t_nodeParent.getChildEdges()) {
                        arrayList.add(t_edge);
                        if (t_edge.getChild() == null) continue;
                        linkedList.add(t_edge.getChild());
                        t_nodes.add(t_edge.getChild());
                    }
                }
                t_mapUndToNodes.put(t_und, t_nodes);
                t_mapUndToEdges.put(t_und, arrayList);
            }
        }
        ArrayList<Edge> t_lCommonEdges = new ArrayList<Edge>();
        ArrayList<Edge> t_lRepeatEdges = new ArrayList<Edge>();
        ArrayList<Edge> t_lCyclicEdges = new ArrayList<Edge>();
        for (Node _node : _glyCo.getAllNodes()) {
            if (_node instanceof Monosaccharide) {
                Monosaccharide t_ms = (Monosaccharide)_node;
                if (t_ms.getAnomer() == AnomericStateDescriptor.UNKNOWN) {
                    throw new GlycanException("The monosaccharide which contains \"u\" or \"U\" can not be converted to GlycoCT");
                }
                org.eurocarbdb.MolecularFramework.sugar.Monosaccharide monosaccharide = this.convertMonosaccharide(t_ms);
                this.m_mapNodeToGlycoNode.put(_node, (GlycoNode)monosaccharide);
                if (_node.getChildEdges().isEmpty() && _node.getParentEdges().isEmpty()) {
                    this.sugar.addNode((GlycoNode)monosaccharide);
                    continue;
                }
            }
            if (_node.getChildEdges().isEmpty()) continue;
            GlycanUndefinedUnit t_undHost = null;
            for (GlycanUndefinedUnit glycanUndefinedUnit : _glyCo.getUndefinedUnit()) {
                if (!((List)t_mapUndToNodes.get(glycanUndefinedUnit)).contains(_node)) continue;
                t_undHost = glycanUndefinedUnit;
                break;
            }
            for (Edge edge : _node.getChildEdges()) {
                Object t_subst;
                if (edge.getSubstituent() != null && ((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)(t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)edge.getSubstituent())).getSubstituent() != null && !this.m_mapNodeToGlycoNode.containsKey(t_subst)) {
                    this.m_mapNodeToGlycoNode.put((Node)t_subst, (GlycoNode)this.convertSubstituent((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_subst));
                }
                if (t_undHost != null) continue;
                if (edge.isRepeat()) {
                    t_lRepeatEdges.add(edge);
                    continue;
                }
                if (edge.isCyclic()) {
                    t_lCyclicEdges.add(edge);
                    continue;
                }
                t_lCommonEdges.add(edge);
            }
        }
        if (_glyCo.isComposition()) {
            if (_glyCo.getNumberOfUndefinedLinkages() != _glyCo.getAllNodes().size() - 1) {
                throw new GlycoconjugateException("It is not handled that the glycan with undefined linkages which number is not the same as the number of monosaccharide minus one.");
            }
            for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnit()) {
                for (Edge t_edge : (List)t_mapUndToEdges.get(t_und)) {
                    this.addEdgeToGlycoGraph(t_edge, (GlycoGraph)this.sugar);
                }
                if (!((List)t_mapUndToEdges.get(t_und)).isEmpty()) continue;
                for (Node t_node : (List)t_mapUndToNodes.get(t_und)) {
                    this.sugar.addNode(this.m_mapNodeToGlycoNode.get(t_node));
                }
            }
            for (GlycanUndefinedUnit t_und : _glyCo.getUndefinedUnitsForSubstituent()) {
                org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)t_und.getConnection().getSubstituent();
                UnderdeterminedSubTree underdeterminedSubTree = new UnderdeterminedSubTree();
                underdeterminedSubTree.addNode((GlycoNode)this.convertSubstituent(t_subst));
                underdeterminedSubTree.setConnection(this.convertSubstituentEdge(t_subst, true));
                this.sugar.addUndeterminedSubTree(underdeterminedSubTree);
                for (GlycoNode t_node : this.sugar.getNodes()) {
                    if (t_node instanceof Substituent) continue;
                    this.sugar.addUndeterminedSubTreeParent(underdeterminedSubTree, t_node);
                }
            }
            return;
        }
        RepeatingUnitExtractor t_repExtractor = new RepeatingUnitExtractor();
        t_repExtractor.start(t_lRepeatEdges);
        for (Edge edge : t_repExtractor.getSortedRepeatEdges()) {
            SugarUnitRepeat sugarUnitRepeat = new SugarUnitRepeat();
            this.m_mapSugarUnitRepeatToEdge.put(sugarUnitRepeat, edge);
            GlycanRepeatModification t_modRep = (GlycanRepeatModification)edge.getSubstituent();
            sugarUnitRepeat.setMaxRepeatCount(t_modRep.getMaxRepeatCount());
            sugarUnitRepeat.setMinRepeatCount(t_modRep.getMinRepeatCount());
            for (Edge t_edgeNested : t_repExtractor.getNestedEdges(edge)) {
                this.addEdgeToGlycoGraph(t_edgeNested, (GlycoGraph)sugarUnitRepeat);
                t_lCommonEdges.remove(t_edgeNested);
            }
            if (t_repExtractor.getNestedEdges(edge).isEmpty()) {
                sugarUnitRepeat.addNode(this.m_mapNodeToGlycoNode.get(edge.getParent()));
            }
            this.addEdgeToGlycoGraph(edge, (GlycoGraph)sugarUnitRepeat);
            this.m_mapNodeToGlycoNode.put(edge.getParent(), (GlycoNode)sugarUnitRepeat);
            this.m_mapNodeToGlycoNode.put(edge.getChild(), (GlycoNode)sugarUnitRepeat);
            if (RepeatingUnitExtractor.getHeadEdge(edge) != null || RepeatingUnitExtractor.getTailEdge(edge) != null) continue;
            this.sugar.addNode((GlycoNode)sugarUnitRepeat);
        }
        for (Edge edge : t_lCommonEdges) {
            this.addEdgeToGlycoGraph(edge, (GlycoGraph)this.sugar);
        }
        for (Edge edge : t_lCyclicEdges) {
            this.addEdgeToGlycoGraph(edge, (GlycoGraph)this.sugar);
        }
        for (GlycanUndefinedUnit glycanUndefinedUnit : _glyCo.getUndefinedUnit()) {
            BigDecimal t_bdProbUpper;
            UnderdeterminedSubTree underdeterminedSubTree = new UnderdeterminedSubTree();
            BigDecimal t_bdProbLower = new BigDecimal(glycanUndefinedUnit.getProbabilityLow());
            if (!t_bdProbLower.toPlainString().equals("-1")) {
                t_bdProbLower = t_bdProbLower.setScale(2, RoundingMode.HALF_UP);
            }
            if (!(t_bdProbUpper = new BigDecimal(glycanUndefinedUnit.getProbabilityHigh())).toPlainString().equals("-1")) {
                t_bdProbUpper = t_bdProbUpper.setScale(2, RoundingMode.HALF_UP);
            }
            underdeterminedSubTree.setProbability(t_bdProbLower.doubleValue(), t_bdProbUpper.doubleValue());
            GlycoEdge t_connection = this.convertGlycosidicEdge(glycanUndefinedUnit.getConnection());
            if (glycanUndefinedUnit.getRootNodes().get(0) instanceof org.glycoinfo.GlycanFormatconverter.Glycan.Substituent) {
                org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_sub = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)glycanUndefinedUnit.getRootNodes().get(0);
                t_connection = this.convertSubstituentEdge(t_sub, true);
            }
            underdeterminedSubTree.setConnection(t_connection);
            if (t_mapUndToEdges.containsKey(glycanUndefinedUnit) && !((List)t_mapUndToEdges.get(glycanUndefinedUnit)).isEmpty()) {
                for (Edge t_edge : (List)t_mapUndToEdges.get(glycanUndefinedUnit)) {
                    this.addEdgeToGlycoGraph(t_edge, (GlycoGraph)underdeterminedSubTree);
                }
            } else {
                for (Node t_node : (List)t_mapUndToNodes.get(glycanUndefinedUnit)) {
                    underdeterminedSubTree.addNode(this.m_mapNodeToGlycoNode.get(t_node));
                }
            }
            this.sugar.addUndeterminedSubTree(underdeterminedSubTree);
            for (Node t_nodeParent : glycanUndefinedUnit.getParents()) {
                GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(t_nodeParent);
                this.sugar.addUndeterminedSubTreeParent(underdeterminedSubTree, t_parent);
            }
        }
    }

    private org.eurocarbdb.MolecularFramework.sugar.Monosaccharide convertMonosaccharide(Monosaccharide _ms) throws GlycoconjugateException {
        SuperClass enumSClass = _ms.getSuperClass();
        Superclass t_enumSuperclass = Superclass.forCAtomCount((int)enumSClass.getSize());
        AnomericStateDescriptor enumAnom = _ms.getAnomer();
        if (enumAnom == AnomericStateDescriptor.UNKNOWN) {
            enumAnom = AnomericStateDescriptor.UNKNOWN_STATE;
        }
        if (enumSClass == SuperClass.SUG && enumAnom == AnomericStateDescriptor.OPEN) {
            enumAnom = AnomericStateDescriptor.UNKNOWN_STATE;
        }
        Anomer t_enumAnomer = Anomer.forSymbol((char)enumAnom.getAnomericState());
        org.eurocarbdb.MolecularFramework.sugar.Monosaccharide sugarMS = new org.eurocarbdb.MolecularFramework.sugar.Monosaccharide(t_enumAnomer, t_enumSuperclass);
        for (String t_strStereo : _ms.getStereos()) {
            if (t_enumSuperclass == Superclass.SUG) break;
            String t_stereo = t_strStereo;
            if (t_stereo.length() == 3) {
                t_stereo = "x" + t_stereo;
            }
            if (t_stereo.contains("d/l-")) {
                t_stereo = t_stereo.replace("d/l-", "x");
            }
            BaseType t_bType = BaseType.forName((String)t_stereo);
            sugarMS.addBaseType(t_bType);
        }
        if (sugarMS.getBaseType().isEmpty() && sugarMS.getSuperclass() == Superclass.TRI) {
            sugarMS.addBaseType(BaseType.XGRO);
        }
        int t_iStart = _ms.getRingStart();
        int t_iEnd = _ms.getRingEnd();
        if (_ms.getAnomer() == AnomericStateDescriptor.OPEN && t_iStart == -1) {
            t_iStart = 0;
            t_iEnd = 0;
        }
        if (t_iStart != -1 && t_iEnd == -1) {
            t_iStart = -1;
        }
        if (!_ms.getStereos().isEmpty() && _ms.getStereos().get(0).equals("Sugar")) {
            t_iStart = -1;
            t_iEnd = -1;
        }
        sugarMS.setRing(t_iStart, t_iEnd);
        ArrayList<GlyCoModification> t_lMods = new ArrayList<GlyCoModification>();
        boolean t_bHasModification1 = false;
        boolean t_bHasAldi1 = false;
        boolean t_bIsAldose = false;
        boolean t_bIsKetose = false;
        boolean t_bIsKetoAldose = false;
        for (GlyCoModification t_mod : _ms.getModifications()) {
            if (t_mod.getModificationTemplate().getGlycoCTnotation().equals("en")) continue;
            if (t_mod.getPositionOne() == 1) {
                t_bHasModification1 = true;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.HYDROXYL) {
                if (enumAnom.getAnomericState() != 'o' || t_mod.getPositionOne() != 1) continue;
                t_bHasAldi1 = true;
                continue;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.KETONE_U || t_mod.getModificationTemplate() == ModificationTemplate.KETONE) {
                if (_ms.getAnomericPosition() == 1 && t_mod.getPositionOne() != 1) {
                    t_bIsKetoAldose = true;
                }
                if (t_mod.getPositionOne() == 1) {
                    t_bIsAldose = true;
                    continue;
                }
                t_bIsKetose = true;
            }
            if (t_mod.getModificationTemplate() == ModificationTemplate.ALDEHYDE) {
                if (t_mod.getPositionOne() != 1) continue;
                t_bIsAldose = true;
                continue;
            }
            t_lMods.add(t_mod);
        }
        if (!(t_bHasModification1 || _ms.getAnomericPosition() != 1 && _ms.getAnomericPosition() != -1)) {
            t_bIsAldose = true;
        }
        if (t_bIsAldose && t_bIsKetose) {
            t_bIsKetoAldose = true;
        }
        if (t_bIsKetoAldose) {
            sugarMS.addModification(new Modification("keto", 1));
        }
        if (t_bIsAldose || t_bIsKetose) {
            t_bHasAldi1 = false;
        }
        if (t_bHasAldi1) {
            sugarMS.addModification(new Modification("aldi", 1));
        }
        for (GlyCoModification t_mod : t_lMods) {
            Modification t_modSugar = new Modification(t_mod.getModificationTemplate().getGlycoCTnotation(), t_mod.getPositionOne().intValue(), t_mod.getPositionTwo());
            sugarMS.addModification(t_modSugar);
        }
        int t_iPrev = 0;
        int i = 1;
        while (i < sugarMS.getSuperclass().getCAtomCount()) {
            if (i > t_iPrev) {
                Enum t_modTempFirst = null;
                Enum t_modTempSecond = null;
                for (GlyCoModification t_mod : _ms.getModifications()) {
                    if (!t_mod.getModificationTemplate().getGlycoCTnotation().equals("en")) continue;
                    if (t_mod.getPositionOne() == i) {
                        t_modTempFirst = t_mod.getModificationTemplate();
                    }
                    if (t_mod.getPositionOne() != i + 1) continue;
                    t_modTempSecond = t_mod.getModificationTemplate();
                }
                if (t_modTempFirst != null && t_modTempSecond != null) {
                    Modification t_mod;
                    t_iPrev = i + 1;
                    boolean t_bHasStereo = false;
                    boolean t_bIsEN = false;
                    switch (GlyContainerToSugar.$SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate()[t_modTempFirst.ordinal()]) {
                        case 2: 
                        case 4: {
                            t_bHasStereo = true;
                        }
                        case 3: {
                            t_bIsEN = true;
                            t_mod = new Modification("d", i);
                            if (i == 1) {
                                t_mod = new Modification("aldi", i);
                            }
                            sugarMS.addModification(t_mod);
                            break;
                        }
                        case 5: 
                        case 7: {
                            t_bHasStereo = true;
                            break;
                        }
                    }
                    switch (GlyContainerToSugar.$SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate()[t_modTempSecond.ordinal()]) {
                        case 2: 
                        case 4: {
                            t_bHasStereo = true;
                        }
                        case 3: {
                            t_bIsEN = true;
                            if (i == sugarMS.getSuperclass().getCAtomCount() - 1) break;
                            sugarMS.addModification(new Modification("d", i + 1));
                            break;
                        }
                        case 5: 
                        case 7: {
                            t_bHasStereo = true;
                            break;
                        }
                    }
                    if (t_bHasStereo && (t_iStart == 0 || t_iStart == -1)) {
                        throw new GlycoconjugateException("Double bond stereo will be missed.");
                    }
                    t_mod = new Modification("enx", i, Integer.valueOf(i + 1));
                    if (t_bIsEN) {
                        t_mod = new Modification("en", i, Integer.valueOf(i + 1));
                    }
                    sugarMS.addModification(t_mod);
                }
            }
            ++i;
        }
        return sugarMS;
    }

    private Substituent convertSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst) throws GlycoconjugateException {
        return new Substituent(SubstituentType.forName((String)_subst.getSubstituent().getglycoCTnotation()));
    }

    private void addEdgeToGlycoGraph(Edge _edge, GlycoGraph _graph) throws GlycoconjugateException, GlycanException {
        Edge t_edgeRepeat;
        org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_substRepeat;
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            if (this.m_mapNodeToGlycoNode.get(_edge.getChild()) instanceof SugarUnitRepeat) {
                t_link.setChildLinkageType(LinkageType.NONMONOSACCHARIDE);
            }
            if (!(this.m_mapNodeToGlycoNode.get(_edge.getParent()) instanceof SugarUnitRepeat)) continue;
            t_link.setParentLinkageType(LinkageType.NONMONOSACCHARIDE);
        }
        if (_edge.getSubstituent() == null || ((org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)_edge.getSubstituent()).getSubstituent() == null) {
            this.addGlycosidicLinkageToGlycoGraph(_edge, _graph);
            return;
        }
        if (_edge.isCyclic()) {
            GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(_edge.getParent());
            GlycoNode t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
            GlycoEdge t_glycoEdge = this.convertGlycosidicEdge(_edge);
            ((Sugar)_graph).addCyclic(t_parent, t_glycoEdge, t_child);
            return;
        }
        org.glycoinfo.GlycanFormatconverter.Glycan.Substituent t_subst = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)_edge.getSubstituent();
        GlycoEdge t_glycoEdge = this.convertSubstituentEdge(t_subst, true);
        if (t_glycoEdge.getGlycosidicLinkages().isEmpty()) {
            for (Linkage t_link : _edge.getGlycosidicLinkages()) {
                Linkage t_link0 = this.normalizeLinkageTypeForSubstituent(t_subst, t_link, true);
                t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
            }
        }
        GlycoNode t_child = this.m_mapNodeToGlycoNode.get(t_subst);
        Node t_parentNode = t_subst.getParentNode();
        if (t_parentNode == null) {
            t_parentNode = _edge.getParent();
        }
        GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(t_parentNode);
        boolean t_bSkipSubst = false;
        if (t_parent instanceof SugarUnitRepeat && (t_substRepeat = (org.glycoinfo.GlycanFormatconverter.Glycan.Substituent)(t_edgeRepeat = this.m_mapSugarUnitRepeatToEdge.get((SugarUnitRepeat)t_parent)).getSubstituent()) != null && t_substRepeat.getSubstituent() != null && t_subst.getSubstituent().getglycoCTnotation().equals(t_substRepeat.getSubstituent().getglycoCTnotation())) {
            t_bSkipSubst = true;
        }
        GlycoGraph t_graph = _graph;
        if (this.hasProbability(_edge)) {
            t_graph = this.getUndeterminedSubTreeWithProbability(_graph, _edge.getGlycosidicLinkages().get(0), t_parent, t_glycoEdge, t_child);
        } else if (this.hasProbability(t_subst)) {
            t_graph = this.getUndeterminedSubTreeWithProbability(_graph, t_subst.getFirstPosition(), t_parent, t_glycoEdge, t_child);
        }
        if (!t_graph.equals(_graph)) {
            t_bSkipSubst = true;
        }
        if (!t_bSkipSubst) {
            t_graph.addNode(t_parent, t_glycoEdge, t_child);
        }
        if (_edge.getChild() == null) {
            return;
        }
        t_glycoEdge = this.convertSubstituentEdge(t_subst, false);
        if (t_glycoEdge.getGlycosidicLinkages().isEmpty()) {
            for (Linkage t_link : _edge.getGlycosidicLinkages()) {
                Linkage t_link0 = this.normalizeLinkageTypeForSubstituent(t_subst, t_link, false);
                t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
            }
        }
        t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
        if (!t_bSkipSubst) {
            t_parent = this.m_mapNodeToGlycoNode.get(t_subst);
        }
        if (_edge.isRepeat()) {
            ((SugarUnitRepeat)t_graph).setRepeatLinkage(t_glycoEdge, t_parent, t_child);
            return;
        }
        t_graph.addNode(t_parent, t_glycoEdge, t_child);
    }

    private void addGlycosidicLinkageToGlycoGraph(Edge _edge, GlycoGraph _graph) throws GlycoconjugateException, GlycanException {
        if (_edge.getGlycosidicLinkages().isEmpty()) {
            throw new GlycoconjugateException("Edge with no linkage can not be handled.");
        }
        GlycoNode t_parent = this.m_mapNodeToGlycoNode.get(_edge.getParent());
        GlycoNode t_child = this.m_mapNodeToGlycoNode.get(_edge.getChild());
        GlycoEdge t_glycoEdge = this.convertGlycosidicEdge(_edge);
        if (this.hasProbability(_edge)) {
            this.getUndeterminedSubTreeWithProbability(_graph, _edge.getGlycosidicLinkages().get(0), t_parent, t_glycoEdge, t_child);
            return;
        }
        if (_edge.isRepeat()) {
            ((SugarUnitRepeat)_graph).setRepeatLinkage(t_glycoEdge, t_parent, t_child);
            return;
        }
        _graph.addNode(t_parent, t_glycoEdge, t_child);
    }

    private UnderdeterminedSubTree getUndeterminedSubTreeWithProbability(GlycoGraph _parentGraph, Linkage _link, GlycoNode _parent, GlycoEdge _connection, GlycoNode _child) throws GlycoconjugateException {
        BigDecimal t_bdProbUpper;
        BigDecimal t_bdProbLower = new BigDecimal(_link.getParentProbabilityLower());
        if (!t_bdProbLower.toPlainString().equals("-1")) {
            t_bdProbLower = t_bdProbLower.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        }
        if (!(t_bdProbUpper = new BigDecimal(_link.getParentProbabilityUpper())).toPlainString().equals("-1")) {
            t_bdProbUpper = t_bdProbUpper.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
        }
        UnderdeterminedSubTree t_subTree = new UnderdeterminedSubTree();
        t_subTree.setProbability(t_bdProbLower.doubleValue(), t_bdProbUpper.doubleValue());
        t_subTree.setConnection(_connection);
        if (!_parentGraph.containsNode(_parent)) {
            _parentGraph.addNode(_parent);
        }
        if (_parentGraph instanceof Sugar) {
            ((Sugar)_parentGraph).addUndeterminedSubTree(t_subTree);
            ((Sugar)_parentGraph).addUndeterminedSubTreeParent(t_subTree, _parent);
        }
        if (_parentGraph instanceof SugarUnitRepeat) {
            ((SugarUnitRepeat)_parentGraph).addUndeterminedSubTree(t_subTree);
            ((SugarUnitRepeat)_parentGraph).addUndeterminedSubTreeParent(t_subTree, _parent);
        }
        t_subTree.addNode(_child);
        return t_subTree;
    }

    private boolean hasProbability(Edge _edge) {
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            if (t_link.getChildProbabilityLower() != 1.0) {
                return true;
            }
            if (t_link.getParentProbabilityLower() == 1.0) continue;
            return true;
        }
        return false;
    }

    private boolean hasProbability(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst) {
        if (_subst.getFirstPosition() == null) {
            return false;
        }
        if (_subst.getFirstPosition().getChildProbabilityLower() != 1.0) {
            return true;
        }
        if (_subst.getFirstPosition().getParentProbabilityLower() != 1.0) {
            return true;
        }
        if (_subst.getSecondPosition() == null) {
            return false;
        }
        if (_subst.getSecondPosition().getChildProbabilityLower() != 1.0) {
            return true;
        }
        return _subst.getSecondPosition().getParentProbabilityLower() != 1.0;
    }

    private GlycoEdge convertGlycosidicEdge(Edge _edge) throws GlycoconjugateException, GlycanException {
        GlycoEdge t_glycoEdge = new GlycoEdge();
        for (Linkage t_link : _edge.getGlycosidicLinkages()) {
            Linkage t_link0 = this.normalizeLinkageTypeForGlycosidicLinkage(t_link);
            t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_link0));
        }
        return t_glycoEdge;
    }

    private GlycoEdge convertSubstituentEdge(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, boolean _isChild) throws GlycanException, GlycoconjugateException {
        GlycoEdge t_glycoEdge = new GlycoEdge();
        if (_subst.getFirstPosition() == null) {
            return t_glycoEdge;
        }
        Linkage t_link = _subst.getFirstPosition();
        if (t_link.getParentLinkages().isEmpty() || t_link.getChildLinkages().isEmpty()) {
            return t_glycoEdge;
        }
        Linkage t_linkNew = this.normalizeLinkageTypeForSubstituent(_subst, t_link, _isChild);
        t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_linkNew));
        if (_subst.getSecondPosition() == null) {
            return t_glycoEdge;
        }
        t_link = _subst.getSecondPosition();
        if (t_link.getParentLinkages().isEmpty() || t_link.getChildLinkages().isEmpty()) {
            return t_glycoEdge;
        }
        t_linkNew = this.normalizeLinkageTypeForSubstituent(_subst, t_link, _isChild);
        t_linkNew.setParentLinkageType(this.getLinkageTypeForSubstituent(_subst, false));
        t_glycoEdge.addGlycosidicLinkage(this.convertLinkage(t_linkNew));
        if (_subst.getSubstituent().getglycoCTnotation().equals("anhydro")) {
            ((org.eurocarbdb.MolecularFramework.sugar.Linkage)t_glycoEdge.getGlycosidicLinkages().get(0)).setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.DEOXY);
            ((org.eurocarbdb.MolecularFramework.sugar.Linkage)t_glycoEdge.getGlycosidicLinkages().get(1)).setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.H_AT_OH);
        }
        return t_glycoEdge;
    }

    private Linkage normalizeLinkageTypeForSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, Linkage _link, boolean _isChild) throws GlycanException {
        Linkage t_link = new Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        ArrayList<Integer> t_lParentPos = new ArrayList<Integer>();
        for (Integer t_pos : _link.getParentLinkages()) {
            t_lParentPos.add(t_pos);
        }
        ArrayList<Integer> t_lChildPos = new ArrayList<Integer>();
        for (Integer t_pos : _link.getChildLinkages()) {
            t_lChildPos.add(t_pos);
        }
        if (_isChild) {
            if (t_ltParent == LinkageType.UNVALIDATED) {
                t_ltParent = this.getLinkageTypeForSubstituent(_subst, _isChild);
            }
            if (t_ltChild != LinkageType.NONMONOSACCHARIDE) {
                t_ltChild = LinkageType.NONMONOSACCHARIDE;
            }
            if (t_lChildPos.size() == 1) {
                t_lChildPos.set(0, 1);
            }
        } else {
            if (t_ltChild == LinkageType.UNVALIDATED) {
                t_ltChild = this.getLinkageTypeForSubstituent(_subst, _isChild);
            }
            if (t_ltParent != LinkageType.NONMONOSACCHARIDE) {
                t_ltParent = LinkageType.NONMONOSACCHARIDE;
            }
            if (t_lParentPos.size() == 1) {
                t_lParentPos.set(0, 1);
            }
        }
        t_link.setParentLinkageType(t_ltParent);
        t_link.setChildLinkageType(t_ltChild);
        t_link.setParentLinkages(t_lParentPos);
        t_link.setChildLinkages(t_lChildPos);
        return t_link;
    }

    private LinkageType getLinkageTypeForSubstituent(org.glycoinfo.GlycanFormatconverter.Glycan.Substituent _subst, boolean _isChild) {
        if (_subst.getSubstituent() == CrossLinkedTemplate.ANHYDROXYL) {
            return _isChild ? LinkageType.H_AT_OH : LinkageType.DEOXY;
        }
        if (_subst.getSubstituent() == CrossLinkedTemplate.PHOSPHOETHANOLAMINE) {
            return _isChild ? LinkageType.H_AT_OH : LinkageType.H_AT_OH;
        }
        String t_strMAP = _subst.getSubstituent().getMAP().replaceAll("\\d", "");
        char t_cLinkage = _isChild ? t_strMAP.charAt(1) : t_strMAP.charAt(t_strMAP.indexOf("*", 1) - 1);
        return t_cLinkage == 'O' ? LinkageType.H_AT_OH : LinkageType.DEOXY;
    }

    private Linkage normalizeLinkageTypeForGlycosidicLinkage(Linkage _link) throws GlycanException {
        Linkage t_link = new Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        if (t_ltParent == LinkageType.UNVALIDATED) {
            t_ltParent = LinkageType.H_AT_OH;
        }
        if (t_ltChild == LinkageType.UNVALIDATED) {
            t_ltChild = LinkageType.DEOXY;
        }
        t_link.setParentLinkageType(t_ltParent);
        t_link.setChildLinkageType(t_ltChild);
        t_link.setParentLinkages(_link.getParentLinkages());
        t_link.setChildLinkages(_link.getChildLinkages());
        return t_link;
    }

    private org.eurocarbdb.MolecularFramework.sugar.Linkage convertLinkage(Linkage _link) throws GlycoconjugateException {
        org.eurocarbdb.MolecularFramework.sugar.Linkage t_sugarLink = new org.eurocarbdb.MolecularFramework.sugar.Linkage();
        LinkageType t_ltParent = _link.getParentLinkageType();
        LinkageType t_ltChild = _link.getChildLinkageType();
        t_sugarLink.setParentLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.forName((char)t_ltParent.getSymbol()));
        t_sugarLink.setParentLinkages(_link.getParentLinkages());
        t_sugarLink.setChildLinkageType(org.eurocarbdb.MolecularFramework.sugar.LinkageType.forName((char)t_ltChild.getSymbol()));
        t_sugarLink.setChildLinkages(_link.getChildLinkages());
        return t_sugarLink;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate() {
        if ($SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate != null) {
            return $SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate;
        }
        int[] nArray = new int[ModificationTemplate.values().length];
        try {
            nArray[ModificationTemplate.ALDEHYDE.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.ALDONICACID.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.DEOXY.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HLOSE_5.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HLOSE_6.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HLOSE_7.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HLOSE_8.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HLOSE_X.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.HYDROXYL.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.KETONE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.KETONE_U.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.METHYL.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.ULOSONIC.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_EL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_EU.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_FL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_FU.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_ZL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.UNSATURATION_ZU.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ModificationTemplate.URONICACID.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$glycoinfo$GlycanFormatconverter$Glycan$ModificationTemplate = nArray;
        return nArray;
    }
}

