/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplate;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplateContainer;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

public class MonosaccharideValidation {
    public static void checkMonosaccharideConsistency(Monosaccharide ms, TemplateContainer container) throws ResourcesDbException {
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, container, true);
    }

    public static void checkMonosaccharideConsistency(Monosaccharide ms, TemplateContainer container, Config conf) throws ResourcesDbException {
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, container, !conf.isPreserveAlditolOrientation());
    }

    public static void checkMonosaccharideConsistency(Monosaccharide ms, TemplateContainer container, boolean checkOrientation) throws ResourcesDbException {
        if (ms.getRingStart() > ms.getSize() || ms.getRingStart() < -1) {
            throw new MonosaccharideException("Carbonyl position out of range: " + ms.getRingStart());
        }
        if (ms.getRingEnd() > ms.getSize() || ms.getRingEnd() < -1) {
            throw new MonosaccharideException("Ring oxygen position out of range: " + ms.getRingEnd());
        }
        if (ms.getRingtype().equals((Object)Ringtype.OPEN)) {
            if (ms.getAnomer().equals((Object)Anomer.ALPHA) || ms.getAnomer().equals((Object)Anomer.BETA)) {
                throw new MonosaccharideException("Anomer in open chain residue set.");
            }
        } else if (ms.isStereolossPositionWithIgnoreType(ms.getRingStart(), CoreModificationTemplate.KETO)) {
            if (ms.getAnomer().equals((Object)Anomer.ALPHA) || ms.getAnomer().equals((Object)Anomer.BETA)) {
                throw new MonosaccharideException("Anomer set in residue with non-chiral anomeric center.");
            }
            if (ms.getAnomer().equals((Object)Anomer.UNKNOWN)) {
                ms.setAnomer(Anomer.NONE);
                ms.setStereoStr(Stereocode.setPositionInStereoString(ms.getStereoStr(), StereoConfiguration.Nonchiral, ms.getRingStart()));
            }
        } else if (ms.getAnomer().equals((Object)Anomer.NONE)) {
            throw new MonosaccharideException("Anomer 'none' in residue with chiral anomeric center.");
        }
        for (int pos = 1; pos <= ms.getSize(); ++pos) {
            Integer linkcount;
            ArrayList<CoreModification> coreModList = ms.getCoreModificationsByPosition(pos);
            ArrayList<Substitution> substList = ms.getSubstitutionsByPosition(pos);
            if (coreModList.size() == 0 && substList.size() == 0) continue;
            if (pos == ms.getRingEnd()) {
                if (substList.size() > 0) {
                    for (Substitution roSubst : substList) {
                        if (roSubst.getTemplate().isCanReplaceRingOxygen() || roSubst.getLinkagetypeByPosition(pos).equals((Object)LinkageType.H_LOSE)) continue;
                        throw new MonosaccharideException("Substitution at ring oxygen.");
                    }
                }
                int enCount = 0;
                for (CoreModification mod : coreModList) {
                    if (mod.getTemplate().equals((Object)CoreModificationTemplate.EN) || mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) {
                        ++enCount;
                        continue;
                    }
                    throw new MonosaccharideException("Disallowed modification at ring oxygen: " + mod.getName());
                }
                if (enCount > 1) {
                    throw new MonosaccharideException("Multiple 'en' modifications at ring oxygen.");
                }
            }
            if (pos == ms.getRingStart()) {
                if (substList.size() > 0 && ms.getRingEnd() == -1 && !ms.isAlditol()) {
                    throw new MonosaccharideException("Substitution at carbonyl position of an open chain monosaccharide.");
                }
                if (pos > 1) {
                    if (ms.isAlditol()) {
                        throw new MonosaccharideException("Alditols are not defined for ketoses");
                    }
                    if ((ms.getCoreModification(CoreModificationTemplate.EN.getName(), pos) != null || ms.getCoreModification(CoreModificationTemplate.ENX.getName(), pos) != null) && ms.getCoreModification(CoreModificationTemplate.DEOXY.getName(), pos) == null) {
                        ms.addCoreModification(new CoreModification(CoreModificationTemplate.DEOXY, pos));
                    }
                }
                if (ms.getRingEnd() == -1) {
                    for (CoreModification mod : coreModList) {
                        if (mod.getTemplate().equals((Object)CoreModificationTemplate.ACID) || mod.getTemplate().equals((Object)CoreModificationTemplate.SP2) || mod.getTemplate().equals((Object)CoreModificationTemplate.EN) || mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) continue;
                        if (mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY) && (ms.getRingEnd() > 1 || !ms.isAlditol())) {
                            throw new MonosaccharideException("Deoxy modification at carbonyl position of open chain residue.");
                        }
                        if (mod.getTemplate().equals((Object)CoreModificationTemplate.KETO)) continue;
                        throw new MonosaccharideException("Modification " + mod.getName() + " not allowed at carbonyl group of open chain residue.");
                    }
                }
            }
            int bondSum = 2;
            if (pos == 1 && ms.getRingStart() > 1) {
                --bondSum;
            }
            if (pos == ms.getSize() && pos != ms.getRingEnd()) {
                --bondSum;
            }
            for (CoreModification mod : coreModList) {
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.ACID)) {
                    if (pos > 1 && pos < ms.getSize()) {
                        throw new MonosaccharideException("Acid modification within backbone (pos. " + pos + ")");
                    }
                    if (pos == 1 && ms.getRingStart() < 2 && ms.getRingEnd() > 0) {
                        throw new MonosaccharideException("Acid modification at ring closure position (" + pos + ").");
                    }
                    if (pos == ms.getRingEnd()) {
                        throw new MonosaccharideException("Acid modification at ring closure position (" + pos + ").");
                    }
                    if (coreModList.size() > 1) {
                        throw new MonosaccharideException("Acid modification at otherwise modified position (" + pos + ").");
                    }
                    if (pos != 1 || !ms.isAlditol()) continue;
                    throw new MonosaccharideException("Excluding modifications: Alditol and 1-Acid");
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.KETO)) {
                    if (substList.size() > 0) {
                        throw new MonosaccharideException("Substitution at keto position (" + pos + ").");
                    }
                    if (CoreModificationTemplate.modListContainsModType(coreModList, CoreModificationTemplate.DEOXY) && pos != ms.getRingStart()) {
                        throw new MonosaccharideException("Deoxygenation at keto position (" + pos + ").");
                    }
                    if (CoreModificationTemplate.modListContainsModType(coreModList, CoreModificationTemplate.SP2) && pos != ms.getRingStart()) {
                        throw new MonosaccharideException("Sp2 hybride at keto position (" + pos + ").");
                    }
                    if (!ms.isAlditol()) continue;
                    throw new MonosaccharideException("Core modifications ALDITOL and KETO must not occurr together in one monosaccharide.");
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) {
                    for (Substitution subst : substList) {
                        if (subst.getLinkagetypeByPosition(pos).equals((Object)LinkageType.H_LOSE)) continue;
                        throw new MonosaccharideException("Substitution at deoxy position (" + pos + ").");
                    }
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.SP2)) {
                    boolean hasDoublebondSubst = false;
                    for (Substitution substitution : substList) {
                        if (substitution.getBondOrder1() == 2.0) {
                            hasDoublebondSubst = true;
                            break;
                        }
                        if (substitution.getBondOrder2() != 2.0) continue;
                        hasDoublebondSubst = true;
                        break;
                    }
                    if (hasDoublebondSubst) continue;
                    throw new MonosaccharideException("Sp2 hybride without substitution of bond order 2");
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.ANHYDRO)) {
                    for (Substitution subst : substList) {
                        if (subst.getLinkagetypeByPosition(pos).equals((Object)LinkageType.H_LOSE)) continue;
                        throw new MonosaccharideException("Substitution at anhydro position (" + pos + ").");
                    }
                    if (CoreModificationTemplate.modListContainsModType(coreModList, CoreModificationTemplate.DEOXY)) {
                        throw new MonosaccharideException("Deoxygenation at anhydro position (" + pos + ").");
                    }
                    if (mod.getIntValuePosition2() != pos + 1) continue;
                    mod.setTemplate(CoreModificationTemplate.EPOXY);
                    continue;
                }
                if (!mod.getTemplate().equals((Object)CoreModificationTemplate.EPOXY)) continue;
                for (Substitution subst : substList) {
                    if (subst.getLinkagetypeByPosition(pos).equals((Object)LinkageType.H_LOSE)) continue;
                    throw new MonosaccharideException("Substitution at epoxy position (" + pos + ").");
                }
                if (CoreModificationTemplate.modListContainsModType(coreModList, CoreModificationTemplate.DEOXY)) {
                    throw new MonosaccharideException("Deoxygenation at epoxy position (" + pos + ").");
                }
                if (mod.getIntValuePosition2() == mod.getIntValuePosition1() + 1) continue;
                throw new MonosaccharideException("Epoxy modification must be at neighbouring carbons (positions present: " + mod.getIntValuePosition1() + "-" + mod.getIntValuePosition2() + ")");
            }
            HashMap<LinkageType, Integer> linktypeCountMap = new HashMap<LinkageType, Integer>();
            for (Substitution subst : substList) {
                Integer n;
                if (subst.containsPosition1(pos)) {
                    bondSum = (int)((double)bondSum + subst.getBondOrder1());
                    if (subst.getLinkagetype1() != null) {
                        linkcount = (Integer)linktypeCountMap.get((Object)subst.getLinkagetype1());
                        if (linkcount == null) {
                            linkcount = new Integer(0);
                        }
                        Integer n2 = linkcount;
                        n = linkcount = Integer.valueOf(linkcount + 1);
                        linktypeCountMap.put(subst.getLinkagetype1(), linkcount);
                    }
                }
                if (!subst.containsPosition2(pos)) continue;
                bondSum = (int)((double)bondSum + subst.getBondOrder2());
                if (subst.getLinkagetype2() == null) continue;
                linkcount = (Integer)linktypeCountMap.get((Object)subst.getLinkagetype2());
                if (linkcount == null) {
                    linkcount = new Integer(0);
                }
                Integer n3 = linkcount;
                n = linkcount = Integer.valueOf(linkcount + 1);
                linktypeCountMap.put(subst.getLinkagetype2(), linkcount);
            }
            if (bondSum > 4) {
                throw new MonosaccharideException("Modifications result in " + bondSum + " bonds for C" + pos);
            }
            for (LinkageType linktype : linktypeCountMap.keySet()) {
                Integer n;
                linkcount = (Integer)linktypeCountMap.get((Object)linktype);
                if (linkcount > 1) {
                    throw new MonosaccharideException(linkcount + " substituents of LinkageType " + (Object)((Object)linktype) + " at position " + pos);
                }
                if (linktype.equals((Object)LinkageType.H_AT_OH) && linkcount > 0 && (n = (Integer)linktypeCountMap.get((Object)LinkageType.DEOXY)) != null && n > 0) {
                    throw new MonosaccharideException("Substituents of LinkageTypes DEOXY and H_AT_OH at position " + pos);
                }
                if (!linktype.equals((Object)LinkageType.H_LOSE) || linkcount <= 0) continue;
                Integer n4 = (Integer)linktypeCountMap.get((Object)LinkageType.R_CONFIG);
                if (n4 != null && n4 > 0) {
                    throw new MonosaccharideException("Substituents of LinkageTypes H_LOSE and R_CONFIG at position " + pos);
                }
                Integer n5 = (Integer)linktypeCountMap.get((Object)LinkageType.S_CONFIG);
                if (n5 == null || n5 <= 0) continue;
                throw new MonosaccharideException("Substituents of LinkageTypes H_LOSE and S_CONFIG at position " + pos);
            }
        }
        MonosaccharideValidation.checkStereocodeConsistency(ms);
        MonosaccharideValidation.checkEnxDeoxygenationStates(ms);
        MonosaccharideValidation.checkModifications(ms);
        if (checkOrientation) {
            MonosaccharideValidation.checkAlditolOrientation(ms, container.getBasetypeTemplateContainer());
        }
    }

    public static void checkStereocodeConsistency(Monosaccharide ms) throws MonosaccharideException {
        String stereo = ms.getStereoStr();
        if (stereo.length() != ms.getSize()) {
            throw new MonosaccharideException("Stereocode / residue size mismatch (" + stereo.length() + "/" + ms.getSize() + ")");
        }
        if (!ms.isSuperclass()) {
            ArrayList<Integer> stereoloss = ms.getStereolossPositions();
            for (Integer posInt : stereoloss) {
                int pos = posInt;
                if (pos == 0 || pos == ms.getRingStart() && !ms.getAnomer().equals((Object)Anomer.NONE) && !ms.getAnomer().equals((Object)Anomer.OPEN_CHAIN) || stereo.charAt(pos - 1) == StereoConfiguration.Nonchiral.getStereosymbol()) continue;
                throw new MonosaccharideException("Stereocode error: position " + pos + " should be nonchiral (" + stereo + ")");
            }
        }
    }

    public static void checkModifications(Monosaccharide ms) throws ResourcesDbException {
        for (CoreModification mod : ms.getCoreModifications()) {
            if (mod.getTemplate() == null) {
                throw new MonosaccharideException("missing core modification template: " + mod);
            }
            if (mod.getTemplate().getValence() == 1) {
                if (!mod.hasPosition2()) continue;
                throw new MonosaccharideException("position 2 set in monovalent modification: " + mod);
            }
            if (mod.getTemplate().getValence() != 2 || mod.hasPosition2()) continue;
            throw new MonosaccharideException("missing position 2 of divalent modification: " + mod);
        }
        for (Substitution subst : ms.getSubstitutions()) {
            Atom linkatom;
            if (subst.getTemplate() == null) {
                throw new MonosaccharideException("missing substituent template: " + subst);
            }
            if (subst.getTemplate().getMaxValence() == 1) {
                if (subst.hasPosition2()) {
                    throw new MonosaccharideException("position 2 set in monovalent substitution: " + subst);
                }
            } else if (subst.getTemplate().getMinValence() == 2 && !subst.hasPosition2()) {
                throw new MonosaccharideException("missing position 2 of divalent substitution: " + subst);
            }
            if ((LinkageType.H_LOSE.equals((Object)subst.getLinkagetype1()) || LinkageType.R_CONFIG.equals((Object)subst.getLinkagetype1()) || LinkageType.S_CONFIG.equals((Object)subst.getLinkagetype1())) && (subst.getIntValuePosition1() == 1 || subst.getIntValuePosition1() == ms.getSize()) && (linkatom = subst.getLinkingAtom1()).getElementSymbol().equalsIgnoreCase("C")) {
                throw new MonosaccharideException("C-linked substituent at terminal carbon.");
            }
            if (!subst.hasPosition2() || !LinkageType.H_LOSE.equals((Object)subst.getLinkagetype2()) && !LinkageType.R_CONFIG.equals((Object)subst.getLinkagetype2()) && !LinkageType.S_CONFIG.equals((Object)subst.getLinkagetype2()) || subst.getIntValuePosition2() != 1 && subst.getIntValuePosition2() != ms.getSize()) continue;
            try {
                if (!subst.getLinkingAtom2().getElementSymbol().equalsIgnoreCase("C")) continue;
                throw new MonosaccharideException("C-linked substituent at terminal carbon.");
            }
            catch (ResourcesDbException rEx) {
                throw new ResourcesDbException("Cannot check H_LOSE linked subst. at terminal carbon: no linking atom defined", rEx);
            }
        }
    }

    public static void checkEnxDeoxygenationStates(Monosaccharide ms) {
        for (CoreModification mod : ms.getCoreModifications(CoreModificationTemplate.ENX.getName())) {
            if (!MonosaccharideValidation.enDeoxypatternConfident(ms, mod)) continue;
            try {
                mod.changeType(CoreModificationTemplate.EN);
            }
            catch (MonosaccharideException monosaccharideException) {}
        }
    }

    public static boolean enDeoxypatternConfident(Monosaccharide ms, CoreModification mod) {
        int position1 = mod.getIntValuePosition1();
        if (position1 == 0) {
            return false;
        }
        int position2 = position1 + 1;
        return MonosaccharideValidation.enDeoxyStatusPositionConfident(ms, position1) && MonosaccharideValidation.enDeoxyStatusPositionConfident(ms, position2);
    }

    public static boolean enDeoxyStatusPositionConfident(Monosaccharide ms, int position) {
        if (position == ms.getRingEnd()) {
            return true;
        }
        if (ms.getCoreModification("deoxy", position) != null) {
            return true;
        }
        if (ms.getSubstitutionsByPosition(position).size() > 0) {
            return true;
        }
        if (ms.getRingStart() == position && position > 1) {
            block6: {
                try {
                    ms.addCoreModification(new CoreModification(CoreModificationTemplate.DEOXY, position));
                }
                catch (MonosaccharideException me) {
                    if (!Config.getGlobalConfig().isPrintErrorMsgs(1)) break block6;
                    System.err.println("Exception: " + me);
                    me.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public static boolean checkAlditolOrientation(Monosaccharide ms, BasetypeTemplateContainer container) throws ResourcesDbException {
        if (!MonosaccharideValidation.hasCorrectAlditolOrientation(ms, container)) {
            if (ms.isAlditol() && ms.isUronic()) {
                ms.setAlditol(false);
            }
            ms.rotateAlditol();
            return false;
        }
        return true;
    }

    public static boolean hasCorrectAlditolOrientation(Monosaccharide ms, BasetypeTemplateContainer container) throws ResourcesDbException {
        String stereo2;
        String stereo1;
        boolean isRotatable = false;
        if (ms.isAlditol()) {
            isRotatable = true;
            if (ms.isUronic()) {
                return false;
            }
        } else if (ms.isAldaric()) {
            if (ms.getRingEnd() == -1) {
                isRotatable = true;
            }
        } else if (ms.getRingtype().equals((Object)Ringtype.OPEN) && ms.hasCoreModification(CoreModificationTemplate.KETO)) {
            isRotatable = true;
        }
        if (!isRotatable) {
            return true;
        }
        String stereo = ms.getStereoStr().replaceAll("" + StereoConfiguration.Nonchiral.getStereosymbol(), "");
        if (stereo.contains("" + StereoConfiguration.Unknown.getStereosymbol())) {
            return true;
        }
        if (Stereocode.stereoStringContainsAbsoluteAndRelative(stereo)) {
            return true;
        }
        if (stereo.length() > 4) {
            stereo1 = stereo.substring(stereo.length() - 4, stereo.length());
            stereo2 = Stereocode.rotateStereoString(stereo.substring(0, 4));
        } else {
            stereo1 = stereo;
            stereo2 = Stereocode.rotateStereoString(stereo);
        }
        BasetypeTemplate basetype1 = container.getBasetypeTemplateByStereoString(stereo1);
        BasetypeTemplate basetype2 = container.getBasetypeTemplateByStereoString(stereo2);
        if (!basetype1.equals(basetype2)) {
            if (basetype1.getBaseName().compareTo(basetype2.getBaseName()) > 0) {
                return false;
            }
        } else {
            StereoConfiguration config2;
            StereoConfiguration config1 = Stereocode.getConfigurationFromStereoString(stereo1);
            if (!config1.equals((Object)(config2 = Stereocode.getConfigurationFromStereoString(stereo2)))) {
                if (config1.equals((Object)StereoConfiguration.Laevus)) {
                    return false;
                }
            } else {
                int m;
                int modSum1 = 0;
                int modSum2 = 0;
                int sizePlusOne = ms.getSize() + 1;
                List<Substitution> modList = ms.getSubstitutions();
                for (m = 0; m < modList.size(); ++m) {
                    ArrayList<Integer> positions = modList.get(m).getPositions();
                    for (int i = 0; i < positions.size(); ++i) {
                        modSum1 += positions.get(i).intValue();
                        modSum2 += sizePlusOne - positions.get(i);
                    }
                }
                if (modSum1 > modSum2) {
                    return false;
                }
                if (modSum1 == modSum2) {
                    for (m = 1; m < sizePlusOne; ++m) {
                        ArrayList<Substitution> mod1 = ms.getSubstitutionsByPosition(m);
                        ArrayList<Substitution> mod2 = ms.getSubstitutionsByPosition(sizePlusOne - m);
                        if (mod1.size() > 0 && mod2.size() > 0) {
                            int i;
                            ArrayList<String> modNames1 = new ArrayList<String>();
                            ArrayList<String> modNames2 = new ArrayList<String>();
                            for (i = 0; i < mod1.size(); ++i) {
                                modNames1.add(mod1.get(i).getName());
                            }
                            Collections.sort(modNames1);
                            for (i = 0; i < mod2.size(); ++i) {
                                modNames2.add(mod2.get(i).getName());
                            }
                            Collections.sort(modNames2);
                            for (i = 0; i < Math.min(modNames1.size(), modNames2.size()); ++i) {
                                if (((String)modNames1.get(i)).compareTo((String)modNames2.get(i)) <= 0) continue;
                                return false;
                            }
                            if (modNames1.size() < modNames2.size()) {
                                return false;
                            }
                            if (modNames1.size() <= modNames2.size()) continue;
                            return true;
                        }
                        if (mod1.size() == 0 && mod2.size() > 0) {
                            return false;
                        }
                        if (mod1.size() <= 0 || mod2.size() != 0) continue;
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public static boolean checkFuzziness(Monosaccharide ms) {
        if (ms.getStereocode().hasUncertainPosition()) {
            return true;
        }
        if (ms.getRingEnd() == 0) {
            return true;
        }
        if (ms.getRingStart() == 0) {
            return true;
        }
        for (CoreModification mod : ms.getCoreModifications()) {
            if (mod.getIntValuePosition1() == 0) {
                return true;
            }
            if (!mod.hasPosition2() || mod.getIntValuePosition2() != 0) continue;
            return true;
        }
        for (Substitution subst : ms.getSubstitutions()) {
            if (subst.getIntValuePosition1() == 0) {
                return true;
            }
            if (subst.getIntValueSubstituentPosition1() == 0) {
                return true;
            }
            if (subst.hasPosition2()) {
                if (subst.getIntValuePosition2() == 0) {
                    return true;
                }
                if (subst.getIntValueSubstituentPosition2() == 0) {
                    return true;
                }
            }
            if (subst.getTemplate() == null) {
                return true;
            }
            if (!subst.getTemplate().isFuzzy()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubstitutable(Monosaccharide ms, int position, LinkageType linktype) {
        if (position == 0) {
            return true;
        }
        if (position < 0 || position > ms.getSize()) {
            return false;
        }
        if (position == ms.getRingStart() || position == ms.getRingEnd()) {
            return false;
        }
        for (CoreModification mod : ms.getCoreModifications()) {
            if (linktype.equals((Object)LinkageType.H_LOSE)) {
                if ((mod.getTemplate().equals((Object)CoreModificationTemplate.EN) || mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) && (mod.position1equals(position) || mod.position2equals(position))) {
                    return false;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) continue;
            }
            if (mod.isSubstitutable()) continue;
            if (mod.position1equals(position)) {
                return false;
            }
            if (!mod.position2equals(position)) continue;
            return false;
        }
        for (Substitution subst : ms.getSubstitutions()) {
            if (subst.hasPosition2()) {
                if (subst.position1equals(position) && subst.position2equals(position)) {
                    return false;
                }
                if (linktype.equals((Object)LinkageType.H_LOSE)) {
                    if (subst.getLinkagetype1().equals((Object)LinkageType.H_LOSE) && subst.position1equals(position)) {
                        return false;
                    }
                    if (!subst.getLinkagetype2().equals((Object)LinkageType.H_LOSE) || !subst.position2equals(position)) continue;
                    return false;
                }
                if (!subst.getLinkagetype1().equals((Object)LinkageType.H_LOSE) && subst.position1equals(position)) {
                    return false;
                }
                if (subst.getLinkagetype2().equals((Object)LinkageType.H_LOSE) || !subst.position2equals(position)) continue;
                return false;
            }
            if ((!linktype.equals((Object)LinkageType.H_LOSE) ? subst.getLinkagetype1().equals((Object)LinkageType.H_LOSE) : !subst.getLinkagetype1().equals((Object)LinkageType.H_LOSE)) || !subst.position1equals(position)) continue;
            return false;
        }
        return true;
    }

    public static boolean impliesOpenChain(Monosaccharide ms) {
        if (ms.getRingtype().equals((Object)Ringtype.OPEN)) {
            if (ms.isAlditol()) {
                return true;
            }
            if (ms.isAldaric() && !ms.hasCoreModification(CoreModificationTemplate.KETO)) {
                return true;
            }
            if (ms.isAldonic() && !ms.hasCoreModification(CoreModificationTemplate.KETO)) {
                return true;
            }
        }
        return false;
    }
}

