/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Periodic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AtomTemplate {
    BB_C("BB_C", Periodic.C, "C${pos}", null, "backbone carbon"),
    BB_O("BB_O", Periodic.O, "O${pos}", null, "backbone oxygen"),
    BB_OR("BB_OR", Periodic.O, "O${pos}", null, "backbone ring oxygen"),
    BB_H("BB_H", Periodic.H, "H${pos}", "H", "backbone hydrogen (single), carbon-linked"),
    BB_HO("BB_HO", Periodic.H, "HO${pos}", "H", "backbone hydroxyl hydrogen"),
    BB_HX("BB_HX", Periodic.H, "H${pos}${abc}", "H", "backbone hydrogen (multiple H at one C), carbon-linked"),
    BB_HR("BB_HR", Periodic.H, "H${pos}r", "H", "backbone hydrogen, pro-R-configuration"),
    BB_HS("BB_HS", Periodic.H, "H${pos}s", "H", "backbone hydrogen, pro-S-configuration"),
    COOH_C_OH("COOH_C", Periodic.C, "C${pos}", null, "carboxyl carbon with protonated oxygen"),
    COOH_C_OX("COOH_C", Periodic.C, "C${pos}", null, "carboxyl carbon with deprotonated oxygen"),
    COOH_O("COOH_O", Periodic.O, "O${pos}", null, "carboxyl oxygen, double bonded"),
    COOH_OH("COOH_OH", Periodic.O, "OH${pos}", null, "carboxyl oxygen, protonated"),
    COOH_OX("COOH_OX", Periodic.O, "O${pos}${abc}", null, "carboxyl oxygen of a deprotonated carboxyl group"),
    COOH_H("COOH_H", Periodic.H, "HO${pos}", "H", "carboxyl hydrogen"),
    SUBST_X("SUBST_X", null, "", null, "substituent atom");

    private String tmplName = null;
    private Periodic element = null;
    private String nameTemplate = null;
    private String mol2Type = null;
    private String description = null;

    private AtomTemplate(String name, Periodic element, String nameTmpl, String mol2type, String desc) {
        this.setTmplName(name);
        this.setElement(element);
        this.setNameTemplate(nameTmpl);
        this.setMol2Type(mol2type);
        this.setDescription(desc);
    }

    public String getTmplName() {
        return this.tmplName;
    }

    private void setTmplName(String tmplName) {
        this.tmplName = tmplName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Periodic getElement() {
        return this.element;
    }

    private void setElement(Periodic element) {
        this.element = element;
    }

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    public void setNameTemplate(String nameTemplate) {
        this.nameTemplate = nameTemplate;
    }

    public String getMol2Type() {
        return this.mol2Type;
    }

    public void setMol2Type(String mol2Type) {
        this.mol2Type = mol2Type;
    }

    public String formatAtomName() throws ResourcesDbException {
        String nameStr = this.getNameTemplate();
        if (nameStr == null) {
            return "";
        }
        if (nameStr.indexOf("$") >= 0) {
            throw new ResourcesDbException("required parameter for atom name missing in " + nameStr);
        }
        return nameStr;
    }

    public String formatAtomName(int pos) throws ResourcesDbException {
        String nameStr = this.getNameTemplate();
        if (nameStr == null) {
            return "";
        }
        while (nameStr.indexOf("${pos}") >= 0) {
            int index = nameStr.indexOf("${pos}");
            nameStr = nameStr.substring(0, index) + Integer.toString(pos) + nameStr.substring(index + 6);
        }
        if (nameStr.indexOf("$") >= 0) {
            throw new ResourcesDbException("required parameter for atom name missing in " + nameStr);
        }
        return nameStr;
    }

    public String formatAtomName(int pos, int charIndex) throws ResourcesDbException {
        String nameStr = this.getNameTemplate();
        if (nameStr == null) {
            return "";
        }
        while (nameStr.indexOf("${pos}") >= 0) {
            int index = nameStr.indexOf("${pos}");
            nameStr = nameStr.substring(0, index) + Integer.toString(pos) + nameStr.substring(index + 6);
        }
        String abcStr = String.valueOf((char)(97 + charIndex));
        while (nameStr.indexOf("${abc}") >= 0) {
            int index = nameStr.indexOf("${abc}");
            nameStr = nameStr.substring(0, index) + abcStr + nameStr.substring(index + 6);
        }
        if (nameStr.indexOf("$") >= 0) {
            throw new ResourcesDbException("required parameter for atom name missing in " + nameStr);
        }
        return nameStr;
    }

    public static AtomTemplate forName(String name) {
        for (AtomTemplate atmpl : AtomTemplate.values()) {
            if (!atmpl.getTmplName().equalsIgnoreCase(name)) continue;
            return atmpl;
        }
        return null;
    }
}

