/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.addcollaborator.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;

public class SelectCollaborator
extends WizardPage {
    private static String title = "Add Collaborator(s)";
    private CheckboxTableViewer checkboxTableViewer;
    private Button addNewButton;
    public Button selectFromButton;

    public SelectCollaborator() {
        super(title);
        this.setTitle(title);
        this.setMessage("Add new Collaborator or Select from existing Collaborators");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginBottom = 8;
        layout.verticalSpacing = 15;
        layout.horizontalSpacing = 10;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.createButtonsPart(container);
        this.createTablePart(container);
        this.setControl((Control)container);
    }

    private void createButtonsPart(Composite container) {
        this.addNewButton = new Button(container, 16);
        this.addNewButton.setText("Add New Collaborator");
        this.addNewButton.setLayoutData((Object)new GridData(1));
        this.selectFromButton = new Button(container, 16);
        this.selectFromButton.setText("Select Collaborator(s) from Table");
        this.selectFromButton.setLayoutData((Object)new GridData(1));
        this.addNewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectCollaborator.this.checkboxTableViewer.setEditable(SelectCollaborator.this.selectFromButton.getSelection());
                SelectCollaborator.this.setPageComplete(true);
                SelectCollaborator.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectCollaborator.this.setPageComplete(true);
            }
        });
        this.selectFromButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectCollaborator.this.checkboxTableViewer.setEditable(SelectCollaborator.this.selectFromButton.getSelection());
                SelectCollaborator.this.setPageComplete(false);
                SelectCollaborator.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTablePart(Composite container) {
        Table collaboratorsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 100;
        tableLayouData.heightHint = 300;
        collaboratorsTable.setLayoutData((Object)tableLayouData);
        this.checkboxTableViewer = new CheckboxTableViewer(collaboratorsTable, "Select");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Collaborators");
        tableColumn2.getColumn().setWidth(500);
        this.checkboxTableViewer.getTable().setHeaderVisible(true);
        this.checkboxTableViewer.getTable().setLinesVisible(true);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (columnIndex > 0 && element instanceof ProjectCollaborator) {
                    ProjectCollaborator collaborator = (ProjectCollaborator)element;
                    value = String.valueOf(collaborator.getName()) + " (";
                    value = String.valueOf(value) + (collaborator.getFundingAgency() == null || collaborator.getFundingAgency().isEmpty() ? " -- " : collaborator.getFundingAgency());
                    value = String.valueOf(value) + " ";
                    value = String.valueOf(value) + (collaborator.getGrantNumber() == null || collaborator.getGrantNumber().isEmpty() ? " -- " : collaborator.getGrantNumber());
                    value = String.valueOf(value) + ")";
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectCollaborator projectCollaborator = (ProjectCollaborator)event.getElement();
                boolean checked = event.getChecked();
                if (!SelectCollaborator.this.selectFromButton.getSelection()) {
                    SelectCollaborator.this.selectFromButton.setSelection(true);
                    SelectCollaborator.this.addNewButton.setSelection(false);
                }
                SelectCollaborator.this.checkboxTableViewer.setChecked(projectCollaborator, checked);
                projectCollaborator.setAddByDefault(checked);
                SelectCollaborator.this.getContainer().updateButtons();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ProjectCollaborator) {
                    return ((ProjectCollaborator)element).isAddByDefault();
                }
                return false;
            }
        });
        ArrayList<ProjectCollaborator> collaborators = new ArrayList<ProjectCollaborator>();
        MultiChoicePreference collaboratorPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.COLLABORATOR);
        for (ProjectCollaborator defaultCollaborator : collaboratorPreference.getSelectedValues()) {
            collaborators.add(defaultCollaborator.getACopy());
        }
        for (ProjectCollaborator otherCollaborator : collaboratorPreference.getOtherValues()) {
            collaborators.add(otherCollaborator.getACopy());
        }
        this.checkboxTableViewer.setComparator(new TableViewerComparator());
        tableColumn2.getColumn().addSelectionListener((SelectionListener)new TableColumnComparatorListener(this.checkboxTableViewer));
        this.checkboxTableViewer.setInput(collaborators);
        this.checkboxTableViewer.refresh();
        this.selectFromButton.setEnabled(!collaborators.isEmpty());
        this.addNewButton.setSelection(true);
        this.addNewButton.notifyListeners(2, new Event());
    }

    public List<ProjectCollaborator> getSelectedCollaborators() {
        ArrayList<ProjectCollaborator> selectedCollaborators = new ArrayList<ProjectCollaborator>();
        Object[] objectArray = this.checkboxTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object collaborator = objectArray[n2];
            selectedCollaborators.add((ProjectCollaborator)collaborator);
            ++n2;
        }
        return selectedCollaborators;
    }
}

