/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.addcollaborator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;
import org.grits.toolbox.core.wizard.addcollaborator.CollaboratorEditListener;

public class ProjectCollaboratorUI {
    private static Logger logger = Logger.getLogger(ProjectCollaboratorUI.class);
    private ProjectCollaborator collaborator = null;
    private Text nameText = null;
    private Text groupPIText = null;
    private ComboViewer positionCombo = null;
    private Text departmentText = null;
    private Text institutionText = null;
    private Text addressText = null;
    private Text countryText = null;
    private Text emailText = null;
    private Text phoneText = null;
    private Text faxText = null;
    private ComboViewer fundingCombo = null;
    private Text grantText = null;
    private NamespaceHandler handler = null;
    private PatriciaTrie<String> trie = null;
    private PatriciaTrieContentProposalProvider contentProposalProvider = null;
    private ContentProposalAdapter contentProposalAdapter = null;
    private CollaboratorEditListener collaboratorEditListener = null;
    private Composite composite;
    private String errorMessage;
    protected ControlDecoration nameErrorDecoration = null;
    private String[] positions;
    private String[] fundings;

    public ProjectCollaboratorUI(CollaboratorEditListener collaboratorEditListener) {
        this.collaboratorEditListener = collaboratorEditListener;
        ArrayList<String> sortedPositions = new ArrayList<String>(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.POSITION).getAllValues());
        Collections.sort(sortedPositions);
        this.positions = this.getArrayFromList(sortedPositions);
        ArrayList<String> sortedFundingAgencies = new ArrayList<String>(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.FUNDING).getAllValues());
        Collections.sort(sortedFundingAgencies);
        this.fundings = this.getArrayFromList(sortedFundingAgencies);
    }

    private String[] getArrayFromList(List<String> listOfValue) {
        String[] arrayOfValue = new String[listOfValue.size()];
        int i = 0;
        Iterator<String> iterator = listOfValue.iterator();
        while (iterator.hasNext()) {
            String value;
            arrayOfValue[i] = value = iterator.next();
            ++i;
        }
        return arrayOfValue;
    }

    public ProjectCollaborator getCollaborator() {
        return this.collaborator;
    }

    public void setCollaborator(ProjectCollaborator collaborator) {
        int n;
        int n2;
        String[] stringArray;
        int selectionIndex;
        int i;
        String fundingSelection;
        this.clearAll();
        this.collaborator = collaborator;
        this.nameText.setText(collaborator.getName());
        if (collaborator.getGroupOrPIName() != null) {
            this.groupPIText.setText(collaborator.getGroupOrPIName());
        }
        if (collaborator.getDepartment() != null) {
            this.departmentText.setText(collaborator.getDepartment());
        }
        if (collaborator.getInstitution() != null) {
            this.institutionText.setText(collaborator.getInstitution());
        }
        if (collaborator.getAddress() != null) {
            this.addressText.setText(collaborator.getAddress());
        }
        if (collaborator.getCountry() != null) {
            this.countryText.setText(collaborator.getCountry());
        }
        if (collaborator.getEmail() != null) {
            this.emailText.setText(collaborator.getEmail());
        }
        if (collaborator.getPhone() != null) {
            this.phoneText.setText(collaborator.getPhone());
        }
        if (collaborator.getFax() != null) {
            this.faxText.setText(collaborator.getFax());
        }
        if (collaborator.getGrantNumber() != null) {
            this.grantText.setText(collaborator.getGrantNumber());
        }
        String positionSelection = collaborator.getPosition() != null && !collaborator.getPosition().isEmpty() ? collaborator.getPosition() : null;
        String string = fundingSelection = collaborator.getFundingAgency() != null && !collaborator.getFundingAgency().isEmpty() ? collaborator.getFundingAgency() : null;
        if (this.positions.length > 0 && positionSelection != null) {
            i = 0;
            selectionIndex = -1;
            stringArray = this.positions;
            n2 = this.positions.length;
            n = 0;
            while (n < n2) {
                String position = stringArray[n];
                if (positionSelection != null && position.equals(positionSelection)) {
                    selectionIndex = i;
                }
                ++i;
                ++n;
            }
            this.positionCombo.setInput((Object)this.positions);
            if (selectionIndex >= 0) {
                this.positionCombo.getCombo().select(selectionIndex);
            }
            this.positionCombo.setSelection(this.positionCombo.getSelection());
        }
        if (this.fundings.length > 0 && fundingSelection != null) {
            i = 0;
            selectionIndex = -1;
            stringArray = this.fundings;
            n2 = this.fundings.length;
            n = 0;
            while (n < n2) {
                String fundingAgency = stringArray[n];
                if (fundingSelection != null && fundingAgency.equals(fundingSelection)) {
                    selectionIndex = i;
                }
                ++i;
                ++n;
            }
            this.fundingCombo.setInput((Object)this.fundings);
            if (selectionIndex >= 0) {
                this.fundingCombo.getCombo().select(selectionIndex);
            }
            this.fundingCombo.setSelection(this.fundingCombo.getSelection());
        }
        this.nameText.selectAll();
        this.nameText.setFocus();
    }

    public void clearAll() {
        this.collaborator = null;
        this.nameText.setText("");
        this.groupPIText.setText("");
        this.departmentText.setText("");
        this.institutionText.setText("");
        this.addressText.setText("");
        this.countryText.setText("");
        this.emailText.setText("");
        this.phoneText.setText("");
        this.faxText.setText("");
        this.grantText.setText("");
        this.positionCombo.getCombo().deselectAll();
        this.fundingCombo.getCombo().deselectAll();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayout((Layout)new GridLayout());
        GridData scrolledCompositeData = new GridData(1808);
        scrolledCompositeData.horizontalSpan = 1;
        scrolledCompositeData.verticalSpan = 1;
        scrolledComposite.setLayoutData((Object)scrolledCompositeData);
        scrolledComposite.setMinSize(400, 580);
        this.composite = new Composite((Composite)scrolledComposite, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 10;
        layout.marginLeft = 10;
        layout.marginTop = 20;
        layout.marginBottom = 20;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.composite.setLayout((Layout)layout);
        scrolledComposite.setContent((Control)this.composite);
        this.nameText = this.createTextLine(this.composite, "Name*");
        this.nameErrorDecoration = new ControlDecoration((Control)this.nameText, 16384);
        this.nameErrorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.nameErrorDecoration.hide();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectCollaboratorUI.this.nameErrorDecoration.hide();
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String name = ((Text)e.getSource()).getText().trim();
                    String invalidMessage = ProjectCollaboratorUI.this.validate(name);
                    if (invalidMessage == null) {
                        ProjectCollaboratorUI.this.collaborator.setName(name);
                    } else {
                        ProjectCollaboratorUI.this.nameErrorDecoration.show();
                    }
                    ProjectCollaboratorUI.this.nameErrorDecoration.setDescriptionText(invalidMessage);
                    ProjectCollaboratorUI.this.errorMessage = invalidMessage;
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.groupPIText = this.createTextLine(this.composite, "Group/P.I.");
        this.groupPIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String groupPI = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setGroupOrPIName(groupPI);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.positionCombo = this.createComboLine(this.composite, "Position");
        this.positionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.positionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex = ProjectCollaboratorUI.this.positionCombo.getCombo().getSelectionIndex();
                if (selectionIndex >= 0 && ProjectCollaboratorUI.this.collaborator != null) {
                    String position = ProjectCollaboratorUI.this.positionCombo.getCombo().getItem(selectionIndex);
                    ProjectCollaboratorUI.this.collaborator.setPosition(position);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.departmentText = this.createTextLine(this.composite, "Department");
        this.departmentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String department = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setDepartment(department);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.institutionText = this.createTextLine(this.composite, "Institution");
        this.institutionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String institution = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setInstitution(institution);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.addressText = this.createTextLine(this.composite, "Address", 514);
        ((GridData)this.addressText.getLayoutData()).heightHint = 50;
        this.addressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String address = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setAddress(address);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.countryText = this.createTextLine(this.composite, "Country");
        this.countryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String country = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setCountry(country);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        try {
            this.handler = new NamespaceHandler("country", "preference", "countries.txt");
            this.trie = this.handler.getTrieForNamespace();
            this.contentProposalProvider = new PatriciaTrieContentProposalProvider(this.trie);
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.countryText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.contentProposalProvider, null, null);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
        this.countryText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    if (ProjectCollaboratorUI.this.collaborator != null && ProjectCollaboratorUI.this.contentProposalAdapter != null && ProjectCollaboratorUI.this.contentProposalAdapter.isProposalPopupOpen()) {
                        ProjectCollaboratorUI.this.countryText.setText("");
                    }
                    e.detail = 0;
                }
            }
        });
        this.emailText = this.createTextLine(this.composite, "Email");
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String email = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setEmail(email);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.phoneText = this.createTextLine(this.composite, "Phone");
        this.phoneText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String phone = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setPhone(phone);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.faxText = this.createTextLine(this.composite, "Fax");
        this.faxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String fax = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setFax(fax);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.fundingCombo = this.createComboLine(this.composite, "Funding");
        this.fundingCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fundingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex;
                if (ProjectCollaboratorUI.this.collaborator != null && (selectionIndex = ProjectCollaboratorUI.this.fundingCombo.getCombo().getSelectionIndex()) >= 0) {
                    String funding = ProjectCollaboratorUI.this.fundingCombo.getCombo().getItem(selectionIndex);
                    ProjectCollaboratorUI.this.collaborator.setFundingAgency(funding);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        this.grantText = this.createTextLine(this.composite, "Grant No.");
        this.grantText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectCollaboratorUI.this.collaborator != null) {
                    String grantNumber = ((Text)e.getSource()).getText().trim();
                    ProjectCollaboratorUI.this.collaborator.setGrantNumber(grantNumber);
                    ProjectCollaboratorUI.this.collaboratorEditListener.valueEdited();
                }
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.horizontalSpan = 1;
        compositeLayoutData.verticalSpan = 1;
        this.composite.setLayoutData((Object)compositeLayoutData);
    }

    protected String validate(String value) {
        return value.isEmpty() ? "Value is empty" : null;
    }

    private Text createTextLine(Composite composite, String label) {
        return this.createTextLine(composite, label, 0);
    }

    private Text createTextLine(Composite composite, String label, int style) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(34);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        Text text = new Text(composite, 0x800 | style);
        GridData newcollaboratorData = new GridData(768);
        newcollaboratorData.grabExcessHorizontalSpace = true;
        newcollaboratorData.horizontalSpan = 1;
        newcollaboratorData.verticalSpan = 1;
        text.setLayoutData((Object)newcollaboratorData);
        return text;
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newcollaboratorData = new GridData(768);
        newcollaboratorData.grabExcessHorizontalSpace = true;
        newcollaboratorData.horizontalSpan = 1;
        newcollaboratorData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newcollaboratorData);
        return comboViewer;
    }

    public void setFocus() {
        this.nameText.setFocus();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

