/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContext;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.ProjectTemplateStore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateStoreCore;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final Set<String> VALID_TYPE_BODY_TEMPLATES = new HashSet<String>();
    public static final String CODEGEN_KEYWORD_THIS = "org.eclipse.jdt.ui.keywordthis";
    public static final String CODEGEN_IS_FOR_GETTERS = "org.eclipse.jdt.ui.gettersetter.use.is";
    public static final String CODEGEN_EXCEPTION_VAR_NAME = "org.eclipse.jdt.ui.exception.name";
    public static final String CODEGEN_ADD_COMMENTS = "org.eclipse.jdt.ui.javadoc";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES;

    static {
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.jdt.ui.text.codetemplates.classbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.jdt.ui.text.codetemplates.interfacebody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.jdt.ui.text.codetemplates.enumbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.jdt.ui.text.codetemplates.annotationbody");
        KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is", "to"};
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "org.eclipse.jdt.ui.text.codetemplates.constructorbody" : "org.eclipse.jdt.ui.text.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, ASTNode locationInAST, String lineDelimiter) throws CoreException {
        String enclosingType = "";
        String enclosingMethod = "";
        if (locationInAST != null) {
            ASTNode parentType;
            MethodDeclaration parentMethod = ASTResolving.findParentMethodDeclaration(locationInAST);
            if (parentMethod != null) {
                enclosingMethod = parentMethod.getName().getIdentifier();
                locationInAST = parentMethod;
            }
            if ((parentType = ASTResolving.findParentType(locationInAST)) instanceof AbstractTypeDeclaration) {
                enclosingType = ((AbstractTypeDeclaration)parentType).getName().getIdentifier();
            }
        }
        return StubUtility.getCatchBodyContent(cu, exceptionType, variableName, enclosingType, enclosingMethod, lineDelimiter);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String enclosingType, String enclosingMethod, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.catchblock", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setVariable("enclosing_type", enclosingType);
        context.setVariable("enclosing_method", enclosingMethod);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        return StubUtility.getCompilationUnitContent(cu, packDecl, fileComment, typeComment, typeContent, lineDelimiter);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String packDecl, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.newtype", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)cu.getElementName()));
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileComment(ICompilationUnit cu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(ICompilationUnit cu, String typeQualifiedName, String[] typeParameterNames, String lineDelim) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, EMPTY, null, typeParameterNames, false, lineDelim);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
            --i;
        }
        return document.get();
    }

    public static String[] getParameterTypeNamesForSeeTag(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            ITypeBinding curr = typeBindings[i];
            curr = curr.getErasure();
            result[i] = curr.getQualifiedName();
            ++i;
        }
        return result;
    }

    private static String[] getParameterTypeNamesForSeeTag(IMethod overridden) {
        try {
            ASTParser parser = ASTParser.newParser((int)11);
            parser.setProject(overridden.getJavaProject());
            IBinding[] bindings = parser.createBindings(new IJavaElement[]{overridden}, null);
            if (bindings.length == 1 && bindings[0] instanceof IMethodBinding) {
                return StubUtility.getParameterTypeNamesForSeeTag((IMethodBinding)bindings[0]);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        String[] paramTypes = overridden.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeNames[i] = Signature.toString((String)Signature.getTypeErasure((String)paramTypes[i]));
            ++i;
        }
        return paramTypeNames;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuilder buf = new StringBuilder();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String[] getTypeParameterNames(ITypeParameter[] typeParameters) {
        String[] typeParametersNames = new String[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            typeParametersNames[i] = typeParameters[i].getElementName();
            ++i;
        }
        return typeParametersNames;
    }

    public static String getTypeBody(String templateID, ICompilationUnit cu, String typeName, String lineDelim) throws CoreException {
        if (!VALID_TYPE_BODY_TEMPLATES.contains(templateID)) {
            throw new IllegalArgumentException("Invalid code template ID: " + templateID);
        }
        Template template = StubUtility.getCodeTemplate(templateID, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", typeName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String[] typeParameterNames, IMethod target, boolean delegate, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
        if (retTypeSig == null) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
        } else if (target != null) {
            templateName = delegate ? "org.eclipse.jdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString((String)retTypeSig));
        }
        if (target != null) {
            String targetTypeName = target.getDeclaringType().getFullyQualifiedName('.');
            String[] targetParamTypeNames = StubUtility.getParameterTypeNamesForSeeTag(target);
            if (delegate) {
                context.setVariable("see_to_target", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            } else {
                context.setVariable("see_to_overridden", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            }
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString((String)excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString((String)retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, typeParameterNames, false, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
            --i2;
        }
        return document.get();
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(line)) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    public static String getFieldComment(ICompilationUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, MethodDeclaration decl, boolean isDeprecated, String targetName, String targetMethodDeclaringTypeName, String[] targetMethodParameterTypeNames, boolean delegate, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        boolean needsTarget = targetMethodDeclaringTypeName != null && targetMethodParameterTypeNames != null;
        String templateName = "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
        if (decl.isConstructor()) {
            templateName = "org.eclipse.jdt.ui.text.codetemplates.constructorcomment";
        } else if (needsTarget) {
            templateName = delegate ? "org.eclipse.jdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.jdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", decl.getName().getIdentifier());
        if (!decl.isConstructor()) {
            context.setVariable("return_type", ASTNodes.asString(StubUtility.getReturnType(decl)));
        }
        if (needsTarget) {
            if (delegate) {
                context.setVariable("see_to_target", StubUtility.getSeeTag(targetMethodDeclaringTypeName, targetName, targetMethodParameterTypeNames));
            } else {
                context.setVariable("see_to_overridden", StubUtility.getSeeTag(targetMethodDeclaringTypeName, targetName, targetMethodParameterTypeNames));
            }
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        List typeParams = StubUtility.shouldGenerateMethodTypeParameterTags(cu.getJavaProject()) ? decl.typeParameters() : Collections.emptyList();
        String[] typeParamNames = new String[typeParams.size()];
        int i = 0;
        while (i < typeParamNames.length) {
            TypeParameter elem = (TypeParameter)typeParams.get(i);
            typeParamNames[i] = elem.getName().getIdentifier();
            ++i;
        }
        List params = decl.parameters();
        String[] paramNames = new String[params.size()];
        int i2 = 0;
        while (i2 < paramNames.length) {
            SingleVariableDeclaration elem = (SingleVariableDeclaration)params.get(i2);
            paramNames[i2] = elem.getName().getIdentifier();
            ++i2;
        }
        String[] exceptionNames = StubUtility.getExceptionNames(decl);
        String returnType = null;
        if (!decl.isConstructor()) {
            returnType = ASTNodes.asString(StubUtility.getReturnType(decl));
        }
        int[] tagOffsets = position.getOffsets();
        int i3 = tagOffsets.length - 1;
        while (i3 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i3], position.getLength(), paramNames, exceptionNames, returnType, typeParamNames, isDeprecated, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
            }
            --i3;
        }
        return textBuffer.get();
    }

    @Deprecated
    private static String[] getExceptionNames(MethodDeclaration decl) {
        String[] exceptionNames;
        if (decl.getAST().apiLevel() >= 8) {
            List exceptions = decl.thrownExceptionTypes();
            exceptionNames = new String[exceptions.size()];
            int i = 0;
            while (i < exceptionNames.length) {
                exceptionNames[i] = ASTNodes.getTypeName((Type)exceptions.get(i));
                ++i;
            }
        } else {
            List exceptions = decl.thrownExceptions();
            exceptionNames = new String[exceptions.size()];
            int i = 0;
            while (i < exceptionNames.length) {
                exceptionNames[i] = ASTNodes.getSimpleNameIdentifier((Name)exceptions.get(i));
                ++i;
            }
        }
        return exceptionNames;
    }

    public static boolean shouldGenerateMethodTypeParameterTags(IJavaProject project) {
        return "enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters", true));
    }

    @Deprecated
    private static ASTNode getReturnType(MethodDeclaration decl) {
        return decl.getAST().apiLevel() == 2 ? decl.getReturnType() : decl.getReturnType2();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, String[] typeParameterNames, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < typeParameterNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param <").append(typeParameterNames[i]).append('>');
            ++i;
        }
        i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && StubUtility.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getLineDelimiterUsed(IJavaProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IJavaProject javaProject) {
        String lineDelimiter;
        IProject project = null;
        if (javaProject != null) {
            project = javaProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IJavaElement elem) {
        IJavaProject project;
        IOpenable openable = elem.getOpenable();
        if (openable instanceof ITypeRoot) {
            try {
                return openable.findRecommendedLineSeparator();
            }
            catch (JavaModelException javaModelException) {}
        }
        return StubUtility.getProjectLineDelimiter((IJavaProject)((project = elem.getJavaProject()).exists() ? project : null));
    }

    public static int getIndentUsed(IJavaElement elem) throws JavaModelException {
        IBuffer buf;
        IOpenable openable = elem.getOpenable();
        if (openable instanceof ITypeRoot && (buf = openable.getBuffer()) != null) {
            int offset = ((ISourceReference)elem).getSourceRange().getOffset();
            return StubUtility.getIndentUsed(buf, offset, elem.getJavaProject());
        }
        return 0;
    }

    public static int getIndentUsed(IBuffer buffer, int offset, IJavaProject project) {
        int i = offset;
        while (i > 0 && !IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i - 1))) {
            --i;
        }
        return Strings.computeIndentUnits(buffer.getText(i, offset - i), project);
    }

    public static IJavaElement findNextSibling(IJavaElement member) throws JavaModelException {
        IJavaElement parent = member.getParent();
        if (parent instanceof IParent) {
            IJavaElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    private static String removeTypeArguments(String baseName) {
        int idx = baseName.indexOf(60);
        if (idx != -1) {
            return baseName.substring(0, idx);
        }
        return baseName;
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaProject project, ITypeBinding expectedType, Expression assignedExpression, Collection<String> excluded) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (assignedExpression != null) {
            String nameFromParent;
            String nameFromExpression = StubUtility.getBaseNameFromExpression(project, assignedExpression, variableKind);
            if (nameFromExpression != null) {
                StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromExpression, 0, excluded, false), res);
            }
            if ((nameFromParent = StubUtility.getBaseNameFromLocationInParent(assignedExpression)) != null) {
                StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromParent, 0, excluded, false), res);
            }
        }
        if (expectedType != null && (expectedType = Bindings.normalizeTypeBinding(expectedType)) != null) {
            String typeName;
            int dim = 0;
            if (expectedType.isArray()) {
                dim = expectedType.getDimensions();
                expectedType = expectedType.getElementType();
            }
            if (expectedType.isParameterizedType()) {
                expectedType = expectedType.getTypeDeclaration();
            }
            if ((typeName = expectedType.getName()).length() > 0) {
                StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, typeName, dim, excluded, false), res);
            }
        }
        if (res.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(variableKind, excluded);
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaProject project, Type expectedType, Expression assignedExpression, Collection<String> excluded) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (assignedExpression != null) {
            String nameFromParent;
            String nameFromExpression = StubUtility.getBaseNameFromExpression(project, assignedExpression, variableKind);
            if (nameFromExpression != null) {
                StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromExpression, 0, excluded, false), res);
            }
            if ((nameFromParent = StubUtility.getBaseNameFromLocationInParent(assignedExpression)) != null) {
                StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromParent, 0, excluded, false), res);
            }
        }
        if (expectedType != null) {
            String[] names = StubUtility.getVariableNameSuggestions(variableKind, project, expectedType, excluded, false);
            int i = 0;
            while (i < names.length) {
                res.add(names[i]);
                ++i;
            }
        }
        if (res.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(variableKind, excluded);
        }
        return res.toArray(new String[res.size()]);
    }

    private static String[] getVariableNameSuggestions(int variableKind, IJavaProject project, Type expectedType, Collection<String> excluded, boolean evaluateDefault) {
        String typeName;
        int dim = 0;
        if (expectedType.isArrayType()) {
            ArrayType arrayType = (ArrayType)expectedType;
            dim = arrayType.getDimensions();
            expectedType = arrayType.getElementType();
        }
        if (expectedType.isParameterizedType()) {
            expectedType = ((ParameterizedType)expectedType).getType();
        }
        if ((typeName = ASTNodes.getTypeName(expectedType)).length() > 0) {
            return StubUtility.getVariableNameSuggestions(variableKind, project, typeName, dim, excluded, evaluateDefault);
        }
        return EMPTY;
    }

    private static String[] getDefaultVariableNameSuggestions(int variableKind, Collection<String> excluded) {
        String prop;
        String name = prop = variableKind == 3 ? "X" : "x";
        int i = 1;
        while (excluded.contains(name)) {
            name = String.valueOf(prop) + i++;
        }
        return new String[]{name};
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaProject project, String baseName, int dimensions, Collection<String> excluded, boolean evaluateDefault) {
        return NamingConventions.suggestVariableNames((int)variableKind, (int)2, (String)StubUtility.removeTypeArguments(baseName), (IJavaProject)project, (int)dimensions, (String[])StubUtility.getExcludedArray(excluded), (boolean)evaluateDefault);
    }

    private static String[] getExcludedArray(Collection<String> excluded) {
        if (excluded == null) {
            return null;
        }
        if (excluded instanceof ExcludedCollection) {
            return ((ExcludedCollection)excluded).getExcludedArray();
        }
        return excluded.toArray(new String[excluded.size()]);
    }

    private static void add(String[] names, Set<String> result) {
        int i = 0;
        while (i < names.length) {
            result.add(names[i]);
            ++i;
        }
    }

    private static String getBaseNameFromExpression(IJavaProject project, Expression assignedExpression, int variableKind) {
        String name = null;
        if (assignedExpression instanceof CastExpression) {
            assignedExpression = ((CastExpression)assignedExpression).getExpression();
        }
        if (assignedExpression instanceof Name) {
            Name simpleNode = (Name)assignedExpression;
            IBinding binding = simpleNode.resolveBinding();
            if (binding instanceof IVariableBinding) {
                return StubUtility.getBaseName((IVariableBinding)binding, project);
            }
            return ASTNodes.getSimpleNameIdentifier(simpleNode);
        }
        if (assignedExpression instanceof MethodInvocation) {
            name = ((MethodInvocation)assignedExpression).getName().getIdentifier();
        } else if (assignedExpression instanceof SuperMethodInvocation) {
            name = ((SuperMethodInvocation)assignedExpression).getName().getIdentifier();
        } else {
            if (assignedExpression instanceof FieldAccess) {
                return ((FieldAccess)assignedExpression).getName().getIdentifier();
            }
            if (variableKind == 3 && (assignedExpression instanceof StringLiteral || assignedExpression instanceof NumberLiteral)) {
                String string = assignedExpression instanceof StringLiteral ? ((StringLiteral)assignedExpression).getLiteralValue() : ((NumberLiteral)assignedExpression).getToken();
                StringBuilder res = new StringBuilder();
                boolean needsUnderscore = false;
                int i = 0;
                while (i < string.length()) {
                    char ch = string.charAt(i);
                    if (Character.isJavaIdentifierPart(ch)) {
                        if (res.length() == 0 && !Character.isJavaIdentifierStart(ch) || needsUnderscore) {
                            res.append('_');
                        }
                        res.append(ch);
                        needsUnderscore = false;
                    } else {
                        needsUnderscore = res.length() > 0;
                    }
                    ++i;
                }
                if (res.length() > 0) {
                    return res.toString();
                }
            }
        }
        if (name != null) {
            int i = 0;
            while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
                String curr = KNOWN_METHOD_NAME_PREFIXES[i];
                if (name.startsWith(curr)) {
                    if (name.equals(curr)) {
                        return null;
                    }
                    if (Character.isUpperCase(name.charAt(curr.length()))) {
                        return name.substring(curr.length());
                    }
                }
                ++i;
            }
        }
        return name;
    }

    private static String getBaseNameFromLocationInParent(Expression assignedExpression, List<Expression> arguments, IMethodBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding[] parameterTypes = binding.getParameterTypes();
        if (parameterTypes.length != arguments.size()) {
            return null;
        }
        int index = arguments.indexOf(assignedExpression);
        if (index == -1) {
            return null;
        }
        ITypeBinding expressionBinding = assignedExpression.resolveTypeBinding();
        if (expressionBinding != null && !expressionBinding.isAssignmentCompatible(parameterTypes[index])) {
            return null;
        }
        try {
            String[] parameterNames;
            IMethod method;
            IJavaElement javaElement = binding.getJavaElement();
            if (javaElement instanceof IMethod && (method = (IMethod)javaElement).getOpenable().getBuffer() != null && index < (parameterNames = method.getParameterNames()).length) {
                return NamingConventions.getBaseName((int)4, (String)parameterNames[index], (IJavaProject)method.getJavaProject());
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private static String getBaseNameFromLocationInParent(Expression assignedExpression) {
        StructuralPropertyDescriptor location = assignedExpression.getLocationInParent();
        if (location == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation parent = (MethodInvocation)assignedExpression.getParent();
            return StubUtility.getBaseNameFromLocationInParent(assignedExpression, parent.arguments(), parent.resolveMethodBinding());
        }
        if (location == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation parent = (ClassInstanceCreation)assignedExpression.getParent();
            return StubUtility.getBaseNameFromLocationInParent(assignedExpression, parent.arguments(), parent.resolveConstructorBinding());
        }
        if (location == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation parent = (SuperMethodInvocation)assignedExpression.getParent();
            return StubUtility.getBaseNameFromLocationInParent(assignedExpression, parent.arguments(), parent.resolveMethodBinding());
        }
        if (location == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation parent = (ConstructorInvocation)assignedExpression.getParent();
            return StubUtility.getBaseNameFromLocationInParent(assignedExpression, parent.arguments(), parent.resolveConstructorBinding());
        }
        if (location == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation parent = (SuperConstructorInvocation)assignedExpression.getParent();
            return StubUtility.getBaseNameFromLocationInParent(assignedExpression, parent.arguments(), parent.resolveConstructorBinding());
        }
        return null;
    }

    public static String[] getArgumentNameSuggestions(IType type, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, type.getJavaProject(), type.getElementName(), 0, new ExcludedCollection(excluded), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaProject project, Type type, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, project, type, new ExcludedCollection(excluded), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaProject project, ITypeBinding binding, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, project, binding, null, (Collection<String>)new ExcludedCollection(excluded));
    }

    public static String[] getArgumentNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    public static String[] getFieldNameSuggestions(IType type, int fieldModifiers, String[] excluded) {
        return StubUtility.getFieldNameSuggestions(type.getJavaProject(), type.getElementName(), 0, fieldModifiers, excluded);
    }

    public static String[] getFieldNameSuggestions(IJavaProject project, String baseName, int dimensions, int modifiers, String[] excluded) {
        if (Flags.isFinal((int)modifiers) && Flags.isStatic((int)modifiers)) {
            return StubUtility.getVariableNameSuggestions(3, project, baseName, dimensions, new ExcludedCollection(excluded), true);
        }
        if (Flags.isStatic((int)modifiers)) {
            return StubUtility.getVariableNameSuggestions(1, project, baseName, dimensions, new ExcludedCollection(excluded), true);
        }
        return StubUtility.getVariableNameSuggestions(2, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    public static String[] getLocalNameSuggestions(IJavaProject project, String baseName, int dimensions, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(5, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    public static String suggestArgumentName(IJavaProject project, String baseName, String[] excluded) {
        return StubUtility.suggestVariableName(4, project, baseName, 0, excluded);
    }

    private static String suggestVariableName(int varKind, IJavaProject project, String baseName, int dimension, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(varKind, project, baseName, dimension, new ExcludedCollection(excluded), true)[0];
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaProject project, String[] paramNames) {
        String[][] newNames = new String[paramNames.length][];
        ArrayList<String> takenNames = new ArrayList<String>();
        int i = 0;
        while (i < paramNames.length) {
            String curr = paramNames[i];
            String baseName = NamingConventions.getBaseName((int)4, (String)curr, (IJavaProject)project);
            String[] proposedNames = StubUtility.getVariableNameSuggestions(4, project, curr, 0, takenNames, true);
            if (!curr.equals(baseName)) {
                LinkedHashSet<String> updatedNames = new LinkedHashSet<String>();
                updatedNames.add(curr);
                int k = 0;
                while (k < proposedNames.length) {
                    updatedNames.add(proposedNames[k]);
                    ++k;
                }
                proposedNames = updatedNames.toArray(new String[updatedNames.size()]);
            }
            newNames[i] = proposedNames;
            takenNames.add(proposedNames[0]);
            ++i;
        }
        return newNames;
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaProject project, IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                String[] parameterNames;
                IMethod method = (IMethod)binding.getMethodDeclaration().getJavaElement();
                if (method != null && (parameterNames = method.getParameterNames()).length == nParams) {
                    return StubUtility.suggestArgumentNamesWithProposals(project, parameterNames);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        String[][] names = new String[nParams][];
        int i = 0;
        while (i < names.length) {
            names[i] = new String[]{"arg" + i};
            ++i;
        }
        return names;
    }

    public static String[] suggestArgumentNames(IJavaProject project, IMethodBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                String[] paramNames;
                IMethod method = (IMethod)binding.getMethodDeclaration().getJavaElement();
                if (method != null && (paramNames = method.getParameterNames()).length == nParams) {
                    String[] namesArray = EMPTY;
                    ArrayList<String> newNames = new ArrayList<String>(paramNames.length);
                    int i = 0;
                    while (i < paramNames.length) {
                        String curr = paramNames[i];
                        String baseName = NamingConventions.getBaseName((int)4, (String)curr, (IJavaProject)method.getJavaProject());
                        if (!curr.equals(baseName)) {
                            newNames.add(curr);
                        } else {
                            newNames.add(StubUtility.suggestArgumentName(project, curr, namesArray));
                        }
                        namesArray = newNames.toArray(new String[newNames.size()]);
                        ++i;
                    }
                    return namesArray;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        String[] names = new String[nParams];
        int i = 0;
        while (i < names.length) {
            names[i] = "arg" + i;
            ++i;
        }
        return names;
    }

    public static String getBaseName(IField field) throws JavaModelException {
        return NamingConventions.getBaseName((int)StubUtility.getFieldKind(field.getFlags()), (String)field.getElementName(), (IJavaProject)field.getJavaProject());
    }

    public static String getBaseName(IVariableBinding binding, IJavaProject project) {
        return NamingConventions.getBaseName((int)StubUtility.getKind(binding), (String)binding.getName(), (IJavaProject)project);
    }

    private static int getKind(IVariableBinding binding) {
        if (binding.isField()) {
            return StubUtility.getFieldKind(binding.getModifiers());
        }
        if (binding.isParameter()) {
            return 4;
        }
        return 5;
    }

    private static int getFieldKind(int modifiers) {
        if (!Modifier.isStatic(modifiers)) {
            return 2;
        }
        if (!Modifier.isFinal(modifiers)) {
            return 1;
        }
        return 3;
    }

    public static boolean hasFieldName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", true);
        String staticPrefixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes", true);
        String staticSuffixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name) || StubUtility.hasPrefixOrSuffix(staticPrefixes, staticSuffixes, name);
    }

    public static boolean hasParameterName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasLocalVariableName(IJavaProject project, String name) {
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.localPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasConstantName(IJavaProject project, String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            return true;
        }
        String prefixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFinalFieldPrefixes", true);
        String suffixes = project.getOption("org.eclipse.jdt.core.codeComplete.staticFinalFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    private static boolean hasPrefixOrSuffix(String prefixes, String suffixes, String name) {
        String curr;
        StringTokenizer tok = new StringTokenizer(prefixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.startsWith(curr)) continue;
            return true;
        }
        tok = new StringTokenizer(suffixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.endsWith(curr)) continue;
            return true;
        }
        return false;
    }

    public static boolean useThisForFieldAccess(IJavaProject project) {
        return Boolean.valueOf(JavaManipulation.getPreference(CODEGEN_KEYWORD_THIS, project));
    }

    public static boolean useIsForBooleanGetters(IJavaProject project) {
        return Boolean.valueOf(JavaManipulation.getPreference(CODEGEN_IS_FOR_GETTERS, project));
    }

    public static String getExceptionVariableName(IJavaProject project) {
        return JavaManipulation.getPreference(CODEGEN_EXCEPTION_VAR_NAME, project);
    }

    public static boolean doAddComments(IJavaProject project) {
        return Boolean.valueOf(JavaManipulation.getPreference(CODEGEN_ADD_COMMENTS, project));
    }

    public static void setCodeTemplate(String templateId, String pattern, IJavaProject project) {
        TemplateStoreCore codeTemplateStore = JavaManipulation.getCodeTemplateStore();
        TemplatePersistenceData data = codeTemplateStore.getTemplateData(templateId);
        Template orig = data.getTemplate();
        Template copy = new Template(orig.getName(), orig.getDescription(), orig.getContextTypeId(), pattern, true);
        data.setTemplate(copy);
    }

    public static Template getCodeTemplate(String id, IJavaProject project) {
        if (project == null) {
            return JavaManipulation.getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            JavaManipulationPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    public static ImportRewrite createImportRewrite(ICompilationUnit cu, boolean restoreExistingImports) throws JavaModelException {
        return CodeStyleConfiguration.createImportRewrite(cu, restoreExistingImports);
    }

    public static ImportRewrite createImportRewrite(CompilationUnit astRoot, boolean restoreExistingImports) {
        ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite(astRoot, restoreExistingImports);
        if (astRoot.getAST().hasResolvedBindings()) {
            rewrite.setUseContextToFilterImplicitImports(true);
        }
        return rewrite;
    }

    private static class ExcludedCollection
    extends AbstractList<String> {
        private String[] fExcluded;

        public ExcludedCollection(String[] excluded) {
            this.fExcluded = excluded;
        }

        public String[] getExcludedArray() {
            return this.fExcluded;
        }

        @Override
        public int size() {
            return this.fExcluded.length;
        }

        @Override
        public String get(int index) {
            return this.fExcluded[index];
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof String) {
                int i = 0;
                while (i < this.fExcluded.length) {
                    if (o.equals(this.fExcluded[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }
}

