/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.tablecore;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.ss.formula.functions.T;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnCategories.ChooseColumnsFromCategoriesCommandHandler;
import org.eclipse.nebula.widgets.nattable.columnCategories.ColumnCategoriesModel;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.stack.ColumnGroupBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.resize.action.ColumnResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEventMatcher;
import org.eclipse.nebula.widgets.nattable.resize.mode.ColumnResizeDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.grits.toolbox.display.control.table.command.GRITSTableDisplayColumnChooserCommand;
import org.grits.toolbox.display.control.table.command.GRITSTableDisplayColumnChooserCommandHandler;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataProvider;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.datamodel.GRITSSortModel;
import org.grits.toolbox.display.control.table.datamodel.GRITSTableDataObject;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.DoubleFormat;
import org.grits.toolbox.display.control.table.tablecore.GRITSColumnHeaderDataProvider;
import org.grits.toolbox.display.control.table.tablecore.GRITSHeaderMenuConfiguration;
import org.grits.toolbox.display.control.table.tablecore.GRITSNatTableStyleConfiguration;
import org.grits.toolbox.display.control.table.tablecore.GRITSSingleClickConfiguration;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.display.control.table.tablecore.UpdatePreferencesFromColumnChooser;

public class GRITSTable
extends NatTable
implements MouseListener,
IGritsTable {
    private static final Color HIGLIGHT_LIGHT = GUIHelper.getColor((RGB)new RGB(255, 242, 228));
    private static final Color HIGHTLIGHT_COLOR = GUIHelper.getColor((RGB)new RGB(255, 204, 153));
    public static final String FILTEREDSELECTED = "filteredAndSelected";
    public static final String FILTEREDNOTSELECTED = "filteredNotSelected";
    public static final String NOMATCHLABEL = "No Match";
    public static final String FILTEREDSELECTEDLABEL = "Match";
    public static final String FILTEREDNOTSELECTEDLABEL = "Hidden Match";
    public static final String NOTFILTERED = "notfiltered";
    private static final Logger logger = Logger.getLogger(GRITSTable.class);
    protected DataLayer dataLayer = null;
    protected DataLayer columnHeaderDataLayer = null;
    protected SortedList sortedList = null;
    protected ColumnHideShowLayer columnHideShowLayer = null;
    protected RowHideShowLayer rowHideShowLayer = null;
    protected SelectionLayer selectionLayer = null;
    protected ConfigRegistry configRegistry = null;
    protected ViewportLayer viewportLayer = null;
    protected DefaultRowHeaderDataProvider rowHeaderDataProvider = null;
    protected RowHeaderLayer rowHeaderLayer = null;
    protected ColumnHeaderLayer columnHeaderLayer = null;
    protected ColumnGroupModel columnGroupModel = null;
    protected ColumnGroupHeaderLayer columnGroupHeaderLayer = null;
    protected GridLayer gridLayer = null;
    protected CornerLayer cornerLayer = null;
    protected EventList eventList = null;
    protected SortHeaderLayer sortHeaderLayer = null;
    protected ISortModel sortModel = null;
    protected static final String CUSTOM_COMPARATOR_LABEL = "customComparatorLabel";
    protected static final String NO_SORT_LABEL = "noSortLabel";
    protected GRITSColumnHeaderDataProvider columnHeaderDataProvider = null;
    protected GRITSListDataProvider bodyDataProvider = null;
    protected GRITSTableDataObject simDataObject = null;
    protected TableDataProcessor tableDataProcessor = null;
    private boolean bTableNeedsResize = true;
    protected HashMap<Integer, Integer> natToSourceIndexMap = null;
    protected HashMap<Integer, Integer> sourceToNatIndexMap = null;
    protected HashMap<Integer, Integer> sourceIdToSourceIndexMap = null;
    private int iPrevMaxWidth = -1;
    protected int iLastMouseDownRow = -1;
    public static UpdatePreferencesFromColumnChooser updatePreferencesFromColumnChooser = new UpdatePreferencesFromColumnChooser();
    protected boolean bResetColumnPreferences = false;
    protected DefaultRowHeaderDataLayer rowHeaderDataLayer;

    public GRITSTable(Composite parent, TableDataProcessor tableDataExtractor) {
        super(parent, false);
        this.tableDataProcessor = tableDataExtractor;
    }

    public void initCommonTableComponents() {
        this.initEventList();
        this.initSortedList();
        this.initDataProvider();
        this.initColumnHeaderDataLayer();
        this.initConfigRegistry();
        this.initSortComparator();
        this.initColumnHideShowLayer();
        this.initRowHideShowLayer();
        this.initSelectionLayer();
        this.initViewportLayer();
        this.initRowHeaderLayer();
        this.initColumnHeaderLayer();
        this.initColumnGroupHeaderLayer();
        this.setColumnGroupIndices();
        this.initViewPreferences();
        this.initSortHeaderLayer();
        this.initCornerLayer();
        this.initGridLayer();
        this.initCellAccumulator();
    }

    @Override
    public TableDataProcessor getTableDataProcessor() {
        return this.tableDataProcessor;
    }

    public void loadData() throws Exception {
        if (this.tableDataProcessor == null) {
            throw new Exception("Null XML Data Extractor. Cannot create table!");
        }
    }

    public void createMainTable() throws Exception {
        this.initCommonTableComponents();
        this.initColumnChooserLayer();
        this.finishNatTable();
        this.initialSort();
    }

    protected void initialSort() {
    }

    @Override
    public GRITSTableDataObject getGRITSTableDataObject() {
        return this.simDataObject;
    }

    public void setSimDataObject(GRITSTableDataObject simDataObject) {
        this.simDataObject = simDataObject;
    }

    public boolean getResetColumnPreferences() {
        return this.bResetColumnPreferences;
    }

    public int getNatIndexFromSourceIndex(int _iSourcePos) {
        if (this.sourceToNatIndexMap.containsKey(_iSourcePos)) {
            return this.sourceToNatIndexMap.get(_iSourcePos);
        }
        return -1;
    }

    public int getSourceIndexFromNatIndex(int _iNatIndex) {
        if (this.natToSourceIndexMap.containsKey(_iNatIndex)) {
            return this.natToSourceIndexMap.get(_iNatIndex);
        }
        return -1;
    }

    public int getSourceIndexFromRowId(int _iRowId) {
        if (this.sourceIdToSourceIndexMap.containsKey(_iRowId)) {
            return this.sourceIdToSourceIndexMap.get(_iRowId);
        }
        return -1;
    }

    public void initEventList() {
        this.eventList = new BasicEventList();
        this.natToSourceIndexMap = new HashMap();
        this.sourceToNatIndexMap = new HashMap();
        this.sourceIdToSourceIndexMap = new HashMap();
        this.showAllRows();
    }

    protected void showAllRows() {
        this.eventList.clear();
        this.natToSourceIndexMap.clear();
        boolean bAddRowIds = this.sourceIdToSourceIndexMap.isEmpty();
        int i = 0;
        while (i < this.getGRITSTableDataObject().getTableData().size()) {
            GRITSListDataRow row = this.getGRITSTableDataObject().getTableData().get(i);
            this.eventList.add(row.clone());
            this.natToSourceIndexMap.put(i, i);
            this.sourceToNatIndexMap.put(i, i);
            if (bAddRowIds) {
                this.sourceIdToSourceIndexMap.put(row.getId(), i);
            }
            ++i;
        }
    }

    protected void hideRows(List<Integer> lHiddenRows) {
        this.eventList.clear();
        this.natToSourceIndexMap.clear();
        this.sourceToNatIndexMap.clear();
        int j = 0;
        int i = 0;
        while (i < this.getGRITSTableDataObject().getTableData().size()) {
            if (!lHiddenRows.contains(i)) {
                GRITSListDataRow row = this.getGRITSTableDataObject().getTableData().get(i);
                this.eventList.add(row.clone());
                this.natToSourceIndexMap.put(j, i);
                this.sourceToNatIndexMap.put(i, j);
                ++j;
            }
            ++i;
        }
    }

    protected boolean isEmpty() {
        return this.eventList.isEmpty();
    }

    public void initSortedList() {
        this.sortedList = new SortedList(this.eventList, null);
    }

    public void initDataProvider() {
        this.bodyDataProvider = new GRITSListDataProvider((List<GRITSListDataRow>)this.sortedList);
        this.dataLayer = new DataLayer((IDataProvider)this.bodyDataProvider);
    }

    public void initColumnHeaderDataLayer() {
        this.columnHeaderDataProvider = new GRITSColumnHeaderDataProvider(this.getGRITSTableDataObject().getLastHeader());
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.columnHeaderDataProvider);
    }

    protected void initConfigRegistry() {
        this.configRegistry = new ConfigRegistry();
    }

    protected void initSortComparator() {
        this.configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new DefaultComparator());
        this.sortModel = new GRITSSortModel((SortedList<T>)this.sortedList, (IConfigRegistry)this.configRegistry, this);
    }

    public ISortModel getSortModel() {
        return this.sortModel;
    }

    public void initColumnHideShowLayer() {
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.dataLayer);
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
    }

    public RowHideShowLayer getRowHideShowLayer() {
        return this.rowHideShowLayer;
    }

    public void initRowHideShowLayer() {
        this.rowHideShowLayer = new RowHideShowLayer((IUniqueIndexLayer)this.columnHideShowLayer);
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public void initSelectionLayer() {
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.rowHideShowLayer);
    }

    public void initViewportLayer() {
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
    }

    public ViewportLayer getViewportLayer() {
        return this.viewportLayer;
    }

    public GridLayer getGridLayer() {
        return this.gridLayer;
    }

    protected void initRowHeaderLayer() {
        this.rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)this.bodyDataProvider);
        this.rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)this.rowHeaderDataProvider);
        this.rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)this.rowHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
    }

    protected ICellPainter getHeaderCellPainter() {
        return new BeveledBorderDecorator((ICellPainter)new TextPainter(true, true, true));
    }

    public void initColumnHeaderLayer() {
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
        this.columnHeaderLayer.addConfiguration((IConfiguration)new DefaultColumnHeaderLayerConfiguration(){

            protected void addColumnHeaderStyleConfig() {
                this.addConfiguration((IConfiguration)new DefaultColumnHeaderStyleConfiguration(){
                    {
                        this.cellPainter = GRITSTable.this.getHeaderCellPainter();
                    }
                });
            }
        });
    }

    protected void initColumnGroupHeaderLayer() {
        this.columnGroupModel = new ColumnGroupModel();
        ColumnGroupBodyLayerStack bodyLayer = new ColumnGroupBodyLayerStack((IUniqueIndexLayer)this.dataLayer, new ColumnGroupModel[]{this.columnGroupModel});
        this.columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)this.columnHeaderLayer, bodyLayer.getSelectionLayer(), this.columnGroupModel);
    }

    @Override
    public ColumnHeaderLayer getColumnHeaderLayer() {
        return this.columnHeaderLayer;
    }

    @Override
    public ColumnGroupModel getColumnGroupModel() {
        return this.columnGroupModel;
    }

    public ColumnGroupHeaderLayer getColumnGroupHeaderLayer() {
        return this.columnGroupHeaderLayer;
    }

    @Override
    public boolean hasColumnGroupHeader() {
        return this.getGRITSTableDataObject().getTableHeader().size() > 1;
    }

    public int getColumnIndexForKey(String _sKey) {
        List<GRITSColumnHeader> alRow = this.getGRITSTableDataObject().getLastHeader();
        int i = 0;
        while (i < alRow.size()) {
            GRITSColumnHeader header = alRow.get(i);
            if (header.getKeyValue().equals(_sKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnIndexForKeyByContains(String _sKey) {
        List<GRITSColumnHeader> alRow = this.getGRITSTableDataObject().getLastHeader();
        int i = 0;
        while (i < alRow.size()) {
            GRITSColumnHeader header = alRow.get(i);
            if (header.getKeyValue().contains(_sKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setColumnGroupIndices() {
        if (this.getGRITSTableDataObject().getTableHeader().size() <= 1) {
            return;
        }
        String sLastExp = null;
        ArrayList<Integer> alGroupIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.getGRITSTableDataObject().getTableHeader().get(0).size()) {
            GRITSColumnHeader oVal = this.getGRITSTableDataObject().getTableHeader().get(0).get(i);
            if (oVal != null || sLastExp != null) {
                boolean bChanged;
                boolean bl = bChanged = oVal != null && (sLastExp == null || !((Object)oVal).toString().equals(sLastExp));
                if (bChanged) {
                    sLastExp = ((Object)oVal).toString();
                    alGroupIndices.add(i);
                }
                this.columnGroupHeaderLayer.addColumnsIndexesToGroup(sLastExp, new int[]{i});
            }
            ++i;
        }
        i = 0;
        while (i < alGroupIndices.size()) {
            this.columnGroupHeaderLayer.setGroupUnbreakable(((Integer)alGroupIndices.get(i)).intValue());
            ++i;
        }
    }

    protected void initViewPreferences() {
        this.bResetColumnPreferences = false;
        try {
            boolean bRes = this.updateViewFromPreferenceSettings();
            if (!bRes) {
                this.bResetColumnPreferences = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            this.bResetColumnPreferences = true;
        }
    }

    protected void initSortHeaderLayer() {
        this.sortHeaderLayer = new SortHeaderLayer((ILayer)this.columnGroupHeaderLayer, this.sortModel, false);
    }

    protected void initCornerLayer() {
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        this.cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)this.rowHeaderLayer, (ILayer)this.sortHeaderLayer);
    }

    protected void initGridLayer() {
        this.gridLayer = new GridLayer((ILayer)this.viewportLayer, (ILayer)this.sortHeaderLayer, (ILayer)this.rowHeaderLayer, (ILayer)this.cornerLayer);
    }

    public void initCellAccumulator() {
    }

    protected void initColumnChooserLayer() {
        GRITSTableDisplayColumnChooserCommandHandler columnChooserCommandHandler = new GRITSTableDisplayColumnChooserCommandHandler(this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    protected void configureColumnCategoriesInChooser() {
        ColumnCategoriesModel model = new ColumnCategoriesModel();
        this.columnHeaderDataLayer.registerCommandHandler((ILayerCommandHandler)new ChooseColumnsFromCategoriesCommandHandler(this.columnHideShowLayer, this.columnHeaderLayer, this.dataLayer, model));
    }

    protected void finishNatTable() {
        this.setLayer((ILayer)this.gridLayer);
        this.setConfigRegistry((IConfigRegistry)this.configRegistry);
        this.addConfigurations();
        this.addMouseListener(this);
        this.configure();
    }

    protected void addConfigurations() {
        this.addConfiguration((IConfiguration)this.getGRITSNatTableStyleConfiguration());
        if (this.addHeaderListeners()) {
            this.addConfiguration((IConfiguration)this.getNewHeaderMenuConfiguration());
        }
        this.addConfiguration((IConfiguration)this.getBodyMenuConfiguration());
        this.addConfiguration((IConfiguration)new GRITSSingleClickConfiguration(this.getGRITSTableDataObject().getTableHeader().size() > 1));
        this.addConfiguration((IConfiguration)this.getUIBindingConfiguration());
    }

    protected AbstractUiBindingConfiguration getUIBindingConfiguration() {
        return new AbstractUiBindingConfiguration(){

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerMouseMoveBinding((IMouseEventMatcher)new MouseEventMatcher(), (IMouseAction)new ClearCursorAction());
                uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 0), (IMouseAction)new ColumnResizeCursorAction());
                uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new ColumnResizeEventMatcher(0, "CORNER", 1), (IDragMode)new ColumnResizeDragMode());
            }
        };
    }

    protected GRITSNatTableStyleConfiguration getGRITSNatTableStyleConfiguration() {
        return new GRITSNatTableStyleConfiguration();
    }

    protected GRITSHeaderMenuConfiguration getNewHeaderMenuConfiguration() {
        return new GRITSHeaderMenuConfiguration(this);
    }

    protected GRITSHeaderMenuConfiguration getBodyMenuConfiguration() {
        return new GRITSHeaderMenuConfiguration(this);
    }

    protected boolean addHeaderListeners() {
        return true;
    }

    protected void hackResizeLastRowsAndCols() {
        int iColCnt = this.selectionLayer.getColumnCount();
        int iWidth = this.viewportLayer.getWidth();
        int iMaxWidth = this.viewportLayer.getClientAreaWidth();
        int iColWidthAdd = 0;
        iColWidthAdd = (int)((double)(iMaxWidth - iWidth) / (double)(iColCnt - 1));
        if (iMaxWidth > iWidth && iMaxWidth > this.iPrevMaxWidth) {
            int i = 1;
            while (i < iColCnt - 1) {
                this.viewportLayer.moveColumnPositionIntoViewport(i);
                int colPosition = LayerUtil.convertColumnPosition((ILayer)this.selectionLayer, (int)i, (IUniqueIndexLayer)this.viewportLayer);
                if (colPosition >= 0) {
                    int iNewWidth = this.viewportLayer.getColumnWidthByPosition(i);
                    if (i < iColCnt - 1) {
                        iNewWidth += iColWidthAdd;
                    }
                    ColumnResizeCommand colResizeCommand = new ColumnResizeCommand((ILayer)this.selectionLayer, colPosition, iNewWidth);
                    this.doCommand((ILayerCommand)colResizeCommand);
                }
                ++i;
            }
        }
        this.iPrevMaxWidth = iMaxWidth;
        iColWidthAdd = 0;
    }

    @Override
    public void performAutoResize() {
        InitializeAutoResizeRowsCommand rowCommand1 = new InitializeAutoResizeRowsCommand((ILayer)this, 2, this.getConfigRegistry(), new GCFactory((Drawable)this));
        this.doCommand((ILayerCommand)rowCommand1);
        boolean bGo = true;
        int iLastRowCnt = this.viewportLayer.getRowCount();
        while (bGo) {
            int i = 0;
            while (i < iLastRowCnt) {
                InitializeAutoResizeRowsCommand rowCommand = new InitializeAutoResizeRowsCommand((ILayer)this, i, this.getConfigRegistry(), new GCFactory((Drawable)this));
                this.doCommand((ILayerCommand)rowCommand);
                ++i;
            }
            int iRowCnt = this.viewportLayer.getRowCount();
            if (iRowCnt != iLastRowCnt) {
                iLastRowCnt = iRowCnt;
                continue;
            }
            bGo = false;
        }
        this.hackResizeLastRowsAndCols();
        this.viewportLayer.moveCellPositionIntoViewport(0, 0);
    }

    protected boolean tableNeedsResize() {
        return this.bTableNeedsResize;
    }

    protected void setTableNeedsResize(boolean _bVal) {
        this.bTableNeedsResize = _bVal;
    }

    protected boolean rowNeedsResize(int iRowNum) {
        return iRowNum < 200 || this.getBottomDataLayer().getRowCount() < 500;
    }

    public void reSort() {
        if (this.getSortModel().getSortedColumnIndexes() != null) {
            for (Integer iCol : this.getSortModel().getSortedColumnIndexes()) {
                this.getSortModel().sort(iCol.intValue(), this.getSortModel().getSortDirection(iCol.intValue()), true);
            }
        }
    }

    public void moveRowIntoViewport(int _iRowNumInBottomLayer) {
        this.viewportLayer.moveRowPositionIntoViewport(_iRowNumInBottomLayer);
    }

    public void performAutoResizeAfterPaint() {
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (GRITSTable.this.tableNeedsResize()) {
                    GRITSTable.this.performAutoResize();
                    GRITSTable.this.setTableNeedsResize(false);
                }
                GRITSTable.this.removeListener(9, this);
            }
        });
    }

    public DataLayer getBottomDataLayer() {
        return this.dataLayer;
    }

    @Override
    public ColumnHideShowLayer getColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    @Override
    public DataLayer getColumnHeaderDataLayer() {
        return this.columnHeaderDataLayer;
    }

    protected void registerDoubleStyles(IConfigRegistry configRegistry) {
        this.registerDoubleStyle(configRegistry, DoubleFormat.SCIENTIFIC_NOTATION);
        this.registerDoubleStyle(configRegistry, DoubleFormat.DECIMAL2DIGIT);
        this.registerDoubleStyle(configRegistry, DoubleFormat.DECIMAL4DIGIT);
    }

    protected void registerDoubleStyle(IConfigRegistry configRegistry, final DoubleFormat label) {
        final DecimalFormat dec2 = new DecimalFormat("0.00");
        final DecimalFormat dec4 = new DecimalFormat("0.0000");
        final DecimalFormat scientific = new DecimalFormat("0.0E0");
        DisplayConverter doubleConverter = new DisplayConverter(){

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return "";
                }
                switch (label) {
                    case DECIMAL2DIGIT: {
                        return dec2.format(Double.valueOf(canonicalValue.toString()));
                    }
                    case DECIMAL4DIGIT: {
                        return dec4.format(Double.valueOf(canonicalValue.toString()));
                    }
                    case SCIENTIFIC_NOTATION: {
                        return scientific.format(Double.valueOf(canonicalValue.toString()));
                    }
                }
                return dec2.format(Double.valueOf(canonicalValue.toString()));
            }

            public Object displayToCanonicalValue(Object displayValue) {
                try {
                    switch (label) {
                        case DECIMAL2DIGIT: {
                            return dec2.parse((String)displayValue);
                        }
                        case DECIMAL4DIGIT: {
                            return dec4.parse((String)displayValue);
                        }
                        case SCIENTIFIC_NOTATION: {
                            return scientific.parse((String)displayValue);
                        }
                    }
                    return dec2.parse((String)displayValue);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        };
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)doubleConverter, "NORMAL", label.name());
    }

    protected void registerFilterStyle(IConfigRegistry configRegistry, boolean addHighlight) {
        if (addHighlight) {
            Style filterSelectedStyle = new Style();
            filterSelectedStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)HIGHTLIGHT_COLOR);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)filterSelectedStyle, "NORMAL", FILTEREDSELECTED);
            Style filterNotSelectedStyle = new Style();
            filterNotSelectedStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)HIGLIGHT_LIGHT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)filterNotSelectedStyle, "NORMAL", FILTEREDNOTSELECTED);
        }
        DisplayConverter filterConverter = new DisplayConverter(){

            public Object displayToCanonicalValue(Object displayValue) {
                if (displayValue == null) {
                    return null;
                }
                if (displayValue instanceof String) {
                    if (((String)displayValue).isEmpty()) {
                        return -1;
                    }
                    if (((String)displayValue).equals(GRITSTable.NOMATCHLABEL)) {
                        return 0;
                    }
                    if (((String)displayValue).equals(GRITSTable.FILTEREDNOTSELECTEDLABEL)) {
                        return 1;
                    }
                    if (((String)displayValue).equals(GRITSTable.FILTEREDSELECTEDLABEL)) {
                        return 11;
                    }
                }
                return null;
            }

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return "";
                }
                if (canonicalValue instanceof Integer) {
                    if ((Integer)canonicalValue < 0) {
                        return "";
                    }
                    if (((Integer)canonicalValue).equals(0)) {
                        return GRITSTable.NOMATCHLABEL;
                    }
                    if (((Integer)canonicalValue).equals(1)) {
                        return GRITSTable.FILTEREDNOTSELECTEDLABEL;
                    }
                    if (((Integer)canonicalValue).equals(11)) {
                        return GRITSTable.FILTEREDSELECTEDLABEL;
                    }
                }
                return null;
            }
        };
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)filterConverter, "NORMAL", FILTEREDNOTSELECTEDLABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)filterConverter, "NORMAL", FILTEREDSELECTEDLABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)filterConverter, "NORMAL", NOMATCHLABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)filterConverter, "NORMAL", NOTFILTERED);
    }

    protected void registerSelectedCheckbox(IConfigRegistry configRegistry) {
        IEditableRule rule = new IEditableRule(){

            public boolean isEditable(int arg0, int arg1) {
                return arg0 == arg1;
            }

            public boolean isEditable(ILayerCell arg0, IConfigRegistry arg1) {
                return GRITSTable.this.getBottomDataLayer().getDataValueByPosition(arg0.getColumnIndex(), arg0.getRowIndex()) != null;
            }
        };
        this.registerSelectedCheckbox(configRegistry, rule);
    }

    protected void registerSelectedCheckbox(IConfigRegistry configRegistry, IEditableRule rule) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)rule, "EDIT", TableDataProcessor.selColHeader.getLabel());
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", TableDataProcessor.selColHeader.getLabel());
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", TableDataProcessor.selColHeader.getLabel());
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", TableDataProcessor.selColHeader.getLabel());
    }

    public void configure() {
        super.configure();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void loadViewerSettings(boolean _bForceRebuild) {
        if (this.getGRITSTableDataObject().getTablePreferences().settingsNeedInitialization() || _bForceRebuild) {
            this.getGRITSTableDataObject().getTablePreferences().setPreferenceSettings(this.getPreferenceSettingsFromCurrentView());
            this.getGRITSTableDataObject().getTablePreferences().writePreference();
        }
    }

    public int getLastMouseDownRow() {
        return this.iLastMouseDownRow;
    }

    public void setLastMouseDownRow(int iLastMouseDownRow) {
        this.iLastMouseDownRow = iLastMouseDownRow;
    }

    public TableViewerColumnSettings getPreferenceSettingsFromCurrentView() {
        TableViewerColumnSettings newEntity = new TableViewerColumnSettings();
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return null;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iPos = 0;
        int i = 0;
        while (i < iNumCols) {
            String headerLabel = (String)this.columnHeaderDataLayer.getDataValueByPosition(i, 0);
            GRITSColumnHeader header = new GRITSColumnHeader(headerLabel, this.columnHeaderDataProvider.getDataKey(i, 0));
            newEntity.setVisColInx(header, iPos++);
            ++i;
        }
        return newEntity;
    }

    @Override
    public boolean updateViewFromPreferenceSettings() {
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return false;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iNumNonHidden = 0;
        if (iNumCols == 0) {
            return false;
        }
        this.columnHideShowLayer.showAllColumns();
        ArrayList<Integer> alHiddenCols = new ArrayList<Integer>();
        int iColLayerPos = 0;
        while (iColLayerPos < iNumCols) {
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0);
            int iColShowLayerPos = LayerUtil.convertColumnPosition((ILayer)this.columnHeaderDataLayer, (int)iColLayerPos, (IUniqueIndexLayer)this.columnHideShowLayer);
            if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                int iPrefColPos = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getVisColInx(sHeaderKey);
                logger.debug((Object)("From column header: key: " + sHeaderKey + ", position: " + iColLayerPos + ", pref col: " + iPrefColPos));
                if (iPrefColPos == -1) {
                    alHiddenCols.add(iColShowLayerPos);
                } else {
                    ++iNumNonHidden;
                }
            }
            ++iColLayerPos;
        }
        this.columnHideShowLayer.hideColumnPositions(alHiddenCols);
        GRITSColumnHeader selCell = this.getGRITSTableDataObject().getLastHeader().get(0);
        boolean bAddSelect = ((Object)selCell).equals(TableDataProcessor.selColHeader);
        int iPrefColPos = 0;
        while (iPrefColPos < iNumNonHidden) {
            GRITSColumnHeader prefHeader = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnAtVisColInx(iPrefColPos);
            if (prefHeader != null) {
                int iFromPos = 0;
                while (iFromPos < this.columnHideShowLayer.getColumnCount()) {
                    int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)iFromPos, (IUniqueIndexLayer)this.columnHeaderDataLayer);
                    String sThisHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                    if (prefHeader.getKeyValue().equals(sThisHeaderKey)) {
                        int iToPos = iPrefColPos;
                        logger.debug((Object)("From pref: key: " + prefHeader.getKeyValue() + ", position: " + iPrefColPos));
                        if (bAddSelect) {
                            ++iToPos;
                        }
                        if (iFromPos == iToPos) break;
                        ColumnReorderCommand command = new ColumnReorderCommand((ILayer)this.columnHideShowLayer, iFromPos, iToPos);
                        this.columnHideShowLayer.doCommand((ILayerCommand)command);
                        break;
                    }
                    ++iFromPos;
                }
            }
            ++iPrefColPos;
        }
        return true;
    }

    @Override
    public void updatePreferenceSettingsFromCurrentView() {
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iNewNumCols = 0;
        int iColInx = 0;
        while (iColInx < iNumCols) {
            boolean bHidden = this.columnHideShowLayer.isColumnIndexHidden(iColInx);
            if (!bHidden) {
                ++iNewNumCols;
            }
            ++iColInx;
        }
        int iToPos = 0;
        int iVisPos = 0;
        while (iVisPos < iNewNumCols) {
            int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)iVisPos, (IUniqueIndexLayer)this.columnHeaderDataLayer);
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
            if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                GRITSColumnHeader header = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnHeader(sHeaderKey);
                this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().setVisColInx(header, iToPos++);
            }
            ++iVisPos;
        }
        int iColInx2 = 0;
        while (iColInx2 < iNumCols) {
            boolean bHidden = this.columnHideShowLayer.isColumnIndexHidden(iColInx2);
            if (bHidden) {
                int iColPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColInx2);
                String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                    GRITSColumnHeader header = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnHeader(sHeaderKey);
                    this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().setVisColInx(header, -1);
                }
            }
            ++iColInx2;
        }
    }

    public void showColumnDialog() {
        GRITSTableDisplayColumnChooserCommand command = new GRITSTableDisplayColumnChooserCommand(this);
        this.doCommand((ILayerCommand)command);
    }
}

