/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.representation;

import java.awt.Dimension;
import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.representation.SvgFactory;

public class Fischer
extends SvgFactory {
    private static int defaultWidth = 120;
    private static int defaultHeight = 120;
    private int lineLength = 15;
    private int backboneX = 60;
    private int positionY = 0;
    private static final String OH = "OH";
    private static final String HO = "HO";
    private static final String H = "H";
    private static final String O = "O";
    private static final String CH3 = "CH3";
    private static final String CH2 = "CH2";
    private static final String CH = "CH";
    private static final String CHO = "CHO";
    private static final String COOH = "COOH";
    private static final String CH2OH = "CH2OH";

    public Fischer() {
        this.setSvgWidth(defaultWidth);
        this.setSvgHeight(defaultHeight);
        this.getSVGGraph2D().setSVGCanvasSize(new Dimension(defaultWidth, defaultHeight));
    }

    public Fischer(int width, int height) {
        this.setSvgWidth(width);
        this.setSvgHeight(height);
        this.getSVGGraph2D().setSVGCanvasSize(new Dimension(width, height));
    }

    private void drawVerticalLines(double bo) {
        if (bo == 1.0) {
            this.drawLine(this.backboneX, this.positionY, this.backboneX, this.positionY + this.lineLength);
        } else if (bo == 2.0) {
            this.drawLine(this.backboneX - 2, this.positionY, this.backboneX - 2, this.positionY + this.lineLength);
            this.drawLine(this.backboneX + 2, this.positionY, this.backboneX + 2, this.positionY + this.lineLength);
        } else if (bo == 3.0) {
            this.drawLine(this.backboneX - 3, this.positionY, this.backboneX - 3, this.positionY + this.lineLength);
            this.drawLine(this.backboneX, this.positionY, this.backboneX, this.positionY + this.lineLength);
            this.drawLine(this.backboneX + 3, this.positionY, this.backboneX + 3, this.positionY + this.lineLength);
        }
        this.positionY += this.lineLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawChainPosition(int pos) throws ResourcesDbException {
        Monosaccharide ms = this.getMonosacc();
        double boToPrevious = 1.0;
        String leftLabel = null;
        double leftBo = 1.0;
        String rightLabel = null;
        double rightBo = 1.0;
        String positionLabel = "C";
        int cWidthHalf = this.getStringWidth("C") / 2;
        StereoConfiguration sConf = ms.getStereocode().getPositionConfiguration(pos);
        if (pos == 1) {
            this.positionY = this.getTextSize() + 2;
            boToPrevious = 0.0;
            positionLabel = ms.isAlditol() ? (ms.hasCoreModification(CoreModificationTemplate.DEOXY, 1) ? CH3 : CH2OH) : (ms.isAldaric() || ms.isAldonic() ? COOH : (ms.hasCoreModification(CoreModificationTemplate.KETO) && !ms.hasCoreModification(CoreModificationTemplate.KETO, 1) ? CH2OH : CHO));
            if (ms.getSubstitutionsByPosition(pos).size() > 0) {
                throw new ResourcesDbException("Fischer projection of monosaccharides with terminal substitutions not yet supported.");
            }
            this.drawString(positionLabel, this.backboneX - cWidthHalf, this.positionY);
            this.positionY += 2;
            return;
        } else if (pos < ms.getSize()) {
            int x2;
            int x1;
            for (CoreModification mod : ms.getCoreModificationsByPosition(pos)) {
                if (CoreModificationTemplate.EN.equals((Object)mod.getTemplate()) && mod.getIntValuePosition2() == pos) {
                    boToPrevious = 2.0;
                }
                if (!CoreModificationTemplate.YN.equals((Object)mod.getTemplate()) || mod.getIntValuePosition2() != pos) continue;
                boToPrevious = 3.0;
            }
            Substitution ohLinkedSubst = ms.getSubstitution(null, pos, LinkageType.H_AT_OH);
            if (ohLinkedSubst == null) {
                ohLinkedSubst = ms.getSubstitution(null, pos, LinkageType.DEOXY);
            }
            Substitution cLinkedSubst = ms.getSubstitution(null, pos, LinkageType.H_LOSE);
            if (sConf.equals((Object)StereoConfiguration.Dexter)) {
                if (ohLinkedSubst != null) {
                    rightLabel = ohLinkedSubst.getTemplate().getHaworthName();
                    if (ohLinkedSubst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                        rightLabel = "O-" + rightLabel;
                    }
                    rightBo = ohLinkedSubst.getBondOrder1();
                } else {
                    rightLabel = OH;
                }
                if (cLinkedSubst != null) {
                    leftLabel = cLinkedSubst.getTemplate().getMirroredHaworthName();
                    leftBo = cLinkedSubst.getBondOrder1();
                } else {
                    leftLabel = H;
                }
            } else if (sConf.equals((Object)StereoConfiguration.Laevus)) {
                if (ohLinkedSubst != null) {
                    leftLabel = ohLinkedSubst.getTemplate().getMirroredHaworthName();
                    if (ohLinkedSubst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                        leftLabel = leftLabel + "-O";
                    }
                    leftBo = ohLinkedSubst.getBondOrder1();
                } else {
                    leftLabel = HO;
                }
                if (cLinkedSubst != null) {
                    rightLabel = cLinkedSubst.getTemplate().getHaworthName();
                    rightBo = cLinkedSubst.getBondOrder1();
                } else {
                    rightLabel = H;
                }
            } else {
                Substitution subst;
                if (!sConf.equals((Object)StereoConfiguration.Nonchiral)) throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with StereoConfiguration " + sConf.getFullname());
                if (ms.hasDoubleBond(pos)) {
                    if (!ms.hasDoubleBond(pos - 1) || !ms.hasDoubleBond(pos + 1)) {
                        if (ms.hasCoreModification(CoreModificationTemplate.DEOXY, pos)) {
                            rightLabel = H;
                            rightBo = 1.0;
                        } else {
                            subst = ms.getSubstitution(null, pos, null);
                            if (subst == null) {
                                rightLabel = OH;
                                rightBo = 1.0;
                            } else {
                                rightLabel = subst.getTemplate().getHaworthName();
                                if (subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                                    rightLabel = "O-" + rightLabel;
                                }
                            }
                        }
                    }
                } else if (ms.hasCoreModification(CoreModificationTemplate.DEOXY, pos)) {
                    rightLabel = H;
                    rightBo = 1.0;
                    leftLabel = H;
                    leftBo = 1.0;
                } else if (ms.hasCoreModification(CoreModificationTemplate.KETO, pos)) {
                    rightLabel = O;
                    rightBo = 2.0;
                } else if (ms.hasCoreModification(CoreModificationTemplate.SP2)) {
                    subst = ms.getSubstitution(null, pos, null);
                    rightLabel = subst.getTemplate().getHaworthName();
                    rightBo = 2.0;
                }
            }
            this.drawVerticalLines(boToPrevious);
            this.positionY += this.getTextSize() + 2;
            this.drawString(positionLabel, this.backboneX - cWidthHalf, this.positionY);
            int lineY = this.positionY - this.getTextSize() / 2;
            if (leftLabel != null) {
                x1 = this.backboneX - cWidthHalf - 2;
                x2 = x1 - this.lineLength;
                if (leftBo == 1.0) {
                    this.drawLine(x1, lineY, x2, lineY);
                } else if (leftBo == 2.0) {
                    this.drawLine(x1, lineY - 2, x2, lineY - 2);
                    this.drawLine(x1, lineY + 2, x2, lineY + 2);
                }
                this.drawString(leftLabel, x2 - 2 - this.getStringWidth(leftLabel), this.positionY);
            }
            if (rightLabel != null) {
                x1 = this.backboneX + cWidthHalf + 2;
                x2 = x1 + this.lineLength;
                if (rightBo == 1.0) {
                    this.drawLine(x1, lineY, x2, lineY);
                } else if (rightBo == 2.0) {
                    this.drawLine(x1, lineY - 2, x2, lineY - 2);
                    this.drawLine(x1, lineY + 2, x2, lineY + 2);
                }
                this.drawString(rightLabel, x2 + 2, this.positionY);
            }
            this.positionY += 2;
            return;
        } else {
            this.drawVerticalLines(boToPrevious);
            this.positionY += this.getTextSize() + 2;
            int centerLabelPosition = this.backboneX - cWidthHalf;
            positionLabel = ms.isUronic() || ms.isAldaric() ? COOH : (ms.hasCoreModification(CoreModificationTemplate.DEOXY, pos) ? (boToPrevious == 3.0 ? CH : (boToPrevious == 2.0 ? CH2 : CH3)) : (ms.hasCoreModification(CoreModificationTemplate.KETO, pos) ? CHO : CH2OH));
            ArrayList<Substitution> substList = ms.getSubstitutionsByPosition(pos);
            if (substList.size() > 0) {
                if (substList.size() != 1) throw new ResourcesDbException("Multiple substituents at terminal carbon not yet supported in Fischer projection");
                Substitution subst = substList.get(0);
                if (ms.isUronic() || ms.isAldaric()) {
                    positionLabel = subst.getLinkagetype1().equals((Object)LinkageType.DEOXY) ? "CO" + subst.getTemplate().getHaworthName() : "COO" + subst.getTemplate().getHaworthName();
                } else {
                    if (!subst.getLinkagetype1().equals((Object)LinkageType.DEOXY) && !subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) throw new ResourcesDbException("LinkageType " + subst.getLinkagetypeStr1() + " not yet supported in Fischer projection at terminal position");
                    int hCount = 4 - (int)Math.floor(boToPrevious + subst.getBondOrder1());
                    positionLabel = "C";
                    if (hCount > 0) {
                        positionLabel = positionLabel + H;
                    }
                    if (hCount > 1) {
                        positionLabel = positionLabel + hCount;
                    }
                    if (subst.getLinkagetype1().equals((Object)LinkageType.H_AT_OH)) {
                        positionLabel = positionLabel + O;
                    }
                    positionLabel = positionLabel + subst.getTemplate().getHaworthName();
                }
            }
            this.drawString(positionLabel, centerLabelPosition, this.positionY);
        }
    }

    private void drawRing() throws ResourcesDbException {
        throw new ResourcesDbException("Fischer projection for ring monosaccharide is not yet implemented.");
    }

    private void drawOpenChain() throws ResourcesDbException {
        for (int pos = 1; pos <= this.getMonosacc().getSize(); ++pos) {
            this.drawChainPosition(pos);
        }
        this.checkSize();
    }

    public void drawMonosaccharide(Monosaccharide ms) throws ResourcesDbException {
        if (MonosaccharideValidation.checkFuzziness(ms)) {
            throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with uncertain / fuzzy properties.");
        }
        if (ms.hasCoreModification(CoreModificationTemplate.ANHYDRO)) {
            throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with anhydro modification.");
        }
        if (ms.hasCoreModification(CoreModificationTemplate.LACTONE)) {
            throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with lactono modification.");
        }
        if (ms.hasCoreModification(CoreModificationTemplate.EPOXY)) {
            throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with epoxy modification.");
        }
        this.setMonosacc(ms);
        if (ms.getRingtype().equals((Object)Ringtype.PYRANOSE) || ms.getRingtype().equals((Object)Ringtype.FURANOSE)) {
            this.drawRing();
        } else if (ms.getRingtype().equals((Object)Ringtype.OPEN)) {
            this.drawOpenChain();
        } else {
            throw new ResourcesDbException("Cannot draw Fischer projection for monosaccharide with ring type " + ms.getRingtype().getName());
        }
        this.checkSize();
    }
}

