/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.WURCSFactory;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectConnectingBackboneGroups;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSValidator {
    private List<String> m_lErrors = new ArrayList<String>();
    private List<String> m_lWarnings = new ArrayList<String>();
    private int m_iTheNumberOfErrors = 0;
    private int m_iTheNumberOfWarnings = 0;
    private String m_sOutWURCS;

    public List<String> getErrors() {
        return this.m_lErrors;
    }

    public List<String> getWarnings() {
        return this.m_lWarnings;
    }

    public int getTheNumberOfErrors() {
        return this.m_iTheNumberOfErrors;
    }

    public int getTheNumberOfWarnings() {
        return this.m_iTheNumberOfWarnings;
    }

    public String getStandardWURCS() {
        return this.m_sOutWURCS;
    }

    public void start(String a_strWURCS) {
        try {
            WURCSFactory factory = new WURCSFactory(a_strWURCS);
            WURCSGraph graph = factory.getGraph();
            WURCSVisitorCollectConnectingBackboneGroups t_oGroup = new WURCSVisitorCollectConnectingBackboneGroups();
            t_oGroup.start(graph);
            if (t_oGroup.getBackboneGroups().size() > 1) {
                ++this.m_iTheNumberOfWarnings;
                this.m_lWarnings.add("All residues must be connected.");
            }
            for (Backbone t_bb : graph.getBackbones()) {
                if (t_bb.getSkeletonCode().contains("<Q>")) continue;
                this.validateAnomer(t_bb);
                this.validateStereo(t_bb);
                this.validateBond(t_bb);
                this.validateAvailableCarbonDescriptor(t_bb);
            }
            for (Modification t_mod : graph.getModifications()) {
                for (WURCSEdge wURCSEdge : t_mod.getEdges()) {
                }
                this.validateSubstituents(t_mod);
            }
            if (this.m_iTheNumberOfErrors == 0) {
                WURCSFactory factory2 = new WURCSFactory(graph);
                String wurcs2 = factory2.getWURCS();
                if (wurcs2.compareTo(a_strWURCS) != 0) {
                    System.err.println("[info] output WURCS is not equal to inputted WURCS");
                    WURCSFactory factory3 = new WURCSFactory(wurcs2);
                    WURCSGraph graph3 = factory3.getGraph();
                    WURCSFactory factory_last = new WURCSFactory(graph3);
                    this.m_sOutWURCS = factory_last.getWURCS();
                    if (this.m_sOutWURCS.compareTo(wurcs2) != 0) {
                        ++this.m_iTheNumberOfWarnings;
                        this.m_lWarnings.add("This WURCS is not standardized.");
                    } else {
                        System.err.println("[info] This WURCS become standard in second standardization.");
                    }
                } else {
                    System.err.println("[info] output WURCS is equal to inputted WURCS");
                    this.m_sOutWURCS = wurcs2;
                }
            } else {
                this.m_sOutWURCS = null;
            }
        }
        catch (WURCSFormatException ex) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("WURCSFormatException: " + ex.getMessage());
        }
        catch (WURCSExchangeException exx) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("WURCSExchangeException: " + exx.getMessage());
        }
        catch (WURCSVisitorException exxx) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("WURCSVisitorException: " + exxx.getMessage());
        }
        catch (WURCSException e) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("WURCSEXception: " + e.getMessage());
        }
    }

    private void validateAnomer(Backbone a_bb) {
        boolean t_bUncertainAnomer = false;
        boolean t_bCarbonyl = false;
        boolean t_bRingForm = false;
        int t_iAnomPos = 0;
        int nu = 0;
        int nk = 0;
        int na = 0;
        for (BackboneCarbon backboneCarbon : a_bb.getBackboneCarbons()) {
            char desc = backboneCarbon.getDesctriptor().getChar();
            if (backboneCarbon.getDesctriptor().getChar() == 'u' || backboneCarbon.getDesctriptor().getChar() == 'U') {
                t_bUncertainAnomer = true;
                ++nu;
            }
            if (backboneCarbon.getDesctriptor().getChar() == 'o' || backboneCarbon.getDesctriptor().getChar() == 'O') {
                t_bCarbonyl = true;
                ++nk;
            }
            if (backboneCarbon.getDesctriptor().getChar() != 'a') continue;
            ++na;
            t_iAnomPos = a_bb.getBackboneCarbons().indexOf(backboneCarbon) + 1;
            t_bRingForm = true;
        }
        int nalcohol = 0;
        for (BackboneCarbon t_bcc : a_bb.getBackboneCarbons()) {
            if (t_bcc.getDesctriptor().getChar() == 'c') {
                nalcohol += 2;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'h') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'e') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'z') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'f') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'M') {
                nalcohol += 3;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'N') {
                nalcohol += 2;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '1') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '2') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '3') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '4') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'x') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '5') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '6') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '7') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == '8') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'X') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'C') {
                nalcohol += 2;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'N') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'E') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() == 'Z') {
                ++nalcohol;
                continue;
            }
            if (t_bcc.getDesctriptor().getChar() != 'F') continue;
            ++nalcohol;
        }
        if (nalcohol < 2) {
            ++this.m_iTheNumberOfWarnings;
            this.m_lWarnings.add("carbohydrate must have alcohol (-X in WURCS) at least 2 (" + nalcohol + " in backbone [" + a_bb.getSkeletonCode() + "])");
        }
        if (nu + nk + na > 1) {
            ++this.m_iTheNumberOfWarnings;
            this.m_lWarnings.add("Too many anomeric descriptor in backbone [" + a_bb.getSkeletonCode() + "]");
        } else if (nu + nk + na == 0) {
            ++this.m_iTheNumberOfWarnings;
            this.m_lWarnings.add("no aldehyde or ketone in backbone [" + a_bb.getSkeletonCode() + "]");
            if (a_bb.getAnomericPosition() != 0 || a_bb.getAnomericSymbol() != 'o') {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("Mismatched anomeric description in backbone [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
        } else if (na == 0 && (nk == 1 || nu == 1)) {
            int n;
            if (a_bb.getAnomericPosition() != 0 || a_bb.getAnomericSymbol() != 'o') {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("Mismatched anomeric description in backbone [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
            boolean bl = false;
            for (BackboneCarbon backboneCarbon : a_bb.getBackboneCarbons()) {
                if (backboneCarbon.getDesctriptor().getChar() == 'u') {
                    n = a_bb.getBackboneCarbons().indexOf(backboneCarbon) + 1;
                }
                if (backboneCarbon.getDesctriptor().getChar() == 'U') {
                    n = a_bb.getBackboneCarbons().indexOf(backboneCarbon) + 1;
                }
                if (backboneCarbon.getDesctriptor().getChar() == 'o') {
                    n = a_bb.getBackboneCarbons().indexOf(backboneCarbon) + 1;
                }
                if (backboneCarbon.getDesctriptor().getChar() != 'O') continue;
                n = a_bb.getBackboneCarbons().indexOf(backboneCarbon) + 1;
            }
            boolean anomeric_ring = false;
            for (WURCSEdge edge : a_bb.getEdges()) {
                if (edge.getModification().isGlycosidic() || edge.getModification().isAglycone()) continue;
                for (WURCSEdge edge2 : edge.getModification().getEdges()) {
                    if (n != edge2.getLinkages().getFirst().getBackbonePosition()) continue;
                    anomeric_ring = true;
                }
            }
            if (anomeric_ring) {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("invalid ring information with respect to constructing hemiacetal [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
        } else if (na == 1) {
            char c;
            for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
                char c2 = t_bc.getDesctriptor().getChar();
                if (c2 != 'a') continue;
                t_iAnomPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            }
            if (a_bb.getAnomericPosition() != t_iAnomPos) {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("Anomeric positions between the anomer descriptor 'a' and anomer information are mismatched. [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
            if ((c = a_bb.getAnomericSymbol()) != 'a' && c != 'b' && c != 'u' && c != 'd' && c != 'x') {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("Invalid anomeric symbol. allowable anomeric symbols are 'a', 'b', 'u','d', and 'x'. [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
            boolean anomeric_ring = false;
            for (WURCSEdge edge : a_bb.getEdges()) {
                if (edge.getModification().isGlycosidic() || edge.getModification().isAglycone()) continue;
                for (WURCSEdge edge2 : edge.getModification().getEdges()) {
                    if (a_bb.getAnomericPosition() != edge2.getLinkages().getFirst().getBackbonePosition()) continue;
                    anomeric_ring = true;
                }
            }
            if (!anomeric_ring) {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("No ring with respect to constructing hemiacetal [" + a_bb.getSkeletonCode() + "-'" + a_bb.getAnomericPosition() + a_bb.getAnomericSymbol() + "']");
            }
        }
    }

    private void validateStereo(Backbone a_bb) {
        ArrayList<Integer> t_lH_LOSEPositions = new ArrayList<Integer>();
        boolean t_bHasAbsolute = false;
        boolean t_bHasRelative = false;
        boolean t_bHasUnknown = false;
        int t_iLastStereo = -1;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            if (t_iPos == 1 || t_iPos == a_bb.getBackboneCarbons().size()) continue;
            char t_cd = t_bc.getDesctriptor().getChar();
            if (t_cd == '1' || t_cd == '2') {
                t_bHasAbsolute = true;
            } else if (t_cd == '5' || t_cd == '6') {
                t_bHasAbsolute = true;
                t_lH_LOSEPositions.add(t_iPos);
            } else if (t_cd == '3' || t_cd == '4') {
                t_bHasRelative = true;
            } else if (t_cd == '7' || t_cd == '8') {
                t_bHasRelative = true;
                t_lH_LOSEPositions.add(t_iPos);
            } else if (t_cd == 'x') {
                t_bHasUnknown = true;
            } else {
                if (t_cd != 'X') continue;
                t_bHasUnknown = true;
                t_lH_LOSEPositions.add(t_iPos);
            }
            t_iLastStereo = t_iPos;
        }
        if (!t_lH_LOSEPositions.isEmpty()) {
            Iterator iterator = t_lH_LOSEPositions.iterator();
            while (iterator.hasNext()) {
                int t_pos = (Integer)iterator.next();
                boolean t_bHasSubstituent = false;
                for (WURCSEdge t_edge : a_bb.getEdges()) {
                    LinkagePosition t_link;
                    if (t_edge.getLinkages().size() != 1 || t_pos != (t_link = t_edge.getLinkages().getFirst()).getBackbonePosition()) continue;
                    t_bHasSubstituent = true;
                }
                if (t_bHasSubstituent) continue;
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("The chiral carbon without hydrogen must connect to at least one substituent.");
            }
        }
        t_bHasAbsolute = false;
        t_bHasUnknown = false;
        boolean t_bHasNoStereo = false;
        int t_cdPrev = 32;
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            int t_cd = t_bc.getDesctriptor().getChar();
            if (t_cd == 101 || t_cd == 69 || t_cd == 122 || t_cd == 90) {
                t_bHasAbsolute = true;
            } else if (t_cd == 102 || t_cd == 70) {
                t_bHasUnknown = true;
            } else if (t_cd == 110 || t_cd == 78) {
                t_bHasNoStereo = true;
            } else {
                t_cd = 32;
            }
            if (t_cdPrev != 32 && t_cd != 32) {
                if ((t_cd = Character.toLowerCase((char)t_cd)) != t_cdPrev) {
                    ++this.m_iTheNumberOfErrors;
                    this.m_lErrors.add("Two carbons on a double bond must have the same stereochemistry.");
                }
                t_cd = 32;
            }
            t_cdPrev = Character.toLowerCase((char)t_cd);
        }
        if (t_bHasNoStereo) {
            ++this.m_iTheNumberOfWarnings;
            this.m_lWarnings.add("CarbonDescriptor 'n' and 'N' could not support in GlycoCT.");
        }
    }

    private void validateBond(Backbone a_bb) {
        int ncarbon = a_bb.getBackboneCarbons().size();
        ArrayList<Integer> nbond = new ArrayList<Integer>();
        for (WURCSEdge t_edge : a_bb.getEdges()) {
            if (!t_edge.getModification().isGlycosidic() || t_edge.getLinkages().getFirst().getBackbonePosition() == -1) continue;
            nbond.add(t_edge.getLinkages().getFirst().getBackbonePosition());
        }
        int icount = 0;
        for (int i = 1; i <= ncarbon; ++i) {
            icount = 0;
            Iterator iterator = nbond.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                if (i != j) continue;
                ++icount;
            }
        }
    }

    private void validateAvailableCarbonDescriptor(Backbone a_bb) {
        for (BackboneCarbon t_bc : a_bb.getBackboneCarbons()) {
            char t_cd;
            int t_iPos = a_bb.getBackboneCarbons().indexOf(t_bc) + 1;
            boolean t_bIsTerminal = false;
            if (t_iPos == 1 || t_iPos == a_bb.getBackboneCarbons().size()) {
                t_bIsTerminal = true;
            }
            if ((t_cd = t_bc.getDesctriptor().getChar()) == 'c' || t_cd == 'C' || t_cd == 'M' || t_cd == 't' || t_cd == 'T' || t_cd == 'K') {
                ++this.m_iTheNumberOfWarnings;
                this.m_lWarnings.add("CarbonDescriptor " + t_cd + " could not support in GlycoCT.");
            }
            if (!t_bIsTerminal || t_cd != '1' && t_cd != '2' && t_cd != '3' && t_cd != '4' && t_cd != 'x' && t_cd != '5' && t_cd != '6' && t_cd != '7' && t_cd != '8' && t_cd != 'X') continue;
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("Terminal carbon with stereo can not be handled for now.");
        }
    }

    private void validateSubstituents(Modification a_mod) {
        if (a_mod.canOmitMAP()) {
            return;
        }
        String t_strMAP = a_mod.getMAPCode();
        int t_nStar = t_strMAP.length() - t_strMAP.replace("*", "").length();
        if (t_strMAP.startsWith("*1")) {
            Pattern p = Pattern.compile("\\*[0-9]*");
            Matcher m = p.matcher(t_strMAP);
            ArrayList<Integer> star = new ArrayList<Integer>();
            int star_size = 0;
            while (m.find()) {
                if (m.group().compareTo("*") != 0) {
                    ++star_size;
                    star.add(Integer.parseInt(m.group().substring(1)));
                    continue;
                }
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("modification position in MAP string is invalid. " + t_strMAP);
            }
            int imatch = 0;
            for (WURCSEdge t_edge : a_mod.getEdges()) {
                for (LinkagePosition linkage : t_edge.getLinkages()) {
                    Iterator iterator = star.iterator();
                    while (iterator.hasNext()) {
                        int t_star = (Integer)iterator.next();
                        if (t_star != linkage.getModificationPosition()) continue;
                        ++imatch;
                    }
                }
            }
            if (imatch != star.size()) {
                ++this.m_iTheNumberOfErrors;
                this.m_lErrors.add("The asymmetric crosslinking substituent in MAP, which must have linkages with substituent linkage position.");
            }
        }
        if (t_nStar > 2) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("Substituent with three or more backbone carbons can not be handled.");
        }
        if (t_nStar == 0) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("At least one backbone carbon must be in a substituent.");
        }
        if (t_nStar == 2 && a_mod.getEdges().size() != 2) {
            ++this.m_iTheNumberOfErrors;
            this.m_lErrors.add("The crosslinking substituent must have two linkages.");
        }
    }
}

