/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddEditIonDialog;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GridUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;
import org.grits.toolbox.ms.om.data.MoleculeSettings;

public class AddNeutralLossForm
extends WizardPage {
    private Method method;
    private List<GridItem> adductGridItems = new ArrayList<GridItem>();
    private HashMap<String, Object> adducts = new HashMap();
    private Grid gridAdduct;
    private Button btnDeleteAdduct;
    private Button btnEditAdduct;
    private List<Molecule> allPossibleAdducts;
    private static final String ADD_DIALOG_TITLE = "Add/Edit Neutral Loss/Gain Dialog";

    public AddNeutralLossForm(Method method) {
        super("wizardPage");
        this.setTitle("Neutral Loss/Gain Settings");
        this.setDescription("Add different neutral losses or gains.");
        this.setMethod(method);
    }

    private List<Molecule> getPossibleAdducts() {
        ArrayList<Molecule> adductList = new ArrayList<Molecule>();
        MoleculeSettings water = new MoleculeSettings(GlycanPreDefinedOptions.LOSS_H20);
        water.setMass(Double.valueOf(-1.0 * water.getMass()));
        adductList.add((Molecule)water);
        MoleculeSettings methyl = new MoleculeSettings(GlycanPreDefinedOptions.LOSS_METHYL);
        methyl.setMass(Double.valueOf(-1.0 * methyl.getMass()));
        adductList.add((Molecule)methyl);
        MoleculeSettings sialNeg = new MoleculeSettings(GlycanPreDefinedOptions.LOSS_SIAL_NEG);
        sialNeg.setMass(Double.valueOf(-1.0 * sialNeg.getMass()));
        adductList.add((Molecule)sialNeg);
        MoleculeSettings sialPos = new MoleculeSettings(GlycanPreDefinedOptions.LOSS_SIAL_POS);
        sialPos.setMass(Double.valueOf(-1.0 * sialPos.getMass()));
        adductList.add((Molecule)sialPos);
        return adductList;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.allPossibleAdducts = this.getPossibleAdducts();
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblAdductSettings = new Label(container, 0);
        lblAdductSettings.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblAdductSettings.setText("Neutral Loss/Gain Settings*");
        Button btnAddAdduct = new Button(container, 0);
        btnAddAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridUtils.addButtonPressed(AddNeutralLossForm.ADD_DIALOG_TITLE, AddNeutralLossForm.this.gridAdduct, AddNeutralLossForm.this.adductGridItems, AddNeutralLossForm.this.adducts, AddNeutralLossForm.this.allPossibleAdducts, true, AddEditIonDialog.DialogType.NEUTRAL_LOSSGAIN, AddNeutralLossForm.this.getShell());
                if (AddNeutralLossForm.this.validateInput()) {
                    AddNeutralLossForm.this.setPageComplete(true);
                } else {
                    AddNeutralLossForm.this.setPageComplete(false);
                }
            }
        });
        btnAddAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddAdduct.setText(" Add Neutral Loss or Gain");
        new Label(container, 0);
        this.btnDeleteAdduct = new Button(container, 0);
        this.btnDeleteAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridUtils.deleteAdductsFromGrid(AddNeutralLossForm.this.gridAdduct, AddNeutralLossForm.this.adductGridItems, AddNeutralLossForm.this.adducts);
                if (AddNeutralLossForm.this.validateInput()) {
                    AddNeutralLossForm.this.setPageComplete(true);
                } else {
                    AddNeutralLossForm.this.setPageComplete(false);
                }
            }
        });
        this.btnDeleteAdduct.setEnabled(false);
        this.btnDeleteAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDeleteAdduct.setText("Delete Neutral Loss or Gain");
        new Label(container, 0);
        this.btnEditAdduct = new Button(container, 0);
        this.btnEditAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddNeutralLossForm.this.handleEdit();
            }
        });
        this.btnEditAdduct.setEnabled(false);
        this.btnEditAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditAdduct.setText("Edit Neutral Loss or Gain");
        new Label(container, 0);
        this.gridAdduct = new Grid(container, 2048);
        this.gridAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddNeutralLossForm.this.gridAdduct.getSelection().length != 0) {
                    AddNeutralLossForm.this.btnDeleteAdduct.setEnabled(true);
                    AddNeutralLossForm.this.btnEditAdduct.setEnabled(true);
                }
            }
        });
        this.gridAdduct.setHeaderVisible(true);
        GridData gd_gridAdduct = new GridData(4, 4, true, true, 1, 1);
        gd_gridAdduct.heightHint = 20;
        this.gridAdduct.setLayoutData((Object)gd_gridAdduct);
        GridColumn gridColumn = new GridColumn(this.gridAdduct, 0);
        gridColumn.setWidth(200);
        gridColumn.setText("Name");
        GridColumn gridColumn_2 = new GridColumn(this.gridAdduct, 0);
        gridColumn_2.setWidth(100);
        gridColumn_2.setText("Label");
        GridColumn gridColumn_3 = new GridColumn(this.gridAdduct, 0);
        gridColumn_3.setWidth(125);
        gridColumn_3.setText("Mass");
        GridColumn gridColumn_4 = new GridColumn(this.gridAdduct, 0);
        gridColumn_4.setWidth(125);
        gridColumn_4.setText("Number");
        if (this.gridAdduct.getItemCount() == 0 && this.adducts.keySet().size() == 1) {
            GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)this.adducts.get(GlycanPreDefinedOptions.LOSS_H20.getLabel()));
        }
        this.gridAdduct.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                AddNeutralLossForm.this.handleEdit();
            }
        });
        this.setControl((Control)container);
        this.updateControlsFromPreferences();
        this.setPageComplete(true);
    }

    public void handleEdit() {
        if (this.adductGridItems.isEmpty() || this.gridAdduct.getSelectionCount() == 0) {
            this.btnDeleteAdduct.setEnabled(false);
            this.btnEditAdduct.setEnabled(false);
        }
        if (this.gridAdduct.getSelectionIndices().length > 1) {
            this.setErrorMessage("You can edit only one adduct at a time");
            return;
        }
        GridUtils.editButtonPressed(ADD_DIALOG_TITLE, this.gridAdduct, this.adductGridItems, this.adducts, this.allPossibleAdducts, true, AddEditIonDialog.DialogType.NEUTRAL_LOSSGAIN, this.getShell());
        if (this.validateInput()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean validateInput() {
        if (this.gridAdduct.getSelectionCount() == 0 || this.adducts.isEmpty() && this.btnDeleteAdduct != null) {
            this.btnDeleteAdduct.setEnabled(false);
            this.btnEditAdduct.setEnabled(false);
        }
        this.setErrorMessage(null);
        this.save();
        return true;
    }

    public boolean checkAdduct() {
        return this.adductGridItems.size() != 0;
    }

    public void save() {
        ArrayList<MoleculeSettings> adductsFinalList = new ArrayList<MoleculeSettings>();
        if (this.adducts.keySet().size() != 0) {
            for (Object adduct : this.adducts.values()) {
                adductsFinalList.add((MoleculeSettings)adduct);
            }
        }
        this.method.setNeutralLoss(adductsFinalList);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void updateControlsFromPreferences() {
        if (!(this.getWizard() instanceof MSGlycanAnnotationWizard)) {
            return;
        }
        MSGlycanAnnotationWizard myWizard = (MSGlycanAnnotationWizard)this.getWizard();
        if (myWizard.getPreferences() != null && myWizard.getPreferences().getMethod() != null) {
            List moleculeSettings = myWizard.getPreferences().getMethod().getNeutralLoss();
            this.adducts.clear();
            this.gridAdduct.disposeAllItems();
            for (MoleculeSettings adduct : moleculeSettings) {
                if (GridUtils.getDuplicateAdduct(this.adducts, (Molecule)adduct) != null) continue;
                GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)adduct);
            }
        }
    }
}

