/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentDictionary;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentType;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.StyledTextCellRenderer;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class FragmentCanvas
extends JComponent
implements Printable,
MouseListener,
MouseMotionListener,
ActionListener {
    public static final int MARGIN_FRAGMENTS = 18;
    public static final int MARGIN_COLUMN = 18;
    public static final int MARGIN_CHILD = 0;
    public static final int MARGIN_CLOSE_BUTTON = 24;
    public static final int SIZE_CLOSE_BUTTON = 12;
    public static final String TEXT_FONT_FACE = "SansSerif.plain";
    public static final int TEXT_SIZE = 12;
    protected boolean canvasRequiresRevalidate;
    protected static final long serialVersionUID = 0L;
    protected JScrollPane theScrollPane = null;
    protected Fragmenter fragmenter;
    protected FragmentNode theRoot = null;
    protected FragmentNode with_button_pressed = null;
    protected SearchResult current_search = null;
    protected FragmentNode current_node = null;
    protected Vector<FragmentNode> all_nodes;
    protected HashSet<FragmentNode> selected_nodes;
    protected GlycanRenderer theGlycanRenderer;
    protected StyledTextCellRenderer theTextRenderer;
    protected Rectangle all_bbox = null;
    protected BBoxManager theBBoxManager;
    protected PositionManager thePosManager;
    protected boolean is_printing = false;
    protected Cursor cut_cursor = null;
    protected ImageIcon minus_button = null;
    protected ImageIcon minus_button_pressed = null;
    protected ImageIcon cross_button = null;
    protected ImageIcon cross_button_pressed = null;
    protected JLabel sel_label = new JLabel();
    protected Vector<SelectionChangeListener> listeners;

    public FragmentCanvas() {
        this.theGlycanRenderer = new GlycanRendererAWT();
        this.theTextRenderer = new StyledTextCellRenderer();
        this.thePosManager = new PositionManager();
        this.theBBoxManager = new BBoxManager();
        this.current_search = new SearchResult();
        this.all_nodes = new Vector();
        this.selected_nodes = new HashSet();
        this.theGlycanRenderer = new GlycanRendererAWT();
        this.thePosManager = new PositionManager();
        this.theBBoxManager = new BBoxManager();
        this.fragmenter = new Fragmenter();
        this.listeners = new Vector();
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.cut_cursor = FileUtils.createCursor((String)"cut");
        this.minus_button = FileUtils.defaultThemeManager.getImageIcon("fcb_minus");
        this.cross_button = FileUtils.defaultThemeManager.getImageIcon("fcb_cross");
        this.minus_button_pressed = FileUtils.defaultThemeManager.getImageIcon("fcb_minusp2");
        this.cross_button_pressed = FileUtils.defaultThemeManager.getImageIcon("fcb_crossp");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public JScrollPane getScrollPane() {
        return this.theScrollPane;
    }

    public void setScrollPane(JScrollPane sp) {
        this.theScrollPane = sp;
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public void setGlycanRenderer(GlycanRenderer r) {
        this.theGlycanRenderer = r;
    }

    private void createActions() {
    }

    private JPopupMenu createPopupMenu(Residue r) {
        JPopupMenu menu = new JPopupMenu();
        JMenu ax_menu = new JMenu("A/X fragments");
        JMenu a_menu = new JMenu("A fragments");
        JMenu x_menu = new JMenu("X fragments");
        ax_menu.add((Action)new GlycanAction("cleave=a,x", null, "All positions", -1, "", (ActionListener)this));
        a_menu.add((Action)new GlycanAction("cleave=a", null, "All positions", -1, "", (ActionListener)this));
        x_menu.add((Action)new GlycanAction("cleave=x", null, "All positions", -1, "", (ActionListener)this));
        for (int fp = 0; fp <= 3; ++fp) {
            for (int lp = fp + 2; lp <= 5 && lp - fp <= 4; ++lp) {
                ax_menu.add((Action)new GlycanAction("cleave=a" + fp + "" + lp + ",x" + fp + "" + lp, null, "Position " + fp + "," + lp, -1, "", (ActionListener)this));
                a_menu.add((Action)new GlycanAction("cleave=a" + fp + "" + lp, null, "Position " + fp + "," + lp, -1, "", (ActionListener)this));
                x_menu.add((Action)new GlycanAction("cleave=x" + fp + "" + lp, null, "Position " + fp + "," + lp, -1, "", (ActionListener)this));
            }
        }
        menu.add(ax_menu);
        menu.add(a_menu);
        menu.add(x_menu);
        return menu;
    }

    private JPopupMenu createPopupMenu(Linkage l, boolean on_border) {
        JPopupMenu menu = new JPopupMenu();
        if (on_border) {
            menu.add((Action)new GlycanAction("cleave=y", null, "Y fragment", -1, "", (ActionListener)this));
        } else {
            menu.add((Action)new GlycanAction("cleave=b,y", null, "B/Y fragments", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=c,z", null, "C/Z fragments", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=b", null, "B fragment", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=y", null, "Y fragment", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=c", null, "C fragment", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=z", null, "Z fragment", -1, "", (ActionListener)this));
            menu.add((Action)new GlycanAction("cleave=b,y,c,z", null, "All fragments", -1, "", (ActionListener)this));
        }
        return menu;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.theGlycanRenderer.computeSize(this.all_bbox);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public PositionManager getPositionManager() {
        return this.thePosManager;
    }

    public void setStructure(Glycan structure) {
        this.theRoot = structure == null ? null : new FragmentNode(null, structure);
        this.current_search = new SearchResult();
        this.refreshAllNodes();
        this.resetSelection();
        this.canvasRequiresRevalidate = true;
        this.repaint();
    }

    public void setStructure(Glycan structure, Residue frag_at) {
        if (structure == null) {
            this.theRoot = null;
        } else {
            this.theRoot = new FragmentNode(null, structure);
            if (frag_at != null) {
                this.theGlycanRenderer.assignPositions(structure, this.thePosManager);
                if (this.thePosManager.isOnBorder(frag_at)) {
                    this.onAddFragments(this.theRoot, frag_at, "y");
                } else {
                    this.onAddFragments(this.theRoot, frag_at, "a,x");
                }
            }
        }
        this.current_search = new SearchResult();
        this.refreshAllNodes();
        this.resetSelection();
        this.canvasRequiresRevalidate = true;
        this.repaint();
    }

    public void setStructure(Glycan structure, Linkage frag_at) {
        if (structure == null) {
            this.theRoot = null;
        } else {
            this.theRoot = new FragmentNode(null, structure);
            if (frag_at != null) {
                this.onAddFragments(this.theRoot, frag_at.getChildResidue(), "b,y");
            }
        }
        this.current_search = new SearchResult();
        this.refreshAllNodes();
        this.resetSelection();
        this.canvasRequiresRevalidate = true;
        this.repaint();
    }

    private boolean addFragment(FragmentNode parent, Residue r, Glycan f) {
        if (parent == null || r == null || f == null) {
            return false;
        }
        if (parent.add(new FragmentNode(r, f))) {
            this.refreshAllNodes();
            return true;
        }
        return false;
    }

    private void clearChildren(FragmentNode parent) {
        parent.clearChildren();
        this.refreshAllNodes();
    }

    private void refreshAllNodes() {
        this.all_nodes.clear();
        FragmentCanvas.getAllNodes(this.all_nodes, this.theRoot);
    }

    private static void getAllNodes(Vector<FragmentNode> buffer, FragmentNode current) {
        if (current == null) {
            return;
        }
        buffer.add(current);
        for (FragmentNode child : current.children) {
            FragmentCanvas.getAllNodes(buffer, child);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clipRect = new Rectangle();
        g.getClipBounds(clipRect);
        GraphicOptions theGraphicOptions = this.theGlycanRenderer.getGraphicOptions();
        boolean old_flag = theGraphicOptions.SHOW_INFO;
        double old_scale = theGraphicOptions.SCALE;
        theGraphicOptions.SHOW_INFO = false;
        this.all_bbox = null;
        if (this.theRoot != null) {
            int max_width;
            int cur_width;
            this.thePosManager.reset();
            this.theBBoxManager.reset();
            Rectangle s_bbox = this.computeStructuresBoundingBoxes(theGraphicOptions.MARGIN_LEFT, theGraphicOptions.MARGIN_TOP, this.theRoot);
            Rectangle t_bbox = this.computeTypesBoundingBoxes(Geometry.right((Rectangle)s_bbox) + 18, this.theRoot);
            Rectangle m_bbox = this.computeMZsBoundingBoxes(Geometry.right((Rectangle)t_bbox) + 18, this.theRoot);
            this.computeNodeBoundingBoxes(theGraphicOptions.MARGIN_LEFT, this.theRoot);
            if (this.theScrollPane != null && (cur_width = s_bbox.width + 18 + t_bbox.width + 18 + m_bbox.width) < (max_width = this.theScrollPane.getViewport().getExtentSize().width - theGraphicOptions.MARGIN_LEFT - theGraphicOptions.MARGIN_RIGHT - 24)) {
                int delta = max_width - cur_width;
                s_bbox = this.computeStructuresBoundingBoxes(theGraphicOptions.MARGIN_LEFT, theGraphicOptions.MARGIN_TOP, this.theRoot);
                t_bbox = this.computeTypesBoundingBoxes(Geometry.right((Rectangle)s_bbox) + delta / 3 + 18, this.theRoot);
                m_bbox = this.computeMZsBoundingBoxes(Geometry.right((Rectangle)t_bbox) + delta / 3 + 18, this.theRoot);
                this.computeNodeBoundingBoxes(theGraphicOptions.MARGIN_LEFT, this.theRoot);
                this.all_bbox = new Rectangle(theGraphicOptions.MARGIN_LEFT, theGraphicOptions.MARGIN_TOP, max_width, 0);
            }
            this.all_bbox = Geometry.union((Rectangle)this.all_bbox, (Rectangle)s_bbox);
            this.all_bbox = Geometry.union((Rectangle)this.all_bbox, (Rectangle)t_bbox);
            this.all_bbox = Geometry.union((Rectangle)this.all_bbox, (Rectangle)m_bbox);
        }
        this.paint(g2d, this.theRoot);
        this.paintSelection(g2d);
        if (this.canvasRequiresRevalidate) {
            this.canvasRequiresRevalidate = false;
            this.revalidate();
        }
        theGraphicOptions.setScale(old_scale);
        theGraphicOptions.SHOW_INFO = old_flag;
        g2d.dispose();
    }

    private Rectangle computeStructuresBoundingBoxes(int cur_left, int cur_top, FragmentNode fn) {
        if (fn == null) {
            return null;
        }
        GraphicOptions theGraphicOptions = this.theGlycanRenderer.getGraphicOptions();
        if (fn.zoom) {
            theGraphicOptions.setScale(Math.max(theGraphicOptions.SCALE_CANVAS, 1.0));
        } else {
            theGraphicOptions.setScale(0.75 * theGraphicOptions.SCALE_CANVAS);
        }
        fn.all_bbox = new Rectangle(cur_left, cur_top, 1, 1);
        fn.fragment_bbox = this.theGlycanRenderer.computeBoundingBoxes(fn.entry.fragment, cur_left + 24, cur_top, false, true, this.thePosManager, this.theBBoxManager);
        fn.all_bbox = Geometry.union((Rectangle)fn.all_bbox, (Rectangle)fn.fragment_bbox);
        if (fn.children.size() > 0) {
            int left = cur_left + 8 - 6;
            int top = cur_top + fn.fragment_bbox.height / 2 - 6;
            fn.close_bbox = new Rectangle(left, top, 12, 12);
        } else {
            fn.close_bbox = null;
        }
        cur_left += 24;
        fn.children_bbox = null;
        for (FragmentNode child : fn.children) {
            cur_top = Geometry.bottom((Rectangle)fn.all_bbox) + 18;
            Rectangle child_bbox = this.computeStructuresBoundingBoxes(cur_left + 0, cur_top, child);
            fn.all_bbox = Geometry.union((Rectangle)fn.all_bbox, (Rectangle)child_bbox);
            fn.children_bbox = Geometry.union((Rectangle)fn.children_bbox, (Rectangle)child_bbox);
        }
        return fn.all_bbox;
    }

    private Rectangle computeTypesBoundingBoxes(int cur_left, FragmentNode fn) {
        Dimension d = this.getTextBounds(fn.entry.name);
        Rectangle all_bbox = fn.type_bbox = new Rectangle(cur_left, Geometry.midy((Rectangle)fn.fragment_bbox) - d.height / 2, d.width, d.height);
        for (FragmentNode child : fn.children) {
            all_bbox = Geometry.union((Rectangle)all_bbox, (Rectangle)this.computeTypesBoundingBoxes(cur_left, child));
        }
        return all_bbox;
    }

    private Rectangle computeMZsBoundingBoxes(int cur_left, FragmentNode fn) {
        DecimalFormat df = new DecimalFormat("0.0000");
        Dimension d = this.getTextBounds(df.format(fn.entry.mz_ratio));
        Rectangle all_bbox = fn.mzs_bbox = new Rectangle(cur_left, Geometry.midy((Rectangle)fn.fragment_bbox) - d.height / 2, d.width, d.height);
        for (FragmentNode child : fn.children) {
            all_bbox = Geometry.union((Rectangle)all_bbox, (Rectangle)this.computeMZsBoundingBoxes(cur_left, child));
        }
        return all_bbox;
    }

    private void computeNodeBoundingBoxes(int cur_left, FragmentNode fn) {
        int width = fn.fragment_bbox.width + 18 + fn.type_bbox.width + 18 + fn.mzs_bbox.width;
        fn.node_bbox = new Rectangle(cur_left, fn.fragment_bbox.y - 9, width, fn.fragment_bbox.height + 18);
        for (FragmentNode child : fn.children) {
            this.computeNodeBoundingBoxes(cur_left + 0, child);
        }
    }

    private Dimension getTextBounds(String text) {
        Component c = this.theTextRenderer.getRendererComponent(new Font(TEXT_FONT_FACE, 0, 12), Color.black, this.getBackground(), (Object)text);
        return c.getPreferredSize();
    }

    private void paintIcon(Graphics2D g2d, Rectangle bbox, ImageIcon icon) {
        if (g2d != null && bbox != null && icon != null) {
            AffineTransform at = new AffineTransform();
            at.setToTranslation(bbox.x, bbox.y);
            g2d.drawImage(icon.getImage(), at, null);
        }
    }

    private void paintText(Graphics2D g2d, Rectangle bbox, String text) {
        Component c = this.theTextRenderer.getRendererComponent(new Font(TEXT_FONT_FACE, 0, 12), Color.black, this.getBackground(), (Object)text);
        SwingUtilities.paintComponent(g2d, c, this, bbox.x, bbox.y, bbox.width, bbox.height);
    }

    private void paint(Graphics2D g2d, FragmentNode fn) {
        if (fn == null) {
            return;
        }
        GraphicOptions theGraphicOptions = this.theGlycanRenderer.getGraphicOptions();
        if (fn.zoom) {
            theGraphicOptions.setScale(Math.max(theGraphicOptions.SCALE_CANVAS, 1.0));
        } else {
            theGraphicOptions.setScale(0.75 * theGraphicOptions.SCALE_CANVAS);
        }
        HashSet<Residue> selected_residues = this.current_search.getSelectedResidues();
        HashSet<Linkage> selected_linkages = this.current_search.getSelectedLinkages();
        if (!this.is_printing && fn.close_bbox != null) {
            this.paintIcon(g2d, fn.close_bbox, this.minus_button);
        }
        this.theGlycanRenderer.paint((Paintable)new DefaultPaintable(g2d), fn.entry.fragment, selected_residues, selected_linkages, false, true, this.thePosManager, this.theBBoxManager);
        this.paintText(g2d, fn.type_bbox, fn.entry.name);
        DecimalFormat df = new DecimalFormat("0.0000");
        this.paintText(g2d, fn.mzs_bbox, df.format(fn.entry.mz_ratio));
        if (Geometry.bottom((Rectangle)fn.fragment_bbox) != Geometry.bottom((Rectangle)this.all_bbox)) {
            g2d.setColor(Color.gray);
            g2d.drawLine(Geometry.left((Rectangle)fn.fragment_bbox), Geometry.bottom((Rectangle)fn.fragment_bbox) + 9, Geometry.right((Rectangle)this.all_bbox) + theGraphicOptions.MARGIN_RIGHT + 24, Geometry.bottom((Rectangle)fn.fragment_bbox) + 9);
        }
        for (FragmentNode child : fn.children) {
            this.paint(g2d, child);
        }
    }

    private void paintSelection(Graphics2D g2d) {
        GraphicOptions theGraphicOptions = this.theGlycanRenderer.getGraphicOptions();
        Iterator<FragmentNode> i = this.all_nodes.iterator();
        while (i.hasNext()) {
            FragmentNode t;
            FragmentNode n = i.next();
            if (!this.selected_nodes.contains(n)) continue;
            Rectangle bbox = n.node_bbox;
            while (i.hasNext() && this.selected_nodes.contains(t = i.next())) {
                bbox = Geometry.union((Rectangle)bbox, (Rectangle)t.node_bbox);
            }
            g2d.setColor(UIManager.getColor("Table.selectionBackground"));
            g2d.fill(new Rectangle(theGraphicOptions.MARGIN_LEFT / 2 - 3, bbox.y, 5, bbox.height));
        }
        if (this.current_node != null && this.current_node.node_bbox != null) {
            Rectangle cur_bbox = this.current_node.node_bbox;
            UIManager.getBorder("Table.focusCellHighlightBorder").paintBorder(this.sel_label, g2d, theGraphicOptions.MARGIN_LEFT / 2 - 3, cur_bbox.y, 5, cur_bbox.height);
        }
    }

    public void onAddFragments(String arguments) {
        this.onAddFragments(this.current_search.getParent(), this.current_search.getFragmentResidue(), arguments);
    }

    public void onAddFragments(FragmentNode fn, Residue r, String arguments) {
        if (fn == null || r == null) {
            return;
        }
        Glycan s = fn.entry.fragment;
        Vector fragment_types = TextUtils.tokenize((String)arguments, (String)",");
        for (String t : fragment_types) {
            int lp;
            CrossRingFragmentType crt;
            char type = t.charAt(0);
            if (type == 'b') {
                for (Glycan fragment : this.fragmenter.getAllBFragmentsWithLabiles(s, r)) {
                    this.addFragment(fn, r, fragment);
                }
                continue;
            }
            if (type == 'c') {
                for (Glycan fragment : this.fragmenter.getAllCFragmentsWithLabiles(s, r)) {
                    this.addFragment(fn, r, fragment);
                }
                continue;
            }
            if (type == 'y') {
                if (r.isLabile()) {
                    this.addFragment(fn, r, this.fragmenter.getLFragment(s, r));
                    continue;
                }
                for (Glycan fragment : this.fragmenter.getAllYFragmentsWithLabiles(s, r)) {
                    this.addFragment(fn, r, fragment);
                }
                continue;
            }
            if (type == 'z') {
                for (Glycan fragment : this.fragmenter.getAllZFragmentsWithLabiles(s, r)) {
                    this.addFragment(fn, r, fragment);
                }
                continue;
            }
            if (type != 'a' && type != 'x') continue;
            if (t.length() == 1) {
                for (int fp = 0; fp <= 3; ++fp) {
                    for (int lp2 = fp + 2; lp2 <= 5 && lp2 - fp <= 4; ++lp2) {
                        crt = CrossRingFragmentDictionary.getCrossRingFragmentType((char)type, (int)fp, (int)lp2, (Residue)r);
                        if (crt == null) continue;
                        if (type == 'a') {
                            for (Glycan fragment : this.fragmenter.getAllAFragmentsWithLabiles(s, r, crt)) {
                                this.addFragment(fn, r, fragment);
                            }
                            continue;
                        }
                        for (Glycan fragment : this.fragmenter.getAllXFragmentsWithLabiles(s, r, crt)) {
                            this.addFragment(fn, r, fragment);
                        }
                    }
                }
                continue;
            }
            int fp = t.charAt(1) - 48;
            crt = CrossRingFragmentDictionary.getCrossRingFragmentType((char)type, (int)fp, (int)(lp = t.charAt(2) - 48), (Residue)r);
            if (crt == null) continue;
            if (type == 'a') {
                for (Glycan fragment : this.fragmenter.getAllAFragmentsWithLabiles(s, r, crt)) {
                    this.addFragment(fn, r, fragment);
                }
                continue;
            }
            for (Glycan fragment : this.fragmenter.getAllXFragmentsWithLabiles(s, r, crt)) {
                this.addFragment(fn, r, fragment);
            }
        }
        this.canvasRequiresRevalidate = true;
        this.repaint();
    }

    public void print(PrinterJob job) throws PrinterException {
        this.is_printing = true;
        job.print();
        this.is_printing = false;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setBackground(Color.white);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension td = this.getPreferredSize();
        double sx = pageFormat.getImageableWidth() / (double)td.width;
        double sy = pageFormat.getImageableHeight() / (double)td.height;
        double s = Math.min(sx, sy);
        if (s < 1.0) {
            g2d.scale(s, s);
        }
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        this.paint(g2d);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        return 0;
    }

    public SearchResult getWhatsAt(Point p) {
        return this.getWhatsAt(this.theRoot, p);
    }

    private SearchResult getWhatsAt(FragmentNode fn, Point p) {
        if (fn == null) {
            return new SearchResult();
        }
        if (fn.close_bbox != null && fn.close_bbox.contains(p)) {
            return new SearchResult(fn, 1);
        }
        SearchResult ret = this.getWhatsAt(fn, fn.entry.fragment, p);
        if (!ret.isEmpty()) {
            return ret;
        }
        for (FragmentNode child : fn.children) {
            ret = this.getWhatsAt(child, p);
            if (ret.isEmpty()) continue;
            return ret;
        }
        return new SearchResult(fn);
    }

    private SearchResult getWhatsAt(FragmentNode fn, Glycan f, Point p) {
        if (f == null) {
            return new SearchResult(fn);
        }
        SearchResult ret = this.getWhatsAt(fn, f.getRoot(), p);
        if (!ret.isEmpty()) {
            return ret;
        }
        return this.getWhatsAt(fn, f.getBracket(), p);
    }

    private SearchResult getWhatsAt(FragmentNode fn, Residue r, Point p) {
        if (r == null) {
            return new SearchResult(fn);
        }
        Rectangle cur_bbox = this.theBBoxManager.getCurrent(r);
        if (cur_bbox == null) {
            return new SearchResult(fn);
        }
        if (cur_bbox.contains(p)) {
            return new SearchResult(fn, r);
        }
        for (Linkage l : r.getChildrenLinkages()) {
            Residue child = l.getChildResidue();
            Rectangle child_bbox = this.theBBoxManager.getCurrent(child);
            if (child_bbox == null) continue;
            if (child_bbox.contains(p)) {
                return new SearchResult(fn, child);
            }
            if (Geometry.distance((Point)p, (Point)Geometry.center((Rectangle)cur_bbox), (Point)Geometry.center((Rectangle)child_bbox)) < 4.0) {
                return new SearchResult(fn, l);
            }
            SearchResult ret = this.getWhatsAt(fn, child, p);
            if (ret.isEmpty()) continue;
            return ret;
        }
        return new SearchResult(fn);
    }

    private void updateSearch(MouseEvent e) {
        boolean on_something;
        SearchResult ret = this.getWhatsAt(e.getPoint());
        boolean to_repaint = !this.current_search.equals(ret);
        boolean bl = on_something = ret.canDoCleavage() || ret.canDoRingFragment();
        if (on_something && this.getCursor() != this.cut_cursor) {
            this.setCursor(this.cut_cursor);
        } else if (!on_something && this.getCursor() == this.cut_cursor) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (to_repaint) {
            this.canvasRequiresRevalidate = true;
            this.repaint();
        }
        this.current_search = ret;
    }

    public FragmentNode getNodeAtPoint(Point p) {
        for (FragmentNode n : this.all_nodes) {
            if (n.node_bbox == null || !n.node_bbox.contains(p)) continue;
            return n;
        }
        return null;
    }

    public boolean hasSelection() {
        return this.selected_nodes.size() > 0;
    }

    public void resetSelection() {
        this.selected_nodes.clear();
        this.current_node = null;
        this.fireUpdatedSelection();
    }

    public boolean hasCurrentNode() {
        return this.current_node != null;
    }

    public FragmentNode getCurrentNode() {
        return this.current_node;
    }

    private void setCurrentNode(FragmentNode node) {
        if (node != null) {
            this.selected_nodes.add(node);
        }
        this.current_node = node;
        this.fireUpdatedSelection();
    }

    public boolean isSelected(FragmentNode node) {
        if (node == null) {
            return false;
        }
        return this.selected_nodes.contains(node);
    }

    public Collection<FragmentNode> getSelectedNodes() {
        return this.selected_nodes;
    }

    public Collection<Glycan> getSelectedFragments() {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (FragmentNode fn : this.selected_nodes) {
            if (fn.entry.fragment == null) continue;
            ret.add(fn.entry.fragment);
        }
        return ret;
    }

    public void setSelection(FragmentNode node) {
        if (node == null) {
            this.resetSelection();
        } else {
            this.selected_nodes.clear();
            this.selected_nodes.add(node);
            this.current_node = node;
            this.fireUpdatedSelection();
        }
    }

    public void addSelection(FragmentNode node) {
        if (node != null) {
            this.selected_nodes.add(node);
            this.current_node = node;
            this.fireUpdatedSelection();
        }
    }

    public void addSelectionPathTo(FragmentNode node) {
        if (node != null) {
            if (this.current_node == null) {
                this.selected_nodes.add(node);
            } else {
                this.selected_nodes.addAll(this.getPath(this.current_node, node));
            }
            this.current_node = node;
            this.fireUpdatedSelection();
        }
    }

    private Vector<FragmentNode> getPath(FragmentNode from, FragmentNode to) {
        int ind2;
        Vector<FragmentNode> ret = new Vector<FragmentNode>();
        if (from == null || to == null) {
            return ret;
        }
        int ind1 = this.all_nodes.indexOf(from);
        if (ind1 <= (ind2 = this.all_nodes.indexOf(to))) {
            for (int i = ind1; i <= ind2; ++i) {
                ret.add(this.all_nodes.elementAt(i));
            }
        } else {
            for (int i = ind2; i <= ind1; ++i) {
                ret.add(this.all_nodes.elementAt(i));
            }
        }
        return ret;
    }

    public void toggleZoom(FragmentNode node) {
        if (node != null) {
            node.zoom = !node.zoom;
            this.canvasRequiresRevalidate = true;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        String param = GlycanAction.getParam((ActionEvent)e);
        if (action.equals("cleave")) {
            this.onAddFragments(param);
        }
    }

    private void showPopup(MouseEvent e) {
        if (this.current_search.canDoCleavage()) {
            this.createPopupMenu(this.current_search.getFragmentLinkage(), this.current_search.isOnBorder()).show(this, e.getX(), e.getY());
        } else if (this.current_search.canDoRingFragment()) {
            this.createPopupMenu(this.current_search.getFragmentResidue()).show(this, e.getX(), e.getY());
        }
    }

    public void drawButton(FragmentNode fn, ImageIcon icon) {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        this.paintIcon(g2d, this.with_button_pressed.close_bbox, icon);
        g2d.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.updateSearch(e);
            this.showPopup(e);
        } else if (MouseUtils.isPushTrigger((MouseEvent)e)) {
            this.updateSearch(e);
            if (this.current_search.isCloseButton()) {
                this.with_button_pressed = this.current_search.getParent();
                this.drawButton(this.with_button_pressed, this.minus_button_pressed);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.with_button_pressed != null) {
            this.updateSearch(e);
            if (this.current_search.getParent() != this.with_button_pressed || !this.current_search.isCloseButton()) {
                this.drawButton(this.with_button_pressed, this.minus_button);
                this.with_button_pressed = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.with_button_pressed != null) {
            this.updateSearch(e);
            if (this.current_search.getParent() == this.with_button_pressed && this.current_search.isCloseButton()) {
                this.clearChildren(this.current_search.parent);
            }
            this.with_button_pressed = null;
            this.canvasRequiresRevalidate = true;
            this.repaint();
        }
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.updateSearch(e);
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        FragmentNode n;
        if (MouseUtils.isSelectTrigger((MouseEvent)e)) {
            this.updateSearch(e);
            if (this.current_search.canDoCleavage()) {
                this.onAddFragments("b,y");
            }
            if (this.current_search.canDoRingFragment()) {
                this.onAddFragments("a,x");
            }
        }
        if ((n = this.getNodeAtPoint(e.getPoint())) != null) {
            if (MouseUtils.isSelectTrigger((MouseEvent)e)) {
                this.setSelection(n);
            } else if (MouseUtils.isAddSelectTrigger((MouseEvent)e)) {
                this.addSelection(n);
            } else if (MouseUtils.isSelectAllTrigger((MouseEvent)e)) {
                this.addSelectionPathTo(n);
            } else if (MouseUtils.isActionTrigger((MouseEvent)e)) {
                this.toggleZoom(n);
            }
        } else {
            this.resetSelection();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateSearch(e);
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireUpdatedSelection() {
        Iterator<SelectionChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(new SelectionChangeEvent(this));
        }
        this.canvasRequiresRevalidate = true;
        this.repaint();
    }

    public class SearchResult {
        public static final int NO_BUTTON = 0;
        public static final int CLOSE_BUTTON = 1;
        protected FragmentNode parent = null;
        protected int button = 0;
        protected Residue residue = null;
        protected Linkage linkage = null;
        protected boolean is_on_border = false;
        protected boolean can_do_cleavage = false;
        protected boolean can_do_ringfragment = false;

        public SearchResult() {
        }

        public SearchResult(FragmentNode fn) {
            this.parent = fn;
        }

        public SearchResult(FragmentNode fn, int b) {
            this.parent = fn;
            this.button = b;
        }

        public SearchResult(FragmentNode fn, Residue r) {
            Glycan s;
            this.parent = fn;
            this.residue = r;
            Glycan glycan = s = this.parent != null ? this.parent.entry.fragment : null;
            if (this.residue != null) {
                this.is_on_border = FragmentCanvas.this.thePosManager.isOnBorder(this.residue);
                if (this.is_on_border) {
                    if (Fragmenter.canDoCleavage((Glycan)s, (Residue)this.residue, (boolean)true)) {
                        this.can_do_cleavage = true;
                    } else {
                        this.residue = null;
                    }
                } else if (Fragmenter.canDoRingFragment((Glycan)s, (Residue)this.residue, (boolean)true)) {
                    this.can_do_ringfragment = true;
                } else {
                    this.residue = null;
                }
            }
        }

        public SearchResult(FragmentNode fn, Linkage l) {
            Glycan s;
            this.parent = fn;
            this.linkage = l;
            Glycan glycan = s = this.parent != null ? this.parent.entry.fragment : null;
            if (this.linkage != null) {
                if (Fragmenter.canDoCleavage((Glycan)s, (Residue)this.linkage.getChildResidue(), (boolean)true)) {
                    this.can_do_cleavage = true;
                } else {
                    this.linkage = null;
                }
            }
        }

        public boolean isEmpty() {
            return this.parent == null || this.button == 0 && this.residue == null && this.linkage == null;
        }

        public FragmentNode getParent() {
            return this.parent;
        }

        public Linkage getSelectedLinkage() {
            return this.linkage;
        }

        public HashSet<Linkage> getSelectedLinkages() {
            HashSet<Linkage> set = new HashSet<Linkage>();
            if (this.linkage != null) {
                set.add(this.linkage);
            }
            return set;
        }

        public Residue getSelectedResidue() {
            return this.residue;
        }

        public HashSet<Residue> getSelectedResidues() {
            HashSet<Residue> set = new HashSet<Residue>();
            if (this.residue != null) {
                set.add(this.residue);
            }
            return set;
        }

        public Residue getFragmentResidue() {
            if (this.residue != null) {
                return this.residue;
            }
            if (this.linkage != null) {
                return this.linkage.getChildResidue();
            }
            return null;
        }

        public Linkage getFragmentLinkage() {
            if (this.linkage != null) {
                return this.linkage;
            }
            if (this.residue != null && this.can_do_cleavage) {
                return this.residue.getParentLinkage();
            }
            return null;
        }

        public boolean isCloseButton() {
            return this.button == 1;
        }

        public boolean isOnBorder() {
            return this.is_on_border;
        }

        public boolean canDoCleavage() {
            return this.can_do_cleavage;
        }

        public boolean canDoRingFragment() {
            return this.can_do_ringfragment;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchResult)) {
                return false;
            }
            SearchResult sr = (SearchResult)other;
            if (this.parent != sr.parent) {
                return false;
            }
            if (this.button != sr.button) {
                return false;
            }
            if (this.residue != sr.residue) {
                return false;
            }
            return this.linkage == sr.linkage;
        }

        public int hashCode() {
            return this.parent.hashCode() + Integer.valueOf(this.button).hashCode() + this.residue.hashCode() + this.linkage.hashCode();
        }
    }

    public static class FragmentNode {
        public Residue position = null;
        public FragmentEntry entry = null;
        public Vector<FragmentNode> children = new Vector();
        public boolean zoom = false;
        Rectangle close_bbox = null;
        Rectangle fragment_bbox = null;
        Rectangle type_bbox = null;
        Rectangle mzs_bbox = null;
        Rectangle children_bbox = null;
        Rectangle node_bbox = null;
        Rectangle all_bbox = null;

        public FragmentNode(Residue p, Glycan f) {
            this.position = p;
            this.entry = new FragmentEntry(f, Fragmenter.getFragmentType((Glycan)f));
        }

        public FragmentNode(Residue p, FragmentEntry _entry) {
            this.position = p;
            this.entry = _entry;
        }

        public boolean add(FragmentNode toadd) {
            if (toadd == null) {
                return false;
            }
            for (FragmentNode child : this.children) {
                if (child.position != toadd.position || !child.entry.name.equals(toadd.entry.name) || !child.entry.structure.equals(toadd.entry.structure)) continue;
                return false;
            }
            this.children.add(toadd);
            return true;
        }

        public void clearChildren() {
            this.children.clear();
        }
    }

    public static class SelectionChangeEvent {
        private FragmentCanvas src;

        public SelectionChangeEvent(FragmentCanvas _src) {
            this.src = _src;
        }

        public FragmentCanvas getSource() {
            return this.src;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(SelectionChangeEvent var1);
    }
}

