/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.count;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.grits.toolbox.util.structure.glycan.count.CompositionSearchEngine;
import org.grits.toolbox.util.structure.glycan.count.SearchQueryItem;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterException;

public class GlycanCompositionCountOperator {
    public static boolean matchAndCountComposition(Sugar sugar, List<SearchQueryItem> queryItems, LinkedHashMap<String, Integer> countsMap) throws GlycanFilterException {
        boolean match = false;
        SugarImporterGlycoCTCondensed importer = new SugarImporterGlycoCTCondensed();
        ArrayList<Sugar> parsedQueryItems = new ArrayList<Sugar>();
        for (SearchQueryItem structure : queryItems) {
            try {
                Sugar queryStr = importer.parse(structure.getSequence());
                parsedQueryItems.add(queryStr);
            }
            catch (SugarImporterException e) {
                throw new GlycanFilterException(e.getMessage(), (Exception)((Object)e));
            }
        }
        CompositionSearchEngine searchEngine = new CompositionSearchEngine();
        try {
            searchEngine.setQueriedStructure(sugar);
            int i = 0;
            for (Sugar sugar2 : parsedQueryItems) {
                searchEngine.setQueryStructure(sugar2);
                int count = 0;
                while (searchEngine.isMatch().booleanValue()) {
                    ++count;
                    searchEngine.removeMatchedFromQueried();
                }
                countsMap.put(queryItems.get(i).getName(), count);
                ++i;
            }
            if (searchEngine.getNotMatchedCount() == 0) {
                match = true;
            }
        }
        catch (SearchEngineException | GlycoVisitorException e) {
            throw new GlycanFilterException(e.getMessage(), (Exception)e);
        }
        return match;
    }

    public static void main(String[] args) {
        ArrayList<SearchQueryItem> queryList = new ArrayList<SearchQueryItem>();
        queryList.add(new SearchQueryItem("HexNac", "RES\n1b:x-HEX-1:5\n2s:n-acetyl\nLIN\n1:1d(2+1)2n"));
        queryList.add(new SearchQueryItem("HexN", "RES\n1b:x-HEX-x:x|1:a\n2s:amino\nLIN\n1:1d(2+1)2n"));
        queryList.add(new SearchQueryItem("NeuAC", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d\n2s:n-acetyl\nLIN\n1:1d(5+1)2n"));
        queryList.add(new SearchQueryItem("NeuGC", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d\n2s:n-glycolyl\nLIN\n1:1d(5+1)2n"));
        queryList.add(new SearchQueryItem("KDN", "RES\n1b:x-dgro-dgal-NON-x:x|1:a|2:keto|3:d"));
        queryList.add(new SearchQueryItem("dHex", "RES\n1b:x-HEX-x:x|6:d"));
        queryList.add(new SearchQueryItem("Hex", "RES\n1b:x-HEX-x:x"));
        queryList.add(new SearchQueryItem("Pent", "RES\n1b:x-PEN-x:x"));
        queryList.add(new SearchQueryItem("Methyl", "RES\n1s:methyl"));
        queryList.add(new SearchQueryItem("GlcA", "RES\n1b:x-dglc-HEX-1:5|6:a"));
        queryList.add(new SearchQueryItem("IdoA", "RES\n1b:x-lido-HEX-1:5|6:a"));
        queryList.add(new SearchQueryItem("Phosphate", "RES\n1s:phosphate"));
        queryList.add(new SearchQueryItem("Sulfate", "RES\n1s:sulfate"));
        String sequence = "RES\n1b:b-dglc-HEX-1:5\n2s:n-acetyl\n3b:b-dglc-HEX-1:5\n4s:n-acetyl\n5b:b-dman-HEX-1:5\n6b:a-dman-HEX-1:5\n7b:b-dglc-HEX-1:5\n8s:n-acetyl\n9b:b-dgal-HEX-1:5\n10s:n-acetyl\n11s:sulfate\n12b:a-dman-HEX-1:5\n13b:b-dglc-HEX-1:5\n14s:n-acetyl\n15b:b-dgal-HEX-1:5\nLIN\n1:1d(2+1)2n\n2:1o(4+1)3d\n3:3d(2+1)4n\n4:3o(4+1)5d\n5:5o(3+1)6d\n6:6o(2+1)7d\n7:7d(2+1)8n\n8:7o(4+1)9d\n9:9d(2+1)10n\n10:9o(4+1)11n\n11:5o(6+1)12d\n12:12o(2+1)13d\n13:13d(2+1)14n\n14:13o(4+1)15d\n";
        SugarImporterGlycoCTCondensed importer = new SugarImporterGlycoCTCondensed();
        try {
            Sugar sugar = importer.parse(sequence);
            LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
            boolean match = GlycanCompositionCountOperator.matchAndCountComposition(sugar, queryList, counts);
            if (match) {
                for (String queryItem : counts.keySet()) {
                    System.out.println(queryItem + "(" + counts.get(queryItem) + ")");
                }
            } else {
                System.out.println("Not matched");
            }
        }
        catch (SugarImporterException | GlycanFilterException e) {
            e.printStackTrace();
        }
    }
}

