/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.database.lipid;

public enum LipidClass {
    SPHINGOMYELIN("Sphingomyelin", "SM"),
    CERAMIDE("Ceramide", "Cer"),
    SPHINGOSINE("Sphingosine", "Sp"),
    FATTY_ACID("Fatty Acid", "FA"),
    FRAGMENT("Fragment", "Fr");

    private String m_strName;
    private String m_strAbbr;

    private LipidClass(String a_strName, String a_strAbbr) {
        this.m_strName = a_strName;
        this.m_strAbbr = a_strAbbr;
    }

    public String getName() {
        return this.m_strName;
    }

    public String getAbbreviation() {
        return this.m_strAbbr;
    }

    public static LipidClass forName(String a_strName) {
        LipidClass[] lipidClassArray = LipidClass.values();
        int n = lipidClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            LipidClass t_lc = lipidClassArray[n2];
            if (t_lc.m_strName.equals(a_strName)) {
                return t_lc;
            }
            ++n2;
        }
        return null;
    }

    public static LipidClass forAbbreviation(String a_strAbbr) {
        LipidClass[] lipidClassArray = LipidClass.values();
        int n = lipidClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            LipidClass t_lc = lipidClassArray[n2];
            if (t_lc.m_strAbbr.equals(a_strAbbr)) {
                return t_lc;
            }
            ++n2;
        }
        return null;
    }
}

