/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.classification;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCT;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.classification.ResultsPerMotif;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngine;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstructureClassCompare {
    private List m_Lmotifs;
    private Sugar m_oSugar = null;
    private ArrayList<Integer> m_aIDsFound = new ArrayList();
    private ArrayList<ResultsPerMotif> m_aResultsPerSequence = new ArrayList();

    public SubstructureClassCompare() throws JDOMException, IOException {
        String location = "./src/org/eurocarbdb/MolecularFramework/util/classification/substructureBased/motifs.xml";
        File f = new File(location);
        if (f.exists()) {
            this.readXMLDefinitions(location);
        }
    }

    public SubstructureClassCompare(String a_strFileName) throws JDOMException, IOException {
        this.readXMLDefinitions(a_strFileName);
    }

    public void scanForMotif(Sugar a_oSugar) throws GlycoVisitorException, SearchEngineException {
        this.clear();
        this.m_oSugar = a_oSugar;
        for (Element motif : this.m_Lmotifs) {
            List sequences = motif.getChildren("sequence");
            for (Element sequence : sequences) {
                Sugar t_oSug = new Sugar();
                try {
                    SugarImporterGlycoCT t_oCTimporter = new SugarImporterGlycoCT();
                    t_oSug = t_oCTimporter.parse(sequence.getChild("sugar"));
                }
                catch (SugarImporterException e) {
                    e.printStackTrace();
                }
                SearchEngine t_comp = new SearchEngine();
                t_comp.setQueriedStructure(this.m_oSugar);
                t_comp.setQueryStructure(t_oSug);
                if (sequence.getAttribute("reducing_end").getValue().equals("true")) {
                    t_comp.restrictToReducingEnds();
                }
                if (!t_comp.isExactMatch().booleanValue()) continue;
                try {
                    ResultsPerMotif t_oRPM = new ResultsPerMotif();
                    t_oRPM.motifID = motif.getAttribute("id").getIntValue();
                    t_oRPM.sequenceID = sequence.getAttribute("id").getIntValue();
                    this.m_aResultsPerSequence.add(t_oRPM);
                    if (this.m_aIDsFound.contains(motif.getAttribute("id").getIntValue())) continue;
                    this.m_aIDsFound.add(motif.getAttribute("id").getIntValue());
                }
                catch (DataConversionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clear() {
        this.m_aIDsFound.clear();
        this.m_aResultsPerSequence.clear();
    }

    public Boolean isMotifIDinSugar(Integer id) {
        if (this.m_aIDsFound.contains(id)) {
            return true;
        }
        return false;
    }

    public Boolean isMotifPrimaryAssignment(Integer idInQuestion) {
        Boolean result = true;
        if (this.m_aIDsFound.contains(idInQuestion) && idInQuestion > 0 && idInQuestion < 100) {
            for (Integer foundId : this.m_aIDsFound) {
                if (foundId <= 0 || idInQuestion >= 100 || foundId >= idInQuestion) continue;
                result = false;
            }
        }
        if (this.m_aIDsFound.contains(idInQuestion) && idInQuestion >= 500 && idInQuestion < 599) {
            for (Integer foundId : this.m_aIDsFound) {
                if (foundId < 500 || idInQuestion >= 599 || foundId >= idInQuestion) continue;
                result = false;
            }
        }
        if (this.m_aIDsFound.contains(idInQuestion) && idInQuestion >= 100 && idInQuestion < 200) {
            for (Integer foundId : this.m_aIDsFound) {
                if (foundId < 100 || idInQuestion >= 200 || foundId >= idInQuestion) continue;
                result = false;
            }
        }
        return result;
    }

    public ArrayList<String> getMotifNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element motif : this.m_Lmotifs) {
            try {
                if (!this.m_aIDsFound.contains(motif.getAttribute("id").getIntValue())) continue;
                result.add(motif.getAttribute("name").getValue());
            }
            catch (DataConversionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<String> getCategoryNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element motif : this.m_Lmotifs) {
            try {
                if (!this.m_aIDsFound.contains(motif.getAttribute("id").getIntValue())) continue;
                result.add(motif.getAttribute("category").getValue());
            }
            catch (DataConversionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<String> getClassNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element motif : this.m_Lmotifs) {
            try {
                if (!this.m_aIDsFound.contains(motif.getAttribute("id").getIntValue())) continue;
                result.add(motif.getAttribute("class").getValue());
            }
            catch (DataConversionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<Integer> getMotifIDs() {
        return this.m_aIDsFound;
    }

    public ArrayList<String> getMotifExplaination() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element motif : this.m_Lmotifs) {
            try {
                if (!this.m_aIDsFound.contains(motif.getAttribute("id").getIntValue())) continue;
                result.add(motif.getAttribute("comment").getValue());
            }
            catch (DataConversionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ArrayList<ResultsPerMotif> getMotifStructures() {
        return this.m_aResultsPerSequence;
    }

    private void readXMLDefinitions(String a_strFileName) throws JDOMException, IOException {
        Document doc = null;
        doc = new SAXBuilder().build(new File(a_strFileName));
        Element rootElement = doc.getRootElement();
        this.m_Lmotifs = rootElement.getChildren();
    }

    public ArrayList<String> getDefinedMotifNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element motif : this.m_Lmotifs) {
            result.add(motif.getAttribute("name").getValue());
        }
        return result;
    }

    public void submitNewMotifFile(String path) throws JDOMException, IOException {
        Document doc = null;
        doc = new SAXBuilder().build(new File(path));
        Element rootElement = doc.getRootElement();
        this.m_Lmotifs = rootElement.getChildren();
    }
}

