/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ScrollableEntryEditorPart;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;

public class MassSpecPropertyView
extends ScrollableEntryEditorPart {
    MPart part;

    @Inject
    public MassSpecPropertyView() {
    }

    @PostConstruct
    public void postConstruct(MPart part, Composite parent) {
        this.part = part;
    }

    protected void initializeComponents() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        this.getParent().setLayout((Layout)layout);
        MassSpecEntityProperty msep = (MassSpecEntityProperty)this.entry.getProperty();
        this.addEntries(this.entry.getParent());
        new Label(this.getParent(), 0).setText("Data File");
        Text file = new Text(this.getParent(), 2048);
        if (msep.getDataFile() != null) {
            file.setText(msep.getDataFile().getName());
        }
        file.setEditable(false);
        file.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(this.getParent(), 0).setText("Scan Hierarchy (if any)");
        new Label(this.getParent(), 0);
        this.addScanHierarchy();
    }

    private void addEntries(Entry e) {
        if (e.getParent() != null && !e.getProperty().getType().equals("org.grits.toolbox.property.project")) {
            this.addEntries(e.getParent());
        }
        if (!(e.getProperty() instanceof MassSpecEntityProperty)) {
            String type = e.getProperty().getType();
            String label = type.substring(type.lastIndexOf(".") + 1);
            new Label(this.getParent(), 0).setText(label.toUpperCase());
            Text text = new Text(this.getParent(), 2048);
            text.setText(e.getDisplayName());
            text.setEditable(false);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
    }

    private void addScanHierarchy() {
        TreeViewer scanTree = new TreeViewer(this.getParent());
        scanTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof ScanEntry) {
                    return ((ScanEntry)element).hasChildren();
                }
                if (element instanceof List) {
                    return ((List)element).size() > 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    return ((List)parentElement).toArray();
                }
                if (parentElement instanceof ScanEntry) {
                    return ((ScanEntry)parentElement).getChildren().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        scanTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ScanEntry) {
                    return ((ScanEntry)element).getDisplayName();
                }
                return super.getText(element);
            }
        });
        ArrayList<ScanEntry> scanEntries = new ArrayList<ScanEntry>();
        this.createScanHierarchy(this.entry, scanEntries);
        scanTree.setInput(scanEntries);
        scanTree.getTree().setLayoutData((Object)new GridData(4, 4, true, false, 2, 4));
        scanTree.expandAll();
    }

    private void createScanHierarchy(Entry e, List<ScanEntry> scanEntries) {
        if (e.getParent() != null && e.getParent().getProperty() instanceof MassSpecEntityProperty) {
            ScanEntry parentEntry = new ScanEntry();
            parentEntry.setDisplayName(e.getParent().getDisplayName());
            scanEntries.add(parentEntry);
            ScanEntry newEntry = this.findEntry(scanEntries, e.getDisplayName());
            if (newEntry == null) {
                newEntry = new ScanEntry();
                newEntry.setDisplayName(e.getDisplayName());
            } else {
                scanEntries.remove(newEntry);
            }
            parentEntry.addChild(newEntry);
            this.createScanHierarchy(e.getParent(), scanEntries);
        }
    }

    private ScanEntry findEntry(List<ScanEntry> scanEntries, String displayName) {
        for (ScanEntry scanEntry : scanEntries) {
            if (!scanEntry.getDisplayName().equals(displayName)) continue;
            return scanEntry;
        }
        return null;
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    class ScanEntry {
        String displayName;
        List<ScanEntry> children = new ArrayList<ScanEntry>();

        ScanEntry() {
        }

        protected void addChild(ScanEntry e) {
            this.children.add(e);
        }

        public List<ScanEntry> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

