/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;

@XmlRootElement(name="massSpecCustomAnnotation")
public class MassSpecCustomAnnotationTemplate {
    private static final Logger logger = Logger.getLogger(MassSpecCustomAnnotationTemplate.class);
    protected String sAnnotationName = null;
    protected String sDescription = null;
    protected Integer iMSLevel = null;
    protected Double dMassTolerance = null;
    protected Boolean bIsPPM = null;
    private List<MassSpecCustomAnnotationPeak> annotatedPeaks = null;

    public MassSpecCustomAnnotationTemplate() {
    }

    public MassSpecCustomAnnotationTemplate(String sAnnotationName, String sDescription, Integer iMSLevel, Double dMassTolerance, Boolean bIsPPM) {
        this.sAnnotationName = sAnnotationName;
        this.sDescription = sDescription;
        this.iMSLevel = iMSLevel;
        this.dMassTolerance = dMassTolerance;
        this.bIsPPM = bIsPPM;
        this.annotatedPeaks = new ArrayList<MassSpecCustomAnnotationPeak>();
    }

    public String toString() {
        return String.valueOf(this.getAnnotationName()) + ", num peaks: " + this.getMassSpecCustomAnnotationPeaks().size();
    }

    public String getAnnotationName() {
        return this.sAnnotationName;
    }

    @XmlAttribute(name="annotationName")
    public void setAnnotationName(String sAnnotationName) {
        this.sAnnotationName = sAnnotationName;
    }

    public String getDescription() {
        return this.sDescription;
    }

    @XmlAttribute(name="description")
    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public Integer getMSLevel() {
        return this.iMSLevel;
    }

    @XmlAttribute(name="msLevel")
    public void setMSLevel(Integer iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    public Double getMassTolerance() {
        return this.dMassTolerance;
    }

    @XmlAttribute(name="massTolerance")
    public void setMassTolerance(Double dMassTolerance) {
        this.dMassTolerance = dMassTolerance;
    }

    public Boolean getIsPPM() {
        return this.bIsPPM;
    }

    @XmlAttribute(name="isPPM")
    public void setIsPPM(Boolean bIsPPM) {
        this.bIsPPM = bIsPPM;
    }

    public MassSpecCustomAnnotation getNewAnnotation() {
        return new MassSpecCustomAnnotation();
    }

    private List<MassSpecCustomAnnotationPeak> getMassSpecCustomAnnotationPeaks() {
        return this.annotatedPeaks;
    }

    @XmlElement(name="massSpecCustomAnnotationPeaks")
    private void setMassSpecCustomAnnotationPeaks(List<MassSpecCustomAnnotationPeak> annotatedPeaks) {
        this.annotatedPeaks = annotatedPeaks;
    }

    private void setMassSpecCustomAnnotationPeaks(MassSpecCustomAnnotation annotation) {
        annotation.setAnnotatedPeaks(new HashMap<Double, MassSpecCustomAnnotationPeak>());
        for (MassSpecCustomAnnotationPeak peak : this.getMassSpecCustomAnnotationPeaks()) {
            annotation.getAnnotatedPeaks().put(peak.getPeakMz(), peak);
        }
    }

    protected void setAnnotationPeaks(MassSpecCustomAnnotation annotation) {
        this.setMassSpecCustomAnnotationPeaks(annotation);
    }

    private void setMassSpecCustomTemplatePeaks(MassSpecCustomAnnotation annotation) {
        this.setMassSpecCustomAnnotationPeaks(new ArrayList<MassSpecCustomAnnotationPeak>());
        for (Double dMz : annotation.getAnnotatedPeaks().keySet()) {
            MassSpecCustomAnnotationPeak peak = annotation.getAnnotatedPeaks().get(dMz);
            this.getMassSpecCustomAnnotationPeaks().add(peak);
        }
    }

    protected void setTemplatePeaks(MassSpecCustomAnnotation annotation) {
        this.setMassSpecCustomTemplatePeaks(annotation);
    }

    public MassSpecCustomAnnotation copyToNewAnnotation() {
        MassSpecCustomAnnotation annotation = this.getNewAnnotation();
        annotation.setAnnotationName(this.getAnnotationName());
        annotation.setDescription(this.getDescription());
        annotation.setIsPPM(this.getIsPPM());
        annotation.setMassTolerance(this.getMassTolerance());
        annotation.setMSLevel(this.getMSLevel());
        this.setAnnotationPeaks(annotation);
        return annotation;
    }

    public static MassSpecCustomAnnotationTemplate unmarshalAnnotationTemplate(String xmlFile) {
        MassSpecCustomAnnotationTemplate annotationTemplate = (MassSpecCustomAnnotationTemplate)XMLUtils.unmarshalObjectXML((String)xmlFile, MassSpecCustomAnnotationTemplate.class);
        return annotationTemplate;
    }

    public static String marshalAnnotatedTemplate(MassSpecCustomAnnotationTemplate annotationTemplate) {
        String sAnnotationText = XMLUtils.marshalObjectXML((Object)annotationTemplate);
        return sAnnotationText;
    }
}

