/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.dialog.MassSpecCustomAnnotationModifyDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecViewerDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationsPreferenceUI;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecCustomAnnotationDialog
extends MassSpecViewerDialog
implements IPropertyChangeListener,
IDynamicTableProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecCustomAnnotationDialog.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    protected Text txtOutput;
    protected static final String PARAMS_OK = "Valid parameters";
    protected GridLayout gridLayout = null;
    protected Label lblSelectAnnotation = null;
    protected Combo cmbSelectAnnotation = null;
    protected MassSpecCustomAnnotation selAnnot = null;
    protected Button btnApplyFilter = null;
    protected Button btnModifyList = null;
    protected Button btnClearCustomAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation storedAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation localAnnotations = null;
    protected IMSPreferenceWithCustomAnnotation entryAnnotations = null;
    protected MassSpecCustomAnnotationModifyDialog win = null;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    public static final String ANNOTATION_APPLIED = "# ";
    public static final String ANNOTATION_DIRTY = "* ";
    public static final String LOCAL_ANNOTATION_CURRENT_ENTRY = " (current entry only)";
    public static final String LOCAL_ANNOTATION_DIFFERS = " (differs from preferences)";

    public MassSpecCustomAnnotationDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell, contextViewer);
        this.setShellStyle(18528);
        this.initStoredAnnotations();
    }

    protected void initLocalAnnotations() {
        this.localAnnotations = new MassSpecPreference();
        MassSpecCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.getMassSpecEntry(), this.localAnnotations);
        this.entryAnnotations = new MassSpecPreference();
        MassSpecCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.getMassSpecEntry(), this.entryAnnotations);
    }

    public void setLocalAnnotations(IMSPreferenceWithCustomAnnotation localAnnotations) {
        this.localAnnotations = localAnnotations;
    }

    public IMSPreferenceWithCustomAnnotation getLocalAnnotations() {
        return this.localAnnotations;
    }

    public IMSPreferenceWithCustomAnnotation getEntryAnnotations() {
        return this.entryAnnotations;
    }

    public void setEntryAnnotations(IMSPreferenceWithCustomAnnotation entryAnnotations) {
        this.entryAnnotations = entryAnnotations;
    }

    public void initStoredAnnotations() {
        this.storedAnnotations = MassSpecCustomAnnotationsPreferenceUI.loadWorkspacePreferences();
    }

    public IMSPreferenceWithCustomAnnotation getStoredAnnotations() {
        return this.storedAnnotations;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void initGridLayout() {
        this.gridLayout = new GridLayout(4, false);
    }

    private void addSelectAnnotationItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblSelectAnnotation = new Label(parent, 0);
        this.lblSelectAnnotation.setText("Current Custom Annotations");
        this.lblSelectAnnotation.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        this.cmbSelectAnnotation = new Combo(parent, 0);
        this.cmbSelectAnnotation.setLayoutData((Object)gd2);
        this.initLocalAnnotations();
        this.initStoredAnnotationsList();
        this.cmbSelectAnnotation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean bVal = false;
                if (!MassSpecCustomAnnotationDialog.this.cmbSelectAnnotation.getText().trim().equals("")) {
                    MassSpecCustomAnnotationDialog.this.setCurrentAnnotationValues(MassSpecCustomAnnotationDialog.this.cmbSelectAnnotation.getText());
                    bVal = true;
                }
                MassSpecCustomAnnotationDialog.this.btnClearCustomAnnotations.setEnabled(bVal);
                MassSpecCustomAnnotationDialog.this.btnApplyFilter.setEnabled(bVal);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        Label dummy = new Label(parent, 0);
        dummy.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, false, 4, 1);
        Label dummy2 = new Label(parent, 0);
        dummy2.setLayoutData((Object)gd4);
    }

    protected boolean hasLocalChanges(String selAnnotName) {
        return selAnnotName.endsWith(LOCAL_ANNOTATION_CURRENT_ENTRY) || selAnnotName.endsWith(LOCAL_ANNOTATION_DIFFERS);
    }

    protected void setCurrentAnnotationValues(String selAnnotName) {
        this.selAnnot = null;
        if (selAnnotName == null) {
            return;
        }
        MassSpecCustomAnnotation prefAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, this.getStoredAnnotations());
        MassSpecCustomAnnotation localAnnot = MassSpecCustomAnnotationDialog.getCurrentAnnot(selAnnotName, this.getLocalAnnotations());
        this.selAnnot = selAnnotName.endsWith(LOCAL_ANNOTATION_CURRENT_ENTRY) || selAnnotName.endsWith(LOCAL_ANNOTATION_DIFFERS) ? localAnnot : prefAnnot;
    }

    public static boolean isTempAnnotationForSelectedItem(String selAnnotName, MassSpecCustomAnnotation curAnnot) {
        if (curAnnot.getAnnotationName().equals(selAnnotName)) {
            return true;
        }
        String sCompareTo = String.valueOf(curAnnot.getAnnotationName()) + LOCAL_ANNOTATION_DIFFERS;
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_APPLIED + curAnnot.getAnnotationName();
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_APPLIED + curAnnot.getAnnotationName() + LOCAL_ANNOTATION_CURRENT_ENTRY;
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_APPLIED + curAnnot.getAnnotationName() + LOCAL_ANNOTATION_DIFFERS;
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_DIRTY + curAnnot.getAnnotationName();
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_DIRTY + curAnnot.getAnnotationName() + LOCAL_ANNOTATION_CURRENT_ENTRY;
        if (sCompareTo.equals(selAnnotName)) {
            return true;
        }
        sCompareTo = ANNOTATION_DIRTY + curAnnot.getAnnotationName() + LOCAL_ANNOTATION_DIFFERS;
        return sCompareTo.equals(selAnnotName);
    }

    public static MassSpecCustomAnnotation getCurrentAnnot(String selAnnotName, IMSPreferenceWithCustomAnnotation preferences) {
        MassSpecCustomAnnotation retAnnot = null;
        if (preferences != null && preferences.getCustomAnnotations() != null) {
            int i = 0;
            while (i < preferences.getCustomAnnotations().size()) {
                MassSpecCustomAnnotation curAnnot = preferences.getCustomAnnotations().get(i);
                if (curAnnot != null && MassSpecCustomAnnotationDialog.isTempAnnotationForSelectedItem(selAnnotName, curAnnot)) {
                    retAnnot = curAnnot;
                }
                ++i;
            }
        }
        return retAnnot;
    }

    public static void setComboEntryForTempAnnotation(MassSpecCustomAnnotation annot, Combo cmbSelectAnnotation, List<MassSpecCustomAnnotation> entryAnnotations, List<MassSpecCustomAnnotation> storedPrefAnnotations) {
        int inx = cmbSelectAnnotation.indexOf(annot.getAnnotationName());
        String sDisplayAs = "";
        if (inx == -1) {
            MassSpecCustomAnnotation entryCA = null;
            if (entryAnnotations != null) {
                int i = 0;
                while (i < entryAnnotations.size()) {
                    MassSpecCustomAnnotation curCA = entryAnnotations.get(i);
                    if (annot.equals(curCA)) {
                        entryCA = curCA;
                        break;
                    }
                    ++i;
                }
            }
            String sStartWith = ANNOTATION_DIRTY;
            if (entryCA != null && !annot.differsFrom(entryCA)) {
                sStartWith = ANNOTATION_APPLIED;
            }
            sDisplayAs = String.valueOf(sStartWith) + annot.getAnnotationName() + LOCAL_ANNOTATION_CURRENT_ENTRY;
            cmbSelectAnnotation.add(sDisplayAs);
        } else {
            MassSpecCustomAnnotation prefAnnot = null;
            if (storedPrefAnnotations != null) {
                int i = 0;
                while (i < storedPrefAnnotations.size()) {
                    MassSpecCustomAnnotation curAnnot = storedPrefAnnotations.get(i);
                    if (annot.equals(curAnnot)) {
                        prefAnnot = curAnnot;
                        break;
                    }
                    ++i;
                }
            }
            MassSpecCustomAnnotation entryAnnot = null;
            if (entryAnnotations != null) {
                int i = 0;
                while (i < entryAnnotations.size()) {
                    MassSpecCustomAnnotation curAnnot = entryAnnotations.get(i);
                    if (annot.equals(curAnnot)) {
                        entryAnnot = curAnnot;
                        break;
                    }
                    ++i;
                }
            }
            String sStartWith = "";
            String sEndWith = "";
            if (entryAnnot != null) {
                sStartWith = ANNOTATION_APPLIED;
                if (entryAnnot.differsFrom(annot)) {
                    sStartWith = ANNOTATION_DIRTY;
                }
                if (prefAnnot == null) {
                    sEndWith = LOCAL_ANNOTATION_CURRENT_ENTRY;
                    if (entryAnnot.differsFrom(annot)) {
                        sEndWith = LOCAL_ANNOTATION_DIFFERS;
                    }
                } else {
                    boolean bDiffersFromPref = entryAnnot.differsFrom(prefAnnot);
                    boolean bDiffersFromLocal = entryAnnot.differsFrom(annot);
                    if (bDiffersFromPref && !bDiffersFromLocal) {
                        sEndWith = LOCAL_ANNOTATION_DIFFERS;
                    } else if (bDiffersFromLocal) {
                        sEndWith = LOCAL_ANNOTATION_DIFFERS;
                    }
                }
            } else if (prefAnnot == null) {
                sEndWith = LOCAL_ANNOTATION_CURRENT_ENTRY;
            } else if (annot.differsFrom(prefAnnot)) {
                sEndWith = LOCAL_ANNOTATION_DIFFERS;
            }
            sDisplayAs = String.valueOf(sStartWith) + annot.getAnnotationName() + sEndWith;
            cmbSelectAnnotation.remove(inx);
            cmbSelectAnnotation.add(sDisplayAs);
        }
    }

    public void initStoredAnnotationsList() {
        int iItemCount;
        MassSpecCustomAnnotation annot;
        int i;
        String sToSelect = "";
        if (this.cmbSelectAnnotation.getItems().length != 0) {
            this.cmbSelectAnnotation.removeAll();
        }
        this.cmbSelectAnnotation.add("");
        if (this.getStoredAnnotations() != null && this.getStoredAnnotations().getCustomAnnotations() != null) {
            i = 0;
            while (i < this.getStoredAnnotations().getCustomAnnotations().size()) {
                annot = this.getStoredAnnotations().getCustomAnnotations().get(i);
                this.cmbSelectAnnotation.add(annot.getAnnotationName());
                if (this.selAnnot != null && annot.getAnnotationName().equals(this.selAnnot.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        if (this.getContextViewer() != null && this.getLocalAnnotations() != null && this.getLocalAnnotations().getCustomAnnotations() != null) {
            i = 0;
            while (i < this.getLocalAnnotations().getCustomAnnotations().size()) {
                annot = this.getLocalAnnotations().getCustomAnnotations().get(i);
                MassSpecCustomAnnotationDialog.setComboEntryForTempAnnotation(annot, this.cmbSelectAnnotation, this.entryAnnotations.getCustomAnnotations(), this.storedAnnotations.getCustomAnnotations());
                if (this.selAnnot != null && annot.getAnnotationName().equals(this.selAnnot.getAnnotationName())) {
                    iItemCount = this.cmbSelectAnnotation.getItemCount();
                    sToSelect = this.cmbSelectAnnotation.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        int iPrevSelInx = this.cmbSelectAnnotation.indexOf(sToSelect);
        this.cmbSelectAnnotation.select(iPrevSelInx);
    }

    protected void clearAnnotation() {
        MassSpecEntityProperty ep = (MassSpecEntityProperty)this.getMassSpecEntry().getProperty();
        MassSpecProperty prop = (MassSpecProperty)ep.getParentProperty();
        MassSpecMetaData msSettings = prop.getMassSpecMetaData();
        this.setCurrentAnnotationValues(this.cmbSelectAnnotation.getText().trim());
        try {
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            if (msSettings.getCustomAnnotations().contains(this.selAnnot)) {
                msSettings.getCustomAnnotations().remove(this.selAnnot);
            }
            msSettings.updateCustomAnotationData();
            prop.updateMSSettings(msSettings, sFileName);
            this.initLocalAnnotations();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.updateViewer(null);
            this.initStoredAnnotationsList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void addClearAnnotations(Composite parent) {
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        this.btnClearCustomAnnotations = new Button(parent, 0);
        this.btnClearCustomAnnotations.setText("Clear Annotated Peaks");
        this.btnClearCustomAnnotations.setLayoutData((Object)gd3);
        this.btnClearCustomAnnotations.setEnabled(false);
        this.btnClearCustomAnnotations.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecCustomAnnotationDialog.this.clearAnnotation();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void performAnnotation() {
        MassSpecEntityProperty ep = (MassSpecEntityProperty)this.getMassSpecEntry().getProperty();
        MassSpecProperty prop = (MassSpecProperty)ep.getParentProperty();
        MassSpecMetaData msSettings = prop.getMassSpecMetaData();
        this.setCurrentAnnotationValues(this.cmbSelectAnnotation.getText());
        try {
            if (msSettings.getCustomAnnotations().contains(this.selAnnot)) {
                msSettings.getCustomAnnotations().remove(this.selAnnot);
            }
            if (this.selAnnot != null) {
                msSettings.getCustomAnnotations().add(this.selAnnot);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateCustomAnotationData();
            prop.updateMSSettings(msSettings, sFileName);
            this.initLocalAnnotations();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            List<String> sKeyVals = this.getColumnKeyLabels();
            this.updateViewer(sKeyVals);
            this.initStoredAnnotationsList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void addFilterItem(Composite parent) {
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        this.btnApplyFilter = new Button(parent, 0);
        this.btnApplyFilter.setText("Annotate Peaks");
        this.btnApplyFilter.setLayoutData((Object)gd3);
        this.btnApplyFilter.setEnabled(false);
        this.btnApplyFilter.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecCustomAnnotationDialog.this.performAnnotation();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void modifyAnnotations() {
        MassSpecMultiPageViewer curView = this.getCurrentViewer();
        if (curView == null) {
            return;
        }
        Entry msEntry = curView.getEntry();
        if (msEntry == null) {
            return;
        }
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MassSpecEntityProperty) {
            if (this.win == null) {
                this.win = new MassSpecCustomAnnotationModifyDialog(this.getShell(), curView);
                this.win.setLocalAnnotations(this.getLocalAnnotations());
                this.win.setEntryAnnotations(this.getEntryAnnotations());
                this.win.setSelectedAnnotation(this.cmbSelectAnnotation.getText());
                this.win.addListener(this);
                this.win.open();
            } else {
                this.win.getShell().forceActive();
            }
            return;
        }
    }

    private void addAdvancedItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 4, 1);
        this.btnModifyList = new Button(parent, 0);
        this.btnModifyList.setText("Modify Annotations");
        this.btnModifyList.setLayoutData((Object)gd1);
        this.btnModifyList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecCustomAnnotationDialog.this.modifyAnnotations();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public int open() {
        Entry entry = this.getEntryForCurrentViewer();
        if (entry == null) {
            return -1;
        }
        this.setMassSpecEntry(entry);
        super.create();
        this.getShell().open();
        this.getShell().layout();
        this.getShell().pack();
        return this.getReturnCode();
    }

    protected boolean isResizable() {
        return true;
    }

    protected String getFormTitle() {
        return "Mass Spec Custom Annotation";
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getFormTitle());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        this.initGridLayout();
        container.setLayout((Layout)this.gridLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.addSelectAnnotationItem(container);
        this.addClearAnnotations(container);
        this.addFilterItem(container);
        this.addAdvancedItem(container);
        container.addPaintListener((PaintListener)new CustomAnnotationPaintListener(this));
        return area;
    }

    protected String getAnnotationLabelText() {
        return "MS Annotation";
    }

    public void validateInput() {
        this.txtOutput.setText(PARAMS_OK);
        if (this.getMassSpecEntry() == null) {
            this.txtOutput.setText("Please select Mass Spec Results");
        }
    }

    public boolean close() {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_WIN_CLOSED, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        return super.close();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof MassSpecCustomAnnotationModifyDialog) {
            if (event.getProperty().equals("Local changes")) {
                this.initStoredAnnotationsList();
            } else if (event.getProperty().equals("Apply pressed")) {
                this.initStoredAnnotations();
                this.initStoredAnnotationsList();
            } else if (event.getProperty().equals(PROPERTY_WIN_CLOSED)) {
                this.win = null;
            }
        }
    }

    protected void updateViewer(List<String> sKeyVals) {
        try {
            MassSpecMultiPageViewer viewer = this.getCurrentViewer();
            viewer.reLoadScansTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getColumnKeyLabels() {
        if (this.selAnnot == null) {
            return null;
        }
        ArrayList<String> keyVals = new ArrayList<String>();
        if (this.selAnnot != null && this.selAnnot.getAnnotatedPeaks() != null) {
            for (MassSpecCustomAnnotationPeak peak : this.selAnnot.getAnnotatedPeaks().values()) {
                keyVals.add(Double.toString(peak.getPeakMz()));
            }
        }
        return keyVals;
    }

    public class CustomAnnotationPaintListener
    implements PaintListener {
        MassSpecCustomAnnotationDialog parent = null;

        public CustomAnnotationPaintListener(MassSpecCustomAnnotationDialog parent) {
            this.parent = parent;
        }

        public void paintControl(PaintEvent e) {
            Entry entry = MassSpecCustomAnnotationDialog.this.getEntryForCurrentViewer();
            if (entry != null && !entry.equals(this.parent.getMassSpecEntry())) {
                this.parent.setMassSpecEntry(entry);
                MassSpecCustomAnnotationDialog.this.initLocalAnnotations();
                this.parent.initStoredAnnotationsList();
            }
        }
    }
}

