/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.pdfgeneration;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.ViewInput;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.handler.ExperimentDesignReportHandler;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Column;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.PDFGenerator;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.ProjectReportPage;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Table;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.TableBuilder;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class ExperimentDesignRDFReport {
    private static final Logger logger = Logger.getLogger(ExperimentDesignRDFReport.class);
    public static final PDRectangle PAGE_SIZE = PDPage.PAGE_SIZE_LETTER;
    public static final float MARGIN = 40.0f;
    public static final boolean IS_LANDSCAPE = false;
    public static final PDFont TEXT_FONT = PDType1Font.HELVETICA;
    public static final PDFont BOLD_FONT = PDType1Font.HELVETICA_BOLD;
    public static final float FONT_SIZE = 12.0f;
    public static final float CELL_MARGIN = 2.0f;
    public static float LENGTH = PDPage.PAGE_SIZE_LETTER.getHeight() - 80.0f;
    PDDocument document;
    float yIndex = LENGTH;

    public void generateDocument(ExperimentDesignReportHandler.Options options, GraphEditor editor) {
        this.document = new PDDocument();
        try {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof ViewInput) {
                Entry entry = ((ViewInput)input).getEntry();
                Entry projectEntry = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
                if (options != null && options.getProject().booleanValue()) {
                    ProjectReportPage.addProjectPage(projectEntry, (ProjectProperty)projectEntry.getProperty(), this.document, this.yIndex);
                }
                Sample sample = SampleProperty.loadAnalyte((Entry)DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.sample"));
                if (options != null && options.getSample().booleanValue()) {
                    this.addSampleInformation(sample);
                }
                ExperimentGraph model = editor.getModel();
                if (options != null && options.getExpDesign().booleanValue()) {
                    this.addExperimentDesignerInformation(editor, model);
                }
                this.addFooter();
                FileDialog fileDialog = new FileDialog(editor.getSite().getShell(), 8192);
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{"*.pdf"});
                fileDialog.setFilterNames(new String[]{"PDF (*.pdf)"});
                fileDialog.setFileName(String.valueOf(model.getName()) + "-experimentdesign.pdf");
                fileDialog.setOverwrite(true);
                String selected = fileDialog.open();
                if (selected != null) {
                    this.document.save(selected);
                }
                this.document.close();
            }
        }
        catch (IOException | JAXBException | COSVisitorException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot generate report!", e);
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"PDF Report cannot be generated! Please check the log file");
        }
    }

    private void addExperimentDesignerInformation(GraphEditor editor, ExperimentGraph model) throws IOException {
        PDPageContentStream contentStream;
        BufferedImage imageForPDF = editor.getBufferedImage();
        PDPixelMap ximage = new PDPixelMap(this.document, imageForPDF);
        PDPage page = new PDPage(PDPage.PAGE_SIZE_LETTER);
        PDRectangle mediabox = page.findMediaBox();
        float pageWidth = mediabox.getWidth();
        this.document.addPage(page);
        this.yIndex = LENGTH;
        this.yIndex = PDFGenerator.writeSimpleText(this.document, page, "Experiment Graph", BOLD_FONT, 12.0f, 40.0f, this.yIndex);
        float x = PDFGenerator.writeTextOnTheSameLine(this.document, page, "Date Created:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
        this.yIndex = PDFGenerator.writeSimpleText(this.document, page, model.getDateCreated().toString(), TEXT_FONT, 12.0f, x, this.yIndex);
        if (model.getDescription() != null && model.getDescription().length() > 0) {
            x = PDFGenerator.writeTextOnTheSameLine(this.document, page, "Description:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
            this.yIndex = PDFGenerator.drawMultilineString(this.document, page, TEXT_FONT, 12.0f, model.getDescription(), this.yIndex, x, LENGTH);
            page = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
        }
        Dimension size = model.calculateSize();
        float xscale = (pageWidth - 80.0f) / (float)size.width;
        float yscale = (LENGTH - 80.0f) / (float)size.height;
        float scale = Math.min(xscale, yscale);
        if (this.yIndex - 80.0f < (float)size.height * scale) {
            page = new PDPage(PDPage.PAGE_SIZE_LETTER);
            this.document.addPage(page);
            this.yIndex = LENGTH;
            contentStream = new PDPageContentStream(this.document, page, true, true);
            contentStream.drawXObject((PDXObject)ximage, 40.0f, 40.0f, (float)size.width * scale, (float)size.height * scale);
            contentStream.close();
        } else {
            contentStream = new PDPageContentStream(this.document, page, true, true);
            contentStream.drawXObject((PDXObject)ximage, 40.0f, LENGTH - this.yIndex + 40.0f, (float)size.width * scale, (float)size.height * scale);
            contentStream.close();
        }
        if (model.getChildren() != null) {
            for (GraphNode node : model.getChildren()) {
                if (!(node instanceof ProtocolNode)) continue;
                PDPage protocolPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
                this.document.addPage(protocolPage);
                this.yIndex = LENGTH;
                x = PDFGenerator.writeTextOnTheSameLine(this.document, protocolPage, "Protocol", BOLD_FONT, 12.0f, 40.0f, this.yIndex, false);
                this.yIndex = PDFGenerator.writeSimpleText(this.document, protocolPage, ((ProtocolNode)node).getLabel(), BOLD_FONT, 12.0f, x, this.yIndex);
                if (((ProtocolNode)node).getCreator() != null) {
                    x = PDFGenerator.writeTextOnTheSameLine(this.document, protocolPage, "Created By:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                    this.yIndex = PDFGenerator.writeSimpleText(this.document, protocolPage, ((ProtocolNode)node).getCreator(), TEXT_FONT, 12.0f, x, this.yIndex);
                }
                if (node.getDescription() != null && node.getDescription().length() > 0) {
                    x = PDFGenerator.writeTextOnTheSameLine(this.document, protocolPage, "Description:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                    this.yIndex = PDFGenerator.drawMultilineString(this.document, protocolPage, TEXT_FONT, 12.0f, node.getDescription(), this.yIndex, x, LENGTH);
                    protocolPage = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
                }
                this.addParameterTable((ProtocolNode)node);
                this.addPapers((ProtocolNode)node);
                protocolPage = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
            }
        }
    }

    private void addParameterTable(ProtocolNode node) throws IOException {
        PDPage page = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("Parameter/Parameter Group", 200.0f));
        columns.add(new Column("Value", 200.0f));
        columns.add(new Column("Unit", 100.0f));
        int tableSize = 0;
        if (node.getParameterGroups() != null) {
            tableSize += node.getParameterGroups().size();
            for (ParameterGroup group : node.getParameterGroups()) {
                tableSize += group.getParameters().size();
            }
        }
        if (node.getParameters() != null) {
            tableSize += node.getParameters().size();
        }
        String[][] content = new String[tableSize][3];
        int row = 0;
        float maxRowHeight = 15.0f;
        if (node.getParameterGroups() != null) {
            for (ParameterGroup group : node.getParameterGroups()) {
                content[row][0] = group.getLabel();
                content[row][1] = "";
                content[row++][2] = "";
                List<Parameter> parameters = group.getParameters();
                for (Parameter parameter : parameters) {
                    content[row][0] = "     " + parameter.getName();
                    if (parameter.getValue() != null) {
                        content[row][1] = parameter.getValue();
                        maxRowHeight = Math.max(PDFGenerator.calculateRowHeight(parameter.getValue(), 200, TEXT_FONT, 12.0f, 2.0f), maxRowHeight);
                    } else {
                        content[row][1] = "";
                    }
                    content[row][2] = parameter.getUnit() != null ? parameter.getUnit().getLabel() : "";
                    ++row;
                }
            }
        }
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                content[row][0] = parameter.getName();
                if (parameter.getValue() != null) {
                    content[row][1] = parameter.getValue();
                    maxRowHeight = Math.max(PDFGenerator.calculateRowHeight(parameter.getValue(), 200, TEXT_FONT, 12.0f, 2.0f), maxRowHeight);
                } else {
                    content[row][1] = "";
                }
                content[row][2] = parameter.getUnit() != null ? parameter.getUnit().getLabel() : "";
                ++row;
            }
        }
        float tableHeight = this.yIndex - 80.0f;
        float tableMaxHeight = PAGE_SIZE.getHeight() - 80.0f;
        Table table = new TableBuilder().setCellMargin(2.0f).setColumns(columns).setContent(content).setHeight(tableHeight).setMaxHeight(tableMaxHeight).setNumberOfRows(content.length).setRowHeight(15.0f).setMargin(40.0f).setPageSize(PAGE_SIZE).setLandscape(false).setTextFont(TEXT_FONT).setHeaderFont(BOLD_FONT).setFontSize(12.0f).setMaxRowHeight(maxRowHeight).build();
        PDFGenerator tableGenerator = new PDFGenerator();
        this.yIndex = tableGenerator.drawTable(this.document, page, table, true, this.yIndex);
    }

    public void addPapers(ProtocolNode node) throws IOException {
        if (node.getPapers() != null && node.getPapers().size() > 0) {
            PDPage page = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
            this.yIndex = PDFGenerator.writeSimpleText(this.document, page, "Papers", BOLD_FONT, 12.0f, 40.0f, this.yIndex - 10.0f);
            for (Paper paper : node.getPapers()) {
                this.yIndex = PDFGenerator.drawMultilineString(this.document, page, TEXT_FONT, 12.0f, paper.toString(), this.yIndex, 40.0f, LENGTH);
                if (this.yIndex != LENGTH) {
                    this.yIndex -= 20.0f;
                }
                page = (PDPage)this.document.getDocumentCatalog().getAllPages().get(this.document.getNumberOfPages() - 1);
            }
        }
    }

    private void addSampleInformation(Sample sample) {
        try {
            PDPage page = new PDPage(PDPage.PAGE_SIZE_LETTER);
            this.document.addPage(page);
            this.yIndex = LENGTH;
            this.yIndex = PDFGenerator.writeSimpleText(this.document, page, "Analyte", BOLD_FONT, 12.0f, 40.0f, this.yIndex);
            float x = PDFGenerator.writeTextOnTheSameLine(this.document, page, "Name:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
            this.yIndex = PDFGenerator.writeSimpleText(this.document, page, sample.getName(), TEXT_FONT, 12.0f, x, this.yIndex);
            if (sample.getDescription() != null && !sample.getDescription().isEmpty()) {
                x = PDFGenerator.writeTextOnTheSameLine(this.document, page, "Description:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                this.yIndex = PDFGenerator.drawMultilineString(this.document, page, TEXT_FONT, 12.0f, sample.getDescription(), this.yIndex, x, LENGTH);
            }
            this.yIndex = PDFGenerator.writeSimpleText(this.document, page, "List of Components: ", BOLD_FONT, 12.0f, 40.0f, this.yIndex);
            int componentNumber = 1;
            for (Component comp : sample.getComponents()) {
                x = PDFGenerator.writeTextOnTheSameLine(this.document, page, String.valueOf(componentNumber++) + ". ", TEXT_FONT, 12.0f, 40.0f, this.yIndex, false);
                this.yIndex = PDFGenerator.writeSimpleText(this.document, page, comp.getLabel(), TEXT_FONT, 12.0f, x, this.yIndex);
            }
            componentNumber = 1;
            for (Component comp : sample.getComponents()) {
                PDPage componentPage = new PDPage(PDPage.PAGE_SIZE_LETTER);
                this.document.addPage(componentPage);
                this.yIndex = LENGTH;
                this.yIndex = PDFGenerator.writeSimpleText(this.document, componentPage, "Component" + componentNumber++, BOLD_FONT, 12.0f, 40.0f, this.yIndex);
                x = PDFGenerator.writeTextOnTheSameLine(this.document, componentPage, "Name:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                this.yIndex = PDFGenerator.writeSimpleText(this.document, componentPage, comp.getLabel(), TEXT_FONT, 12.0f, x, this.yIndex);
                if (comp.getDescription() != null && !comp.getDescription().isEmpty()) {
                    x = PDFGenerator.writeTextOnTheSameLine(this.document, componentPage, "Description:", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                    this.yIndex = PDFGenerator.drawMultilineString(this.document, componentPage, TEXT_FONT, 12.0f, comp.getDescription(), this.yIndex, x, LENGTH);
                }
                if (comp.getTemplateUri() != null) {
                    x = PDFGenerator.writeTextOnTheSameLine(this.document, componentPage, "Template: ", TEXT_FONT, 12.0f, 40.0f, this.yIndex, true);
                    this.yIndex = PDFGenerator.writeSimpleText(this.document, componentPage, comp.getTemplateUri(), TEXT_FONT, 12.0f, x, this.yIndex);
                }
                Category sampleInformation = comp.getSampleInformation();
                this.yIndex = this.writeCategoryInComponentPage(sampleInformation, this.document, componentPage, this.yIndex);
                Category tracking = comp.getTracking();
                this.yIndex = this.writeCategoryInComponentPage(tracking, this.document, componentPage, this.yIndex);
                Category amount = comp.getAmount();
                this.yIndex = this.writeCategoryInComponentPage(amount, this.document, componentPage, this.yIndex);
                Category purityQC = comp.getPurityQC();
                this.yIndex = this.writeCategoryInComponentPage(purityQC, this.document, componentPage, this.yIndex);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"Sample Information could not be added to the document successfully.");
        }
    }

    private float writeCategoryInComponentPage(Category category, PDDocument document, PDPage componentPage, float yIndex) throws IOException {
        try {
            if (!category.getDescriptors().isEmpty() || !category.getDescriptorGroups().isEmpty()) {
                ArrayList<Column> columns = new ArrayList<Column>();
                columns.add(new Column("Descriptor/Descriptor Group", 250.0f));
                columns.add(new Column("Value", 150.0f));
                columns.add(new Column("Unit", 150.0f));
                int tableSize = category.getDescriptors().size();
                for (DescriptorGroup dg : category.getDescriptorGroups()) {
                    int sum = 1 + dg.getMandatoryDescriptors().size() + dg.getOptionalDescriptors().size();
                    tableSize += sum;
                }
                String[][] content = new String[tableSize][3];
                int row = 0;
                float maxRowHeight = 15.0f;
                for (Descriptor desc : category.getDescriptors()) {
                    maxRowHeight = this.writeDescriptorRow(desc, content, row, maxRowHeight);
                    ++row;
                }
                for (DescriptorGroup dg : category.getDescriptorGroups()) {
                    content[row][0] = dg.getLabel();
                    content[row][1] = "";
                    content[row][2] = "";
                    ++row;
                    for (Descriptor desc : dg.getMandatoryDescriptors()) {
                        maxRowHeight = this.writeDescriptorRow(desc, content, row, maxRowHeight);
                        ++row;
                    }
                    for (Descriptor desc : dg.getOptionalDescriptors()) {
                        maxRowHeight = this.writeDescriptorRow(desc, content, row, maxRowHeight);
                        ++row;
                    }
                }
                float tableHeight = yIndex - 80.0f;
                float tableMaxHeight = PAGE_SIZE.getHeight() - 80.0f;
                Table table = ExperimentDesignRDFReport.createTable(columns, content, tableHeight, tableMaxHeight, maxRowHeight);
                PDFGenerator tableGenerator = new PDFGenerator();
                if (yIndex - 40.0f - 15.0f * (float)(content.length + 1) > 0.0f) {
                    float x = PDFGenerator.writeTextOnTheSameLine(document, componentPage, "Category:", TEXT_FONT, 12.0f, 40.0f, yIndex -= 10.0f, true);
                    yIndex = PDFGenerator.writeSimpleText(document, componentPage, this.getCategoryLabel(category.getUri()), BOLD_FONT, 12.0f, x, yIndex);
                    yIndex = tableGenerator.drawTable(document, componentPage, table, true, yIndex);
                } else {
                    PDPage componentPage2 = new PDPage(PDPage.PAGE_SIZE_LETTER);
                    document.addPage(componentPage2);
                    yIndex = LENGTH;
                    float x = PDFGenerator.writeTextOnTheSameLine(document, componentPage2, "Category:", TEXT_FONT, 12.0f, 40.0f, yIndex, true);
                    yIndex = PDFGenerator.writeSimpleText(document, componentPage2, this.getCategoryLabel(category.getUri()), BOLD_FONT, 12.0f, x, yIndex);
                    tableHeight = yIndex - 80.0f;
                    tableMaxHeight = PAGE_SIZE.getHeight() - 80.0f;
                    table.setHeight(tableHeight);
                    table.setMaxHeight(tableMaxHeight);
                    yIndex = tableGenerator.drawTable(document, componentPage2, table, true, yIndex);
                }
            }
            return yIndex;
        }
        catch (IOException e) {
            logger.error((Object)("Error Generating category Information for Sample : " + category.getUri()));
            throw e;
        }
    }

    public static Table createTable(List<Column> columns, String[][] content, float tableHeight, float tableMaxHeight, float maxRowHeight) {
        return new TableBuilder().setCellMargin(2.0f).setColumns(columns).setContent(content).setHeight(tableHeight).setMaxHeight(tableMaxHeight).setNumberOfRows(content.length).setRowHeight(15.0f).setMargin(40.0f).setPageSize(PAGE_SIZE).setLandscape(false).setTextFont(TEXT_FONT).setHeaderFont(BOLD_FONT).setFontSize(12.0f).setMaxRowHeight(maxRowHeight).build();
    }

    private String getCategoryLabel(String uri) {
        switch (uri) {
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                return "Sample Information";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                return "Sample Tracking";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                return "Amount";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                return "Purity Q.C.";
            }
        }
        return null;
    }

    private float writeDescriptorRow(Descriptor desc, String[][] content, int row, float maxRowHeight) throws IOException {
        try {
            content[row][0] = desc.getLabel();
            if (desc.getValue() != null) {
                content[row][1] = desc.getValue();
                maxRowHeight = Math.max(PDFGenerator.calculateRowHeight(desc.getValue(), 150, TEXT_FONT, 12.0f, 2.0f), maxRowHeight);
                if (desc.getSelectedMeasurementUnit() != null) {
                    String selectedUnitLabel;
                    content[row][2] = selectedUnitLabel = desc.getUnitLabelFromUri(desc.getSelectedMeasurementUnit());
                    maxRowHeight = Math.max(PDFGenerator.calculateRowHeight(selectedUnitLabel, 150, TEXT_FONT, 12.0f, 2.0f), maxRowHeight);
                }
            }
            return maxRowHeight;
        }
        catch (IOException e) {
            logger.error((Object)("Error Creating Row for Descriptor : " + desc.getLabel()));
            throw e;
        }
    }

    public void addHeader(ExperimentGraph model) throws IOException {
        List pages = this.document.getDocumentCatalog().getAllPages();
        for (PDPage page : pages) {
            PDPageContentStream contentStream = new PDPageContentStream(this.document, page, true, true);
            contentStream.beginText();
            contentStream.setFont(TEXT_FONT, 10.0f);
            contentStream.moveTextPositionByAmount(40.0f, 750.0f);
            contentStream.drawString(model.getName());
            contentStream.endText();
            contentStream.close();
            if (model.getCreatedBy() == null) continue;
            contentStream = new PDPageContentStream(this.document, page, true, true);
            contentStream.beginText();
            contentStream.setFont(TEXT_FONT, 10.0f);
            contentStream.moveTextPositionByAmount(400.0f, 750.0f);
            contentStream.drawString(model.getCreatedBy());
            contentStream.endText();
            contentStream.close();
        }
    }

    public void addFooter() throws IOException {
        List pages = this.document.getDocumentCatalog().getAllPages();
        int i = 1;
        for (PDPage page : pages) {
            PDPageContentStream contentStream = new PDPageContentStream(this.document, page, true, true);
            PDRectangle mediabox = page.findMediaBox();
            float rightCorner = mediabox.getUpperRightX();
            contentStream.beginText();
            contentStream.setFont(TEXT_FONT, 10.0f);
            contentStream.moveTextPositionByAmount(rightCorner - 40.0f, 10.0f);
            contentStream.drawString(String.valueOf(i));
            contentStream.endText();
            contentStream.close();
            float leftCorner = mediabox.getLowerLeftX();
            contentStream = new PDPageContentStream(this.document, page, true, true);
            contentStream.beginText();
            contentStream.setFont(TEXT_FONT, 10.0f);
            contentStream.moveTextPositionByAmount(leftCorner + 40.0f, 10.0f);
            contentStream.drawString(new Date().toString());
            contentStream.endText();
            contentStream.close();
            ++i;
        }
    }

    public static BufferedImage SWTimageToAWTImage(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

