/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="paper-reference")
public class Paper {
    Integer pubMedId;
    String title;
    Integer year;
    String bibliographicCitation;
    List<String> authors;
    String formatedAuthor;

    @XmlElement(name="author")
    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void addAuthor(String author) {
        if (this.authors == null) {
            this.authors = new ArrayList<String>();
        }
        if (!this.authors.contains(author)) {
            this.authors.add(author);
        }
    }

    @XmlAttribute
    public Integer getPubMedId() {
        return this.pubMedId;
    }

    public void setPubMedId(Integer pubMedId) {
        this.pubMedId = pubMedId;
    }

    @XmlAttribute
    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    @XmlAttribute
    public String getFormatedAuthor() {
        return this.formatedAuthor;
    }

    public void setFormatedAuthor(String formatedAuthor) {
        this.formatedAuthor = formatedAuthor;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAttribute
    public String getBibliographicCitation() {
        return this.bibliographicCitation;
    }

    public void setBibliographicCitation(String bibliographicCitation) {
        this.bibliographicCitation = bibliographicCitation;
    }

    public String toString() {
        String toString = String.valueOf(this.title) + "\n" + this.formatedAuthor + ".";
        toString = String.valueOf(toString) + "\n" + this.bibliographicCitation;
        if (this.pubMedId != null) {
            toString = String.valueOf(toString) + "\nPMID: " + this.pubMedId;
        }
        return toString;
    }

    public boolean equals(Object arg0) {
        return arg0 != null && arg0 instanceof Paper && this.pubMedId != null && this.pubMedId.equals(((Paper)arg0).getPubMedId());
    }

    public int hashCode() {
        if (this.pubMedId == null) {
            return -1;
        }
        return this.pubMedId;
    }

    public Paper getACopy() {
        Paper paper = new Paper();
        paper.setTitle(this.title);
        paper.setYear(this.year);
        paper.setPubMedId(this.pubMedId);
        if (this.authors != null) {
            ArrayList<String> authorList = new ArrayList<String>();
            authorList.addAll(this.authors);
            paper.setAuthors(authorList);
        }
        paper.setFormatedAuthor(this.formatedAuthor);
        paper.setBibliographicCitation(this.bibliographicCitation);
        return paper;
    }
}

