/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class TaskPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(TaskPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.tasklist.task";
    public static String lastSelection = null;
    private SingleChoicePreference taskPreference = null;
    private List<String> allTasks = null;
    private String defaultTask = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Tasks");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createTasksTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newTaskCount = 1;
                while (TaskPreference.this.allTasks.contains("Task " + newTaskCount)) {
                    ++newTaskCount;
                }
                String newTask = "Task " + newTaskCount;
                TaskPreference.this.allTasks.add(newTask);
                if (TaskPreference.this.allTasks.size() == 1) {
                    TaskPreference.this.defaultTask = newTask;
                }
                TaskPreference.this.checkboxTableViewer.refresh();
                TaskPreference.this.tableColumn2.getViewer().editElement((Object)newTask, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)TaskPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedTask = (String)selection.getFirstElement();
                    int selectionIndex = TaskPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    TaskPreference.this.allTasks.remove(selectedTask);
                    if (selectedTask.equals(TaskPreference.this.defaultTask)) {
                        TaskPreference.this.defaultTask = TaskPreference.this.allTasks.isEmpty() ? null : (String)TaskPreference.this.allTasks.iterator().next();
                    }
                    TaskPreference.this.checkboxTableViewer.refresh();
                    if (!TaskPreference.this.allTasks.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, TaskPreference.this.allTasks.size() - 1);
                        TaskPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(TaskPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)TaskPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(TaskPreference.this.defaultTask);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TaskPreference.this.defaultTask = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.TASK.getPreferenceName()));
        this.taskPreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK);
        this.allTasks = new ArrayList<String>();
        this.allTasks.addAll(this.taskPreference.getAllValues());
        this.defaultTask = this.taskPreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allTasks, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allTasks);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createTasksTableViewer(Composite container) {
        Table tasksTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        tasksTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(tasksTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Tasks");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (TaskPreference.this.checkboxTableViewer.getChecked(element)) {
                        TaskPreference.this.defaultTask = newValue;
                    }
                    if (TaskPreference.this.allTasks.contains(element)) {
                        TaskPreference.this.allTasks.set(TaskPreference.this.allTasks.indexOf(element), newValue);
                    }
                    TaskPreference.this.checkboxTableViewer.refresh();
                    TaskPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allTasksMap = this.taskPreference.loadDefaultValues(ProjectPreferenceStore.Preference.TASK);
        this.allTasks = new ArrayList<String>();
        this.defaultTask = null;
        for (String task : allTasksMap.keySet()) {
            this.allTasks.add(task);
            if (!allTasksMap.get(task).booleanValue()) continue;
            this.defaultTask = task;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Task\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniqueTasks = new HashSet<String>();
        uniqueTasks.addAll(this.allTasks);
        String string = errorMessage = uniqueTasks.size() == this.allTasks.size() ? errorMessage : "Non-unique Tasks";
        if (uniqueTasks.contains("")) {
            errorMessage = "Empty Task";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.taskPreference.setAllValues(new HashSet<String>());
        this.taskPreference.setDefaultValue(null);
        for (String task : this.allTasks) {
            if (this.checkboxTableViewer.getChecked(task) && this.taskPreference.getDefaultValue() == null) {
                this.taskPreference.setDefaultValue(task);
            }
            this.taskPreference.addValue(task);
        }
        return this.taskPreference.savePreference();
    }
}

