/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.preference.project.ActionPreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class EventPart {
    private static Logger logger = Logger.getLogger(EventPart.class);
    public static final String PART_ID = "org.grits.toolbox.core.part.project.event";
    private static final String ADD_NEW_TO_PREFERENCE = "Add New ...";
    public static final String EVENT_TOPIC_VALUE_MODIFIED = "EventTopic_EventPart_Modified";
    private ComboViewer actionCombo = null;
    private CDateTime cDateTime = null;
    private Text descriptionText = null;
    @Inject
    IEventBroker eventBroker;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;
    private ProjectEvent projectEvent = null;

    @Inject
    public EventPart() {
    }

    @Optional
    @Inject
    void setProjectEvent(@UIEventTopic(value="grits_project_some_field_selected") ProjectEvent projectEvent, EPartService partService, EModelService modelService) {
        MPart eventPart;
        MPart mPart = eventPart = partService == null ? null : partService.findPart(PART_ID);
        if (eventPart != null && eventPart.getObject() != null) {
            this.clearAll();
            if (projectEvent != null) {
                String action = projectEvent.getProjectAction() == null ? null : projectEvent.getProjectAction().getAction();
                this.selectValueInCombo(this.actionCombo, action);
                String value = projectEvent.getDescription() == null ? "" : projectEvent.getDescription();
                this.descriptionText.setText(value);
                this.cDateTime.setSelection(projectEvent.getEventDate());
                this.projectEvent = projectEvent;
                this.makeEditable(true);
                modelService.bringToTop((MUIElement)eventPart);
            }
        }
    }

    private void clearAll() {
        this.projectEvent = null;
        this.actionCombo.getCombo().deselectAll();
        this.descriptionText.setText("");
        this.cDateTime.setSelection(null);
        this.makeEditable(false);
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        logger.debug((Object)"START : Creating Event View");
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.marginTop = 30;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.actionCombo = this.createComboLine(composite);
        this.actionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.actionCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ACTION).getAllValues());
        this.actionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection;
                if (EventPart.this.projectEvent != null && (selection = (StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String action = (String)selection.getFirstElement();
                    if (action.equals(EventPart.ADD_NEW_TO_PREFERENCE)) {
                        HashMap<String, String> preferencePageParams = new HashMap<String, String>();
                        preferencePageParams.put("org.grits.toolbox.core.commandparameter.preference.pageid", "org.grits.toolbox.core.preference.project.event.action");
                        EventPart.this.handlerService.executeHandler(EventPart.this.commandService.createCommand("org.grits.toolbox.core.command.preference.open", preferencePageParams));
                        EventPart.this.setInputInCombo(EventPart.this.actionCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ACTION).getAllValues());
                        EventPart.this.actionCombo.getCombo().deselectAll();
                        int comboSelection = EventPart.this.getIndexOf(EventPart.this.actionCombo, ActionPreference.lastSelection);
                        if (comboSelection >= 0) {
                            EventPart.this.actionCombo.setSelection((ISelection)new StructuredSelection((Object)ActionPreference.lastSelection));
                        }
                    } else if (!Objects.equals(action, EventPart.this.projectEvent.getProjectAction().getAction())) {
                        EventPart.this.projectEvent.getProjectAction().setAction(action);
                        EventPart.this.eventBroker.post(EventPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)EventPart.this.projectEvent);
                    }
                }
            }
        });
        this.createLabel(composite, "Date");
        this.cDateTime = new CDateTime(composite, 3);
        this.cDateTime.setPattern("MM/dd/yyyy");
        GridData calendarComboData = new GridData(768);
        calendarComboData.grabExcessHorizontalSpace = true;
        calendarComboData.horizontalSpan = 1;
        calendarComboData.verticalSpan = 1;
        this.cDateTime.setLayoutData((Object)calendarComboData);
        this.cDateTime.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.changeDate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.changeDate();
            }

            private void changeDate() {
                if (EventPart.this.projectEvent != null && !Objects.equals(EventPart.this.projectEvent.getEventDate(), EventPart.this.cDateTime.getSelection())) {
                    EventPart.this.projectEvent.setEventDate(EventPart.this.cDateTime.getSelection());
                    EventPart.this.eventBroker.post(EventPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)EventPart.this.projectEvent);
                }
            }
        });
        this.descriptionText = this.createTextLine(composite, "Description", 2880, 200);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String description;
                if (EventPart.this.projectEvent != null && !Objects.equals(description = ((Text)e.getSource()).getText().trim(), EventPart.this.projectEvent.getDescription())) {
                    EventPart.this.projectEvent.setDescription(description);
                    EventPart.this.eventBroker.post(EventPart.EVENT_TOPIC_VALUE_MODIFIED, (Object)EventPart.this.projectEvent);
                }
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        this.makeEditable(false);
        logger.debug((Object)"END   : Creating Event View");
    }

    private void createLabel(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
    }

    private Text createTextLine(Composite composite, String label, int style, int heightHint) {
        this.createLabel(composite, label);
        Text text = new Text(composite, style);
        GridData newEventData = new GridData(768);
        newEventData.grabExcessHorizontalSpace = true;
        newEventData.horizontalSpan = 1;
        newEventData.verticalSpan = 1;
        newEventData.heightHint = heightHint;
        text.setLayoutData((Object)newEventData);
        return text;
    }

    private ComboViewer createComboLine(Composite composite) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText("Action");
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newEventData = new GridData(768);
        newEventData.grabExcessHorizontalSpace = true;
        newEventData.horizontalSpan = 1;
        newEventData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newEventData);
        return comboViewer;
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size() + 1];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        items[i] = ADD_NEW_TO_PREFERENCE;
        comboViewer.setInput((Object)items);
    }

    private void selectValueInCombo(ComboViewer comboViewer, String value) {
        int selectionIndex;
        comboViewer.getCombo().deselectAll();
        if (value != null && (selectionIndex = this.getIndexOf(comboViewer, value)) >= 0) {
            comboViewer.getCombo().select(selectionIndex);
            comboViewer.setSelection(comboViewer.getSelection());
        }
    }

    private int getIndexOf(ComboViewer comboViewer, String value) {
        int selectionIndex = -1;
        if (comboViewer != null && comboViewer.getCombo().getItems() != null && value != null) {
            selectionIndex = comboViewer.getCombo().indexOf(value);
        }
        return selectionIndex;
    }

    private void makeEditable(boolean editable) {
        this.actionCombo.getCombo().setEnabled(editable);
        this.descriptionText.setEnabled(editable);
        this.cDateTime.setEnabled(editable);
    }

    @Focus
    public void onFocus() {
    }

    @Persist
    public void save() {
    }
}

