/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.service.IGritsDataModelService;

@Singleton
public class GritsDataModelService
implements IGritsDataModelService {
    private static final Logger logger = Logger.getLogger(GritsDataModelService.class);
    private StructuredSelection lastSelection = null;
    Map<Entry, Integer> lastIdentifierPerProject = new HashMap<Entry, Integer>();
    private Integer lastIdentifier = 0;
    public static boolean updateMode = true;
    @Inject
    IEventBroker eventBroker;
    @Inject
    @Optional
    @Named(value="grits_workspace_entry")
    Entry workspaceEntry;

    @Override
    public void addProjectEntry(Entry projectEntry) throws Exception {
        boolean currentUpdateMode = updateMode;
        try {
            updateMode = true;
            this.addEntry(this.workspaceEntry, projectEntry);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        updateMode = currentUpdateMode;
    }

    @Override
    public void addEntry(Entry parentEntry, Entry childEntry) {
        parentEntry.addChild(childEntry);
        childEntry.setParent(parentEntry);
        if (updateMode) {
            this.updateProjectModificationTime(childEntry);
            logger.info((Object)("Add Entry: parentEntry[" + parentEntry + "], childEntry[" + childEntry + "]."));
        }
        this.eventBroker.send("grits_data_model_changed", (Object)parentEntry);
    }

    @Override
    public void closeProject(Entry entry) {
        if (entry.getProperty().getType().equals("org.grits.toolbox.property.project")) {
            this.removeAllChildren(entry);
            ((ProjectProperty)entry.getProperty()).setOpen(false);
            if (updateMode) {
                this.updateProjectModificationTime(entry);
            }
            this.eventBroker.send("grits_data_model_changed", (Object)entry);
        }
    }

    @Override
    public void deleteEntry(Entry entry) throws IOException {
        if (entry != null && entry.getProperty() != null && !entry.getProperty().getType().equals("org.grits.toolbox.property.workspace")) {
            entry.delete();
            Entry parentEntry = entry.getParent();
            if (parentEntry != null) {
                parentEntry.removeChild(entry);
                if (updateMode) {
                    this.updateProjectModificationTime(parentEntry);
                    logger.info((Object)("deleted Entry: entry[" + entry + "], parentEntry[" + parentEntry + "]."));
                }
                this.eventBroker.send("grits_data_model_changed", (Object)parentEntry);
            }
        }
    }

    @Override
    public Entry getRootEntry() {
        return this.workspaceEntry;
    }

    @Override
    public void removeAllChildren(Entry parent) {
        for (Entry child : parent.getChildren()) {
            this.removeEntry(parent, child);
        }
    }

    @Override
    public void removeEntry(Entry parentEntry, Entry toRemove) {
        parentEntry.removeChild(toRemove);
        if (updateMode) {
            this.updateProjectModificationTime(parentEntry);
            logger.info((Object)("Removed Entry: parentEntry[" + parentEntry + "], toRemove[" + toRemove + "]."));
        }
        this.eventBroker.send("grits_data_model_changed", (Object)parentEntry);
    }

    @Override
    public void renameEntry(Entry entry, String newName) {
        entry.setDisplayName(newName);
        if (updateMode) {
            this.updateProjectModificationTime(entry);
            logger.info((Object)("Renamed Entry: entry[" + entry + "]."));
        }
        this.eventBroker.send("grits_data_model_changed", (Object)entry);
    }

    @Override
    public void setRoot(Entry workspaceEntry) {
        this.workspaceEntry = workspaceEntry;
        this.eventBroker.send("grits_data_model_changed", (Object)workspaceEntry);
    }

    @Override
    public void updateProjectModificationTime(Entry entry) {
        Entry projectEntry = this.findParentByType(entry, "org.grits.toolbox.property.project");
        if (projectEntry != null) {
            try {
                ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails(projectEntry);
                projectDetails.setModificationTime(new Date());
                ProjectDetailsHandler.writeProjectDetails(projectDetails);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Entry findParentByType(Entry entry, String type) {
        if (entry.getProperty().getType().equals(type)) {
            return entry;
        }
        Entry parent = entry.getParent();
        if (parent == null || parent.getProperty() == null || parent.getProperty().getType() == null) {
            return null;
        }
        if (parent.getProperty().getType().equals(type)) {
            return parent;
        }
        return this.findParentByType(parent, type);
    }

    @Override
    public Entry findEntryById(Integer entryId) {
        if (this.workspaceEntry == null || this.workspaceEntry.getChildren() == null) {
            return null;
        }
        for (Entry e : this.workspaceEntry.getChildren()) {
            if (e.getId() == null || !e.getId().equals(entryId)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void setLastSelection(StructuredSelection lastSelection) {
        this.lastSelection = lastSelection;
    }

    @Override
    public StructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    @Override
    public void setLastIdentifierForProject(Entry projectEntry, Integer lastIdentifier) {
        this.lastIdentifierPerProject.put(projectEntry, lastIdentifier);
    }

    @Override
    public Integer getLastIdentifierForProject(Entry projectEntry) {
        return this.lastIdentifierPerProject.get(projectEntry);
    }
}

