/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.filter;

import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.FilterSettingLibrary;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanFilterPreference;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.util.structure.glycan.gui.FilterChangedListener;
import org.grits.toolbox.util.structure.glycan.gui.FilterTableSetup;

public class MSGlycanCustomFilterSelection {
    private static final Logger logger = Logger.getLogger(MSGlycanCustomFilterSelection.class);
    private FilterSettingLibrary library;
    private FilterTableSetup filterTableSetup;
    private Combo cmbSelectFilter;
    private FilterSetting filterSetting;
    private FilterChangedListener listener;

    public MSGlycanCustomFilterSelection() {
        this.loadFilterPreferences();
    }

    public MSGlycanCustomFilterSelection(FilterChangedListener listener) {
        this();
        this.listener = listener;
    }

    private void loadFilterPreferences() {
        try {
            MSGlycanFilterPreference preferences = MSGlycanFilterPreference.getMSGlycanFilterPreferences(MSGlycanFilterPreference.getPreferenceEntity());
            if (preferences != null) {
                this.library = preferences.getFilterSettings();
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            logger.error((Object)"Cannot load filter preference");
        }
    }

    public void setFilterTableSetup(FilterTableSetup filterTableSetup) {
        this.filterTableSetup = filterTableSetup;
    }

    public void createFilterSelectionArea(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        Label lblSelectFilter = new Label(parent, 0);
        lblSelectFilter.setText("Select from Stored Filters");
        lblSelectFilter.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        this.cmbSelectFilter = new Combo(parent, 0);
        this.cmbSelectFilter.setLayoutData((Object)gd2);
        this.initStoredFiltersList();
        this.cmbSelectFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSGlycanCustomFilterSelection.this.processSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void initStoredFiltersList() {
        this.cmbSelectFilter.removeAll();
        if (this.library != null && this.library.getFilterSettings() != null) {
            for (FilterSetting filter : this.library.getFilterSettings()) {
                this.cmbSelectFilter.add(filter.getName());
            }
        }
    }

    protected void processSelection() {
        if (!this.cmbSelectFilter.getText().trim().equals("")) {
            this.setCurrentFilterValues(this.cmbSelectFilter.getText().trim());
            this.filterSetting = this.filterTableSetup.getFilterSetting();
            if (this.listener != null) {
                this.listener.filterChanged();
            }
        }
    }

    protected void setCurrentFilterValues(String selFilterName) {
        if (selFilterName == null) {
            return;
        }
        FilterSetting selFilter = this.getCurrentFilter(selFilterName);
        if (selFilter == null) {
            return;
        }
        if (this.filterTableSetup != null) {
            this.filterTableSetup.setExistingFilters(selFilter);
        }
    }

    protected FilterSetting getCurrentFilter(String selFilter) {
        if (this.library != null && this.library.getFilterSettings() != null) {
            int i = 0;
            while (i < this.library.getFilterSettings().size()) {
                FilterSetting curFilter = this.library.getFilterSettings().get(i);
                if (curFilter.getName().equals(selFilter)) {
                    return curFilter;
                }
                ++i;
            }
        }
        return null;
    }

    public FilterSetting getFilterSetting() {
        return this.filterSetting;
    }
}

