/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakFinderOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakFinderOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.PeakFinderThread;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.ProgressDialog;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class PeakFinderPlugin
implements Plugin,
ActionListener {
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected PeakFinderOptions theOptions = null;
    protected boolean first_time_run = true;
    protected PeakFinderThread theThread = null;
    protected ProgressDialog progressDialog = null;
    protected Timer activityMonitor = null;

    public PeakFinderPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        try {
            this.theOptions = new PeakFinderOptions();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void init() {
        if (this.theWorkspace != null) {
            this.theOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public void exit() {
        if (this.theWorkspace != null) {
            this.theOptions.store(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public String getName() {
        return "Glyco-Peakfinder";
    }

    @Override
    public int getMnemonic() {
        return 75;
    }

    @Override
    public ImageIcon getIcon() {
        return ThemeManager.getEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE);
    }

    @Override
    public int getViewPosition(String view) {
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return null;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("options", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Set plugin options", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("findCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find structure compositions with a given m/z value", 70, "", (ActionListener)this));
        actions.add(new GlycanAction("matchCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find structure compositions matching the peak list", 80, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("findFragmentCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find fragments compositions with a given m/z value", 73, "", (ActionListener)this));
        actions.add(new GlycanAction("matchFragmentCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find fragments compositions matching the peak list", 76, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
        this.theManager.addMsPeakAction(new GlycanAction("findCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find structure compositions matching the peaks", 80, "", (ActionListener)this));
        this.theManager.addMsMsPeakAction(new GlycanAction("findFragmentCompositions", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Find fragments compositions matching the peaks", 80, "", (ActionListener)this));
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        if (this.theWorkspace != null) {
            this.theOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    @Override
    public void show(String view) throws Exception {
        throw new Exception("Invalid view: " + view);
    }

    @Override
    public boolean runAction(String action) throws Exception {
        if (action.startsWith("find")) {
            String m_z = JOptionPane.showInputDialog((Component)((Object)this.theApplication), "Insert m/z value", this.theWorkspace.getRecentMZValue());
            if (m_z != null) {
                Double mz_value = Double.valueOf(m_z);
                this.theWorkspace.setRecentMZValue(mz_value);
                return this.runAction(true, action, (Object)new PeakList(mz_value));
            }
            return false;
        }
        return this.runAction(true, action, (Object)this.theWorkspace.getPeakList());
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        if (this.runAction(this.first_time_run, action, params)) {
            this.first_time_run = false;
            return true;
        }
        return false;
    }

    public boolean runAction(boolean ask, String action, Object params) throws Exception {
        if (!(params instanceof PeakList)) {
            throw new Exception("Invalid param object: PeakList needed");
        }
        PeakList peaks = (PeakList)((Object)params);
        if (action.equals("options")) {
            return this.setOptions();
        }
        if (action.equals("findCompositions")) {
            if (this.matchCompositions(ask, peaks, false)) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchCompositions")) {
            if (this.matchCompositions(ask, peaks, false)) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("findFragmentCompositions")) {
            if (this.matchCompositions(ask, peaks, true)) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        if (action.equals("matchFragmentCompositions")) {
            if (this.matchCompositions(ask, peaks, true)) {
                this.theManager.show("Search", "Details");
                return true;
            }
            return false;
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
    }

    @Override
    public void updateMasses() {
    }

    public boolean setOptions() {
        PeakFinderOptionsDialog pdlg = new PeakFinderOptionsDialog((Frame)((Object)this.theApplication), this.theOptions);
        pdlg.setVisible(true);
        if (!pdlg.getReturnStatus().equals("OK")) {
            return false;
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, true, false);
        adlg.setVisible(true);
        return adlg.getReturnStatus().equals("OK");
    }

    public boolean matchCompositions(boolean ask, PeakList peaks, boolean compute_fragments) throws Exception {
        if (ask) {
            PeakFinderOptionsDialog pdlg = new PeakFinderOptionsDialog((Frame)((Object)this.theApplication), this.theOptions);
            pdlg.setVisible(true);
            if (!pdlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        if (ask) {
            AnnotationOptionsDialog adlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, compute_fragments, false);
            adlg.setVisible(true);
            if (!adlg.getReturnStatus().equals("OK")) {
                return false;
            }
        }
        if (ann_opt.CLEAR_EXISTING_ANNOTATIONS) {
            this.theWorkspace.getAnnotatedPeakList().clear();
        }
        this.theApplication.haltInteractions();
        this.theThread = compute_fragments ? new PeakFinderThread(peaks, this.theOptions, ann_opt, frag_opt) : new PeakFinderThread(peaks, this.theOptions, ann_opt, null);
        return this.runAnnotation();
    }

    private boolean runAnnotation() {
        this.theThread.start();
        this.progressDialog = new ProgressDialog((JFrame)((Object)this.theApplication), "Matching peaks with compositions", null, -1, -1);
        this.progressDialog.setVisible(true);
        this.activityMonitor = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!PeakFinderPlugin.this.theThread.isAlive() || PeakFinderPlugin.this.theThread.isInterrupted() || PeakFinderPlugin.this.progressDialog.isCanceled()) {
                    PeakFinderPlugin.this.activityMonitor.stop();
                    PeakFinderPlugin.this.progressDialog.setVisible(false);
                    if (PeakFinderPlugin.this.progressDialog.isCanceled()) {
                        PeakFinderPlugin.this.theThread.interrupt();
                        PeakFinderPlugin.this.onAnnotationAborted(PeakFinderPlugin.this.theThread);
                    } else {
                        PeakFinderPlugin.this.onAnnotationCompleted(PeakFinderPlugin.this.theThread);
                    }
                }
            }
        });
        this.activityMonitor.start();
        return true;
    }

    public void onAnnotationCompleted(PeakFinderThread t) {
        this.theWorkspace.setSearchGenerator(this);
        this.theWorkspace.getSearchResults().copy(t.getAnnotatedPeaks());
        this.theApplication.restoreInteractions();
    }

    public void onAnnotationAborted(PeakFinderThread t) {
        this.theWorkspace.setSearchGenerator(this);
        this.theWorkspace.getSearchResults().copy(t.getAnnotatedPeaks());
        this.theApplication.restoreInteractions();
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

