/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.eurocarbdb.application.glycanbuilder.Data;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycanbuilder.StyledTextCellRenderer;
import org.eurocarbdb.application.glycoworkbench.plugin.MultiLineHeaderRenderer;
import org.eurocarbdb.application.glycoworkbench.plugin.OffsetPageFormat;
import org.eurocarbdb.application.glycoworkbench.plugin.ResizingTable;

public class GlycanTable
extends ResizingTable
implements SVGUtils.Renderable,
Printable,
MouseListener {
    protected JPopupMenu thePopupMenu = null;
    protected GlycanRenderer theGlycanRenderer;
    protected DecimalFormat df_fourdigits;
    protected DecimalFormat df_twodigits;
    protected double glycan_scale = 0.5;
    protected double glycans_vector_scale = 0.4;
    protected boolean use_styled_text = true;
    protected boolean show_redend = true;
    protected boolean is_printing = false;
    protected HashSet<Glycan> magnified;
    protected Vector<ActionListener> action_listeners = new Vector();
    Glycan header_structure = null;
    Printable table_printable = null;

    public GlycanTable() {
        this.theGlycanRenderer = new GlycanRendererAWT();
        this.df_fourdigits = new DecimalFormat("0.0000");
        this.df_twodigits = new DecimalFormat("0.00");
        this.magnified = new HashSet();
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setShowVerticalLines(false);
        this.getTableHeader().setDefaultRenderer(new MultiLineHeaderRenderer(this.theGlycanRenderer));
        this.setDefaultRenderer(Vector.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public void setValue(Object value) {
                this.setIcon(new ImageIcon(GlycanTable.this.theGlycanRenderer.getImage((Collection)((Vector)value), false, false, GlycanTable.this.show_redend, GlycanTable.this.glycans_vector_scale)));
            }
        });
        this.setDefaultRenderer(Glycan.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public void setValue(Object value) {
                if (GlycanTable.this.magnified.contains((Glycan)value) && !GlycanTable.this.is_printing) {
                    this.setIcon(new ImageIcon(GlycanTable.this.theGlycanRenderer.getImage((Glycan)value, false, false, GlycanTable.this.show_redend, 1.0)));
                } else {
                    this.setIcon(new ImageIcon(GlycanTable.this.theGlycanRenderer.getImage((Glycan)value, false, false, GlycanTable.this.show_redend, GlycanTable.this.glycan_scale)));
                }
            }
        });
        if (this.use_styled_text) {
            this.setDefaultRenderer(String.class, (TableCellRenderer)new StyledTextCellRenderer());
        } else {
            this.setDefaultRenderer(String.class, new DefaultTableCellRenderer());
        }
        this.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    this.setText(((Integer)value).toString());
                } else {
                    this.setText("");
                }
            }
        });
        this.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    this.setText(GlycanTable.this.df_fourdigits.format((Double)value));
                } else {
                    this.setText("");
                }
            }
        });
        this.addMouseListener(this);
    }

    public void setShowRedend(boolean f) {
        this.show_redend = f;
    }

    public boolean getShowRedend() {
        return this.show_redend;
    }

    public void setGlycanScale(double val) {
        this.glycan_scale = val;
    }

    public double getGlycanScale() {
        return this.glycan_scale;
    }

    public void setGlycansVectorScale(double val) {
        this.glycans_vector_scale = val;
    }

    public double getGlycansVectorScale() {
        return this.glycans_vector_scale;
    }

    public void setUseStyledText(boolean f) {
        this.use_styled_text = f;
        if (this.use_styled_text) {
            this.setDefaultRenderer(String.class, (TableCellRenderer)new StyledTextCellRenderer());
        } else {
            this.setDefaultRenderer(String.class, new DefaultTableCellRenderer());
        }
    }

    public boolean getUseStyledText() {
        return this.use_styled_text;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.thePopupMenu = menu;
    }

    public JPopupMenu getPopupMenu() {
        return this.thePopupMenu;
    }

    public void setGlycanRenderer(GlycanRenderer r) {
        this.theGlycanRenderer = r;
        this.getTableHeader().setDefaultRenderer(new MultiLineHeaderRenderer(this.theGlycanRenderer));
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public void beforeRendering() {
        this.is_printing = true;
    }

    public void afterRendering() {
        this.is_printing = false;
    }

    public Dimension getRenderableSize() {
        return new Dimension(this.getWidth(), this.getHeight() + this.getTableHeader().getHeight());
    }

    public void paintRenderable(Graphics2D g2d) {
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.paint(g2d);
        g2d.translate(0, tableHeader.getHeight());
        super.paint(g2d);
    }

    public void print(PrinterJob pj) {
        this.print(pj, null);
    }

    public void print(PrinterJob pj, Glycan _header_structure) {
        if (pj == null) {
            return;
        }
        try {
            this.header_structure = _header_structure;
            this.table_printable = this.getPrintable(JTable.PrintMode.FIT_WIDTH, null, new MessageFormat("{0}"));
            pj.setPrintable(this);
            if (pj.printDialog()) {
                this.is_printing = true;
                pj.print();
                this.is_printing = false;
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            BufferedImage struct_img = this.theGlycanRenderer.getImage(this.header_structure, false, true, true, 1.0);
            Graphics2D g2d = (Graphics2D)graphics;
            AffineTransform old_transform = g2d.getTransform();
            g2d.setBackground(Color.white);
            Dimension td = new Dimension(((Image)struct_img).getWidth(null), ((Image)struct_img).getHeight(null));
            double s_width = td.width;
            double s_height = td.height;
            double sx = pageFormat.getImageableWidth() / (double)td.width;
            double sy = pageFormat.getImageableHeight() / (double)td.height;
            double s = Math.min(sx, sy);
            if (s < 1.0) {
                s_width *= s;
                s_height *= s;
                struct_img = this.theGlycanRenderer.getImage(this.header_structure, false, true, true, s);
            }
            int left_margin = (int)((pageFormat.getImageableWidth() - s_width) / 2.0);
            g2d.translate(pageFormat.getImageableX() + (double)left_margin, pageFormat.getImageableY());
            g2d.drawImage(struct_img, null, null);
            g2d.setTransform(old_transform);
            return this.table_printable.print(graphics, new OffsetPageFormat(pageFormat, (int)(s_height + 20.0)), pageIndex);
        }
        return this.table_printable.print(graphics, pageFormat, pageIndex);
    }

    private void showPopup(MouseEvent e) {
        if (this.thePopupMenu != null) {
            int row = this.rowAtPoint(e.getPoint());
            int column = this.columnAtPoint(e.getPoint());
            if (!this.isRowSelected(row)) {
                this.setRowSelectionInterval(row, row);
            } else {
                this.addRowSelectionInterval(row, row);
            }
            this.addColumnSelectionInterval(column, column);
            this.thePopupMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (MouseUtils.isActionTrigger((MouseEvent)e)) {
            int col;
            int row = this.rowAtPoint(e.getPoint());
            Object value = this.getValueAt(row, col = this.columnAtPoint(e.getPoint()));
            if (value instanceof Glycan) {
                if (this.magnified.contains((Glycan)value)) {
                    this.magnified.remove((Glycan)value);
                } else {
                    this.magnified.add((Glycan)value);
                }
                this.updateDimensions(row, row);
                this.addRowSelectionInterval(row, row);
            } else {
                for (ActionListener al : this.action_listeners) {
                    al.actionPerformed(new ActionEvent(this, 0, "tableaction"));
                }
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if ((e.getFirstRow() == -1 || e.getLastRow() == Integer.MAX_VALUE) && this.magnified != null) {
            this.magnified.clear();
        }
        if (e.getFirstRow() == -1) {
            Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                columns.nextElement().setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
            }
        }
    }

    public void addActionListener(ActionListener al) {
        if (al != null) {
            this.action_listeners.add(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null && this.action_listeners.contains(al)) {
            this.action_listeners.remove(al);
        }
    }

    public Data getSelectedData() {
        Data rows = new Data();
        for (int c = 0; c < this.getColumnCount(); ++c) {
            rows.add((Object)this.getColumnName(c));
        }
        rows.newRow();
        int[] sel_ind = this.getSelectedRows();
        for (int i = 0; i < sel_ind.length; ++i) {
            int r = sel_ind[i];
            for (int c = 0; c < this.getColumnCount(); ++c) {
                Object o = this.getValueAt(r, c);
                if (o instanceof Glycan) {
                    rows.add((Object)this.theGlycanRenderer.makeCompositionText((Glycan)o, false));
                    continue;
                }
                if (o instanceof Vector) {
                    StringBuilder sb = new StringBuilder();
                    for (Glycan g : (Vector)o) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(this.theGlycanRenderer.makeCompositionText(g, false));
                    }
                    rows.add((Object)sb.toString());
                    continue;
                }
                rows.add(o);
            }
            rows.newRow();
        }
        return rows;
    }
}

