/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.structure;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.structure.GlycanAnalyteFragment;
import org.grits.toolbox.ms.annotation.structure.IAnalyteFragment;
import org.grits.toolbox.ms.annotation.structure.IAnalyteFragments;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.FragmentPerActivationMethod;
import org.grits.toolbox.ms.om.data.FragmentPerMsLevel;

public class GlycanAnalyteFragments
implements IAnalyteFragments {
    protected List<IAnalyteFragment> fragments = new ArrayList<IAnalyteFragment>();
    protected String sequence;
    protected String scanActivationMethod;
    protected int scanMSLevel;
    protected boolean isMonoisotopic;

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setScanActivationMethod(String scanActivationMethod) {
        this.scanActivationMethod = scanActivationMethod;
    }

    public String getScanActivationMethod() {
        return this.scanActivationMethod;
    }

    public void setScanMSLevel(int scanMSLevel) {
        this.scanMSLevel = scanMSLevel;
    }

    public int getScanMSLevel() {
        return this.scanMSLevel;
    }

    public void setMonoisotopic(boolean isMonoisotopic) {
        this.isMonoisotopic = isMonoisotopic;
    }

    public boolean isMonoisotopic() {
        return this.isMonoisotopic;
    }

    @Override
    public List<IAnalyteFragment> getAnalyteFragments(AnalyteSettings settings) {
        List<IAnalyteFragment> fragments = null;
        boolean match = false;
        if (settings.getGlycanSettings().getPerActivation().size() != 0) {
            for (FragmentPerActivationMethod f : settings.getGlycanSettings().getPerActivation()) {
                if (!f.getActivationMethod().equals(this.scanActivationMethod)) continue;
                fragments = GlycanAnalyteFragments.generateFragments(this.sequence, settings, f.getFragments(), f.getMaxNumOfCleavages(), f.getMaxNumOfCrossRingCleavages(), this.isMonoisotopic);
                match = true;
                break;
            }
            if (!match) {
                fragments = GlycanAnalyteFragments.generateFragments(this.sequence, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages(), this.isMonoisotopic);
            }
        } else if (settings.getGlycanSettings().getPerMsLevel().size() != 0) {
            for (FragmentPerMsLevel f : settings.getGlycanSettings().getPerMsLevel()) {
                if (f.getMsLevel() != this.scanMSLevel) continue;
                fragments = GlycanAnalyteFragments.generateFragments(this.sequence, settings, f.getFragments(), f.getM_maxNumOfCleavages(), f.getM_maxNumOfCrossRingCleavages(), this.isMonoisotopic);
                match = true;
                break;
            }
            if (!match) {
                fragments = GlycanAnalyteFragments.generateFragments(this.sequence, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages(), this.isMonoisotopic);
            }
        } else {
            fragments = GlycanAnalyteFragments.generateFragments(this.sequence, settings, settings.getGlycanSettings().getGlycanFragments(), settings.getGlycanSettings().getMaxNumOfCleavages(), settings.getGlycanSettings().getMaxNumOfCrossRingCleavages(), this.isMonoisotopic);
        }
        return fragments;
    }

    public static String getAutoString(double dMz) {
        int iIntMass = (int)(dMz * 100.0);
        return "Frag-" + iIntMass;
    }

    public void setFragments(List<IAnalyteFragment> fragments) {
        this.fragments = fragments;
    }

    public List<IAnalyteFragment> getFragments() {
        return this.fragments;
    }

    public static List<IAnalyteFragment> generateFragments(String sequence, AnalyteSettings settings, List<Fragment> fragments, int maxNumClvg, int maxNumCr, boolean isMonoisotopic) {
        BuilderWorkspace bw = new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        Fragmenter t_fragmenter = new Fragmenter();
        t_fragmenter.setComputeBFragments(false);
        t_fragmenter.setComputeYFragments(false);
        t_fragmenter.setComputeCFragments(false);
        t_fragmenter.setComputeZFragments(false);
        t_fragmenter.setComputeAFragments(false);
        t_fragmenter.setComputeXFragments(false);
        for (Fragment fragment : fragments) {
            if (fragment.getType().equals("B")) {
                t_fragmenter.setComputeBFragments(true);
            }
            if (fragment.getType().equals("Y")) {
                t_fragmenter.setComputeYFragments(true);
            }
            if (fragment.getType().equals("C")) {
                t_fragmenter.setComputeCFragments(true);
            }
            if (fragment.getType().equals("Z")) {
                t_fragmenter.setComputeZFragments(true);
            }
            if (fragment.getType().equals("A")) {
                t_fragmenter.setComputeAFragments(true);
            }
            if (!fragment.getType().equals("X")) continue;
            t_fragmenter.setComputeXFragments(true);
        }
        t_fragmenter.setMaxNoCleavages(maxNumClvg);
        t_fragmenter.setMaxNoCrossRings(maxNumCr);
        try {
            Glycan t_glycan = Glycan.fromString((String)sequence);
            t_glycan.setMassOptions(GlycanStructureAnnotation.collectMassOptions(isMonoisotopic, settings));
            FragmentCollection fc = t_fragmenter.computeAllFragments(t_glycan);
            List<IAnalyteFragment> lFrags = GlycanAnalyteFragment.convertGWBFragments(fc);
            return lFrags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getComparableSequence(String sequence) {
        if (sequence == null) {
            return sequence;
        }
        ArrayList<Integer> alDashIndices = new ArrayList<Integer>();
        int iFirstInx = 0;
        while (iFirstInx > -1) {
            alDashIndices.add(iFirstInx);
            iFirstInx = sequence.indexOf("--", iFirstInx + 1);
        }
        alDashIndices.add(sequence.length());
        ArrayList<Integer> alCleaveIndices = new ArrayList<Integer>();
        iFirstInx = sequence.indexOf("cleavage");
        while (iFirstInx > -1) {
            alCleaveIndices.add(iFirstInx);
            iFirstInx = sequence.indexOf("cleavage", iFirstInx + 1);
        }
        if (alCleaveIndices.isEmpty()) {
            return sequence;
        }
        String sSwapText1 = "?1D";
        String sSwapText2 = "-Hex,p/#";
        String sCompSeq = "";
        int iCurDash = 1;
        int iLastInx = 0;
        block2: for (Integer iCleaveInx : alCleaveIndices) {
            for (int i = iCurDash; i < alDashIndices.size(); ++i) {
                if ((Integer)alDashIndices.get(i) <= iCleaveInx) continue;
                int iStartInx = (Integer)alDashIndices.get(i - 1);
                if (iLastInx != iStartInx) {
                    sCompSeq = sCompSeq + sequence.substring(iLastInx, iStartInx);
                }
                int iEndInx = sequence.indexOf("-", iStartInx + 2);
                if (iStartInx == 0 || i == alDashIndices.size() - 1) {
                    if (iStartInx > 0) {
                        sCompSeq = sCompSeq + "--";
                    }
                    sCompSeq = sCompSeq + sSwapText1;
                } else {
                    String sSeq = sequence.substring(iStartInx, iEndInx);
                    if (!sSeq.startsWith("--")) {
                        sCompSeq = sCompSeq + "--";
                    }
                    sCompSeq = sCompSeq + sequence.substring(iStartInx, iEndInx);
                }
                sCompSeq = sCompSeq + sSwapText2;
                String sCleavage = sequence.substring(iCleaveInx - 1, iCleaveInx + 8);
                sCompSeq = sCompSeq + sCleavage;
                iLastInx = iCleaveInx + 8;
                iCurDash = i;
                continue block2;
            }
        }
        if (iLastInx > 0) {
            sCompSeq = sCompSeq + sequence.substring(iLastInx);
        }
        return sCompSeq;
    }
}

