/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Annotation
implements Comparable<Annotation>,
SAXUtils.SAXWriter {
    protected FragmentEntry fragmentEntry;
    protected IonCloud ions;
    protected IonCloud neutralExchanges;

    public Annotation() {
        this.fragmentEntry = new FragmentEntry();
        this.ions = new IonCloud();
        this.neutralExchanges = new IonCloud();
        this.fragmentEntry.setCharges(this.ions, this.neutralExchanges);
    }

    public Annotation(FragmentEntry f) {
        this.fragmentEntry = f != null ? f.clone() : new FragmentEntry();
        this.ions = this.fragmentEntry.getCharges();
        this.neutralExchanges = this.fragmentEntry.getNeutralExchanges();
    }

    public Annotation(FragmentEntry f, IonCloud c) {
        this.fragmentEntry = f != null ? f.clone() : new FragmentEntry();
        this.ions = c != null ? c.clone() : new IonCloud();
        this.neutralExchanges = new IonCloud();
        this.fragmentEntry.setCharges(this.ions, this.neutralExchanges);
    }

    public Annotation(FragmentEntry f, IonCloud c, IonCloud e) {
        this.fragmentEntry = f != null ? f.clone() : new FragmentEntry();
        this.ions = c != null ? c.clone() : new IonCloud();
        this.neutralExchanges = e != null ? e.clone() : new IonCloud();
        this.fragmentEntry.setCharges(this.ions, this.neutralExchanges);
    }

    public Annotation clone() {
        return new Annotation(this.fragmentEntry, this.ions, this.neutralExchanges);
    }

    public FragmentEntry getFragmentEntry() {
        return this.fragmentEntry;
    }

    public IonCloud getIons() {
        return this.ions;
    }

    public IonCloud getNeutralExchanges() {
        return this.neutralExchanges;
    }

    public boolean isEmpty() {
        return !(this.fragmentEntry.fragment != null && !this.fragmentEntry.fragment.isEmpty() || this.fragmentEntry.name != null && this.fragmentEntry.name.length() != 0);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Annotation)) {
            return false;
        }
        Annotation a = (Annotation)other;
        return this.fragmentEntry.equals((Object)a.fragmentEntry) && this.ions.equals((Object)a.ions) && this.neutralExchanges.equals((Object)a.neutralExchanges);
    }

    public int hashCode() {
        int ret = 0;
        ret += this.fragmentEntry.hashCode();
        ret += this.ions.hashCode();
        return ret += this.neutralExchanges.hashCode();
    }

    @Override
    public int compareTo(Annotation a) {
        if (a == null) {
            return 1;
        }
        return this.fragmentEntry.compareTo(a.fragmentEntry);
    }

    public double getAccuracy(Peak peak) {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.getMZ() - peak.getMZ();
    }

    public double getAccuracyPPM(Peak peak) {
        if (this.isEmpty()) {
            return 0.0;
        }
        return 1000000.0 * (this.getMZ() / peak.getMZ() - 1.0);
    }

    public double getMZ() {
        return this.ions.computeMZ(this.neutralExchanges.getIonsMass() + this.fragmentEntry.mass);
    }

    public int getZ() {
        return this.ions.getIonsNum();
    }

    public String toString() {
        return this.fragmentEntry + " " + this.ions + " " + this.neutralExchanges;
    }

    public static Annotation fromXML(Node ann_node) throws Exception {
        Annotation ret = new Annotation();
        Node fe_node = XMLUtils.assertChild((Node)ann_node, (String)"FragmentEntry");
        ret.fragmentEntry = FragmentEntry.fromXML((Node)fe_node);
        ret.ions = IonCloud.fromString((String)XMLUtils.getAttribute((Node)ann_node, (String)"ions"));
        ret.neutralExchanges = IonCloud.fromString((String)XMLUtils.getAttribute((Node)ann_node, (String)"neutralExchanges"));
        ret.fragmentEntry.setCharges(ret.ions, ret.neutralExchanges, false);
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element ann_node = document.createElement("Annotation");
        if (ann_node == null) {
            return null;
        }
        Element fe_node = this.fragmentEntry.toXML(document);
        if (fe_node == null) {
            return null;
        }
        ann_node.appendChild(fe_node);
        ann_node.setAttribute("ions", this.ions.toString());
        ann_node.setAttribute("neutralExchanges", this.neutralExchanges.toString());
        return ann_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "ions", "CDATA", this.ions.toString());
        atts.addAttribute("", "", "neutralExchanges", "CDATA", this.neutralExchanges.toString());
        th.startElement("", "", "Annotation", atts);
        this.fragmentEntry.write(th);
        th.endElement("", "", "Annotation");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Annotation";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(FragmentEntry.SAXHandler.getNodeElementName())) {
                return new FragmentEntry.SAXHandler();
            }
            return null;
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            Annotation ret = new Annotation();
            try {
                ret.ions = IonCloud.fromString((String)this.stringAttribute(atts, "ions", ""));
                ret.neutralExchanges = IonCloud.fromString((String)this.stringAttribute(atts, "neutralExchanges", ""));
            }
            catch (Exception e) {
                throw new SAXException(this.createMessage(e));
            }
            this.object = ret;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            Annotation ret = (Annotation)this.object;
            ret.fragmentEntry = (FragmentEntry)this.getSubObject(FragmentEntry.SAXHandler.getNodeElementName(), true);
            ret.fragmentEntry.setCharges(ret.ions, ret.neutralExchanges, false);
            return ret;
        }
    }
}

