/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;

public abstract class ModalDialog
extends TitleAreaDialog {
    protected Composite parent;
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");

    public ModalDialog(Shell parentShell) {
        super(parentShell);
        this.parent = parentShell;
        Monitor primary = parentShell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = parentShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        parentShell.setLocation(x, y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected boolean checkBasicLengthCheck(Label targetLabel, Text targetText, int min, int max) {
        if (targetLabel.getFont().equals((Object)this.boldFont) && targetText.getText().length() == min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be empty. Please provide a name.");
            return false;
        }
        if (targetText.getText().length() > max || targetText.getText().length() < min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be longer than " + max + " characters");
            return false;
        }
        this.removeError(targetLabel);
        return true;
    }

    protected void removeError(Label targetLabel) {
        targetLabel.setForeground(this.parent.getDisplay().getSystemColor(2));
        this.setErrorMessage(null);
    }

    protected void setError(Label targetLabel, String string) {
        this.setErrorMessage(string);
        targetLabel.setForeground(this.parent.getDisplay().getSystemColor(3));
    }

    protected Label createSeparator(int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(this.parent, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    protected Button createButtonOK(Composite parent2) {
        GridData okData = new GridData();
        okData.grabExcessHorizontalSpace = true;
        okData.horizontalAlignment = 3;
        okData.horizontalSpan = 2;
        okData.widthHint = 100;
        Button OKbutton = new Button(parent2, 8);
        OKbutton.setText("OK");
        OKbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ModalDialog.this.isValidInput()) {
                    ModalDialog.this.okPressed();
                    ModalDialog.this.close();
                }
            }
        });
        OKbutton.setLayoutData((Object)okData);
        return OKbutton;
    }

    protected Button createButtonCancel(Composite parent2) {
        GridData cancelData = new GridData();
        cancelData.horizontalAlignment = 3;
        cancelData.grabExcessHorizontalSpace = true;
        cancelData.widthHint = 100;
        cancelData.horizontalSpan = 2;
        Button CancelButton = new Button(parent2, 8);
        CancelButton.setText("Cancel");
        CancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModalDialog.this.setReturnCode(1);
                ModalDialog.this.close();
            }
        });
        CancelButton.setLayoutData((Object)cancelData);
        return CancelButton;
    }

    protected Label setMandatoryLabel(Label lable) {
        lable.setText(String.valueOf(lable.getText()) + "*");
        lable.setFont(this.boldFont);
        return lable;
    }

    protected boolean findSameNameEntry(String _entryName, Entry parent, String type) {
        if (parent != null) {
            List<Entry> children = parent.getChildren();
            for (Entry child : children) {
                if (!child.getProperty().getType().equals(type) || !child.getDisplayName().equals(_entryName)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isValidInput();

    protected abstract Entry createEntry();
}

