/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.filter.visitor;

import java.util.HashMap;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserTreeSingle;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.grits.toolbox.util.structure.glycan.filter.visitor.MonosaccharidePattern;
import org.grits.toolbox.util.structure.glycan.filter.visitor.MonosaccharidePatternMatcher;

public class GlycoVisitorLinakgePattern
implements GlycoVisitor {
    private MonosaccharidePattern m_pattern = null;
    private MonosaccharidePatternMatcher m_matcher = new MonosaccharidePatternMatcher();
    private boolean m_foundPattern = false;
    private boolean m_violatePattern = false;
    private boolean m_terminal = false;
    private HashMap<Integer, Boolean> m_parentLinkage = new HashMap();

    public MonosaccharidePattern getMonosaccharidePattern() {
        return this.m_pattern;
    }

    public void setMonosaccharidePattern(MonosaccharidePattern a_pattern) {
        this.m_pattern = a_pattern;
    }

    public void linkagePattern(String a_pattern) throws GlycoVisitorException {
        String[] t_parts;
        this.m_parentLinkage.clear();
        String t_pattern = a_pattern.trim();
        if (t_pattern.length() == 0) {
            throw new GlycoVisitorException("Invalid linkage pattern: missing linkage position");
        }
        for (String t_string : t_parts = t_pattern.split(",")) {
            try {
                this.m_parentLinkage.put(Integer.parseInt(t_string.trim()), Boolean.TRUE);
            }
            catch (NumberFormatException e) {
                throw new GlycoVisitorException("Invalid linkage pattern: linkage position must be a number: " + t_string, (Throwable)e);
            }
        }
    }

    public void clear() {
        this.m_foundPattern = false;
        this.m_violatePattern = false;
        if (this.m_pattern.getAllowSubstituents() == null) {
            this.m_pattern.setAllowSubstituents(false);
        }
        if (this.m_pattern.getAllowModifications() == null) {
            this.m_pattern.setAllowModifications(false);
        }
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_visitor) throws GlycoVisitorException {
        return new GlycoTraverserTreeSingle(a_visitor);
    }

    public void start(Sugar a_sugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_sugar);
        for (UnderdeterminedSubTree t_tree : a_sugar.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(NonMonosaccharide a_arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitRepeat a_repeat) throws GlycoVisitorException {
        GlycoTraverser t_traverser = this.getTraverser(this);
        t_traverser.traverseGraph((GlycoGraph)a_repeat);
        for (UnderdeterminedSubTree t_tree : a_repeat.getUndeterminedSubTrees()) {
            t_traverser.traverseGraph((GlycoGraph)t_tree);
        }
    }

    public void visit(Substituent a_arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitCyclic a_arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative is not supported.");
    }

    public void visit(UnvalidatedGlycoNode a_arg0) throws GlycoVisitorException {
        throw new GlycoVisitorException("UnvalidatedGlycoNode is not supported.");
    }

    public void visit(GlycoEdge a_arg0) throws GlycoVisitorException {
    }

    public void visit(Monosaccharide a_monosaccharide) throws GlycoVisitorException {
        if (this.m_matcher.matchMonosaccharide(this.m_pattern, a_monosaccharide) && a_monosaccharide.getParentEdge() != null) {
            if (this.m_terminal) {
                if (a_monosaccharide.getChildEdges().size() == this.m_matcher.getSubstituents().size()) {
                    if (this.matchLinkage(this.m_parentLinkage, a_monosaccharide.getParentEdge())) {
                        this.m_foundPattern = true;
                    } else {
                        this.m_violatePattern = true;
                    }
                }
            } else if (this.matchLinkage(this.m_parentLinkage, a_monosaccharide.getParentEdge())) {
                this.m_foundPattern = true;
            } else {
                this.m_violatePattern = true;
            }
        }
    }

    private boolean matchLinkage(HashMap<Integer, Boolean> a_linkagePositions, GlycoEdge a_parentEdge) {
        for (Linkage t_linkage : a_parentEdge.getGlycosidicLinkages()) {
            for (Integer t_pos : t_linkage.getParentLinkages()) {
                if (t_pos == -1) {
                    return true;
                }
                if (a_linkagePositions.get(t_pos) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFoundPattern() {
        if (this.m_foundPattern) {
            return !this.m_violatePattern;
        }
        return false;
    }

    public boolean isTerminal() {
        return this.m_terminal;
    }

    public void setTerminal(boolean a_terminal) {
        this.m_terminal = a_terminal;
    }
}

