/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.MonosaccharideIndex;

public class CondensedConverter
extends IUPACNotationConverter {
    public String start(Node _node, boolean _iswebStyle) throws GlycanException {
        Node copy = _node.copy();
        this.makeTrivialName(copy);
        return this.makeCondensedNotation(copy, _iswebStyle);
    }

    private String makeCondensedNotation(Node _copy, boolean _iswebStyle) {
        Monosaccharide mono = (Monosaccharide)_copy;
        String threeLetter = this.getThreeLetterCode().toString();
        String configuration = "?";
        if (!mono.getStereos().isEmpty()) {
            configuration = this.makeConfiguration(mono.getStereos().getFirst()).toUpperCase();
        }
        StringBuilder ret = new StringBuilder(threeLetter);
        MonosaccharideIndex monoInd = MonosaccharideIndex.forTrivialNameWithIgnore(threeLetter);
        if (_iswebStyle) {
            SuperClass superclass;
            if (monoInd != null || mono.getStereos().size() == 1) {
                ret.insert(0, configuration);
            }
            if ((superclass = SuperClass.forSuperClassWithIgnore(threeLetter)) != null) {
                ret.insert(0, configuration);
            }
        } else {
            if (monoInd != null && !monoInd.getFirstConfiguration().endsWith(configuration)) {
                ret.insert(0, String.valueOf(configuration) + "-");
            }
            if (monoInd == null && mono.getStereos().size() != 2) {
                ret.insert(0, String.valueOf(configuration) + "-");
            }
        }
        ret.insert(0, this.getSubConv().getPrefixSubstituent());
        ret.append(this.extractUlonic(mono));
        String ringSize = this.defineRingSize(_copy);
        if (_iswebStyle) {
            ret.append(ringSize);
        } else if (monoInd != null) {
            if (!monoInd.getRingSize().equals(ringSize)) {
                ret.append(ringSize);
            }
        } else {
            ret.append(ringSize);
        }
        ret.append(this.getSubConv().getCoreSubstituentNotaiton());
        String acidicStatus = this.makeAcidicStatus(_copy);
        if (acidicStatus.equals("A")) {
            ret.append(acidicStatus);
        }
        ret.append(this.getSubConv().getSubstituentNotation());
        if (!acidicStatus.equals("A") && !this.containUlonicAcid(this.getThreeLetterCode())) {
            ret.append(acidicStatus);
        }
        if (this.isAlditol(_copy)) {
            ret.append("-ol");
        }
        if (this.isAldehyde(_copy)) {
            ret.insert(0, "aldehyde-");
        }
        return ret.toString();
    }
}

