/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.GlycanIOUtils;
import org.grits.toolbox.tools.glycanbuilder.core.io.ImageFormat;
import org.grits.toolbox.tools.glycanbuilder.core.io.SequenceFormat;
import org.grits.toolbox.tools.glycanbuilder.core.io.parser.GWSParser;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanDocument;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanInfo;
import org.grits.toolbox.tools.glycanbuilder.database.GlycanDatabaseUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.DatabaseExportDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.DatabaseInformationComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.FormAbstract;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.ImportTextComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.Messages;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.MultiPageFormAbstract;
import org.grits.toolbox.util.structure.glycan.database.GlycanDatabase;
import org.grits.toolbox.util.structure.glycan.database.GlycanStructure;

public class FileForm
extends FormAbstract {
    private boolean m_bIsChanged;
    private Button m_btnNew;
    private Button m_btnOpen;
    private Button m_btnInsert;
    private Button m_btnSave;
    private Button m_btnSaveAs;
    private Map<SequenceFormat, Button> m_mapSecFormatToButtonForExportSelection = new HashMap<SequenceFormat, Button>();
    private Map<SequenceFormat, Button> m_mapSecFormatToButtonForExportAll = new HashMap<SequenceFormat, Button>();
    private Map<ImageFormat, Button> m_mapImgFormatToButtonForExportSelection = new HashMap<ImageFormat, Button>();
    private Map<ImageFormat, Button> m_mapImgFormatToButtonForExportCurrent = new HashMap<ImageFormat, Button>();
    private Map<SequenceFormat, Button> m_mapSecFormatToButtonForImport = new HashMap<SequenceFormat, Button>();
    private ImportTextComposite m_importText;
    private Button m_btnImportDatabase;
    private Button m_btnExportDatabase;
    private DatabaseInformationComposite m_dbInfo;

    public FileForm(MultiPageFormAbstract parent, String tabText) {
        super(parent, tabText);
        this.createControl();
    }

    public void setChanged(boolean changed) {
        this.m_bIsChanged = changed;
    }

    private void createControl() {
        Enum format;
        this.getForm().setText(Messages.getString("File.title"));
        Button btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("File.new"), 0x800000);
        btn.setToolTipText(Messages.getString("File.new_desc"));
        this.m_btnNew = btn;
        btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("File.open"), 0x800000);
        btn.setToolTipText(Messages.getString("File.open_desc"));
        this.m_btnOpen = btn;
        btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("File.insert"), 0x800000);
        btn.setToolTipText(Messages.getString("File.insert_desc"));
        this.m_btnInsert = btn;
        btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("File.save"), 0x800000);
        btn.setToolTipText(Messages.getString("File.save_desc"));
        this.m_btnSave = btn;
        btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("File.save_as"), 0x800000);
        btn.setToolTipText(Messages.getString("File.save_as_desc"));
        this.m_btnSaveAs = btn;
        Composite sectionClient = this.createNewSection(Messages.getString("File.export"));
        ExpandableComposite exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.export_sequence_selection"));
        exp.setToolTipText(Messages.getString("File.export_sequence_selection_desc"));
        Enum[] enumArray = SequenceFormat.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            format = enumArray[n2];
            btn = this.getToolkit().createButton((Composite)exp.getClient(), ((SequenceFormat)format).getName(), 0x800000);
            btn.setToolTipText(((SequenceFormat)format).getDescription());
            this.m_mapSecFormatToButtonForExportSelection.put((SequenceFormat)format, btn);
            ++n2;
        }
        exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.export_sequence_all"));
        exp.setToolTipText(Messages.getString("File.export_sequence_all_desc"));
        enumArray = SequenceFormat.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            format = enumArray[n2];
            btn = this.getToolkit().createButton((Composite)exp.getClient(), ((SequenceFormat)format).getName(), 0x800000);
            btn.setToolTipText(((SequenceFormat)format).getDescription());
            this.m_mapSecFormatToButtonForExportAll.put((SequenceFormat)format, btn);
            ++n2;
        }
        exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.export_image_selection"));
        exp.setToolTipText(Messages.getString("File.export_image_selection_desc"));
        enumArray = ImageFormat.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            format = enumArray[n2];
            btn = this.getToolkit().createButton((Composite)exp.getClient(), ((ImageFormat)format).getName(), 0x800000);
            btn.setToolTipText(((ImageFormat)format).getDescription());
            this.m_mapImgFormatToButtonForExportSelection.put((ImageFormat)format, btn);
            ++n2;
        }
        exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.export_image_current"));
        exp.setToolTipText(Messages.getString("File.export_image_current_desc"));
        enumArray = ImageFormat.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            format = enumArray[n2];
            btn = this.getToolkit().createButton((Composite)exp.getClient(), ((ImageFormat)format).getName(), 0x800000);
            btn.setToolTipText(((ImageFormat)format).getDescription());
            this.m_mapImgFormatToButtonForExportCurrent.put((ImageFormat)format, btn);
            ++n2;
        }
        sectionClient = this.createNewSection(Messages.getString("File.import"));
        exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.import_sequence"));
        enumArray = SequenceFormat.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            format = enumArray[n2];
            btn = this.getToolkit().createButton((Composite)exp.getClient(), ((SequenceFormat)format).getName(), 0x800000);
            btn.setToolTipText(((SequenceFormat)format).getDescription());
            this.m_mapSecFormatToButtonForImport.put((SequenceFormat)format, btn);
            ++n2;
        }
        exp = this.createExpandableComposite(sectionClient);
        exp.setText(Messages.getString("File.import_text"));
        this.m_importText = new ImportTextComposite((Composite)exp.getClient(), this.getToolkit());
        sectionClient = this.createNewSection(Messages.getString("File.database"));
        Group grp = new Group(sectionClient, 0);
        grp.setBackground(sectionClient.getBackground());
        grp.setText(Messages.getString("File.db_info"));
        this.m_dbInfo = new DatabaseInformationComposite((Composite)grp, this.getToolkit());
        btn = this.getToolkit().createButton(sectionClient, Messages.getString("File.import_db"), 0x800000);
        btn.setToolTipText(Messages.getString("File.import_db_desc"));
        this.m_btnImportDatabase = btn;
        btn = this.getToolkit().createButton(sectionClient, Messages.getString("File.export_db"), 0x800000);
        btn.setToolTipText(Messages.getString("File.export_db_desc"));
        this.m_btnExportDatabase = btn;
    }

    public void addListenerToGlycanDocument(GlycanDocument doc) {
        doc.addListener(new GlycanDocument.Listener(){

            @Override
            public void stateSaved() {
                FileForm.this.m_bIsChanged = true;
            }

            @Override
            public void stateLoaded() {
                FileForm.this.m_bIsChanged = true;
            }

            @Override
            public void fileSaved() {
                FileForm.this.m_bIsChanged = false;
            }

            @Override
            public void fileOpened() {
                FileForm.this.m_bIsChanged = false;
            }
        });
    }

    public void addSelecionListenersForCanvas(final GlycanCanvasComposite canvas) {
        Button btn = this.m_btnNew;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileForm.this.confirmSaveBeforeChange(canvas, ((Button)e.widget).getToolTipText())) {
                    return;
                }
                FileForm.this.m_dbInfo.clearForm();
                canvas.resetDocument();
                canvas.updateView();
            }
        });
        btn = this.m_btnOpen;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileForm.this.confirmSaveBeforeChange(canvas, ((Button)e.widget).getToolTipText())) {
                    return;
                }
                canvas.resetDocument();
                canvas.getBuilderWorkspace().getGlycanDocument().open(null);
                canvas.loadDocument();
                canvas.updateView();
            }
        });
        btn = this.m_btnInsert;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getBuilderWorkspace().getGlycanDocument().insert(null);
                canvas.loadDocument();
                canvas.updateView();
            }
        });
        btn = this.m_btnSave;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getBuilderWorkspace().getGlycanDocument().save();
            }
        });
        btn = this.m_btnSaveAs;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getBuilderWorkspace().getGlycanDocument().saveAs();
            }
        });
        for (final SequenceFormat sequenceFormat : this.m_mapSecFormatToButtonForExportSelection.keySet()) {
            btn = this.m_mapSecFormatToButtonForExportSelection.get((Object)sequenceFormat);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List lGlycans = FileForm.this.getSelectedGlycansFromCanvas(canvas);
                    if (lGlycans == null) {
                        return;
                    }
                    GlycanIOUtils.saveGlycanSequence(lGlycans, sequenceFormat, false);
                }
            });
        }
        for (final SequenceFormat sequenceFormat : this.m_mapSecFormatToButtonForExportAll.keySet()) {
            btn = this.m_mapSecFormatToButtonForExportAll.get((Object)sequenceFormat);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List lGlycans = FileForm.this.getAllGlycans(canvas);
                    if (lGlycans == null) {
                        return;
                    }
                    GlycanIOUtils.saveGlycanSequence(lGlycans, sequenceFormat, false);
                }
            });
        }
        for (final ImageFormat imageFormat : this.m_mapImgFormatToButtonForExportSelection.keySet()) {
            btn = this.m_mapImgFormatToButtonForExportSelection.get((Object)imageFormat);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List lGlycans = FileForm.this.getSelectedGlycansFromCanvas(canvas);
                    if (lGlycans == null) {
                        return;
                    }
                    GlycanIOUtils.saveGlycanImage(lGlycans, canvas.getBuilderWorkspace(), imageFormat);
                }
            });
        }
        for (final ImageFormat imageFormat : this.m_mapImgFormatToButtonForExportCurrent.keySet()) {
            btn = this.m_mapImgFormatToButtonForExportCurrent.get((Object)imageFormat);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List lGlycans = FileForm.this.getAllGlycansFromCurrentCanvas(canvas);
                    if (lGlycans == null) {
                        return;
                    }
                    GlycanIOUtils.saveGlycanImage(lGlycans, canvas.getBuilderWorkspace(), imageFormat);
                }
            });
        }
        for (final SequenceFormat sequenceFormat : this.m_mapSecFormatToButtonForImport.keySet()) {
            btn = this.m_mapSecFormatToButtonForImport.get((Object)sequenceFormat);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List<Glycan> lGlycans = GlycanIOUtils.loadGlycans(sequenceFormat, canvas.getBuilderWorkspace().getDefaultMassOptions());
                    if (lGlycans == null) {
                        return;
                    }
                    canvas.addGlycans(lGlycans);
                    canvas.updateView();
                }
            });
        }
        this.m_importText.addImportListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileForm.this.m_importText.getSequence().isEmpty()) {
                    MessageBox box = new MessageBox(FileForm.this.getForm().getShell(), 33);
                    box.setMessage("Please enter a sequence.");
                    box.open();
                    return;
                }
                List<Glycan> lGlycans = GlycanIOUtils.getGlycansFromSequence(FileForm.this.m_importText.getSequence(), FileForm.this.m_importText.getSequenceFormat(), canvas.getBuilderWorkspace().getDefaultMassOptions());
                if (lGlycans == null || lGlycans.isEmpty()) {
                    return;
                }
                FileForm.this.m_importText.clearText();
                canvas.addGlycans(lGlycans);
                canvas.updateView();
            }
        });
        btn = this.m_btnImportDatabase;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileForm.this.confirmSaveBeforeChange(canvas, ((Button)e.widget).getToolTipText())) {
                    return;
                }
                canvas.resetDocument();
                GlycanDatabase database = GlycanDatabaseUtils.loadGlycanDatabase();
                if (database == null) {
                    return;
                }
                boolean bOverwrite = true;
                if (!FileForm.this.m_dbInfo.isEmpty()) {
                    MessageBox box = new MessageBox(FileForm.this.getForm().getShell(), 200);
                    box.setMessage("Do you want to overwrite current database information with imported one?");
                    if (box.open() == 128) {
                        bOverwrite = false;
                    }
                }
                if (bOverwrite) {
                    FileForm.this.m_dbInfo.setDatabaseName(database.getName());
                    FileForm.this.m_dbInfo.setDatabaseVersion(database.getVersion());
                    FileForm.this.m_dbInfo.setDatabaseDescription(database.getDescription());
                }
                try {
                    ArrayList<GlycanInfo> gInfos = new ArrayList<GlycanInfo>();
                    for (GlycanStructure gStructure : database.getStructures()) {
                        Glycan glycan = GWSParser.fromString(gStructure.getGWBSequence(), canvas.getBuilderWorkspace().getDefaultMassOptions());
                        GlycanInfo gInfo = new GlycanInfo(glycan);
                        gInfo.setID(gStructure.getId());
                        gInfos.add(gInfo);
                    }
                    canvas.getBuilderWorkspace().getGlycanDocument().addStructures(gInfos);
                    canvas.loadDocument();
                    canvas.updateView();
                }
                catch (Exception e1) {
                    MessageBox box = new MessageBox(FileForm.this.getForm().getShell(), 33);
                    box.setMessage("A sequence can not be imported correctly.");
                    box.open();
                    LogUtils.report((Exception)e1);
                }
            }
        });
        btn = this.m_btnExportDatabase;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (canvas.getBuilderWorkspace().getGlycanDocument().isEmpty()) {
                    MessageBox box = new MessageBox(FileForm.this.getForm().getShell(), 40);
                    box.setMessage("No glycan in this canvas.");
                    box.open();
                    return;
                }
                if (canvas.colorDuplicatedIDs()) {
                    MessageBox box = new MessageBox(FileForm.this.getForm().getShell(), 33);
                    box.setText("Duplicated IDs are detected");
                    box.setMessage("Please specify a unique or empty ID to each glycan.");
                    box.open();
                    return;
                }
                DatabaseExportDialog dlg = new DatabaseExportDialog(FileForm.this.getForm().getShell(), canvas.getBuilderWorkspace().getGlycanDocument());
                if (!FileForm.this.m_dbInfo.isEmpty()) {
                    dlg.setDatabaseInformation(FileForm.this.m_dbInfo);
                }
                dlg.open();
            }
        });
    }

    private boolean confirmSaveBeforeChange(GlycanCanvasComposite canvas, String title) {
        if (!this.m_bIsChanged) {
            return true;
        }
        if (canvas.getAllGlycans().isEmpty()) {
            return true;
        }
        MessageBox box = new MessageBox(this.getForm().getShell(), 452);
        box.setText(title);
        box.setMessage("Save changes to structures?");
        int ret = box.open();
        if (ret == 256) {
            return false;
        }
        if (ret == 64) {
            canvas.getBuilderWorkspace().getGlycanDocument().save();
        }
        return true;
    }

    private List<Glycan> getAllGlycans(GlycanCanvasComposite canvas) {
        ArrayList<Glycan> lGlycans = new ArrayList<Glycan>();
        for (GlycanInfo info : canvas.getBuilderWorkspace().getGlycanDocument().getStructures()) {
            Glycan glycan = info.getGlycan();
            if (glycan == null) continue;
            lGlycans.add(glycan);
        }
        return lGlycans;
    }

    private List<Glycan> getAllGlycansFromCurrentCanvas(GlycanCanvasComposite canvas) {
        List<Glycan> lGlycans = canvas.getAllGlycans();
        if (lGlycans.isEmpty()) {
            MessageBox box = new MessageBox(canvas.getControl().getShell(), 40);
            box.setMessage("No glycan in this canvas.");
            box.open();
            return null;
        }
        return lGlycans;
    }

    private List<Glycan> getSelectedGlycansFromCanvas(GlycanCanvasComposite canvas) {
        if (canvas.hasSelection()) {
            if (canvas.getSelectedGlycanLabels().size() > 1) {
                return canvas.getSelectedGlycans();
            }
            ArrayList<Glycan> lGlycan = new ArrayList<Glycan>();
            lGlycan.add(canvas.getSelectedGlycanLabels().get(0).getGlycan());
            return lGlycan;
        }
        MessageBox box = new MessageBox(canvas.getControl().getShell(), 40);
        box.setMessage("No glycan is selected.");
        box.open();
        return null;
    }
}

