/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.grits.toolbox.util.structure.glycan.filter.om.ComboFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FiltersLibrary;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterAnd;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterAntenna;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterGlycanFeature;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterLinkage;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterModification;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterMonosaccharide;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterNot;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterOr;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterResidueCount;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterSubstituent;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterSubstructure;

public class FilterUtils {
    public static Class[] filterClassContext = new Class[]{GlycanFilterMonosaccharide.class, GlycanFilterSubstituent.class, GlycanFilterSubstructure.class, GlycanFilterModification.class, GlycanFilterGlycanFeature.class, GlycanFilterAnd.class, GlycanFilterOr.class, GlycanFilterNot.class, GlycanFilterAntenna.class, ComboFilter.class, GlycanFilterLinkage.class, GlycanFilterResidueCount.class};

    public static FiltersLibrary readFilters(String filepath) throws UnsupportedEncodingException, JAXBException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(filepath);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(filterClassContext));
        contextList.add(FiltersLibrary.class);
        JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FiltersLibrary filtersLibrary = (FiltersLibrary)unmarshaller.unmarshal((Reader)reader);
        return filtersLibrary;
    }

    public static FiltersLibrary readCustomFilters(String filepath, JAXBContext context) throws UnsupportedEncodingException, JAXBException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(filepath);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FiltersLibrary filtersLibrary = (FiltersLibrary)unmarshaller.unmarshal((Reader)reader);
        return filtersLibrary;
    }

    public static void updateLibrary(FiltersLibrary library, String filepath, JAXBContext context) throws JAXBException, IOException {
        String version = library.getVersion();
        String[] versionBits = version.split("\\.");
        if (versionBits != null && versionBits.length == 3) {
            String localVersion = versionBits[2];
            try {
                Integer vInt;
                Integer n = vInt = Integer.valueOf(Integer.parseInt(localVersion));
                Integer n2 = vInt = Integer.valueOf(vInt + 1);
                version = versionBits[0] + "." + versionBits[1] + "." + String.valueOf(vInt);
                library.setVersion(version);
            }
            catch (NumberFormatException e) {
                throw new IOException("Version format is incorrect! Cannot update the version", e);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)library, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(filepath);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    public static boolean needToCopyFilterLibraryFromJar(FiltersLibrary library, FiltersLibrary localLibrary) throws Exception {
        String version1 = library.getVersion();
        String[] version1Split = version1.split("\\.");
        String version2 = localLibrary.getVersion();
        String[] version2Split = version2.split("\\.");
        if (version2Split.length == 3 && version1Split.length == 3) {
            String localMajorMinor;
            String majorMinor = version1Split[0] + "." + version1Split[1];
            return !majorMinor.equals(localMajorMinor = version2Split[0] + "." + version2Split[1]);
        }
        throw new Exception("Version numbers are invalid!");
    }

    public static boolean mergeFilterLibraries(FiltersLibrary library, FiltersLibrary localLibrary) throws Exception {
        if (library == null || localLibrary == null) {
            return false;
        }
        String version1 = library.getVersion();
        String[] version1Split = version1.split("\\.");
        String version2 = localLibrary.getVersion();
        String[] version2Split = version2.split("\\.");
        if (version2Split.length == 3 && version1Split.length == 3) {
            Integer lastDigitLocal = Integer.parseInt(version2Split[2]);
            if (lastDigitLocal > 0) {
                String newVersion = version1Split[0] + "." + version1Split[1] + "." + version2Split[2];
                localLibrary.setVersion(newVersion);
                for (Filter f : library.getFilters()) {
                    if (localLibrary.getFilters().contains(f)) {
                        int idx = localLibrary.getFilters().indexOf(f);
                        localLibrary.getFilters().remove(idx);
                    }
                    localLibrary.addFilter(f);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

