/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.filter.om;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterException;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterVisitor;
import org.grits.toolbox.util.structure.glycan.filter.om.IntegerFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.MonosaccharideDefintion;

@XmlRootElement(name="antennaFilter")
public class GlycanFilterAntenna
extends IntegerFilter {
    private List<MonosaccharideDefintion> m_excludeMonosaccharide = new ArrayList<MonosaccharideDefintion>();
    private boolean m_filterBisection = true;

    @XmlAttribute
    public boolean isFilterBisection() {
        return this.m_filterBisection;
    }

    public void setFilterBisection(boolean a_filterBisection) {
        this.m_filterBisection = a_filterBisection;
    }

    @Override
    public boolean accept(GlycanFilterVisitor a_operator) throws GlycanFilterException {
        return a_operator.visit(this);
    }

    @Override
    public Filter copy() {
        GlycanFilterAntenna copy = new GlycanFilterAntenna();
        copy.setName(this.name);
        copy.setDescription(this.description);
        copy.setLabel(this.label);
        copy.setClassification(this.classification);
        copy.setMin(this.m_min);
        copy.setMax(this.m_max);
        copy.setFilterBisection(this.m_filterBisection);
        ArrayList<MonosaccharideDefintion> t_definitions = new ArrayList<MonosaccharideDefintion>();
        for (MonosaccharideDefintion t_monosaccharideDefintion : this.m_excludeMonosaccharide) {
            t_definitions.add(t_monosaccharideDefintion.copy());
        }
        copy.setExcludeMonosaccharide(t_definitions);
        return copy;
    }

    public List<MonosaccharideDefintion> getExcludeMonosaccharide() {
        return this.m_excludeMonosaccharide;
    }

    public void setExcludeMonosaccharide(List<MonosaccharideDefintion> a_excludeMonosaccharide) {
        this.m_excludeMonosaccharide = a_excludeMonosaccharide;
    }
}

