/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.util.structure.glycan.filter.om;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterException;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterOrder;
import org.grits.toolbox.util.structure.glycan.filter.om.GlycanFilterVisitor;

@XmlRootElement(name="combinationFilter")
public class ComboFilter
extends Filter {
    private List<Filter> filters;
    private List<FilterOrder> filterOrders;
    private Filter selected = null;
    FilterOrderComparator comp = new FilterOrderComparator();

    @Override
    public boolean accept(GlycanFilterVisitor a_operator) throws GlycanFilterException {
        return a_operator.visit(this);
    }

    @XmlElementRef
    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<Filter> getFiltersInFilterOrder() {
        if (this.filterOrders != null) {
            Collections.sort(this.filters, this.comp);
        }
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
        Collections.sort(filters);
    }

    @XmlIDREF
    @XmlAttribute
    public Filter getSelected() {
        return this.selected;
    }

    public void setSelected(Filter selected) {
        this.selected = selected;
    }

    public String toString() {
        if (this.selected != null) {
            return this.selected.toString();
        }
        return super.toString();
    }

    @Override
    public Filter copy() {
        ComboFilter copy = new ComboFilter();
        copy.setName(this.name);
        copy.setDescription(this.description);
        copy.setLabel(this.label);
        copy.setClassification(this.classification);
        copy.setFilters(this.filters);
        if (this.selected != null) {
            copy.setSelected(this.selected.copy());
        }
        copy.setFilterOrders(this.filterOrders);
        return copy;
    }

    @XmlElement(name="order")
    public List<FilterOrder> getFilterOrders() {
        return this.filterOrders;
    }

    public void setFilterOrders(List<FilterOrder> filterOrders) {
        this.filterOrders = filterOrders;
    }

    class FilterOrderComparator
    implements Comparator<Filter> {
        FilterOrderComparator() {
        }

        @Override
        public int compare(Filter o1, Filter o2) {
            return this.findFilterOrder(o1).compareTo(this.findFilterOrder(o2));
        }

        private Integer findFilterOrder(Filter o1) {
            if (ComboFilter.this.filterOrders != null) {
                for (FilterOrder order : ComboFilter.this.filterOrders) {
                    if (!order.getFilterName().equals(o1.getName())) continue;
                    return order.getOrder();
                }
            }
            return 0;
        }
    }
}

