/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.ontology;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.editor.experimentdesigner.config.ExperimentConfig;
import org.grits.toolbox.editor.experimentdesigner.io.ExperimentTemplateFileHandler;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolEntry;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolExistsException;
import org.grits.toolbox.editor.experimentdesigner.io.ProtocolVariantFileHandler;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.MeasurementUnit;
import org.grits.toolbox.editor.experimentdesigner.model.MyColor;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolCategory;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolPaletteEntry;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignModelAPI;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;
import org.grits.toolbox.editor.experimentdesigner.ontology.OntologyManager;

public class ExperimentDesignOntologyAPI
implements ExperimentDesignModelAPI {
    private static Logger logger = Logger.getLogger(ExperimentDesignOntologyAPI.class);
    private static OntologyManager om;

    private static String getOntologyLocation(String filename) throws Exception {
        if (filename.equals("experimentdesignontology.owl")) {
            URL resourceFileUrl = FileLocator.toFileURL((URL)ExperimentConfig.ONTOLOGY_RESOURCE_URL);
            if (resourceFileUrl == null) {
                throw new Exception("Ontology is missing from the jar.");
            }
            String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + filename;
            return originalJarFilePath;
        }
        String configFolderLocation = PropertyHandler.getVariable((String)"configuration_location");
        File configFolder = new File(configFolderLocation);
        if (configFolder.isDirectory()) {
            List<String> childFiles = Arrays.asList(configFolder.list());
            String experimentSubFolderName = String.valueOf(configFolderLocation) + File.separator + "org.grits.toolbox.editor.experimentdesigner";
            File experimentSubFolder = new File(experimentSubFolderName);
            boolean subFolderExists = experimentSubFolder.exists();
            if (!subFolderExists && !childFiles.contains(experimentSubFolderName)) {
                subFolderExists = experimentSubFolder.mkdir();
            }
            if (subFolderExists) {
                String configOntologyLocation = String.valueOf(experimentSubFolder.getAbsolutePath()) + File.separator + filename;
                childFiles = Arrays.asList(experimentSubFolder.list());
                if (!childFiles.contains(filename)) {
                    URL resourceFileUrl = FileLocator.toFileURL((URL)ExperimentConfig.ONTOLOGY_RESOURCE_URL);
                    String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + filename;
                    File originalJarFile = new File(originalJarFilePath);
                    FileOutputStream configFile = new FileOutputStream(configOntologyLocation);
                    Files.copy(originalJarFile.toPath(), configFile);
                    configFile.close();
                }
                return configOntologyLocation;
            }
        }
        return null;
    }

    private static String copyFromJar(String filename) throws IOException {
        String configOntologyLocation = String.valueOf(ExperimentDesignOntologyAPI.getConfigFolderLocation()) + File.separator + filename;
        URL resourceFileUrl = FileLocator.toFileURL((URL)ExperimentConfig.ONTOLOGY_RESOURCE_URL);
        String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + filename;
        File originalJarFile = new File(originalJarFilePath);
        FileOutputStream configFile = new FileOutputStream(configOntologyLocation);
        Files.copy(originalJarFile.toPath(), configFile);
        configFile.close();
        return configOntologyLocation;
    }

    private static String getConfigFolderLocation() {
        return String.valueOf(PropertyHandler.getVariable((String)"configuration_location")) + File.separator + "org.grits.toolbox.editor.experimentdesigner";
    }

    public static String getTemplateFolderLocation() {
        return String.valueOf(ExperimentDesignOntologyAPI.getConfigFolderLocation()) + File.separator + "experimentTemplates";
    }

    public static String getProtocolVariantFolderLocation() {
        return String.valueOf(ExperimentDesignOntologyAPI.getConfigFolderLocation()) + File.separator + "protocols";
    }

    private static File[] getConfigFilesByDirectory(String directory) throws Exception {
        block3: {
            File dataFolder;
            block4: {
                String configFolderLocation = ExperimentDesignOntologyAPI.getConfigFolderLocation();
                File configFolder = new File(configFolderLocation);
                if (!configFolder.isDirectory()) break block3;
                String dataFolderLocation = String.valueOf(configFolderLocation) + File.separator + directory;
                dataFolder = new File(dataFolderLocation);
                if (dataFolder.exists()) break block4;
                return null;
            }
            return dataFolder.listFiles();
        }
        return null;
    }

    public ExperimentDesignOntologyAPI() throws Exception {
        if (om == null) {
            logger.info((Object)"org.grits.toolbox.editor.experimentdesigner- START : Loading Ontology. ");
            try {
                String filePath1 = ExperimentDesignOntologyAPI.getOntologyLocation("experimentdesignontology.owl");
                if (filePath1 == null) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error loading ontology, file path is empty!");
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Loading Ontology.");
                    throw new Exception("Error loading ontology, file path is empty!");
                }
                String filePath2 = ExperimentDesignOntologyAPI.getOntologyLocation("localexperimentdesignontology.owl");
                if (filePath2 == null) {
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error loading local ontology, file path is empty!");
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Loading Local Ontology.");
                    throw new Exception("Error loading local ontology, file path is empty!");
                }
                om = new OntologyManager(new FileInputStream(new File(filePath1)), new FileInputStream(new File(filePath2)));
                String version = ExperimentDesignOntologyAPI.om.standardOntologymodel.getOntology(OntologyManager.ontURI).getVersionInfo();
                Ontology localOnt = ExperimentDesignOntologyAPI.om.localOntologymodel.getOntology(OntologyManager.ontURI);
                String localVersion = null;
                if (localOnt != null) {
                    localVersion = localOnt.getVersionInfo();
                }
                boolean versionConflict = false;
                if (version != null) {
                    boolean keep;
                    int first = Integer.parseInt(version.substring(0, version.indexOf(".")));
                    if (localVersion == null) {
                        versionConflict = true;
                    } else {
                        int firstLocal = Integer.parseInt(localVersion.substring(0, localVersion.indexOf(".")));
                        if (first != firstLocal) {
                            versionConflict = true;
                        }
                    }
                    if (versionConflict && !(keep = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"The local ontology is out-of-date. Do you want to keep it anyway?\nChoose NO to get the latest version but you will loose access to your changes"))) {
                        String filePath = ExperimentDesignOntologyAPI.copyFromJar("localexperimentdesignontology.owl");
                        om.reloadLocalOntology(new FileInputStream(new File(filePath)));
                    }
                }
            }
            catch (IOException ex) {
                logger.error((Object)"Error Loading Ontology", (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Loading Ontology.");
                throw ex;
            }
            catch (Exception ex) {
                logger.fatal((Object)"Error Loading Ontology", (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Loading Ontology. Please contact the developers for further information or help.");
                throw ex;
            }
            logger.info((Object)"org.grits.toolbox.editor.experimentdesigner- END   : Loading Ontology. ");
        }
    }

    public List<ProtocolCategory> getTopLevelCategories() {
        LinkedList<ProtocolCategory> categories = new LinkedList<ProtocolCategory>();
        try {
            List<Individual> categoryIndividuals = om.getAllIndiviudalsOfClass(OntologyManager.TOPLEVELCATEGORY_CLASS_URI);
            for (Individual categoryIndiv : categoryIndividuals) {
                ProtocolCategory category = new ProtocolCategory();
                category.setUri(categoryIndiv.getURI());
                category.setName(categoryIndiv.getLabel(null));
                Literal position = om.getLiteralValue(categoryIndiv, "has_position");
                int pos = position.getInt();
                category.setPosition(position.getInt());
                Literal icon = om.getLiteralValue(categoryIndiv, "has_icon");
                if (icon != null) {
                    category.setIcon(icon.getString());
                }
                category.setColor(this.getColorForCategory(categoryIndiv));
                category.setDescription(categoryIndiv.getComment(null));
                this.addObjectInPosition(categories, pos, category);
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Reading Ontology");
        }
        return categories;
    }

    public ProtocolCategory getTopLevelCategoryForProtocol(ProtocolNode protocol) {
        ProtocolCategory topLevel = null;
        if (protocol.getCategory() == null) {
            return null;
        }
        List<Individual> topLevelcategoryIndividuals = om.getAllSubjects("has_subCategory", protocol.getCategory().getUri());
        Iterator<Individual> iterator = topLevelcategoryIndividuals.iterator();
        if (iterator.hasNext()) {
            Individual categoryIndiv = iterator.next();
            topLevel = new ProtocolCategory();
            topLevel.setUri(categoryIndiv.getURI());
            topLevel.setName(categoryIndiv.getLabel(null));
            Literal position = om.getLiteralValue(categoryIndiv, "has_position");
            topLevel.setPosition(position.getInt());
            Literal icon = om.getLiteralValue(categoryIndiv, "has_icon");
            if (icon != null) {
                topLevel.setIcon(icon.getString());
            }
            topLevel.setColor(this.getColorForCategory(categoryIndiv));
            topLevel.setDescription(categoryIndiv.getComment(null));
        }
        return topLevel;
    }

    public List<ProtocolCategory> getProtocolCategoriesByTopLevelCategory(ProtocolCategory topLevel) {
        LinkedList<ProtocolCategory> categories = new LinkedList<ProtocolCategory>();
        try {
            Individual topLevelIndividual = om.getIndividual(topLevel.getUri());
            if (topLevelIndividual == null) {
                return categories;
            }
            List<Individual> categoryIndividuals = om.getAllObjects(topLevelIndividual, "has_subCategory");
            for (Individual categoryIndiv : categoryIndividuals) {
                ProtocolCategory category = new ProtocolCategory();
                category.setUri(categoryIndiv.getURI());
                category.setName(categoryIndiv.getLabel(null));
                Literal position = om.getLiteralValue(categoryIndiv, "has_position");
                int pos = position.getInt();
                category.setPosition(position.getInt());
                Literal icon = om.getLiteralValue(categoryIndiv, "has_icon");
                if (icon != null) {
                    category.setIcon(icon.getString());
                }
                category.setColor(this.getColorForCategory(categoryIndiv));
                category.setDescription(categoryIndiv.getComment(null));
                this.addObjectInPosition(categories, pos, category);
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Reading Ontology");
        }
        return categories;
    }

    MyColor getColorForCategory(Individual categoryIndiv) {
        MyColor color = new MyColor(new RGB(255, 255, 255));
        Literal icon = om.getLiteralValue(categoryIndiv, "has_icon");
        if (icon != null) {
            String iconName = icon.getString();
            String[] colorCode = (iconName = iconName.substring(0, iconName.lastIndexOf("."))).split("-");
            if (colorCode.length == 3) {
                try {
                    color = new MyColor(new RGB(Integer.parseInt(colorCode[0]), Integer.parseInt(colorCode[1]), Integer.parseInt(colorCode[2])));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"Color code for the icon is incorrect in the ontology", (Throwable)e);
                }
            }
        }
        return color;
    }

    @Override
    public List<ProtocolCategory> getProtocolCategories() {
        LinkedList<ProtocolCategory> categories = new LinkedList<ProtocolCategory>();
        try {
            List<Individual> categoryIndividuals = om.getAllIndiviudalsOfClass(OntologyManager.PROTOCOLCATEGORY_CLASS_URI);
            for (Individual categoryIndiv : categoryIndividuals) {
                ProtocolCategory category = new ProtocolCategory();
                category.setUri(categoryIndiv.getURI());
                category.setName(categoryIndiv.getLabel(null));
                Literal position = om.getLiteralValue(categoryIndiv, "has_position");
                int pos = position.getInt();
                category.setPosition(position.getInt());
                Literal icon = om.getLiteralValue(categoryIndiv, "has_icon");
                if (icon != null) {
                    category.setIcon(icon.getString());
                }
                category.setColor(this.getColorForCategory(categoryIndiv));
                category.setDescription(categoryIndiv.getComment(null));
                this.addObjectInPosition(categories, pos, category);
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Reading Ontology");
        }
        return categories;
    }

    private <T extends EntityWithPosition> void addObjectInPosition(LinkedList<T> llist, int position, T item) {
        if (llist.size() == 0) {
            llist.add(item);
        } else if (((EntityWithPosition)llist.get(0)).getPosition() != null && ((EntityWithPosition)llist.get(0)).getPosition() > position) {
            llist.add(0, item);
        } else if (((EntityWithPosition)llist.get(0)).getPosition() == null || ((EntityWithPosition)llist.get(llist.size() - 1)).getPosition() == null) {
            llist.add(item);
        } else if (((EntityWithPosition)llist.get(llist.size() - 1)).getPosition() < position) {
            llist.add(llist.size(), item);
        } else {
            int i = 0;
            while (((EntityWithPosition)llist.get(i)).getPosition() < position) {
                ++i;
            }
            llist.add(i, item);
        }
    }

    @Override
    public ProtocolNode getProtocolByUri(String uri) {
        ProtocolNode protocol = null;
        OntModel model = ExperimentDesignOntologyAPI.om.standardOntologymodel;
        Individual protocolIndiv = om.getIndividual(uri);
        if (protocolIndiv == null) {
            protocolIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, uri);
            model = ExperimentDesignOntologyAPI.om.localOntologymodel;
        }
        if (protocolIndiv != null) {
            Literal filename;
            Literal url;
            protocol = new ProtocolNode();
            protocol.setTemplateUri(uri);
            protocol.setLabel(protocolIndiv.getLabel(null));
            protocol.setDescription(protocolIndiv.getComment(null));
            Literal creator = om.getAnnotationValue(model, protocolIndiv, "creator");
            if (creator != null) {
                protocol.setCreator(creator.getString());
            }
            if ((url = om.getLiteralValue(model, protocolIndiv, "has_url")) != null) {
                protocol.setUrl(url.getString());
            }
            if ((filename = om.getLiteralValue(model, protocolIndiv, "has_file")) != null) {
                protocol.setFile(filename.getString());
            }
            protocol.setParameters(this.getAllParametersForProtocol(model, uri));
            protocol.setParameterGroups(this.getAllParameterGroupsForProtocol(model, uri));
            List<Individual> categories = om.getAllObjects(model, protocolIndiv, "has_category");
            ProtocolCategory category = new ProtocolCategory();
            Iterator<Individual> iterator = categories.iterator();
            if (iterator.hasNext()) {
                Individual individual = iterator.next();
                category.setUri(individual.getURI());
                category.setName(individual.getLabel(null));
                Literal position = om.getLiteralValue(individual, "has_position");
                category.setPosition(position.getInt());
                Literal icon = om.getLiteralValue(individual, "has_icon");
                if (icon != null) {
                    category.setIcon(icon.getString());
                }
                category.setColor(this.getColorForCategory(individual));
                category.setDescription(individual.getComment(null));
            }
            protocol.setCategory(category);
        }
        return protocol;
    }

    public List<ProtocolNode> getProtocolsByLabel(String label) {
        String existing;
        ArrayList<ProtocolNode> protocols = new ArrayList<ProtocolNode>();
        List<Individual> allProtocols = om.getAllIndiviudalsOfClass(ExperimentDesignOntologyAPI.om.standardOntologymodel, OntologyManager.PROTOCOL_CLASS_URI);
        for (Individual individual : allProtocols) {
            existing = individual.getLabel(null);
            if (existing == null || !existing.equalsIgnoreCase(label)) continue;
            protocols.add(this.getProtocolByUri(individual.getURI()));
        }
        allProtocols = om.getAllIndiviudalsOfClass(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PROTOCOL_CLASS_URI);
        for (Individual individual : allProtocols) {
            existing = individual.getLabel(null);
            if (existing == null || !existing.equalsIgnoreCase(label)) continue;
            protocols.add(this.getProtocolByUri(individual.getURI()));
        }
        return protocols;
    }

    @Override
    public List<ProtocolPaletteEntry> getProtocolsForCategory(ProtocolCategory category) {
        Literal filename;
        Literal url;
        Literal creator;
        ProtocolPaletteEntry entry;
        ArrayList<ProtocolPaletteEntry> entries = new ArrayList<ProtocolPaletteEntry>();
        List<Individual> protocols = om.getAllSubjects("has_category", category.getUri());
        HashSet<String> protocolIndivURIs = new HashSet<String>();
        for (Individual protocol : protocols) {
            protocolIndivURIs.add(protocol.getURI());
            entry = new ProtocolPaletteEntry();
            entry.setLabel(protocol.getLabel(null));
            entry.setCategory(category);
            entry.setUri(protocol.getURI());
            entry.setDescription(protocol.getComment(null));
            creator = om.getAnnotationValue(protocol, "creator");
            if (creator != null) {
                entry.setCreator(creator.getString());
            }
            if ((url = om.getLiteralValue(protocol, "has_url")) != null) {
                entry.setUrl(url.getString());
            }
            if ((filename = om.getLiteralValue(protocol, "has_file")) != null) {
                entry.setFile(filename.getString());
            }
            entry.setParameterGroups(this.getAllParameterGroupsForProtocol(ExperimentDesignOntologyAPI.om.standardOntologymodel, protocol.getURI()));
            entry.setParameters(this.getAllParametersForProtocol(ExperimentDesignOntologyAPI.om.standardOntologymodel, protocol.getURI()));
            entry.setPapers(this.getAllPapersForProtocol(ExperimentDesignOntologyAPI.om.standardOntologymodel, protocol.getURI()));
            entry.setColor(new Color((Device)Display.getCurrent(), category.getColor().getRed(), category.getColor().getGreen(), category.getColor().getBlue()));
            entries.add(entry);
        }
        protocols = om.getAllSubjects(ExperimentDesignOntologyAPI.om.localOntologymodel, "has_category", category.getUri());
        for (Individual protocol : protocols) {
            if (protocolIndivURIs.contains(protocol.getURI())) continue;
            entry = new ProtocolPaletteEntry();
            entry.setLabel(protocol.getLabel(null));
            entry.setCategory(category);
            entry.setUri(protocol.getURI());
            entry.setDescription(protocol.getComment(null));
            creator = om.getAnnotationValue(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol, "creator");
            if (creator != null) {
                entry.setCreator(creator.getString());
            }
            if ((url = om.getLiteralValue(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol, "has_url")) != null) {
                entry.setUrl(url.getString());
            }
            if ((filename = om.getLiteralValue(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol, "has_file")) != null) {
                entry.setFile(filename.getString());
            }
            entry.setParameterGroups(this.getAllParameterGroupsForProtocol(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol.getURI()));
            entry.setParameters(this.getAllParametersForProtocol(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol.getURI()));
            entry.setPapers(this.getAllPapersForProtocol(ExperimentDesignOntologyAPI.om.localOntologymodel, protocol.getURI()));
            entry.setColor(new Color((Device)Display.getCurrent(), category.getColor().getRed(), category.getColor().getGreen(), category.getColor().getBlue()));
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public List<ParameterGroup> getParameterGroups() {
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        try {
            ParameterGroup group;
            HashSet<String> groupIndivURIs = new HashSet<String>();
            List<Individual> groupIndividuals = om.getAllIndiviudalsOfClass(OntologyManager.PARAMETERGROUP_CLASS_URI);
            HashMap<String, ParameterGroup> repeatingGroups = new HashMap<String, ParameterGroup>();
            for (Individual groupIndiv : groupIndividuals) {
                group = new ParameterGroup();
                group.setUri(groupIndiv.getURI());
                group.setLabel(groupIndiv.getLabel(null));
                if (repeatingGroups.get(group.getLabel()) != null) {
                    group.setId(((ParameterGroup)repeatingGroups.get(group.getLabel())).getId() + 1);
                    repeatingGroups.remove(group.getLabel());
                    repeatingGroups.put(group.getLabel(), group);
                } else {
                    group.setId(1);
                    repeatingGroups.put(group.getLabel(), group);
                }
                group.setDescription(groupIndiv.getComment(null));
                group.setParameters(this.getParametersForParameterGroup(ExperimentDesignOntologyAPI.om.standardOntologymodel, group));
                groups.add(group);
                groupIndivURIs.add(groupIndiv.getURI());
            }
            groupIndividuals = om.getAllIndiviudalsOfClass(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETERGROUP_CLASS_URI);
            repeatingGroups = new HashMap();
            for (Individual groupIndiv : groupIndividuals) {
                if (groupIndivURIs.contains(groupIndiv.getURI())) continue;
                group = new ParameterGroup();
                group.setUri(groupIndiv.getURI());
                group.setLabel(groupIndiv.getLabel(null));
                if (repeatingGroups.get(group.getLabel()) != null) {
                    group.setId(((ParameterGroup)repeatingGroups.get(group.getLabel())).getId() + 1);
                    repeatingGroups.remove(group.getLabel());
                    repeatingGroups.put(group.getLabel(), group);
                } else {
                    group.setId(1);
                    repeatingGroups.put(group.getLabel(), group);
                }
                group.setDescription(groupIndiv.getComment(null));
                group.setParameters(this.getParametersForParameterGroup(ExperimentDesignOntologyAPI.om.localOntologymodel, group));
                groups.add(group);
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error Reading Ontology");
        }
        return groups;
    }

    @Override
    public List<Parameter> getAllParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            MeasurementUnit mUnit;
            ArrayList<MeasurementUnit> unitList;
            List<Individual> units;
            Parameter param;
            HashSet<String> paramIndivURIs = new HashSet<String>();
            List<Individual> paramIndividuals = om.getAllIndiviudalsOfClass(OntologyManager.PARAMETER_CLASS_URI);
            for (Individual paramIndiv : paramIndividuals) {
                param = new Parameter();
                param.setUri(paramIndiv.getURI());
                param.setName(paramIndiv.getLabel(null));
                param.setDescription(paramIndiv.getComment(null));
                units = om.getAllObjects(paramIndiv, "has_unit_of_measurement");
                unitList = new ArrayList<MeasurementUnit>();
                for (Individual unit : units) {
                    mUnit = new MeasurementUnit();
                    mUnit.setUri(unit.getURI());
                    mUnit.setLabel(unit.getLabel(null));
                    unitList.add(mUnit);
                }
                param.setAvailableUnits(unitList);
                this.setNamespace(ExperimentDesignOntologyAPI.om.standardOntologymodel, paramIndiv, param);
                parameters.add(param);
                paramIndivURIs.add(paramIndiv.getURI());
            }
            paramIndividuals = om.getAllIndiviudalsOfClass(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETER_CLASS_URI);
            for (Individual paramIndiv : paramIndividuals) {
                if (paramIndivURIs.contains(paramIndiv.getURI())) continue;
                param = new Parameter();
                param.setUri(paramIndiv.getURI());
                param.setName(paramIndiv.getLabel(null));
                param.setDescription(paramIndiv.getComment(null));
                units = om.getAllObjects(ExperimentDesignOntologyAPI.om.localOntologymodel, paramIndiv, "has_unit_of_measurement");
                unitList = new ArrayList();
                for (Individual unit : units) {
                    mUnit = new MeasurementUnit();
                    mUnit.setUri(unit.getURI());
                    mUnit.setLabel(unit.getLabel(null));
                    unitList.add(mUnit);
                }
                this.setNamespace(ExperimentDesignOntologyAPI.om.localOntologymodel, paramIndiv, param);
                param.setAvailableUnits(unitList);
                parameters.add(param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error Reading Ontology", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error getting parameters from the Ontology");
        }
        return parameters;
    }

    private List<Parameter> getAllParametersForProtocol(OntModel model, String protocolUri) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        Individual protocolIndiv = om.getIndividual(model, protocolUri);
        List<Individual> parameterIndivs = om.getAllObjects(model, protocolIndiv, "has_parameter");
        for (Individual param : parameterIndivs) {
            List<Individual> guidelinesFromContext;
            List<Individual> parametersFromContext = om.getAllObjects(model, param, "parameter");
            Literal required = om.getLiteralValue(model, param, "is_required");
            if (parametersFromContext == null || parametersFromContext.size() != 1) continue;
            Individual parameterIndiv = parametersFromContext.get(0);
            Parameter parameter = new Parameter();
            parameter.setUri(parameterIndiv.getURI());
            parameter.setName(parameterIndiv.getLabel(null));
            parameter.setDescription(parameterIndiv.getComment(null));
            parameter.setRequired(required.getBoolean());
            List<Individual> units = om.getAllObjects(model, parameterIndiv, "has_unit_of_measurement");
            ArrayList<MeasurementUnit> unitList = new ArrayList<MeasurementUnit>();
            for (Individual unit : units) {
                MeasurementUnit mUnit = new MeasurementUnit();
                mUnit.setUri(unit.getURI());
                mUnit.setLabel(unit.getLabel(null));
                unitList.add(mUnit);
            }
            this.setNamespace(model, parameterIndiv, parameter);
            parameter.setAvailableUnits(unitList);
            Literal position = om.getLiteralValue(model, param, "has_position");
            int pos = 0;
            if (position != null) {
                pos = position.getInt();
                parameter.setPosition(pos);
            }
            if ((guidelinesFromContext = om.getAllObjects(model, param, "guideline_info")) != null) {
                ArrayList<String> guidelines = new ArrayList<String>();
                for (Individual guideline : guidelinesFromContext) {
                    guidelines.add(guideline.getLabel(null));
                }
                parameter.setGuidelineURIs(guidelines);
            }
            this.addObjectInPosition(parameters, pos, parameter);
        }
        return parameters;
    }

    private void setNamespace(OntModel model, Individual parameterIndiv, Parameter parameter) {
        try {
            List<Individual> namespaces = om.getAllObjects(model, parameterIndiv, "has_namespace");
            Iterator<Individual> iterator = namespaces.iterator();
            if (iterator.hasNext()) {
                Literal isShortNamespace;
                Individual namespace = iterator.next();
                parameter.setNamespace(namespace.getURI());
                Literal namespaceFile = om.getLiteralValue(model, namespace, "has_namespace_file");
                if (namespaceFile != null && namespaceFile.getString() != null) {
                    parameter.setNamespaceFile(namespaceFile.getString());
                }
                if ((isShortNamespace = om.getLiteralValue(ExperimentDesignOntologyAPI.om.localOntologymodel, namespace, "is_short_namespace")) != null) {
                    parameter.setShortNamespace(isShortNamespace.getBoolean());
                }
                return;
            }
        }
        catch (Exception e) {
            logger.info((Object)"migrating the ontology from old namespace to the new namespace structure");
            Literal namespace = om.getLiteralValue(ExperimentDesignOntologyAPI.om.localOntologymodel, parameterIndiv, "has_namespace");
            if (namespace != null && namespace.getString() != null) {
                if (namespace.getString().equals(XSD.xdouble.getURI())) {
                    Individual namespaceIndiv = om.getIndividual(model, String.valueOf(OntologyManager.baseURI) + "double");
                    if (namespaceIndiv == null) {
                        om.createNewIndividualwithURI(model, OntologyManager.NAMESPACE_CLASS_URI, String.valueOf(OntologyManager.baseURI) + "double", String.valueOf(OntologyManager.baseURI) + "double");
                    }
                    parameter.setNamespace(String.valueOf(OntologyManager.baseURI) + "double");
                } else if (namespace.getString().equals(XSD.xstring.getURI())) {
                    Individual namespaceIndiv = om.getIndividual(model, String.valueOf(OntologyManager.baseURI) + "double");
                    if (namespaceIndiv == null) {
                        om.createNewIndividualwithURI(model, OntologyManager.NAMESPACE_CLASS_URI, String.valueOf(OntologyManager.baseURI) + "string", String.valueOf(OntologyManager.baseURI) + "string");
                    }
                    parameter.setNamespace(String.valueOf(OntologyManager.baseURI) + "string");
                }
            }
            logger.error((Object)"migration did not work", (Throwable)e);
            throw e;
        }
    }

    private List<ParameterGroup> getAllParameterGroupsForProtocol(OntModel model, String protocolUri) {
        LinkedList<ParameterGroup> parameterGroups = new LinkedList<ParameterGroup>();
        Individual protocolIndiv = om.getIndividual(model, protocolUri);
        List<Individual> parameterGroupIndivs = om.getAllObjects(model, protocolIndiv, "has_parameter_group");
        int groupId = 1;
        for (Individual paramGroup : parameterGroupIndivs) {
            List<Individual> guidelinesFromContext;
            List<Individual> paramGroupsFromContext = om.getAllObjects(model, paramGroup, "parameter_group");
            Literal required = om.getLiteralValue(model, paramGroup, "is_required");
            if (paramGroupsFromContext == null || paramGroupsFromContext.size() != 1) continue;
            Individual paramGroupIndiv = paramGroupsFromContext.get(0);
            ParameterGroup group = new ParameterGroup();
            group.setUri(paramGroupIndiv.getURI());
            group.setLabel(paramGroupIndiv.getLabel(null));
            group.setDescription(paramGroupIndiv.getComment(null));
            group.setRequired(required.getBoolean());
            group.setId(groupId++);
            Literal position = om.getLiteralValue(model, paramGroup, "has_position");
            int pos = 0;
            if (position != null) {
                pos = position.getInt();
                group.setPosition(pos);
            }
            if ((guidelinesFromContext = om.getAllObjects(model, paramGroup, "guideline_info")) != null) {
                ArrayList<String> guidelines = new ArrayList<String>();
                for (Individual guideline : guidelinesFromContext) {
                    guidelines.add(guideline.getLabel(null));
                }
                group.setGuidelineURIs(guidelines);
            }
            this.addObjectInPosition(parameterGroups, pos, group);
            group.setParameters(this.getParametersForParameterGroup(model, group));
        }
        return parameterGroups;
    }

    private List<Paper> getAllPapersForProtocol(OntModel model, String protocolUri) {
        ArrayList<Paper> papers = new ArrayList<Paper>();
        Individual protocolIndiv = om.getIndividual(model, protocolUri);
        List<Individual> paperIndivs = om.getAllObjects(model, protocolIndiv, "has_reference");
        for (Individual paperIndiv : paperIndivs) {
            Literal bibCitation;
            Literal issued;
            Paper paper = new Paper();
            String pubmedId = paperIndiv.getLabel(null);
            if (pubmedId != null) {
                try {
                    paper.setPubMedId(Integer.parseInt(pubmedId));
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("Invalid pubmed id for protocol " + protocolUri), (Throwable)e);
                }
            }
            String comment = paperIndiv.getComment(null);
            paper.setFormatedAuthor(comment);
            Literal title = om.getAnnotationValue(model, paperIndiv, "title");
            if (title != null) {
                paper.setTitle(title.getString());
            }
            if ((issued = om.getAnnotationValue(model, paperIndiv, "issued")) != null) {
                paper.setYear(Integer.parseInt(issued.getString()));
            }
            if ((bibCitation = om.getAnnotationValue(model, paperIndiv, "bibliographicCitation")) != null) {
                paper.setBibliographicCitation(bibCitation.getString());
            }
            List<Literal> authors = om.getAnnotationValues(model, paperIndiv, "creator");
            for (Literal literal : authors) {
                paper.addAuthor(literal.getString());
            }
            papers.add(paper);
        }
        return papers;
    }

    private List<Parameter> getParametersForParameterGroup(OntModel model, ParameterGroup group) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        Individual parameterGroupIndiv = om.getIndividual(model, group.getUri());
        List<Individual> parameterContextIndivs = om.getAllObjects(model, parameterGroupIndiv, "contains_parameter");
        for (Individual context : parameterContextIndivs) {
            List<Individual> parametersFromContext = om.getAllObjects(model, context, "subparameter");
            Literal required = om.getLiteralValue(model, context, "is_required");
            Literal position = om.getLiteralValue(model, context, "has_position");
            List<Individual> guidelinesFromContext = om.getAllObjects(model, context, "guideline_info");
            if (parametersFromContext == null || parametersFromContext.size() != 1) continue;
            Individual param = parametersFromContext.get(0);
            Parameter parameter = new Parameter();
            parameter.setUri(param.getURI());
            parameter.setName(param.getLabel(null));
            parameter.setDescription(param.getComment(null));
            if (required != null) {
                parameter.setRequired(required.getBoolean());
            }
            parameter.setGroupId(group.getId());
            int pos = 0;
            if (position != null) {
                pos = position.getInt();
                parameter.setPosition(pos);
            }
            List<Individual> units = om.getAllObjects(model, param, "has_unit_of_measurement");
            ArrayList<MeasurementUnit> unitList = new ArrayList<MeasurementUnit>();
            for (Individual unit : units) {
                MeasurementUnit mUnit = new MeasurementUnit();
                mUnit.setUri(unit.getURI());
                mUnit.setLabel(unit.getLabel(null));
                unitList.add(mUnit);
            }
            this.setNamespace(model, param, parameter);
            parameter.setAvailableUnits(unitList);
            if (guidelinesFromContext != null) {
                ArrayList<String> guidelines = new ArrayList<String>();
                for (Individual guideline : guidelinesFromContext) {
                    guidelines.add(guideline.getLabel(null));
                }
                parameter.setGuidelineURIs(guidelines);
            }
            this.addObjectInPosition(parameters, pos, parameter);
        }
        return parameters;
    }

    @Override
    public List<ProtocolEntry> getAllProtocolVariantEntries() throws IOException {
        List<ProtocolEntry> list = ProtocolVariantFileHandler.getAllProtocolVariants(ExperimentDesignOntologyAPI.getProtocolVariantFolderLocation());
        URL url = ExperimentConfig.PROTOCOL_RESOURCE_URL;
        if (url == null) {
            throw new IOException("No protocol variant folder found in the jar file");
        }
        URL resourceFileUrl = FileLocator.toFileURL((URL)url);
        list.addAll(ProtocolVariantFileHandler.getAllProtocolVariants(new File(resourceFileUrl.getPath()), true));
        return list;
    }

    @Override
    public List<ProtocolNode> getAllProtocolVariants() {
        ArrayList<ProtocolNode> protocols = new ArrayList<ProtocolNode>();
        try {
            List<ProtocolEntry> entries = this.getAllProtocolVariantEntries();
            for (ProtocolEntry protocolEntry : entries) {
                String filename = protocolEntry.getFilename();
                String fileLocation = null;
                if (protocolEntry.isFromJar()) {
                    URL url = ExperimentConfig.PROTOCOL_RESOURCE_URL;
                    if (url != null) {
                        URL resourceFileUrl = FileLocator.toFileURL((URL)url);
                        fileLocation = String.valueOf(resourceFileUrl.getPath()) + File.separator + filename;
                    }
                } else {
                    fileLocation = String.valueOf(ExperimentDesignOntologyAPI.getProtocolVariantFolderLocation()) + File.separator + filename;
                }
                if (fileLocation == null) continue;
                FileInputStream inputStream = new FileInputStream(fileLocation);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProtocolNode.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                ProtocolNode node = (ProtocolNode)unmarshaller.unmarshal((InputStream)inputStream);
                inputStream.close();
                protocols.add(node);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"org.grits.toolbox.editor.experimentdesigner Cannot retrieve protocol variants! ", (Throwable)e);
        }
        return protocols;
    }

    @Override
    public List<ProtocolNode> getProtocolVariantsByUri(String uri) {
        ArrayList<ProtocolNode> protocols = new ArrayList<ProtocolNode>();
        try {
            List<ProtocolEntry> entries = this.getAllProtocolVariantEntries();
            for (ProtocolEntry protocolEntry : entries) {
                if (!protocolEntry.getUri().equalsIgnoreCase(uri)) continue;
                String filename = protocolEntry.getFilename();
                String fileLocation = null;
                if (protocolEntry.isFromJar()) {
                    URL url = ExperimentConfig.PROTOCOL_RESOURCE_URL;
                    if (url != null) {
                        URL resourceFileUrl = FileLocator.toFileURL((URL)url);
                        File dir = new File(resourceFileUrl.toURI());
                        fileLocation = dir.getAbsolutePath();
                    }
                } else {
                    fileLocation = String.valueOf(ExperimentDesignOntologyAPI.getProtocolVariantFolderLocation()) + File.separator + filename;
                }
                if (fileLocation == null) continue;
                FileInputStream inputStream = new FileInputStream(fileLocation);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProtocolNode.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                ProtocolNode node = (ProtocolNode)unmarshaller.unmarshal((InputStream)inputStream);
                inputStream.close();
                protocols.add(node);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"org.grits.toolbox.editor.experimentdesigner Cannot retrieve protocol variants with given uri! ", (Throwable)e);
        }
        return protocols;
    }

    @Override
    public String createProtocolTemplate(ProtocolNode protocol, String paletteCategoryURI) throws Exception {
        Ontology localOnt;
        String version;
        List<ParameterGroup> parameterGroups;
        List<Parameter> parameters;
        Individual categoryIndiv;
        ProtocolCategory category;
        ProtocolCategory topLevel = new ProtocolCategory();
        topLevel.setUri(paletteCategoryURI);
        List<ProtocolNode> existing = this.getProtocolsByLabel(protocol.getLabel());
        if (!existing.isEmpty()) {
            for (ProtocolNode protocolNode : existing) {
                ProtocolCategory paletteCat = this.getTopLevelCategoryForProtocol(protocolNode);
                if (paletteCat == null || !paletteCat.getUri().equals(paletteCategoryURI)) continue;
                throw new ProtocolExistsException("A protocol template named " + protocol.getLabel() + " already exists in " + paletteCategoryURI, protocolNode.getTemplateUri());
            }
        }
        if ((category = protocol.getCategory()) != null) {
            categoryIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, category.getUri());
            if (categoryIndiv == null) {
                categoryIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.standardOntologymodel, category.getUri());
                if (categoryIndiv == null) {
                    throw new Exception("Cannot add the template. Category not found in ontology");
                }
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PROTOCOLCATEGORY_CLASS_URI, category.getName(), categoryIndiv.getURI());
            }
        } else {
            throw new Exception("Cannot add the template. Category is missing!");
        }
        String indivUri = om.createUniqueRandomIndividualURI(protocol.getLabel());
        om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PROTOCOL_CLASS_URI, protocol.getLabel(), indivUri);
        om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, protocol.getDescription());
        if (protocol.getCreator() != null) {
            om.addAnnotation(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "creator", protocol.getCreator());
        }
        if (protocol.getUrl() != null) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_url", ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(protocol.getUrl()));
        }
        if (protocol.getFile() != null) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_file", ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(protocol.getFile()));
        }
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_category", categoryIndiv.getURI());
        List<Paper> papers = protocol.getPapers();
        if (papers != null) {
            for (Paper paper : papers) {
                String paperUri = this.addPaperToTemplate(paper);
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_reference", paperUri);
            }
        }
        if ((parameters = protocol.getParameters()) != null) {
            for (Parameter parameter : parameters) {
                String contextUri = this.addParameterToTemplate(parameter, protocol.getLabel(), indivUri);
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_parameter", contextUri);
            }
        }
        if ((parameterGroups = protocol.getParameterGroups()) != null) {
            for (ParameterGroup parameterGroup : parameterGroups) {
                this.addParameterGroupToTemplate(parameterGroup, protocol.getLabel(), indivUri);
            }
        }
        if ((version = (localOnt = ExperimentDesignOntologyAPI.om.localOntologymodel.getOntology(OntologyManager.ontURI)).getVersionInfo()) != null) {
            try {
                String firstDigit = version.substring(0, version.lastIndexOf("."));
                int secondDigit = Integer.parseInt(version.substring(version.lastIndexOf(".") + 1));
                localOnt.setVersionInfo(String.valueOf(firstDigit) + "." + ++secondDigit);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)"Cannot increase the version number of the local ontology", (Throwable)e);
            }
        }
        FileOutputStream outStream = new FileOutputStream(new File(ExperimentDesignOntologyAPI.getOntologyLocation("localexperimentdesignontology.owl")));
        om.writeOntology(ExperimentDesignOntologyAPI.om.localOntologymodel, outStream);
        return indivUri;
    }

    private String addPaperToTemplate(Paper paper) throws UnsupportedEncodingException {
        List<String> authors;
        String paperUri;
        if (paper.getPubMedId() == null) {
            paperUri = om.createUniqueRandomIndividualURI("paper");
            om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PAPER_CLASS_URI, paperUri, paperUri);
        } else {
            paperUri = om.createNewIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PAPER_CLASS_URI, String.valueOf(paper.getPubMedId()));
        }
        om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, paper.getFormatedAuthor());
        if (paper.getPubMedId() != null) {
            om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, "has_pubmed_id", String.valueOf(paper.getPubMedId()));
        }
        if (paper.getTitle() != null) {
            om.addAnnotation(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, "title", paper.getTitle());
        }
        if (paper.getBibliographicCitation() != null) {
            om.addAnnotation(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, "bibliographicCitation", paper.getBibliographicCitation());
        }
        if (paper.getYear() != null) {
            om.addAnnotation(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, "issued", String.valueOf(paper.getYear()));
        }
        if ((authors = paper.getAuthors()) != null) {
            for (String string : authors) {
                om.addAnnotation(ExperimentDesignOntologyAPI.om.localOntologymodel, paperUri, "creator", string);
            }
        }
        return paperUri;
    }

    private void addParameterGroupToTemplate(ParameterGroup parameterGroup, String label, String uri) {
        List<String> guidelines;
        String contextUri = om.createUniqueRandomIndividualURI("Parameter Group Context");
        om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETER_GROUPCONTEXT_CLASS_URI, String.valueOf(label) + "_" + parameterGroup.getLabel(), contextUri);
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, uri, "has_parameter_group", contextUri);
        Individual parameterGroupIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parameterGroup.getUri());
        if (parameterGroupIndiv == null) {
            om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETERGROUP_CLASS_URI, parameterGroup.getLabel(), parameterGroup.getUri());
            if (parameterGroup.getDescription() != null) {
                om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, parameterGroup.getUri(), parameterGroup.getDescription());
            }
        }
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "parameter_group", parameterGroup.getUri());
        Boolean isRequired = parameterGroup.getRequired();
        if (isRequired != null && isRequired.booleanValue()) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(true));
        } else {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(false));
        }
        Integer position = parameterGroup.getPosition();
        if (position != null) {
            Literal positionLiteral = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral("" + position);
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "has_position", positionLiteral);
        }
        if ((guidelines = parameterGroup.getGuidelineURIs()) != null) {
            for (String guideline : guidelines) {
                String guidelineUri = String.valueOf(OntologyManager.GUIDELINE_CLASS_URI) + guideline.toLowerCase().replaceAll(" ", "_");
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.GUIDELINE_CLASS_URI, guideline, guidelineUri);
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "guideline_info", guidelineUri);
            }
        }
        List<Parameter> parameters = parameterGroup.getParameters();
        for (Parameter parameter : parameters) {
            String paramInParamGroupContextUri = this.addParameterToParameterGroup(parameter, parameterGroup);
            om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parameterGroup.getUri(), "contains_parameter", paramInParamGroupContextUri);
        }
    }

    private String addParameterToParameterGroup(Parameter parameter, ParameterGroup parameterGroup) {
        String contextUri = om.createUniqueRandomIndividualURI("Parameter In Group Context");
        om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETERINGROUPCONTEXT_CLASS_URI, String.valueOf(parameterGroup.getLabel()) + "_" + parameter.getName(), contextUri);
        Individual parameterIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri());
        if (parameterIndiv == null) {
            om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETER_CLASS_URI, parameter.getName(), parameter.getUri());
            if (parameter.getDescription() != null) {
                om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), parameter.getDescription());
            }
            if (parameter.getNamespace() != null) {
                Individual namespace = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace());
                if (namespace == null) {
                    OntClass namespaceClass = ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.NAMESPACE_CLASS_URI);
                    if (namespaceClass == null) {
                        this.handleOldVersionForNamespace();
                    }
                    om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.NAMESPACE_CLASS_URI, parameter.getNamespace(), parameter.getNamespace());
                    if (parameter.getNamespaceFile() != null) {
                        om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace(), "has_namespace_file", ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(parameter.getNamespaceFile()));
                    }
                    om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace(), "is_short_namespace", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral((Object)parameter.getShortNamespace()));
                }
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), "has_namespace", parameter.getNamespace());
            }
        }
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "subparameter", parameter.getUri());
        Boolean isRequired = parameter.getRequired();
        if (isRequired != null && isRequired.booleanValue()) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(true));
        } else {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(false));
        }
        Integer position = parameter.getPosition();
        if (position != null) {
            Literal positionLiteral = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral("" + position);
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "has_position", positionLiteral);
        }
        List<MeasurementUnit> units = parameter.getAvailableUnits();
        for (MeasurementUnit measurementUnit : units) {
            Individual unitIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, measurementUnit.getUri());
            if (unitIndiv == null) {
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.UNIT_URI, measurementUnit.getLabel(), measurementUnit.getUri());
            }
            om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), "has_unit_of_measurement", measurementUnit.getUri());
        }
        List<String> guidelines = parameter.getGuidelineURIs();
        if (guidelines != null) {
            for (String guideline : guidelines) {
                String guidelineUri = String.valueOf(OntologyManager.GUIDELINE_CLASS_URI) + guideline.toLowerCase().replaceAll(" ", "_");
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.GUIDELINE_CLASS_URI, guideline, guidelineUri);
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "guideline_info", guidelineUri);
            }
        }
        return contextUri;
    }

    private String getContextForParameterInTemplate(String parameterUri, String protocolTemplateUri) {
        Individual templateIndividual;
        String parameterContextURI = null;
        RDFNode thisContextValue = null;
        Resource thisParameterResource = null;
        Individual individual = templateIndividual = ExperimentDesignOntologyAPI.om.standardOntologymodel.getIndividual(protocolTemplateUri) == null ? ExperimentDesignOntologyAPI.om.standardOntologymodel.getIndividual(protocolTemplateUri) : ExperimentDesignOntologyAPI.om.localOntologymodel.getIndividual(protocolTemplateUri);
        if (templateIndividual != null) {
            NodeIterator contextValues = templateIndividual.listPropertyValues(ExperimentDesignOntologyAPI.om.standardOntologymodel.getProperty(String.valueOf(OntologyManager.baseURI) + "has_parameter"));
            while (contextValues.hasNext()) {
                thisContextValue = contextValues.next();
                if (!thisContextValue.isResource() || !(thisParameterResource = thisContextValue.asResource().getPropertyResourceValue(ExperimentDesignOntologyAPI.om.standardOntologymodel.getProperty("parameter"))).getURI().equals(parameterUri)) continue;
                parameterContextURI = thisContextValue.asResource().getURI();
                break;
            }
        }
        return parameterContextURI;
    }

    private String addParameterToTemplate(Parameter parameter, String protocolLabel, String protocolUri) {
        String contextUri = om.createUniqueRandomIndividualURI("Parameter Context");
        om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETERCONTEXT_CLASS_URI, String.valueOf(protocolLabel) + "_" + parameter.getName(), contextUri);
        Individual parameterIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri());
        if (parameterIndiv == null) {
            om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETER_CLASS_URI, parameter.getName(), parameter.getUri());
            if (parameter.getDescription() != null) {
                om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), parameter.getDescription());
            }
            if (parameter.getNamespace() != null) {
                Individual namespace = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace());
                if (namespace == null) {
                    OntClass namespaceClass = ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.NAMESPACE_CLASS_URI);
                    if (namespaceClass == null) {
                        this.handleOldVersionForNamespace();
                    }
                    om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.NAMESPACE_CLASS_URI, parameter.getNamespace(), parameter.getNamespace());
                    if (parameter.getNamespaceFile() != null) {
                        om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace(), "has_namespace_file", ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(parameter.getNamespaceFile()));
                    }
                    om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getNamespace(), "is_short_namespace", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral((Object)parameter.getShortNamespace()));
                }
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), "has_namespace", parameter.getNamespace());
            }
        }
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "parameter", parameter.getUri());
        Boolean isRequired = parameter.getRequired();
        if (isRequired != null && isRequired.booleanValue()) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(true));
        } else {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "is_required", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(false));
        }
        Integer position = parameter.getPosition();
        if (position != null) {
            Literal positionLiteral = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral("" + position);
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "has_position", positionLiteral);
        }
        List<MeasurementUnit> units = parameter.getAvailableUnits();
        for (MeasurementUnit measurementUnit : units) {
            Individual unitIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, measurementUnit.getUri());
            if (unitIndiv == null) {
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.UNIT_URI, measurementUnit.getLabel(), measurementUnit.getUri());
            }
            om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parameter.getUri(), "has_unit_of_measurement", measurementUnit.getUri());
        }
        List<String> guidelines = parameter.getGuidelineURIs();
        if (guidelines != null) {
            for (String guideline : guidelines) {
                String guidelineUri = String.valueOf(OntologyManager.GUIDELINE_CLASS_URI) + guideline.toLowerCase().replaceAll(" ", "_");
                om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.GUIDELINE_CLASS_URI, guideline, guidelineUri);
                om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, contextUri, "guideline_info", guidelineUri);
            }
        }
        return contextUri;
    }

    private void handleOldVersionForNamespace() {
        ExperimentDesignOntologyAPI.om.localOntologymodel.createClass(OntologyManager.NAMESPACE_CLASS_URI);
        DatatypeProperty namespaceProperty = ExperimentDesignOntologyAPI.om.localOntologymodel.getDatatypeProperty(String.valueOf(OntologyManager.baseURI) + "has_namespace");
        if (namespaceProperty == null) {
            ObjectProperty prop = ExperimentDesignOntologyAPI.om.localOntologymodel.createObjectProperty("has_namespace");
            prop.setDomain((Resource)ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.PARAMETER_CLASS_URI));
            prop.setRange((Resource)ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.NAMESPACE_CLASS_URI));
        } else {
            ObjectProperty prop = ExperimentDesignOntologyAPI.om.localOntologymodel.getObjectProperty(String.valueOf(OntologyManager.baseURI) + "has_namespace");
            if (prop == null) {
                Object oldNamespace;
                List<Individual> allParameterIndividuals = om.getAllIndiviudalsOfClass(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PARAMETER_CLASS_URI);
                HashMap<String, String> previousNameSpaces = new HashMap<String, String>();
                for (Individual individual : allParameterIndividuals) {
                    oldNamespace = om.getLiteralValue(individual, "has_namespace");
                    if (oldNamespace == null) continue;
                    previousNameSpaces.put(individual.getURI(), oldNamespace.getString());
                    individual.removeProperty((Property)namespaceProperty, (RDFNode)oldNamespace);
                }
                namespaceProperty.remove();
                prop = ExperimentDesignOntologyAPI.om.localOntologymodel.createObjectProperty(String.valueOf(OntologyManager.baseURI) + "has_namespace");
                prop.setDomain((Resource)ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.PARAMETER_CLASS_URI));
                prop.setRange((Resource)ExperimentDesignOntologyAPI.om.localOntologymodel.getOntClass(OntologyManager.NAMESPACE_CLASS_URI));
                for (String paramUri : previousNameSpaces.keySet()) {
                    oldNamespace = (String)previousNameSpaces.get(paramUri);
                    if (((String)oldNamespace).equals(XSD.xdouble.getURI())) {
                        om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.NAMESPACE_CLASS_URI, String.valueOf(OntologyManager.baseURI) + "double", String.valueOf(OntologyManager.baseURI) + "double");
                        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, paramUri, "has_namespace", String.valueOf(OntologyManager.baseURI) + "double");
                        continue;
                    }
                    if (!((String)oldNamespace).equals(XSD.xstring.getURI())) continue;
                    om.createNewIndividualwithURI(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.NAMESPACE_CLASS_URI, String.valueOf(OntologyManager.baseURI) + "string", String.valueOf(OntologyManager.baseURI) + "string");
                    om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, paramUri, "has_namespace", String.valueOf(OntologyManager.baseURI) + "string");
                }
            }
        }
    }

    @Override
    public void createProtocolVariant(ProtocolNode protocol) throws Exception {
        File protocolFolder;
        String protocolFileName;
        String configFolderLocation = ExperimentDesignOntologyAPI.getConfigFolderLocation();
        String protocolVariantLocation = ExperimentDesignOntologyAPI.getProtocolVariantFolderLocation();
        File[] existingFiles = ExperimentDesignOntologyAPI.getConfigFilesByDirectory("protocols");
        boolean indexFileExists = false;
        if (existingFiles != null) {
            String[] fileNames = new String[existingFiles.length];
            int i = 0;
            while (i < existingFiles.length) {
                fileNames[i] = existingFiles[i].getName();
                if (existingFiles[i].getName().equals("protocol.xml")) {
                    indexFileExists = true;
                }
                ++i;
            }
            if (!indexFileExists) {
                ProtocolVariantFileHandler.createIndexFile(protocolVariantLocation);
            }
            protocolFileName = ExperimentDesignOntologyAPI.generateFileName(fileNames, "protocol");
        } else {
            protocolFileName = ExperimentDesignOntologyAPI.generateFileName(new String[1], "protocol");
        }
        File configFolder = new File(configFolderLocation);
        if (configFolder.isDirectory()) {
            protocolFolder = new File(protocolVariantLocation);
            if (!protocolFolder.exists()) {
                protocolFolder.mkdirs();
                ProtocolVariantFileHandler.createIndexFile(protocolVariantLocation);
            }
        } else {
            throw new IOException("Configuration folder does not exist");
        }
        ProtocolEntry entry = new ProtocolEntry();
        entry.setCategory(protocol.getCategory().getUri());
        entry.setName(protocol.getLabel());
        entry.setUri(protocol.getTemplateUri());
        entry.setFilename(protocolFileName);
        ProtocolVariantFileHandler.addProtocolVariant(entry, protocolVariantLocation);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ProtocolNode.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)protocol, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(String.valueOf(protocolFolder.getAbsolutePath()) + File.separator + protocolFileName);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    @Override
    public List<ExperimentTemplateEntry> getAllExperimentTemplateEntries() throws IOException {
        List<ExperimentTemplateEntry> entries = ExperimentTemplateFileHandler.getAllTemplates(ExperimentDesignOntologyAPI.getTemplateFolderLocation());
        URL url = ExperimentConfig.EXPERIMET_TEMPLATE_RESOURCE_URL;
        if (url == null) {
            throw new IOException("No experiment template folder found in the jar file");
        }
        URL resourceFileUrl = FileLocator.toFileURL((URL)url);
        try {
            File dir = new File(resourceFileUrl.getPath());
            entries.addAll(ExperimentTemplateFileHandler.getAllTemplates(dir, true));
        }
        catch (Exception exception) {
            throw new IOException("No experiment template folder found in the jar file");
        }
        return entries;
    }

    @Override
    public void createTemplateForExperimentGraph(ExperimentGraph experimentDesign) throws Exception {
        File templateFolder;
        String templateFileName;
        String nameWithoutSpaces = experimentDesign.getName().replace(" ", "");
        String uri = String.valueOf(OntologyManager.baseURI) + URLEncoder.encode(nameWithoutSpaces, "UTF-8");
        experimentDesign.setUri(uri);
        String configFolderLocation = ExperimentDesignOntologyAPI.getConfigFolderLocation();
        String templateFolderLocation = ExperimentDesignOntologyAPI.getTemplateFolderLocation();
        File[] existingFiles = ExperimentDesignOntologyAPI.getConfigFilesByDirectory("experimentTemplates");
        boolean indexFileExists = false;
        if (existingFiles != null) {
            String[] fileNames = new String[existingFiles.length];
            int i = 0;
            while (i < existingFiles.length) {
                fileNames[i] = existingFiles[i].getName();
                if (existingFiles[i].getName().equals("template.xml")) {
                    indexFileExists = true;
                }
                ++i;
            }
            if (!indexFileExists) {
                ExperimentTemplateFileHandler.createTemplateIndexFile(templateFolderLocation);
            }
            templateFileName = ExperimentDesignOntologyAPI.generateFileName(fileNames, "experimentTemplate");
        } else {
            templateFileName = ExperimentDesignOntologyAPI.generateFileName(new String[1], "experimentTemplate");
        }
        File configFolder = new File(configFolderLocation);
        if (configFolder.isDirectory()) {
            templateFolder = new File(templateFolderLocation);
            if (!templateFolder.exists()) {
                templateFolder.mkdirs();
                ExperimentTemplateFileHandler.createTemplateIndexFile(templateFolderLocation);
            }
        } else {
            throw new IOException("Configuration folder does not exist");
        }
        ExperimentTemplateEntry entry = new ExperimentTemplateEntry();
        entry.setCreator(experimentDesign.getCreatedBy());
        entry.setName(experimentDesign.getName());
        entry.setDescription(experimentDesign.getDescription());
        entry.setDateCreated(experimentDesign.getDateCreated());
        entry.setFilename(templateFileName);
        ExperimentTemplateFileHandler.addTemplate(entry, templateFolderLocation);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)experimentDesign, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(String.valueOf(templateFolder.getAbsolutePath()) + File.separator + templateFileName);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    private static String generateFileName(String[] existingNames, String prefix) {
        String fileName = "";
        int randomLength = 0;
        do {
            fileName = prefix;
            while (randomLength < 5) {
                int randomcharacter = (int)(Math.random() * 10.0);
                ++randomLength;
                fileName = String.valueOf(fileName) + randomcharacter;
            }
            fileName = String.valueOf(fileName) + ".xml";
        } while (Arrays.asList(existingNames).contains(fileName));
        return fileName;
    }

    public List<MeasurementUnit> getAllMeasurementUnits() {
        ArrayList<MeasurementUnit> measurementUnits = new ArrayList<MeasurementUnit>();
        MeasurementUnit measurementUnit = null;
        OntClass unitResource = ExperimentDesignOntologyAPI.om.standardOntologymodel.getOntClass(OntologyManager.UNIT_URI);
        Individual unitIndiv = null;
        ExtendedIterator extendedIterator = ExperimentDesignOntologyAPI.om.standardOntologymodel.listIndividuals((Resource)unitResource);
        while (extendedIterator.hasNext()) {
            unitIndiv = (Individual)extendedIterator.next();
            measurementUnit = new MeasurementUnit();
            measurementUnit.setLabel(unitIndiv.getLabel(null));
            measurementUnit.setUri(unitIndiv.getURI());
            measurementUnits.add(measurementUnit);
        }
        extendedIterator = ExperimentDesignOntologyAPI.om.localOntologymodel.listIndividuals((Resource)unitResource);
        while (extendedIterator.hasNext()) {
            unitIndiv = (Individual)extendedIterator.next();
            measurementUnit = new MeasurementUnit();
            measurementUnit.setLabel(unitIndiv.getLabel(null));
            measurementUnit.setUri(unitIndiv.getURI());
            measurementUnits.add(measurementUnit);
        }
        return measurementUnits;
    }

    public void createMeasurementUnit(MeasurementUnit measurementUnit) throws AlreadyExistsException, UnsupportedEncodingException {
        if (ExperimentDesignOntologyAPI.om.localOntologymodel.getOntResource(measurementUnit.getUri()) != null) {
            throw new AlreadyExistsException(measurementUnit.getUri());
        }
        Individual unitIndiv = ExperimentDesignOntologyAPI.om.localOntologymodel.createIndividual(measurementUnit.getUri(), ExperimentDesignOntologyAPI.om.localOntologymodel.getResource(OntologyManager.UNIT_URI));
        ExperimentDesignOntologyAPI.om.localOntologymodel.add(unitIndiv.asResource(), RDFS.label, measurementUnit.getLabel());
    }

    public boolean isExistingURI(String uri) {
        return ExperimentDesignOntologyAPI.om.localOntologymodel.getOntResource(uri) != null || ExperimentDesignOntologyAPI.om.standardOntologymodel.getOntResource(uri) != null;
    }

    public void createNamespace(String namespaceUri, String namespaceLabel, String newFileName) throws AlreadyExistsException {
        if (this.isExistingURI(namespaceUri)) {
            throw new AlreadyExistsException("Cannot create this namespace : " + namespaceLabel + "\nThe uri already exists : " + namespaceUri);
        }
        Individual namespaceIndiv = ExperimentDesignOntologyAPI.om.localOntologymodel.createIndividual(namespaceUri, ExperimentDesignOntologyAPI.om.localOntologymodel.getResource(OntologyManager.NAMESPACE_CLASS_URI));
        ExperimentDesignOntologyAPI.om.localOntologymodel.add(namespaceIndiv.asResource(), RDFS.label, namespaceLabel);
        if (newFileName != null) {
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, namespaceUri, "has_namespace_file", ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(newFileName));
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, namespaceUri, "is_short_namespace", ExperimentDesignOntologyAPI.om.localOntologymodel.createTypedLiteral(true));
        }
    }

    public Set<String> getAllShortNamespaceFileNames() {
        HashSet<String> shortNamespaceFileNames = new HashSet<String>();
        shortNamespaceFileNames.addAll(this.getShortNamespaceFileNames(ExperimentDesignOntologyAPI.om.standardOntologymodel));
        return shortNamespaceFileNames;
    }

    private Set<String> getShortNamespaceFileNames(OntModel model) {
        HashSet<String> shortNamespaceFileNames = new HashSet<String>();
        OntClass namespaceResource = model.getOntClass(OntologyManager.NAMESPACE_CLASS_URI);
        Individual namespaceIndiv = null;
        ExtendedIterator extendedIterator = model.listIndividuals((Resource)namespaceResource);
        Literal shortLiteralValue = null;
        Literal fileNameLiteral = null;
        while (extendedIterator.hasNext()) {
            namespaceIndiv = (Individual)extendedIterator.next();
            shortLiteralValue = om.getLiteralValue(model, namespaceIndiv, "is_short_namespace");
            if (shortLiteralValue == null || !shortLiteralValue.getBoolean() || (fileNameLiteral = om.getLiteralValue(model, namespaceIndiv, "has_namespace_file")) == null || fileNameLiteral.getString() == null) continue;
            shortNamespaceFileNames.add(fileNameLiteral.getString());
        }
        return shortNamespaceFileNames;
    }

    public void addCategoryForProtocol(String protocolUri, String categoryUri) throws Exception {
        Individual protcolIndiv = ExperimentDesignOntologyAPI.om.localOntologymodel.getIndividual(protocolUri);
        if (protcolIndiv == null || protcolIndiv.getOntClass() == null || !OntologyManager.PROTOCOL_CLASS_URI.equals(protcolIndiv.getOntClass().getURI())) {
            throw new Exception("No Such Protocol Exists in the local ontology : " + protocolUri);
        }
        Individual categoryIndiv = ExperimentDesignOntologyAPI.om.localOntologymodel.getIndividual(categoryUri);
        if (categoryIndiv == null || categoryIndiv.getOntClass() == null || !OntologyManager.PROTOCOLCATEGORY_CLASS_URI.equals(categoryIndiv.getOntClass().getURI())) {
            throw new Exception("No Such Category Exists in the local ontology : " + categoryUri);
        }
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, protocolUri, "has_category", categoryUri);
    }

    public String getStandardOntologyVersion() {
        return ExperimentDesignOntologyAPI.om.standardOntologymodel.getOntology(OntologyManager.ontURI).getVersionInfo();
    }

    public String getLocalOntologyVersion() {
        return ExperimentDesignOntologyAPI.om.localOntologymodel.getOntology(OntologyManager.ontURI).getVersionInfo();
    }

    @Override
    public ProtocolCategory createCategory(String label, String parentURI, String icon, String description, Integer position) throws Exception {
        boolean exists = false;
        List<ProtocolCategory> existing = this.getProtocolCategories();
        for (ProtocolCategory protocolCategory : existing) {
            if (!protocolCategory.equals(label)) continue;
            exists = true;
            break;
        }
        if (exists) {
            throw new ProtocolExistsException("A category named " + label + "already exists!");
        }
        Individual parent = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, parentURI);
        if (parent == null) {
            parent = om.getIndividual(ExperimentDesignOntologyAPI.om.standardOntologymodel, parentURI);
            if (parent != null) {
                int pos = 1;
                List<ProtocolCategory> categories = this.getTopLevelCategories();
                if (categories != null) {
                    pos = categories.size() + 1;
                }
                this.createPaletteCategory(parent.getLabel(null), pos);
            } else {
                throw new Exception("Cannot add the category. PaletteCategory" + parentURI + " not found in ontology");
            }
        }
        String indivUri = om.createNewIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.PROTOCOLCATEGORY_CLASS_URI, label);
        om.addProperty(ExperimentDesignOntologyAPI.om.localOntologymodel, parent.getURI(), "has_subCategory", indivUri);
        Literal iconLit = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral(icon);
        om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_icon", iconLit);
        if (position != null) {
            Literal positionLiteral = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral("" + position);
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_position", positionLiteral);
        }
        if (description != null && !description.isEmpty()) {
            om.addComment(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, description);
        }
        Individual categoryIndiv = om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri);
        ProtocolCategory category = new ProtocolCategory();
        category.setUri(indivUri);
        category.setName(label);
        if (position != null) {
            category.setPosition(position);
        }
        if (iconLit != null) {
            category.setIcon(iconLit.getString());
        }
        category.setColor(this.getColorForCategory(categoryIndiv));
        category.setDescription(categoryIndiv.getComment(null));
        return category;
    }

    @Override
    public String createPaletteCategory(String label, Integer position) throws Exception {
        String uri = String.valueOf(OntologyManager.baseURI) + URLEncoder.encode(label.replace(' ', '_'), "UTF-8");
        if (om.getIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, uri) != null) {
            return uri;
        }
        String indivUri = om.createNewIndividual(ExperimentDesignOntologyAPI.om.localOntologymodel, OntologyManager.TOPLEVELCATEGORY_CLASS_URI, label);
        if (position != null) {
            Literal positionLiteral = ExperimentDesignOntologyAPI.om.localOntologymodel.createLiteral("" + position);
            om.addLiteral(ExperimentDesignOntologyAPI.om.localOntologymodel, indivUri, "has_position", positionLiteral);
        }
        return indivUri;
    }
}

