/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.util;

import java.util.ArrayList;

public class NumberUtils {
    public static Double parseDoubleStr(String str, Double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static Integer parseIntStr(String str, Integer defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static ArrayList<Integer> parseMultipleIntStr(String str, String delim, Integer defaultValue) {
        String[] substrings;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (String substr : substrings = str.split(delim)) {
            try {
                Integer strValue = Integer.parseInt(substr);
                resultList.add(strValue);
            }
            catch (Throwable e) {
                resultList.add(defaultValue);
            }
        }
        return resultList;
    }

    public static double nullsaveDoubleValue(Double theDouble, double defaultValue) {
        if (theDouble != null) {
            return theDouble;
        }
        return defaultValue;
    }

    public static double nullsaveDoubleValue(Double theDouble) {
        return NumberUtils.nullsaveDoubleValue(theDouble, 0.0);
    }

    public static int nullsaveIntValue(Integer theInt, int defaultValue) {
        if (theInt != null) {
            return theInt;
        }
        return defaultValue;
    }

    public static int nullsaveIntValue(Integer theInt) {
        return NumberUtils.nullsaveIntValue(theInt, 0);
    }
}

