/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycomedb.residuetranslator.ResidueTranslator;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportByonicProcess;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.util.structure.glycan.count.GlycanCompositionCountOperator;
import org.grits.toolbox.util.structure.glycan.count.SearchQueryItem;
import org.grits.toolbox.utils.process.GlycoWorkbenchUtil;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;

public class MSGlycanAnnotationExportByonicProcess
extends MSAnnotationExportByonicProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationExportByonicProcess.class);
    protected GlycoWorkbenchUtil m_gwbUtil;
    List<SearchQueryItem> componentList;

    public void setComponentList(List<SearchQueryItem> componentList) {
        this.componentList = componentList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.getOutputFile()));
            out.write("% Created by GRITS on " + new Date());
            out.newLine();
            Config t_objConf = new Config();
            MonosaccharideConverter t_msdb = new MonosaccharideConverter(t_objConf);
            try {
                this.m_gwbUtil = new GlycoWorkbenchUtil((MonosaccharideConversion)new ResidueTranslator(), (MonosaccharideConversion)t_msdb);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(this.tableDataObject.getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            HashSet<Row> rowsToWrite = new HashSet<Row>();
            int i = 0;
            while (i < this.getTableDataObject().getTableData().size()) {
                if (this.isCanceled()) {
                    out.close();
                    return false;
                }
                int iParentScanIdCol = -1;
                if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
                    iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
                }
                int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
                int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
                Integer iParentScanNum = null;
                if (this.getMasterParentScan() != -1) {
                    iParentScanNum = this.getMasterParentScan();
                } else if (iParentScanIdCol != -1 && ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol) != null) {
                    iParentScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol);
                }
                Integer iPeakId = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iPeakIdCol);
                String sFeatureId = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iFeatureIdCol);
                if (sFeatureId != null || !this.hideUnAnnotatedRows()) {
                    Integer iScanNum = null;
                    if (this.getTableDataObject().getScanNoCols() != null && !this.getTableDataObject().getScanNoCols().isEmpty()) {
                        iScanNum = (Integer)this.getTableDataObject().getScanNoCols().get(0);
                    }
                    String iRowId = Feature.getRowId((Integer)iPeakId, iScanNum, (boolean)this.getTableDataObject().getUsesComplexRowId());
                    if (iPeakId == null || sFeatureId == null || iParentScanNum == null || !this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) {
                        boolean bInvisible = false;
                        if (iPeakId != null && iParentScanNum != null && this.getTableDataObject().isInvisibleRow(iParentScanNum, iRowId)) {
                            bInvisible = true;
                        }
                        if (!bInvisible) {
                            int iInx1;
                            int sequenceCol = (Integer)this.getTableDataObject().getSequenceCols().get(0);
                            String sequence = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(sequenceCol);
                            if (sequence != null && !sequence.isEmpty() && (iInx1 = sequence.indexOf("~|~")) < 0) {
                                this.m_gwbUtil.parseGWSSequence(sequence);
                                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                                glycan.setReducingEndType(ResidueType.createFreeReducingEnd());
                                LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
                                boolean matched = GlycanCompositionCountOperator.matchAndCountComposition((Sugar)glycan.toSugar(), this.componentList, counts);
                                if (matched) {
                                    rowsToWrite.add(new Row(sFeatureId, glycan.computeMass(), counts));
                                } else {
                                    logger.info((Object)("Not a match, Excluding: " + sFeatureId));
                                    logger.info((Object)("Sequence: " + sequence));
                                }
                            }
                        }
                        ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                    }
                }
                ++i;
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(rowsToWrite.size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            i = 0;
            for (Row row : rowsToWrite) {
                out.write(row.toString());
                out.newLine();
                logger.debug((Object)(String.valueOf(row.toString()) + " -->" + row.featureId));
                ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + ++i);
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    class Row {
        Map<String, Integer> componentCounts;
        Double mass;
        String featureId;

        public Row(String featureId, Double mass, Map<String, Integer> counts) {
            this.featureId = featureId;
            this.mass = mass;
            this.componentCounts = counts;
        }

        public void setComponentCounts(Map<String, Integer> componentCounts) {
            this.componentCounts = componentCounts;
        }

        public void setMass(Double mass) {
            this.mass = mass;
        }

        public void setFeatureId(String featureId) {
            this.featureId = featureId;
        }

        public String toString() {
            if (this.componentCounts == null) {
                return null;
            }
            String output = "";
            for (String component : this.componentCounts.keySet()) {
                int count = this.componentCounts.get(component);
                if (count == 0) continue;
                output = String.valueOf(output) + component + "(" + this.componentCounts.get(component) + ")";
            }
            output = String.valueOf(output) + " % " + this.mass;
            return output;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Row)) {
                return false;
            }
            return this.featureId.equals(((Row)obj).featureId);
        }

        public int hashCode() {
            return this.featureId.hashCode();
        }
    }
}

