/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;

public class PlateTableColumnPropertyAccessor<TableData>
implements IColumnPropertyAccessor<TableData> {
    List<GRITSColumnHeader> propertyNames;
    Boolean rawData = true;
    Double lowerThreshold;
    private QrtPCRTableEditor editor;
    private QrtPCRData data;
    private Integer runId = 0;
    Boolean masterTable = false;

    public PlateTableColumnPropertyAccessor(QrtPCRTableEditor editor, QrtPCRData qrtPCRData, List<GRITSColumnHeader> columns, Integer runId, Boolean rawData, Boolean masterTable, Double lowerThreshold) {
        this.editor = editor;
        this.rawData = rawData;
        this.propertyNames = columns;
        this.lowerThreshold = lowerThreshold;
        this.runId = runId;
        this.data = qrtPCRData;
        this.masterTable = masterTable;
    }

    public int getColumnCount() {
        return this.propertyNames.size();
    }

    public void setMasterTable(Boolean masterTable) {
        this.masterTable = masterTable;
    }

    public Object getDataValue(TableData element, int columnIndex) {
        String columnName;
        switch (columnName = this.propertyNames.get(columnIndex).getKeyValue()) {
            case "Well": {
                if (element instanceof GeneData) {
                    return ((GeneData)element).getPosition().toString();
                }
                return null;
            }
            case "Gene Identifier": {
                if (element instanceof GeneData) {
                    return null;
                }
                if (!(element instanceof Gene)) break;
                return ((Gene)element).getGeneIdentifier();
            }
            case "ct0": {
                if (element instanceof GeneData) {
                    Double ct0 = null;
                    ct0 = this.rawData == false ? ((GeneData)element).getCt() : ((GeneData)element).getOriginalCt();
                    if (ct0 != null) {
                        return String.valueOf(ct0);
                    }
                    return "" + this.lowerThreshold;
                }
                return null;
            }
            case "Gene Symbol": {
                if (element instanceof Gene) {
                    return ((Gene)element).getGeneSymbol();
                }
                return null;
            }
            case "StDev": {
                if (element instanceof Gene) {
                    if (this.rawData.booleanValue()) {
                        return String.valueOf(((Gene)element).getStandardDeviation(0, this.lowerThreshold, true));
                    }
                    return String.valueOf(((Gene)element).getStandardDeviation(0, this.lowerThreshold, false));
                }
                return null;
            }
            case "2^-ct": {
                if (element instanceof GeneData) {
                    Double d = ((GeneData)element).get2PowCt(this.rawData);
                    if (d != null) {
                        return String.valueOf(d);
                    }
                    return "";
                }
                return null;
            }
            case "Norm Value": {
                if (element instanceof Gene) {
                    if (this.rawData.booleanValue() && this.data != null) {
                        return String.valueOf(this.data.findNormValue(0, true));
                    }
                    return String.valueOf(((Gene)element).getNormValue(0));
                }
                return "";
            }
            case "Normalized": {
                Double d;
                if (element instanceof GeneData && (d = ((GeneData)element).get2PowCt(this.rawData)) != null) {
                    if (this.rawData.booleanValue() && this.data != null) {
                        return String.valueOf(d / this.data.findNormValue(null, true));
                    }
                    return String.valueOf(d / ((GeneData)element).getGene().getNormValue(0));
                }
                return "";
            }
            case "Scaler": {
                if (element instanceof Gene) {
                    if (this.rawData.booleanValue() && this.data != null) {
                        return String.valueOf(((Gene)element).getScaler(0, this.lowerThreshold, this.data.findNormValue(0, true)));
                    }
                    return String.valueOf(((Gene)element).getScaler(0, this.lowerThreshold, this.data.findNormValue(0, false)));
                }
                return "";
            }
            case "Adjusted": {
                Double d;
                if (element instanceof GeneData && (d = ((GeneData)element).get2PowCt(this.rawData)) != null) {
                    Gene g = ((GeneData)element).getGene();
                    if (this.rawData.booleanValue() && this.data != null) {
                        Double normValue = this.data.findNormValue(0, true);
                        return String.valueOf(d / normValue - g.getScaler(0, this.lowerThreshold, normValue));
                    }
                    return String.valueOf(d / g.getNormValue(0) - g.getScaler(0, this.lowerThreshold, g.getNormValue(0)));
                }
                return "";
            }
            case "Average": {
                if (element instanceof Gene) {
                    Double d = null;
                    d = this.rawData != false && this.data != null ? ((Gene)element).getAdjustedAverage(0, true, this.lowerThreshold, this.data.findNormValue(0, true)) : (this.masterTable != false ? ((Gene)element).getAdjustedAverage(((Gene)element).getRunId(), this.lowerThreshold, ((Gene)element).getNormValue(((Gene)element).getRunId())) : ((Gene)element).getAdjustedAverage(0, false, this.lowerThreshold, ((Gene)element).getNormValue(0)));
                    if (d != null) {
                        return String.valueOf(d);
                    }
                }
                return "";
            }
            case "St Dev - Adjusted": {
                if (element instanceof Gene) {
                    Double d = null;
                    d = this.rawData != false && this.data != null ? ((Gene)element).getStDevForAdjusted(0, true, this.lowerThreshold, this.data.findNormValue(0, true)) : (this.masterTable != false ? ((Gene)element).getStDevForAdjusted(((Gene)element).getRunId(), this.lowerThreshold, ((Gene)element).getNormValue(((Gene)element).getRunId())) : ((Gene)element).getStDevForAdjusted(0, false, this.lowerThreshold, ((Gene)element).getNormValue(0)));
                    if (d != null) {
                        return String.valueOf(d);
                    }
                }
                return "";
            }
        }
        return null;
    }

    public void setDataValue(TableData element, int columnIndex, Object value) {
        String columnName = this.propertyNames.get(columnIndex).getKeyValue();
        if (columnName.equals("ct0") && element != null && element instanceof GeneData) {
            Double oldValue = ((GeneData)element).getCt();
            Double newValue = null;
            if (value != null && !((String)value).trim().isEmpty()) {
                newValue = Double.parseDouble((String)value);
            }
            ((GeneData)element).setCt(newValue);
            if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                ((GeneData)element).addPreviousValue(oldValue, CtHistory.Reason.USERCHANGE.getReason());
                if (((GeneData)element).getGene().getIsControl().booleanValue() && this.data != null) {
                    this.data.calculateNormValue();
                }
                this.editor.updateFirstRun(((GeneData)element).getGene(), this.runId);
                this.editor.markDirty();
            }
        }
    }

    public int getColumnIndex(String propertyName) {
        int index = 0;
        for (GRITSColumnHeader simianColumnHeader : this.propertyNames) {
            if (simianColumnHeader.getKeyValue().equals(propertyName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getColumnProperty(int columnIndex) {
        return this.propertyNames.get(columnIndex).getKeyValue();
    }
}

