/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.util.Utils;

public class Modification
extends ResourcesDbObject
implements Comparator<Object>,
Cloneable {
    private String name;
    private int valence;
    private ArrayList<Integer> position1;
    private ArrayList<Integer> position2;
    private String sourceName;
    private int modificationId = 0;
    public static final int EMPTYPOSITIONVALUE = -1;

    public Modification() {
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValence() {
        return this.valence;
    }

    public void setValence(int valence) {
        this.valence = valence;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    public void setModificationId(int modificationId) {
        this.modificationId = modificationId;
    }

    public ArrayList<Integer> getPosition1() {
        if (this.position1 == null) {
            this.position1 = new ArrayList();
        }
        return this.position1;
    }

    public String getPosition1Str(String delimiter, String unknownPositionLabel) {
        return Utils.formatPositionsString(this.getPosition1(), delimiter, unknownPositionLabel);
    }

    public ArrayList<Integer> getPosition1Clone() {
        return Utils.cloneIntegerList(this.getPosition1());
    }

    public int getIntValuePosition1() {
        if (this.getPosition1().size() == 0) {
            return -1;
        }
        if (this.getPosition1().size() == 1) {
            return this.getPosition1().get(0);
        }
        return 0;
    }

    public void setIntValuePosition1(int position) throws MonosaccharideException {
        this.setPosition1(position);
    }

    public void setPosition1(ArrayList<Integer> positions) {
        this.position1 = positions;
    }

    public void setPosition1(int position) throws MonosaccharideException {
        if (this.getPosition1() == null) {
            this.setPosition1(new ArrayList<Integer>());
        } else {
            this.getPosition1().clear();
        }
        if (position != -1) {
            this.addPosition1(position);
        }
    }

    public void addPosition1(int position) throws MonosaccharideException {
        if (position < 0) {
            throw new MonosaccharideException("Modification position must not be negative.");
        }
        if (!this.containsPosition1(position)) {
            this.getPosition1().add(new Integer(position));
            Collections.sort(this.getPosition1());
        }
    }

    public boolean containsPosition1(int position) {
        for (int i = 0; i < this.getPosition1().size(); ++i) {
            int usedPosition = this.getPosition1().get(i);
            if (usedPosition != position) continue;
            return true;
        }
        return false;
    }

    public boolean position1equals(int position) {
        return this.getPosition1().size() == 1 && this.getIntValuePosition1() == position;
    }

    public ArrayList<Integer> getPosition2() {
        if (this.position2 == null) {
            this.position2 = new ArrayList();
        }
        return this.position2;
    }

    public String getPosition2Str(String delimiter, String unknownPositionLabel) {
        return Utils.formatPositionsString(this.getPosition2(), delimiter, unknownPositionLabel);
    }

    public ArrayList<Integer> getPosition2Clone() {
        return Utils.cloneIntegerList(this.getPosition2());
    }

    public int getIntValuePosition2() {
        if (this.getPosition2().size() == 0) {
            return -1;
        }
        if (this.getPosition2().size() == 1) {
            return this.getPosition2().get(0);
        }
        return 0;
    }

    public void setIntValuePosition2(int position) throws MonosaccharideException {
        this.setPosition2(position);
    }

    public void setPosition2(ArrayList<Integer> positions) {
        this.position2 = positions;
    }

    public void setPosition2(int position) throws MonosaccharideException {
        if (this.getPosition2() == null) {
            this.setPosition2(new ArrayList<Integer>());
        } else {
            this.getPosition2().clear();
        }
        if (position != -1) {
            this.addPosition2(position);
        }
    }

    public void addPosition2(int position) throws MonosaccharideException {
        if (position < 0) {
            throw new MonosaccharideException("Modification position must not be negative.");
        }
        if (!this.containsPosition2(position)) {
            this.getPosition2().add(new Integer(position));
            Collections.sort(this.getPosition2());
        }
    }

    public boolean containsPosition2(int position) {
        for (int i = 0; i < this.getPosition2().size(); ++i) {
            int usedPosition = this.getPosition2().get(i);
            if (usedPosition != position) continue;
            return true;
        }
        return false;
    }

    public boolean position2equals(int position) {
        return this.getPosition2().size() == 1 && this.getIntValuePosition2() == position;
    }

    public boolean containsPosition(int position) {
        return this.containsPosition1(position) || this.containsPosition2(position);
    }

    public boolean hasPosition2() {
        return this.getPosition2().size() > 0;
    }

    public ArrayList<Integer> getPositions() {
        ArrayList<Integer> posList = this.getPosition1Clone();
        if (this.hasPosition2()) {
            for (Integer pos2value : this.getPosition2()) {
                if (this.containsPosition1(pos2value)) continue;
                posList.add(pos2value);
            }
        }
        return posList;
    }

    public boolean hasUncertainLinkagePosition() {
        if (this.getPosition1().size() > 1) {
            return true;
        }
        if (this.containsPosition1(0)) {
            return true;
        }
        if (this.hasPosition2()) {
            if (this.getPosition2().size() > 1) {
                return true;
            }
            if (this.containsPosition2(0)) {
                return true;
            }
        }
        return false;
    }

    public void sortPositions() {
        Collections.sort(this.getPosition1());
        if (this.hasPosition2()) {
            Collections.sort(this.getPosition2());
            String pos1Str = Utils.formatPositionsString(this.getPosition1(), ",", "X");
            String pos2Str = Utils.formatPositionsString(this.getPosition2(), ",", "X");
            if (pos1Str.compareTo(pos2Str) > 0) {
                ArrayList<Integer> tmpPosList = this.getPosition1();
                this.setPosition1(this.getPosition2());
                this.setPosition2(tmpPosList);
            }
        }
    }

    public boolean positionsEqual(Modification otherMod) {
        if (otherMod == null) {
            return false;
        }
        if (this.getPosition1().size() != otherMod.getPosition1().size()) {
            return false;
        }
        for (Integer posInt : this.getPosition1()) {
            if (otherMod.containsPosition1(posInt)) continue;
            return false;
        }
        if (this.getPosition2().size() != otherMod.getPosition2().size()) {
            return false;
        }
        for (Integer posInt : this.getPosition2()) {
            if (otherMod.containsPosition2(posInt)) continue;
            return false;
        }
        return true;
    }

    public Modification clone() {
        Modification modClone = new Modification();
        modClone.setName(this.getName());
        modClone.setValence(this.getValence());
        modClone.setPosition1(this.getPosition1Clone());
        modClone.setPosition2(this.getPosition2Clone());
        return modClone;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int i;
        ArrayList<Integer> positions1 = ((Modification)o1).getPosition1();
        ArrayList<Integer> positions2 = ((Modification)o2).getPosition1();
        for (i = 0; i < Math.min(positions1.size(), positions2.size()); ++i) {
            if (positions1.get(i) < positions2.get(i) && positions1.get(i) != 0) {
                return -1;
            }
            if (positions1.get(i) <= positions2.get(i)) continue;
            return 1;
        }
        if (positions1.size() > positions2.size()) {
            return -1;
        }
        if (positions1.size() < positions2.size()) {
            return 1;
        }
        positions1 = ((Modification)o1).getPosition2();
        positions2 = ((Modification)o2).getPosition2();
        for (i = 0; i < Math.min(positions1.size(), positions2.size()); ++i) {
            if (positions1.get(i) < positions2.get(i)) {
                return -1;
            }
            if (positions1.get(i) <= positions2.get(i)) continue;
            return 1;
        }
        if (positions1.size() > positions2.size()) {
            return -1;
        }
        if (positions1.size() < positions2.size()) {
            return 1;
        }
        return ((Modification)o1).getName().compareTo(((Modification)o2).getName());
    }

    public boolean equals(Modification mod2) {
        return this.compare(this, mod2) == 0;
    }

    public void init() {
        this.setName(null);
        this.setPosition1(new ArrayList<Integer>());
        this.setPosition2(new ArrayList<Integer>());
        this.setValence(0);
        this.setSourceName(null);
        this.setModificationId(0);
    }

    public String makeCmpString() {
        String cmpStr = Utils.formatPositionsString(this.getPosition1(), "/", "0");
        if (this.hasPosition2()) {
            cmpStr = cmpStr + "|" + Utils.formatPositionsString(this.getPosition2(), "/", "0");
        }
        cmpStr = cmpStr + "|" + this.getName();
        return cmpStr;
    }

    public String toString() {
        String str = "[";
        str = str + "name: " + this.getName() + "; ";
        str = str + "position: " + this.getPosition1().toString();
        if (this.getPosition2() != null && this.getPosition2().size() > 0) {
            str = str + "/" + this.getPosition2().toString();
        }
        str = str + "]";
        return str;
    }
}

