/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.display.control.spectrum.chart.GRITSChartComposite;
import org.grits.toolbox.display.control.spectrum.chart.GRITSJFreeChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerChart;
import org.grits.toolbox.display.control.spectrum.chart.GRITSSpectralViewerData;
import org.grits.toolbox.display.control.spectrum.datamodel.MSIonData;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.entry.ms.exceptions.MSException;
import org.grits.toolbox.entry.ms.extquantfiles.process.CustomAnnotationDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraControlPanelView;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.file.reader.IMSFileReader;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.jfree.chart.JFreeChart;

public class MassSpecSpectraView
implements IEntryEditorPart {
    public static final String VIEW_ID = "plugin.ms.views.MSSpectraView";
    private static final Logger logger = Logger.getLogger(MassSpecSpectraView.class);
    protected Composite parent = null;
    protected String sMzXMLFile = null;
    protected Integer iScanNum = null;
    protected String sDescription = null;
    protected Double dMz = null;
    protected Integer iMSLevel = null;
    protected MassSpecTableDataProcessor peakListTableProcessor = null;
    protected MassSpecTableDataProcessor scanListtableProcessor = null;
    protected Composite compositeTop = null;
    protected Composite compositeBottom = null;
    protected MSSpectraViewerSashForm sashForm = null;
    protected MassSpecSpectraControlPanelView controlPanel = null;
    protected Boolean bIsCentroid = false;
    protected GRITSSpectralViewerChart svChart = null;
    protected GRITSJFreeChart jFreeChart = null;
    protected GRITSChartComposite chartComposite = null;
    protected Entry entry;
    private MPart part;

    @Inject
    public MassSpecSpectraView(@Optional Entry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public boolean isLoaded() {
        return this.svChart != null;
    }

    public void setPeakListTableProcessor(MassSpecTableDataProcessor tableProcessor) {
        this.peakListTableProcessor = tableProcessor;
    }

    public MassSpecTableDataProcessor getPeakListTableProcessor() {
        return this.peakListTableProcessor;
    }

    public void setScanListTableProcessor(MassSpecTableDataProcessor tableProcessor) {
        this.scanListtableProcessor = tableProcessor;
    }

    public MassSpecTableDataProcessor getScanListTableProcessor() {
        return this.scanListtableProcessor;
    }

    public GRITSSpectralViewerChart getSpectralViewerChart() {
        return this.svChart;
    }

    public boolean isSameRunAs(String _sMzXMLFile) {
        if (this.sMzXMLFile == null || _sMzXMLFile == null) {
            return false;
        }
        return this.sMzXMLFile.equals(_sMzXMLFile);
    }

    public Composite getView() {
        return this.sashForm;
    }

    public GRITSChartComposite getChart() {
        return this.chartComposite;
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public void setMzXMLFile(String sMzXMLFile) {
        this.sMzXMLFile = sMzXMLFile;
    }

    public void setScanNum(Integer iScanNum) {
        this.iScanNum = iScanNum;
    }

    public void setMSLevel(Integer iMSLevel) {
        this.iMSLevel = iMSLevel;
    }

    public void setMz(Double dMz) {
        this.dMz = dMz;
    }

    public String getMSPath() {
        Entry msEntry = MassSpecProperty.getMSParentEntry(this.getEntry());
        MassSpecProperty cfr_ignored_0 = (MassSpecProperty)msEntry.getProperty();
        String folderName = MassSpecProperty.getFullyQualifiedFolderName(msEntry);
        return folderName;
    }

    public MSPropertyDataFile getMSSourceFile() {
        if (this.entry == null) {
            return null;
        }
        MSPropertyDataFile msSourceFile = ((MassSpecEntityProperty)this.getEntry().getProperty()).getDataFile();
        Property prop = this.entry.getProperty();
        MassSpecProperty msProp = null;
        MassSpecEntityProperty msep = null;
        if (prop instanceof MassSpecEntityProperty) {
            msep = (MassSpecEntityProperty)prop;
            msProp = msep.getMassSpecParentProperty();
        } else {
            msProp = (MassSpecProperty)prop;
        }
        MSPropertyDataFile newMSSourceFile = msProp.getUpdatePropertyDataFile(msSourceFile);
        if (!((Object)((Object)msSourceFile)).equals((Object)newMSSourceFile)) {
            if (msep != null) {
                msep.setDataFile(newMSSourceFile);
            }
            return newMSSourceFile;
        }
        return msSourceFile;
    }

    protected ArrayList<MSIonData> getCurrentScanDataTIM(MassSpecProperty prop) {
        ArrayList<MSIonData> alIons = new ArrayList<MSIonData>();
        MSPropertyDataFile msSourceFile = this.getMSSourceFile();
        if (msSourceFile == null) {
            return alIons;
        }
        MSFile msFile = msSourceFile.getMSFileWithReader(this.getMSPath(), prop.getMassSpecMetaData().getMsExperimentType(), true);
        IMSFileReader reader = msFile.getReader();
        if (reader == null || !(reader instanceof IMSAnnotationFileReader)) {
            return alIons;
        }
        try {
            List scans = ((IMSAnnotationFileReader)reader).readMSFile(msFile, 2, -1, -1);
            int i = 0;
            while (i < scans.size()) {
                Scan scan = (Scan)scans.get(i);
                if (scan != null && scan.getPrecursor() != null) {
                    MSIonData ion = new MSIonData(scan.getPrecursor().getMz().doubleValue(), scan.getPrecursor().getIntensity().doubleValue());
                    alIons.add(ion);
                }
                ++i;
            }
            this.bIsCentroid = true;
            return alIons;
        }
        catch (Exception ex) {
            reader = null;
            logger.error((Object)"General Exception in getCurrentScanData.", (Throwable)ex);
            return null;
        }
    }

    protected ArrayList<MSIonData> getCurrentScanData() throws MSException {
        boolean bHasMS1;
        MSFile msFile;
        IMSFileReader reader;
        ArrayList<MSIonData> alIons = new ArrayList<MSIonData>();
        MSPropertyDataFile msSourceFile = this.getMSSourceFile();
        if (msSourceFile == null) {
            return alIons;
        }
        MassSpecProperty prop = null;
        Entry msEntry = MassSpecProperty.getMSParentEntry(this.getEntry());
        if (msEntry != null && msEntry.getProperty() instanceof MassSpecProperty) {
            prop = (MassSpecProperty)msEntry.getProperty();
        }
        if ((reader = (msFile = msSourceFile.getMSFileWithReader(this.getMSPath(), prop.getMassSpecMetaData().getMsExperimentType(), true)).getReader()) == null || !(reader instanceof IMSAnnotationFileReader)) {
            return alIons;
        }
        if (!(this.iScanNum != null && this.iScanNum > 0 || (bHasMS1 = ((IMSAnnotationFileReader)reader).hasMS1Scan(msFile)))) {
            return this.getCurrentScanDataTIM(prop);
        }
        try {
            Scan scan = null;
            if (this.iScanNum == null || this.iScanNum <= 0) {
                Scan firstScan = ((IMSAnnotationFileReader)reader).getFirstMS1Scan(msFile);
                List scans = ((IMSAnnotationFileReader)reader).readMSFile(msFile, -1, -1, firstScan.getScanNo().intValue());
                if (!scans.isEmpty()) {
                    scan = (Scan)scans.get(0);
                }
            } else {
                List scans = ((IMSAnnotationFileReader)reader).readMSFile(msFile, -1, -1, this.iScanNum.intValue());
                if (!scans.isEmpty()) {
                    scan = (Scan)scans.get(0);
                }
            }
            if (scan == null) {
                throw new MSException(4);
            }
            this.iScanNum = scan.getScanNo();
            this.bIsCentroid = scan.getIsCentroided();
            if (!scan.getPeaklist().isEmpty()) {
                int i = 0;
                while (i < scan.getPeaklist().size()) {
                    Peak p = (Peak)scan.getPeaklist().get(i);
                    if (!(p.getIntensity() <= 0.0)) {
                        MSIonData ionData = new MSIonData(p.getMz().doubleValue(), p.getIntensity().doubleValue());
                        alIons.add(ionData);
                    }
                    ++i;
                }
            }
        }
        catch (MSException e) {
            throw e;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return alIons;
    }

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        this.parent = parent;
        this.part = part;
    }

    @Focus
    public void setFocus() {
    }

    public void setPartName(String partName) {
        this.part.setLabel(partName);
    }

    protected GRITSSpectralViewerData initSpectralViewerData() throws MSException {
        try {
            GRITSSpectralViewerData svd = new GRITSSpectralViewerData();
            ArrayList<MSIonData> alRawData = this.getCurrentScanData();
            if (alRawData == null || alRawData.isEmpty()) {
                return svd;
            }
            svd.setRawData(alRawData);
            this.setScanListTableData(svd);
            this.setPeakListTableData(svd);
            return svd;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected void setScanListTableData(GRITSSpectralViewerData svd) throws MSException {
        try {
            ArrayList<MSIonData> alPickedPeaks = new ArrayList<MSIonData>();
            HashMap<Double, List<Object>> htPickedPeakLabels = new HashMap<Double, List<Object>>();
            svd.setPickedPeaks(alPickedPeaks);
            svd.setPickedPeakLabels(htPickedPeakLabels);
            if (this.getScanListTableProcessor() == null || svd == null) {
                return;
            }
            MassSpecTableDataObject msTable = this.getScanListTableProcessor().getSimianTableDataObject();
            if (msTable.getMzCols() == null || msTable.getMzCols().isEmpty()) {
                return;
            }
            int i = 0;
            while (i < msTable.getTableData().size()) {
                GRITSListDataRow alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Double dMz = null;
                Double dIntensity = null;
                Integer iScanNo = null;
                boolean bIsPrecursor = false;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                    if (!msTable.getScanNoCols().isEmpty() && alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0)) != null) {
                        iScanNo = (Integer)alRow.getDataRow().get((Integer)msTable.getScanNoCols().get(0));
                    }
                    String sIsPrecursor = null;
                    if (msTable.getPeakIsPrecursorCols() != null && !msTable.getPeakIsPrecursorCols().isEmpty()) {
                        sIsPrecursor = (String)alRow.getDataRow().get((Integer)msTable.getPeakIsPrecursorCols().get(0));
                    }
                    bIsPrecursor = iScanNo != null || sIsPrecursor != null && sIsPrecursor.equals("Yes");
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null) {
                    MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                    if (bIsPrecursor && !alPickedPeaks.contains(msData)) {
                        alPickedPeaks.add(msData);
                        Object oLabel = this.getPeakLabel(dMz, iScanNo);
                        if (oLabel != null) {
                            List<Object> al = null;
                            if (htPickedPeakLabels.containsKey(dMz)) {
                                al = (List)htPickedPeakLabels.get(dMz);
                            } else {
                                al = new ArrayList();
                                htPickedPeakLabels.put(dMz, al);
                            }
                            if (!al.contains(oLabel)) {
                                al.add(oLabel);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void setPeakListTableData(GRITSSpectralViewerData svd) throws MSException {
        try {
            ArrayList<MSIonData> alAnnotatedPeaks = new ArrayList<MSIonData>();
            HashMap<Double, List<Object>> htAnnotatedLabels = new HashMap<Double, List<Object>>();
            svd.setAnnotatedPeaks(alAnnotatedPeaks);
            svd.setAnnotatedPeakLabels(htAnnotatedLabels);
            if (this.getPeakListTableProcessor() == null || svd == null) {
                return;
            }
            MassSpecTableDataObject msTable = this.getPeakListTableProcessor().getSimianTableDataObject();
            if (msTable.getMzCols() == null || msTable.getMzCols().isEmpty() || msTable.getFillType() == FillTypes.Scans) {
                return;
            }
            int i = 0;
            while (i < msTable.getTableData().size()) {
                GRITSListDataRow alRow = (GRITSListDataRow)msTable.getTableData().get(i);
                Double dMz = null;
                Double dIntensity = null;
                try {
                    dMz = (Double)alRow.getDataRow().get((Integer)msTable.getMzCols().get(0));
                    dIntensity = (Double)alRow.getDataRow().get((Integer)msTable.getPeakIntensityCols().get(0));
                }
                catch (Exception ex) {
                    logger.error((Object)"Invalid number format for m/z or intensity in table", (Throwable)ex);
                }
                if (dMz != null && dIntensity != null) {
                    MSIonData msData = new MSIonData(dMz.doubleValue(), dIntensity.doubleValue());
                    int iMSLevel = ((MassSpecEntityProperty)this.getPeakListTableProcessor().getSourceProperty()).getMsLevel() - 1;
                    Object oLabel = this.getPeakLabelForSpecialPeaks(dMz, dIntensity, iMSLevel);
                    if (oLabel != null && !alAnnotatedPeaks.contains(msData)) {
                        alAnnotatedPeaks.add(msData);
                        List<Object> al = null;
                        if (htAnnotatedLabels.containsKey(dMz)) {
                            al = (List)htAnnotatedLabels.get(dMz);
                        } else {
                            al = new ArrayList();
                            htAnnotatedLabels.put(dMz, al);
                        }
                        if (!al.contains(oLabel)) {
                            al.add(oLabel);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected Object getPeakLabelForSpecialPeaks(Double dMz, Double dIntensity, int iMSLevel) {
        if (this.getPeakListTableProcessor().getQuantFileProcessors() == null || this.getPeakListTableProcessor().getQuantFileProcessors().isEmpty()) {
            return null;
        }
        for (QuantFileProcessor fp : this.getPeakListTableProcessor().getQuantFileProcessors()) {
            if (!(fp instanceof CustomAnnotationDataProcessor)) continue;
            CustomAnnotationDataProcessor sfp = (CustomAnnotationDataProcessor)fp;
            if (this.iScanNum == null || sfp.getQuantPeakData() == null || sfp.getQuantPeakData().getPeaks() == null || sfp.getQuantPeakMatches() == null || sfp.getQuantPeakMatches().get(this.iScanNum) == null) continue;
            QuantPeakMatch match = null;
            for (QuantPeakMatch qpm : sfp.getQuantPeakMatches().get(this.iScanNum)) {
                if (!(qpm.getMinMz() < dMz) || !(qpm.getMaxMz() > dMz)) continue;
                match = qpm;
                break;
            }
            if (match == null) continue;
            String sLabel = Double.toString(match.getMzMostAbundant());
            MassSpecCustomAnnotationPeak annotatedPeak = sfp.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(match.getMzMostAbundant());
            if (annotatedPeak != null && annotatedPeak.getMSLevel() == iMSLevel) {
                sLabel = match.getMzMostAbundant() + " - " + sfp.getMassSpecCustomAnnotation().getAnnotatedPeaks().get(match.getMzMostAbundant()).getPeakLabel();
            }
            return sLabel;
        }
        return null;
    }

    protected Object getPeakLabel(Double dMz, Integer iScanNo) {
        if (iScanNo == null) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        String sLabel = iScanNo != null ? "Scan: " + iScanNo + ", " + df.format(dMz) : df.format(dMz);
        return sLabel;
    }

    protected GRITSSpectralViewerChart getNewSpectralViewerChart() {
        return new GRITSSpectralViewerChart(this.sDescription, this.iScanNum.intValue(), this.iMSLevel.intValue(), this.bIsCentroid == false, false);
    }

    protected void initializeChartData() throws MSException {
        try {
            GRITSSpectralViewerData svd = this.initSpectralViewerData();
            if (svd == null || svd.getRawData() == null || svd.getRawData().isEmpty()) {
                throw new MSException(2);
            }
            this.svChart = this.getNewSpectralViewerChart();
            this.controlPanel.enableComponents(svd);
            this.svChart.setSpectralViewerData(svd);
        }
        catch (MSException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing chart data.", (Throwable)e);
            this.svChart = null;
        }
    }

    protected void updatePrefs() {
        MassSpecViewerPreference pref = (MassSpecViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        pref.setShowRaw(this.controlPanel.getShowSpectra().getSelection());
        pref.setShowPicked(this.controlPanel.getPickedPeaks().getSelection());
        pref.setShowPickedLabels(this.controlPanel.getPickedPeakLabels().getSelection());
        pref.setShowAnnotated(this.controlPanel.getAnnotatedPeaks().getSelection());
        pref.setShowAnnotatedLabels(this.controlPanel.getAnnotatedPeakLabels().getSelection());
        pref.writePreference();
    }

    protected void initializeChartPlot() {
        MassSpecViewerPreference pref = (MassSpecViewerPreference)this.getScanListTableProcessor().getSimianTableDataObject().getTablePreferences();
        this.controlPanel.getShowSpectra().setSelection(pref.isShowRaw());
        this.controlPanel.getAnnotatedPeaks().setSelection(pref.isShowAnnotated());
        if (this.controlPanel.getAnnotatedPeaks().getSelection()) {
            this.controlPanel.getAnnotatedPeaks().setEnabled(true);
            this.controlPanel.getAnnotatedPeakLabels().setEnabled(true);
            this.controlPanel.getAnnotatedPeakLabels().setSelection(pref.isShowAnnotatedLabels());
        }
        this.controlPanel.getPickedPeaks().setSelection(pref.isShowPicked());
        if (this.controlPanel.getPickedPeaks().getSelection()) {
            this.controlPanel.getPickedPeaks().setEnabled(true);
            this.controlPanel.getPickedPeakLabels().setEnabled(true);
            this.controlPanel.getPickedPeakLabels().setSelection(pref.isShowPickedLabels());
        }
        this.jFreeChart = this.svChart.createChart();
    }

    public void updateChartPlot() {
        MassSpecSpectraControlPanelView cp = this.controlPanel;
        this.svChart.updateChart(cp.showRaw(), cp.showPickedPeaks(), cp.showPickedPeakLabels(), cp.showAnnotatedPeaks(), cp.showAnnotatedPeakLabels(), false, false);
        this.updatePrefs();
    }

    protected MassSpecSpectraControlPanelView getNewSpectraControlPanel() {
        this.part.getContext().set(MassSpecSpectraView.class, (Object)this);
        MassSpecSpectraControlPanelView cp = (MassSpecSpectraControlPanelView)ContextInjectionFactory.make(MassSpecSpectraControlPanelView.class, (IEclipseContext)this.part.getContext());
        return cp;
    }

    public MassSpecSpectraControlPanelView getControlPanel() {
        return this.controlPanel;
    }

    public void createChart(Composite parent) throws MSException {
        this.sashForm = new MSSpectraViewerSashForm(parent, 512, this);
        this.controlPanel = this.getNewSpectraControlPanel();
        this.compositeTop = new Composite((Composite)this.sashForm, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        this.controlPanel.createPartControl(this.compositeTop);
        this.controlPanel.getShowSpectra().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MassSpecSpectraView.this.setWeights();
                MassSpecSpectraView.this.controlPanel.cbShowSpectra.removePaintListener((PaintListener)this);
            }
        });
        this.createThisChart();
    }

    protected int[] getSashWeights() {
        int dPrefTopWeight = this.getPrefEntityScrollerWeight();
        int dPrefBotWeight = 1000 - dPrefTopWeight;
        return new int[]{dPrefTopWeight, dPrefBotWeight};
    }

    protected int getPrefEntityScrollerWeight() {
        if (this.compositeTop == null) {
            return 1;
        }
        int iTopHeight = this.controlPanel.getShowSpectra().getSize().y * 4 + 30;
        this.compositeTop.setSize(this.compositeTop.getSize().x, 100);
        int iFormHeight = this.sashForm.getSize().y;
        int iTopWeight = (int)Math.ceil((double)iTopHeight / (double)iFormHeight * 1000.0) + 30;
        return iTopWeight;
    }

    protected void setWeights() {
        int[] dWeights = this.getSashWeights();
        try {
            this.sashForm.setWeights(dWeights);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug((Object)("Weight calculation failed: " + dWeights));
            this.sashForm.setWeights(new int[]{10, 90});
        }
    }

    public void createThisChart() throws MSException {
        try {
            if (this.compositeBottom != null) {
                this.compositeBottom.dispose();
            }
            this.compositeBottom = new Composite((Composite)this.sashForm, 2048);
            this.compositeBottom.setLayout((Layout)new GridLayout(1, false));
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.initializeChartData();
            this.initializeChartPlot();
            this.updateChartPlot();
            this.chartComposite = new GRITSChartComposite(this.compositeBottom, 0, (JFreeChart)this.jFreeChart, true);
            this.chartComposite.setMzXMLFile(this.sMzXMLFile);
            this.chartComposite.setScanNum(this.iScanNum);
            this.chartComposite.setLayoutData((Object)gridData);
            this.sashForm.layout(true);
            this.setWeights();
        }
        catch (MSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error parsing mzXML file", (Throwable)e);
        }
    }

    public void createView() throws MSException {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 1;
        this.parent.setLayout((Layout)layout);
        this.createChart(this.parent);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.chartComposite.setLayoutData((Object)gridData);
    }

    public boolean equals(String _sMzXMLFile, Integer _iScanNum) {
        if (this.iScanNum == null || _iScanNum == null) {
            return false;
        }
        return this.isSameRunAs(_sMzXMLFile) && this.iScanNum.equals(_iScanNum);
    }

    public void createPartControl(Composite parent) {
    }

    public void setDirty(boolean b) {
    }

    public boolean isDirty() {
        return false;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public class MSSpectraViewerSashForm
    extends SashForm {
        private MassSpecSpectraView view;

        public MSSpectraViewerSashForm(Composite parent, int style, MassSpecSpectraView view) {
            super(parent, style);
            this.view = view;
        }

        public MassSpecSpectraView getMSSpectraView() {
            return this.view;
        }
    }
}

