/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.dialog.IDynamicTableProcessor;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantFileGrid;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantModifyDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecViewerDialog;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithStandardQuant;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecStandardQuantPreferenceUI;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MassSpecStandardQuantApplyDialog
extends MassSpecViewerDialog
implements IPropertyChangeListener,
IDynamicTableProcessor {
    private static final Logger logger = Logger.getLogger(MassSpecStandardQuantApplyDialog.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    protected Text txtOutput;
    protected static final String PARAMS_OK = "Valid parameters";
    protected GridLayout gridLayout = null;
    protected Label lblSelectStandards = null;
    protected Combo cmbSelectStandards = null;
    protected MassSpecStandardQuant selStandards = null;
    protected MassSpecStandardQuantFileGrid fileGrid = null;
    protected Button btnApplyFilter = null;
    protected Button btnModifyList = null;
    protected Button btnClearStandardQuant = null;
    protected IMSPreferenceWithStandardQuant storedStandardQuant = null;
    protected IMSPreferenceWithStandardQuant localStandardQuant = null;
    protected IMSPreferenceWithStandardQuant entryStandardQuant = null;
    protected MassSpecStandardQuantModifyDialog modQuantWin = null;
    protected MassSpecStandardQuantFileGrid selQuantFileWin = null;
    public static final String PROPERTY_WIN_CLOSED = "Window Closed";
    public static final String STANDARDQUANT_APPLIED = "# ";
    public static final String STANDARDQUANT_DIRTY = "* ";
    public static final String LOCAL_STANDARDQUANT_CURRENT_ENTRY = " (current entry only)";
    public static final String LOCAL_STANDARDQUANT_DIFFERS = " (differs from preferences)";

    public MassSpecStandardQuantApplyDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell, contextViewer);
        this.setShellStyle(18544);
        this.initStoredStandardQuant();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getFormTitle());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        this.initGridLayout();
        container.setLayout((Layout)this.gridLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.addSelectStdQuantItem(container);
        this.addSelectStdQuantFilesItem(container);
        this.addFilterItem(container);
        this.addModifyStdQuantItem(container);
        container.addPaintListener((PaintListener)new StandardQuantPaintListener(this));
        return area;
    }

    protected void initLocalStandardQuant() {
        this.localStandardQuant = new MassSpecPreference();
        MassSpecUISettings msSettings = MassSpecStandardQuantPreferenceUI.getMassSpecUISettingsFromEntry(this.getMassSpecEntry());
        MassSpecStandardQuantPreferenceUI.initStandardQuantFromEntry(msSettings, this.localStandardQuant);
        this.entryStandardQuant = new MassSpecPreference();
        MassSpecStandardQuantPreferenceUI.initStandardQuantFromEntry(msSettings, this.entryStandardQuant);
    }

    public void setLocalStandardQuant(IMSPreferenceWithStandardQuant localStandardQuant) {
        this.localStandardQuant = localStandardQuant;
    }

    public IMSPreferenceWithStandardQuant getLocalStandardQuant() {
        return this.localStandardQuant;
    }

    public IMSPreferenceWithStandardQuant getEntryStandardQuant() {
        return this.entryStandardQuant;
    }

    public void setEntryStandardQuant(IMSPreferenceWithStandardQuant entryStandardQuant) {
        this.entryStandardQuant = entryStandardQuant;
    }

    public void initStoredStandardQuant() {
        this.storedStandardQuant = MassSpecStandardQuantPreferenceUI.loadWorkspacePreferences();
    }

    public IMSPreferenceWithStandardQuant getStoredStandardQuant() {
        return this.storedStandardQuant;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void initGridLayout() {
        this.gridLayout = new GridLayout(4, false);
    }

    private void addSelectStdQuantItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, false, 1, 1);
        this.lblSelectStandards = new Label(parent, 0);
        this.lblSelectStandards.setText("Standard Quantification Peak Sets");
        this.lblSelectStandards.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false, 3, 1);
        this.cmbSelectStandards = new Combo(parent, 0);
        this.cmbSelectStandards.setLayoutData((Object)gd2);
        this.initLocalStandardQuant();
        this.initStoredStandardQuantList();
        this.cmbSelectStandards.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MassSpecStandardQuantApplyDialog.this.processCmbSelectStandardsSelect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        Label dummy = new Label(parent, 0);
        dummy.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, false, 4, 1);
        Label dummy2 = new Label(parent, 0);
        dummy2.setLayoutData((Object)gd4);
    }

    protected void processCmbSelectStandardsSelect() {
        if (this.cmbSelectStandards == null || this.btnApplyFilter == null || this.fileGrid == null) {
            return;
        }
        boolean bVal = false;
        if (!this.cmbSelectStandards.getText().trim().equals("")) {
            this.setCurrentStdQuantValues(this.cmbSelectStandards.getText());
            bVal = true;
        }
        this.btnApplyFilter.setEnabled(bVal);
        this.fileGrid.setEnabled(bVal);
    }

    protected boolean hasLocalChanges(String selStdQuantName) {
        return selStdQuantName.endsWith(LOCAL_STANDARDQUANT_CURRENT_ENTRY) || selStdQuantName.endsWith(LOCAL_STANDARDQUANT_DIFFERS);
    }

    protected void setCurrentStdQuantValues(String selStdQuantName) {
        this.selStandards = null;
        if (selStdQuantName == null) {
            return;
        }
        MassSpecStandardQuant prefStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, this.getStoredStandardQuant());
        MassSpecStandardQuant localStdQuant = MassSpecStandardQuantApplyDialog.getCurrentStdQuant(selStdQuantName, this.getLocalStandardQuant());
        this.selStandards = selStdQuantName.endsWith(LOCAL_STANDARDQUANT_CURRENT_ENTRY) || selStdQuantName.endsWith(LOCAL_STANDARDQUANT_DIFFERS) ? localStdQuant : prefStdQuant;
        this.fileGrid.updateAppliedFileList(this.selStandards.getStandardQuantName());
    }

    public static boolean isTempStdQuantForSelectedItem(String selStdQuantName, MassSpecStandardQuant curStdQuant) {
        if (curStdQuant.getStandardQuantName().equals(selStdQuantName)) {
            return true;
        }
        String sCompareTo = String.valueOf(curStdQuant.getStandardQuantName()) + LOCAL_STANDARDQUANT_DIFFERS;
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_APPLIED + curStdQuant.getStandardQuantName();
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_APPLIED + curStdQuant.getStandardQuantName() + LOCAL_STANDARDQUANT_CURRENT_ENTRY;
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_APPLIED + curStdQuant.getStandardQuantName() + LOCAL_STANDARDQUANT_DIFFERS;
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_DIRTY + curStdQuant.getStandardQuantName();
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_DIRTY + curStdQuant.getStandardQuantName() + LOCAL_STANDARDQUANT_CURRENT_ENTRY;
        if (sCompareTo.equals(selStdQuantName)) {
            return true;
        }
        sCompareTo = STANDARDQUANT_DIRTY + curStdQuant.getStandardQuantName() + LOCAL_STANDARDQUANT_DIFFERS;
        return sCompareTo.equals(selStdQuantName);
    }

    public static MassSpecStandardQuant getCurrentStdQuant(String selStdQuantName, IMSPreferenceWithStandardQuant preferences) {
        MassSpecStandardQuant retStdQuant = null;
        if (preferences != null && preferences.getStandardQuant() != null) {
            int i = 0;
            while (i < preferences.getStandardQuant().size()) {
                MassSpecStandardQuant curStdQuant = preferences.getStandardQuant().get(i);
                if (curStdQuant != null && MassSpecStandardQuantApplyDialog.isTempStdQuantForSelectedItem(selStdQuantName, curStdQuant)) {
                    retStdQuant = curStdQuant;
                }
                ++i;
            }
        }
        return retStdQuant;
    }

    public static void setComboEntryForTempStdQuant(MassSpecStandardQuant stdQuant, Combo cmbSelectStandards, List<MassSpecStandardQuant> entryStandardQuant, List<MassSpecStandardQuant> storedPrefStandardQuant) {
        int inx = cmbSelectStandards.indexOf(stdQuant.getStandardQuantName());
        String sDisplayAs = "";
        if (inx == -1) {
            MassSpecStandardQuant entryStdQuant = null;
            if (entryStandardQuant != null) {
                int i = 0;
                while (i < entryStandardQuant.size()) {
                    MassSpecStandardQuant curStdQuant = entryStandardQuant.get(i);
                    if (stdQuant.equals(curStdQuant)) {
                        entryStdQuant = curStdQuant;
                        break;
                    }
                    ++i;
                }
            }
            String sStartWith = STANDARDQUANT_DIRTY;
            if (entryStdQuant != null && !stdQuant.differsFrom(entryStdQuant)) {
                sStartWith = STANDARDQUANT_APPLIED;
            }
            sDisplayAs = String.valueOf(sStartWith) + stdQuant.getStandardQuantName() + LOCAL_STANDARDQUANT_CURRENT_ENTRY;
            cmbSelectStandards.add(sDisplayAs);
        } else {
            MassSpecStandardQuant prefStdQuant = null;
            if (storedPrefStandardQuant != null) {
                int i = 0;
                while (i < storedPrefStandardQuant.size()) {
                    MassSpecStandardQuant curStdQuant = storedPrefStandardQuant.get(i);
                    if (stdQuant.equals(curStdQuant)) {
                        prefStdQuant = curStdQuant;
                        break;
                    }
                    ++i;
                }
            }
            MassSpecStandardQuant entryStdQuant = null;
            if (entryStandardQuant != null) {
                int i = 0;
                while (i < entryStandardQuant.size()) {
                    MassSpecStandardQuant curStdQuant = entryStandardQuant.get(i);
                    if (stdQuant.equals(curStdQuant)) {
                        entryStdQuant = curStdQuant;
                        break;
                    }
                    ++i;
                }
            }
            String sStartWith = "";
            String sEndWith = "";
            if (entryStdQuant != null) {
                sStartWith = STANDARDQUANT_APPLIED;
                if (entryStdQuant.differsFrom(stdQuant)) {
                    sStartWith = STANDARDQUANT_DIRTY;
                }
                if (prefStdQuant == null) {
                    sEndWith = LOCAL_STANDARDQUANT_CURRENT_ENTRY;
                    if (entryStdQuant.differsFrom(stdQuant)) {
                        sEndWith = LOCAL_STANDARDQUANT_DIFFERS;
                    }
                } else {
                    boolean bDiffersFromPref = entryStdQuant.differsFrom(prefStdQuant);
                    boolean bDiffersFromLocal = entryStdQuant.differsFrom(stdQuant);
                    if (bDiffersFromPref && !bDiffersFromLocal) {
                        sEndWith = LOCAL_STANDARDQUANT_DIFFERS;
                    } else if (bDiffersFromLocal) {
                        sEndWith = LOCAL_STANDARDQUANT_DIFFERS;
                    }
                }
            } else if (prefStdQuant == null) {
                sEndWith = LOCAL_STANDARDQUANT_CURRENT_ENTRY;
            } else if (stdQuant.differsFrom(prefStdQuant)) {
                sEndWith = LOCAL_STANDARDQUANT_DIFFERS;
            }
            sDisplayAs = String.valueOf(sStartWith) + stdQuant.getStandardQuantName() + sEndWith;
            cmbSelectStandards.remove(inx);
            cmbSelectStandards.add(sDisplayAs);
        }
    }

    public void initStoredStandardQuantList() {
        int iItemCount;
        int i;
        String sToSelect = "";
        if (this.cmbSelectStandards.getItems().length != 0) {
            this.cmbSelectStandards.removeAll();
        }
        this.cmbSelectStandards.add("");
        if (this.getStoredStandardQuant() != null && this.getStoredStandardQuant().getStandardQuant() != null) {
            i = 0;
            while (i < this.getStoredStandardQuant().getStandardQuant().size()) {
                MassSpecStandardQuant storedStdQuant = this.getStoredStandardQuant().getStandardQuant().get(i);
                this.cmbSelectStandards.add(storedStdQuant.getStandardQuantName());
                if (this.selStandards != null && storedStdQuant.getStandardQuantName().equals(this.selStandards.getStandardQuantName())) {
                    iItemCount = this.cmbSelectStandards.getItemCount();
                    sToSelect = this.cmbSelectStandards.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        if (this.getContextViewer() != null && this.getLocalStandardQuant() != null && this.getLocalStandardQuant().getStandardQuant() != null) {
            i = 0;
            while (i < this.getLocalStandardQuant().getStandardQuant().size()) {
                MassSpecStandardQuant localStdQuant = this.getLocalStandardQuant().getStandardQuant().get(i);
                MassSpecStandardQuantApplyDialog.setComboEntryForTempStdQuant(localStdQuant, this.cmbSelectStandards, this.entryStandardQuant.getStandardQuant(), this.storedStandardQuant.getStandardQuant());
                if (this.selStandards != null && localStdQuant.getStandardQuantName().equals(this.selStandards.getStandardQuantName())) {
                    iItemCount = this.cmbSelectStandards.getItemCount();
                    sToSelect = this.cmbSelectStandards.getItem(iItemCount - 1);
                }
                ++i;
            }
        }
        int iPrevSelInx = this.cmbSelectStandards.indexOf(sToSelect);
        this.cmbSelectStandards.select(iPrevSelInx);
        this.processCmbSelectStandardsSelect();
    }

    protected void addClearStandardQuant(Composite parent) {
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        this.btnClearStandardQuant = new Button(parent, 0);
        this.btnClearStandardQuant.setText("Clear Standard Quant Peaks");
        this.btnClearStandardQuant.setLayoutData((Object)gd3);
        this.btnClearStandardQuant.setEnabled(false);
        this.btnClearStandardQuant.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecStandardQuantApplyDialog.this.clearStdQuant();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void clearStdQuant() {
        MassSpecEntityProperty ep = (MassSpecEntityProperty)this.getMassSpecEntry().getProperty();
        MassSpecProperty prop = (MassSpecProperty)ep.getParentProperty();
        MassSpecMetaData msSettings = prop.getMassSpecMetaData();
        try {
            this.fileGrid.updateIntQuantFileSettings();
            if (msSettings.getStandardQuant().contains(this.selStandards)) {
                msSettings.getStandardQuant().remove(this.selStandards);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateStandardQuantData();
            prop.updateMSSettings(msSettings, sFileName);
            this.initLocalStandardQuant();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.updateViewer(null);
            this.initStoredStandardQuantList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void clearBeforeReApply() {
        MassSpecEntityProperty ep = (MassSpecEntityProperty)this.getMassSpecEntry().getProperty();
        MassSpecProperty prop = (MassSpecProperty)ep.getParentProperty();
        MassSpecMetaData msSettings = prop.getMassSpecMetaData();
        if (msSettings.getStandardQuant().contains(this.selStandards)) {
            try {
                msSettings.getStandardQuant().remove(this.selStandards);
                String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
                msSettings.updateStandardQuantData();
                prop.updateMSSettings(msSettings, sFileName);
                this.updateViewer(null);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    protected void performStdQuant() {
        this.clearBeforeReApply();
        MassSpecEntityProperty ep = (MassSpecEntityProperty)this.getMassSpecEntry().getProperty();
        MassSpecProperty prop = (MassSpecProperty)ep.getParentProperty();
        MassSpecMetaData msSettings = prop.getMassSpecMetaData();
        try {
            this.fileGrid.updateIntQuantFileSettings();
            if (this.selStandards != null) {
                msSettings.getStandardQuant().add(this.selStandards);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateStandardQuantData();
            prop.updateMSSettings(msSettings, sFileName);
            this.initLocalStandardQuant();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            List<String> sKeyVals = this.getColumnKeyLabels();
            this.updateViewer(sKeyVals);
            this.initStoredStandardQuantList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void addFilterItem(Composite parent) {
        GridData gd3 = new GridData(4, 4, true, false, 4, 1);
        this.btnApplyFilter = new Button(parent, 0);
        this.btnApplyFilter.setText("Apply Standard Quantification");
        this.btnApplyFilter.setLayoutData((Object)gd3);
        this.btnApplyFilter.setEnabled(false);
        this.btnApplyFilter.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int iNumSel = MassSpecStandardQuantApplyDialog.this.fileGrid.getNumSelectedEntries();
                if (iNumSel == 0) {
                    MassSpecStandardQuantApplyDialog.this.clearStdQuant();
                } else {
                    MassSpecStandardQuantApplyDialog.this.performStdQuant();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected MassSpecStandardQuantModifyDialog getNewQuantModifyDialog(Shell shell, MassSpecMultiPageViewer viewer) {
        return new MassSpecStandardQuantModifyDialog(shell, viewer);
    }

    protected void modifyStandardQuant() {
        MassSpecMultiPageViewer curView = this.getCurrentViewer();
        if (curView == null) {
            return;
        }
        Entry msEntry = curView.getEntry();
        if (msEntry == null) {
            return;
        }
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MassSpecEntityProperty) {
            if (this.modQuantWin == null) {
                this.modQuantWin = this.getNewQuantModifyDialog(this.getShell(), curView);
                this.modQuantWin.setLocalStdQuant(this.getLocalStandardQuant());
                this.modQuantWin.setEntryStdQuant(this.getEntryStandardQuant());
                this.modQuantWin.setSelectedStdQuant(this.cmbSelectStandards.getText());
                this.modQuantWin.addListener(this);
                this.modQuantWin.open();
            } else {
                this.modQuantWin.getShell().forceActive();
            }
            return;
        }
    }

    private void addModifyStdQuantItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 4, 1);
        this.btnModifyList = new Button(parent, 0);
        this.btnModifyList.setText("Modify Internal Standard Sets");
        this.btnModifyList.setLayoutData((Object)gd1);
        this.btnModifyList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MassSpecStandardQuantApplyDialog.this.modifyStandardQuant();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected MassSpecStandardQuantFileGrid getNewMassSpecStandardQuantFileGrid(Composite parent, MassSpecMultiPageViewer curView) {
        return new MassSpecStandardQuantFileGrid(parent, curView);
    }

    private void addSelectStdQuantFilesItem(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, false, 4, 1);
        MassSpecMultiPageViewer curView = this.getCurrentViewer();
        if (curView == null) {
            return;
        }
        Entry msEntry = curView.getEntry();
        if (msEntry == null) {
            return;
        }
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MassSpecEntityProperty) {
            this.fileGrid = this.getNewMassSpecStandardQuantFileGrid(parent, curView);
            this.fileGrid.initializeGrid();
            this.fileGrid.setLayoutData(gd1);
            this.fileGrid.setEnabled(false);
        }
    }

    public int open() {
        Entry entry = this.getEntryForCurrentViewer();
        if (entry == null) {
            return -1;
        }
        this.setMassSpecEntry(entry);
        super.create();
        this.getShell().open();
        this.getShell().layout();
        this.getShell().pack();
        return this.getReturnCode();
    }

    protected boolean isResizable() {
        return true;
    }

    protected String getFormTitle() {
        return "Mass Spec Standard Quantification";
    }

    protected String getStandardQuantificationLabelText() {
        return "MS Std Quantification";
    }

    public void validateInput() {
        this.txtOutput.setText(PARAMS_OK);
        if (this.getMassSpecEntry() == null) {
            this.txtOutput.setText("Please select Mass Spec Results");
        }
    }

    public boolean close() {
        if (this.getListeners() != null) {
            for (IPropertyChangeListener listener : this.getListeners()) {
                listener.propertyChange(new PropertyChangeEvent((Object)this, PROPERTY_WIN_CLOSED, (Object)Boolean.FALSE, (Object)Boolean.TRUE));
            }
        }
        return super.close();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof MassSpecStandardQuantModifyDialog) {
            if (event.getProperty().equals("Local changes")) {
                this.initStoredStandardQuantList();
            } else if (event.getProperty().equals("Apply pressed")) {
                this.initStoredStandardQuant();
                this.initStoredStandardQuantList();
            } else if (event.getProperty().equals(PROPERTY_WIN_CLOSED)) {
                this.modQuantWin = null;
                this.selQuantFileWin = null;
            }
        }
    }

    protected void updateViewer(List<String> sKeyVals) {
        try {
            MassSpecMultiPageViewer viewer = this.getCurrentViewer();
            viewer.reLoadScansTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getColumnKeyLabels() {
        if (this.selStandards == null) {
            return null;
        }
        ArrayList<String> keyVals = new ArrayList<String>();
        if (this.fileGrid != null && this.fileGrid.getSelectedQuantFileAliases() != null && this.selStandards.getStandardQuantPeaks() != null) {
            for (String sFileName : this.fileGrid.getSelectedQuantFileAliases().keySet()) {
                String sFileAlias = this.fileGrid.getSelectedQuantFileAliases().get(sFileName);
                String sColPrefix = String.valueOf(this.selStandards.getStandardQuantName()) + " : " + sFileAlias;
                for (MassSpecStandardQuantPeak peak : this.selStandards.getStandardQuantPeaks().values()) {
                    keyVals.add(String.valueOf(sColPrefix) + "-" + Double.toString(peak.getPeakMz()));
                }
            }
        }
        return keyVals;
    }

    public class StandardQuantPaintListener
    implements PaintListener {
        MassSpecStandardQuantApplyDialog parent = null;

        public StandardQuantPaintListener(MassSpecStandardQuantApplyDialog parent) {
            this.parent = parent;
        }

        public void paintControl(PaintEvent e) {
            Entry entry = MassSpecStandardQuantApplyDialog.this.getEntryForCurrentViewer();
            if (entry != null && !entry.equals(this.parent.getMassSpecEntry())) {
                this.parent.setMassSpecEntry(entry);
                MassSpecStandardQuantApplyDialog.this.initLocalStandardQuant();
                this.parent.initStoredStandardQuantList();
            }
        }
    }
}

