/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.BatchOfAnalytesWizard;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.AnalyteListEditingSupport;
import org.grits.toolbox.entry.sample.wizard.batchofanalytes.pages.AnalyteListLabelProvider;

public class BatchOfAnalytesTablePageTwo
extends WizardPage {
    private static final Logger logger = Logger.getLogger(BatchOfAnalytesTablePageTwo.class);
    private static final String PAGE_NAME = "ComponentPage";
    private Text sampleLabelText;
    private Composite container;
    public int selectedOption;
    private TableViewer tableViewer;
    private List<Sample> samples;

    public BatchOfAnalytesTablePageTwo() {
        super(PAGE_NAME);
        this.setTitle("Analytes");
        this.setDescription("List of Analytes to be created");
    }

    public Entry getProjectEntry() {
        return ((BatchOfAnalytesWizard)this.getWizard()).getProjectEntry();
    }

    public void createControl(Composite parent) {
        logger.debug((Object)"Creating page for batch analytes wizard");
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.container.setLayout((Layout)layout);
        Label label = new Label(this.container, 0);
        label.setText("Analytes");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 1, 1));
        this.createTableViewer(this.container);
        Button removeButton = new Button(this.container, 0);
        removeButton.setText("Remove");
        GridData removeButtonData = new GridData(128);
        removeButtonData.widthHint = 80;
        removeButtonData.verticalSpan = 1;
        removeButtonData.verticalAlignment = 2;
        removeButton.setLayoutData((Object)removeButtonData);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List analytes = (List)BatchOfAnalytesTablePageTwo.this.tableViewer.getInput();
                int selectionIndex = BatchOfAnalytesTablePageTwo.this.tableViewer.getTable().getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < analytes.size()) {
                    Sample selectedAnalyte = (Sample)BatchOfAnalytesTablePageTwo.this.tableViewer.getElementAt(selectionIndex);
                    analytes.remove(selectedAnalyte);
                    BatchOfAnalytesTablePageTwo.this.tableViewer.refresh();
                    if (analytes.size() > 0) {
                        selectionIndex = Math.max(selectionIndex - 1, 0);
                        BatchOfAnalytesTablePageTwo.this.tableViewer.getTable().select(selectionIndex);
                        BatchOfAnalytesTablePageTwo.this.tableViewer.setSelection(BatchOfAnalytesTablePageTwo.this.tableViewer.getSelection());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        logger.debug((Object)"Creating page for batch analytes wizard");
        this.setControl((Control)this.container);
    }

    private void createTableViewer(Composite container2) {
        Table analytesTable = new Table(this.container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 1;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 250;
        tableLayouData.heightHint = 300;
        analytesTable.setLayoutData((Object)tableLayouData);
        this.tableViewer = new TableViewer(analytesTable);
        TableViewerColumn tableColumn1 = new TableViewerColumn(this.tableViewer, 4, 0);
        tableColumn1.getColumn().setText("Name");
        tableColumn1.getColumn().setWidth(200);
        tableColumn1.setEditingSupport((EditingSupport)new AnalyteListEditingSupport(this, 0));
        TableViewerColumn tableColumn2 = new TableViewerColumn(this.tableViewer, 4, 1);
        tableColumn2.getColumn().setText("Description");
        tableColumn2.getColumn().setWidth(400);
        tableColumn2.setEditingSupport((EditingSupport)new AnalyteListEditingSupport(this, 1));
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AnalyteListLabelProvider());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.tableViewer.getTable().setFocus();
        if (this.tableViewer.getInput() != null && this.tableViewer.getElementAt(0) != null) {
            this.tableViewer.editElement(this.tableViewer.getElementAt(0), 0);
        }
    }

    public String getLabel() {
        return this.sampleLabelText.getText();
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
        if (this.tableViewer != null) {
            this.tableViewer.setInput(samples);
        }
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public boolean findSameNameEntry(String name, Sample current) {
        if (this.tableViewer != null && this.tableViewer.getInput() != null) {
            List samples = (List)this.tableViewer.getInput();
            for (Sample sample : samples) {
                if (sample == current || !sample.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

