/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.io;

import java.io.IOException;
import java.util.ArrayList;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.sample.property.SampleProperty;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class SamplePropertyWriter
implements PropertyWriter {
    public void write(Property property, Element propertyElement) throws IOException {
        PropertyDataFile sampleFile;
        if (property instanceof SampleProperty) {
            SampleProperty sampleProperty = (SampleProperty)property;
            sampleFile = sampleProperty.getSampleFile();
            if (sampleFile == null || sampleFile.getName() == null) {
                throw new IOException("Property could not be added as its sample file (or name) is null.");
            }
        } else {
            throw new IOException("This property is not a Sample Property");
        }
        Element fileElement = new Element("file");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("name", sampleFile.getName()));
        String version = sampleFile.getVersion() == null ? "1.0" : sampleFile.getVersion();
        attributes.add(new Attribute("version", version));
        attributes.add(new Attribute("type", "default"));
        fileElement.setAttributes(attributes);
        propertyElement.setContent((Content)fileElement);
    }
}

